--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetInletPolicy = {}

---@class ThermalMgmtIpmiCmds.GetInletPolicyReq
---@field ManufactureId integer
local TGetInletPolicyReq = {}
TGetInletPolicyReq.__index = TGetInletPolicyReq
TGetInletPolicyReq.group = {}

local function TGetInletPolicyReq_from_obj(obj)
    return setmetatable(obj, TGetInletPolicyReq)
end

function TGetInletPolicyReq.new(ManufactureId)
    return TGetInletPolicyReq_from_obj({ManufactureId = ManufactureId})
end
---@param obj ThermalMgmtIpmiCmds.GetInletPolicyReq
function TGetInletPolicyReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
end

function TGetInletPolicyReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetInletPolicyReq.group)
end

TGetInletPolicyReq.from_obj = TGetInletPolicyReq_from_obj

TGetInletPolicyReq.proto_property = {'ManufactureId'}

TGetInletPolicyReq.default = {0}

TGetInletPolicyReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}
}

function TGetInletPolicyReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, "uint32",
                      false, errs, need_convert)

    TGetInletPolicyReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetInletPolicyReq.proto_property, errs,
                                 need_convert)
    return self
end

function TGetInletPolicyReq:unpack(_) return self.ManufactureId end

GetInletPolicy.GetInletPolicyReq = TGetInletPolicyReq

---@class ThermalMgmtIpmiCmds.GetInletPolicyRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field EnvArrLen integer
---@field EnvSpdArr string
local TGetInletPolicyRsp = {}
TGetInletPolicyRsp.__index = TGetInletPolicyRsp
TGetInletPolicyRsp.group = {}

local function TGetInletPolicyRsp_from_obj(obj)
    return setmetatable(obj, TGetInletPolicyRsp)
end

function TGetInletPolicyRsp.new(CompletionCode, ManufactureId, EnvArrLen,
                                EnvSpdArr)
    return TGetInletPolicyRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        EnvArrLen = EnvArrLen,
        EnvSpdArr = EnvSpdArr
    })
end
---@param obj ThermalMgmtIpmiCmds.GetInletPolicyRsp
function TGetInletPolicyRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.EnvArrLen = obj.EnvArrLen
    self.EnvSpdArr = obj.EnvSpdArr
end

function TGetInletPolicyRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetInletPolicyRsp.group)
end

TGetInletPolicyRsp.from_obj = TGetInletPolicyRsp_from_obj

TGetInletPolicyRsp.proto_property = {
    'CompletionCode', 'ManufactureId', 'EnvArrLen', 'EnvSpdArr'
}

TGetInletPolicyRsp.default = {0, 0, 0, ''}

TGetInletPolicyRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil},
    {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'EnvArrLen', is_array = false, struct = nil},
    {name = 'EnvSpdArr', is_array = false, struct = nil}
}

function TGetInletPolicyRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, "uint8",
                      false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, "uint32",
                      false, errs, need_convert)
    validate.Optional(prefix .. 'EnvArrLen', self.EnvArrLen, "uint8", false,
                      errs, need_convert)
    validate.Optional(prefix .. 'EnvSpdArr', self.EnvSpdArr, "string", false,
                      errs, need_convert)

    TGetInletPolicyRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetInletPolicyRsp.proto_property, errs,
                                 need_convert)
    return self
end

function TGetInletPolicyRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.EnvArrLen,
           self.EnvSpdArr
end

GetInletPolicy.GetInletPolicyRsp = TGetInletPolicyRsp

return GetInletPolicy
