--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetFanSpeed = {}

---@class ThermalMgmtIpmiCmds.GetFanSpeedReq
---@field ManufactureId integer
---@field DeviceNumber integer
local TGetFanSpeedReq = {}
TGetFanSpeedReq.__index = TGetFanSpeedReq
TGetFanSpeedReq.group = {}

local function TGetFanSpeedReq_from_obj(obj)
    return setmetatable(obj, TGetFanSpeedReq)
end

function TGetFanSpeedReq.new(ManufactureId, DeviceNumber)
    return TGetFanSpeedReq_from_obj({
        ManufactureId = ManufactureId,
        DeviceNumber = DeviceNumber
    })
end
---@param obj ThermalMgmtIpmiCmds.GetFanSpeedReq
function TGetFanSpeedReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.DeviceNumber = obj.DeviceNumber
end

function TGetFanSpeedReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetFanSpeedReq.group)
end

TGetFanSpeedReq.from_obj = TGetFanSpeedReq_from_obj

TGetFanSpeedReq.proto_property = {'ManufactureId', 'DeviceNumber'}

TGetFanSpeedReq.default = {0, 0}

TGetFanSpeedReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'DeviceNumber', is_array = false, struct = nil}
}

function TGetFanSpeedReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, "uint32",
                      false, errs, need_convert)
    validate.Optional(prefix .. 'DeviceNumber', self.DeviceNumber, "uint8",
                      false, errs, need_convert)

    TGetFanSpeedReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetFanSpeedReq.proto_property, errs,
                                 need_convert)
    return self
end

function TGetFanSpeedReq:unpack(_) return self.ManufactureId, self.DeviceNumber end

GetFanSpeed.GetFanSpeedReq = TGetFanSpeedReq

---@class ThermalMgmtIpmiCmds.GetFanSpeedRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field Reading integer
---@field Unit integer
local TGetFanSpeedRsp = {}
TGetFanSpeedRsp.__index = TGetFanSpeedRsp
TGetFanSpeedRsp.group = {}

local function TGetFanSpeedRsp_from_obj(obj)
    return setmetatable(obj, TGetFanSpeedRsp)
end

function TGetFanSpeedRsp.new(CompletionCode, ManufactureId, Reading, Unit)
    return TGetFanSpeedRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        Reading = Reading,
        Unit = Unit
    })
end
---@param obj ThermalMgmtIpmiCmds.GetFanSpeedRsp
function TGetFanSpeedRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.Reading = obj.Reading
    self.Unit = obj.Unit
end

function TGetFanSpeedRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetFanSpeedRsp.group)
end

TGetFanSpeedRsp.from_obj = TGetFanSpeedRsp_from_obj

TGetFanSpeedRsp.proto_property = {
    'CompletionCode', 'ManufactureId', 'Reading', 'Unit'
}

TGetFanSpeedRsp.default = {0, 0, 0, 0}

TGetFanSpeedRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil},
    {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'Reading', is_array = false, struct = nil},
    {name = 'Unit', is_array = false, struct = nil}
}

function TGetFanSpeedRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, "uint8",
                      false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, "uint32",
                      false, errs, need_convert)
    validate.Optional(prefix .. 'Reading', self.Reading, "uint32", false, errs,
                      need_convert)
    validate.Optional(prefix .. 'Unit', self.Unit, "uint8", false, errs,
                      need_convert)

    TGetFanSpeedRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetFanSpeedRsp.proto_property, errs,
                                 need_convert)
    return self
end

function TGetFanSpeedRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.Reading, self.Unit
end

GetFanSpeed.GetFanSpeedRsp = TGetFanSpeedRsp

return GetFanSpeed
