--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetFanSpdProps = {}

---@class ThermalMgmtIpmiCmds.GetFanSpdPropsReq
---@field SystemId integer
---@field FruId integer
local TGetFanSpdPropsReq = {}
TGetFanSpdPropsReq.__index = TGetFanSpdPropsReq
TGetFanSpdPropsReq.group = {}

local function TGetFanSpdPropsReq_from_obj(obj)
    return setmetatable(obj, TGetFanSpdPropsReq)
end

function TGetFanSpdPropsReq.new(SystemId, FruId)
    return TGetFanSpdPropsReq_from_obj({SystemId = SystemId, FruId = FruId})
end
---@param obj ThermalMgmtIpmiCmds.GetFanSpdPropsReq
function TGetFanSpdPropsReq:init_from_obj(obj)
    self.SystemId = obj.SystemId
    self.FruId = obj.FruId
end

function TGetFanSpdPropsReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetFanSpdPropsReq.group)
end

TGetFanSpdPropsReq.from_obj = TGetFanSpdPropsReq_from_obj

TGetFanSpdPropsReq.proto_property = {'SystemId', 'FruId'}

TGetFanSpdPropsReq.default = {0, 0}

TGetFanSpdPropsReq.struct = {
    {name = 'SystemId', is_array = false, struct = nil},
    {name = 'FruId', is_array = false, struct = nil}
}

function TGetFanSpdPropsReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SystemId', self.SystemId, "uint8", false, errs,
                      need_convert)
    validate.Optional(prefix .. 'FruId', self.FruId, "uint8", false, errs,
                      need_convert)

    TGetFanSpdPropsReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetFanSpdPropsReq.proto_property, errs,
                                 need_convert)
    return self
end

function TGetFanSpdPropsReq:unpack(_) return self.SystemId, self.FruId end

GetFanSpdProps.GetFanSpdPropsReq = TGetFanSpdPropsReq

---@class ThermalMgmtIpmiCmds.GetFanSpdPropsRsp
---@field CompletionCode integer
---@field PicmgIdentifier integer
---@field MinimalSpd integer
---@field MaximumSpd integer
---@field DefaultSpd integer
---@field DefaultData integer
local TGetFanSpdPropsRsp = {}
TGetFanSpdPropsRsp.__index = TGetFanSpdPropsRsp
TGetFanSpdPropsRsp.group = {}

local function TGetFanSpdPropsRsp_from_obj(obj)
    return setmetatable(obj, TGetFanSpdPropsRsp)
end

function TGetFanSpdPropsRsp.new(CompletionCode, PicmgIdentifier, MinimalSpd,
                                MaximumSpd, DefaultSpd, DefaultData)
    return TGetFanSpdPropsRsp_from_obj({
        CompletionCode = CompletionCode,
        PicmgIdentifier = PicmgIdentifier,
        MinimalSpd = MinimalSpd,
        MaximumSpd = MaximumSpd,
        DefaultSpd = DefaultSpd,
        DefaultData = DefaultData
    })
end
---@param obj ThermalMgmtIpmiCmds.GetFanSpdPropsRsp
function TGetFanSpdPropsRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.PicmgIdentifier = obj.PicmgIdentifier
    self.MinimalSpd = obj.MinimalSpd
    self.MaximumSpd = obj.MaximumSpd
    self.DefaultSpd = obj.DefaultSpd
    self.DefaultData = obj.DefaultData
end

function TGetFanSpdPropsRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetFanSpdPropsRsp.group)
end

TGetFanSpdPropsRsp.from_obj = TGetFanSpdPropsRsp_from_obj

TGetFanSpdPropsRsp.proto_property = {
    'CompletionCode', 'PicmgIdentifier', 'MinimalSpd', 'MaximumSpd',
    'DefaultSpd', 'DefaultData'
}

TGetFanSpdPropsRsp.default = {0, 0, 0, 0, 0, 0}

TGetFanSpdPropsRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil},
    {name = 'PicmgIdentifier', is_array = false, struct = nil},
    {name = 'MinimalSpd', is_array = false, struct = nil},
    {name = 'MaximumSpd', is_array = false, struct = nil},
    {name = 'DefaultSpd', is_array = false, struct = nil},
    {name = 'DefaultData', is_array = false, struct = nil}
}

function TGetFanSpdPropsRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, "uint8",
                      false, errs, need_convert)
    validate.Optional(prefix .. 'PicmgIdentifier', self.PicmgIdentifier,
                      "uint8", false, errs, need_convert)
    validate.Optional(prefix .. 'MinimalSpd', self.MinimalSpd, "uint8", false,
                      errs, need_convert)
    validate.Optional(prefix .. 'MaximumSpd', self.MaximumSpd, "uint8", false,
                      errs, need_convert)
    validate.Optional(prefix .. 'DefaultSpd', self.DefaultSpd, "uint8", false,
                      errs, need_convert)
    validate.Optional(prefix .. 'DefaultData', self.DefaultData, "uint8", false,
                      errs, need_convert)

    TGetFanSpdPropsRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetFanSpdPropsRsp.proto_property, errs,
                                 need_convert)
    return self
end

function TGetFanSpdPropsRsp:unpack(_)
    return self.CompletionCode, self.PicmgIdentifier, self.MinimalSpd,
           self.MaximumSpd, self.DefaultSpd, self.DefaultData
end

GetFanSpdProps.GetFanSpdPropsRsp = TGetFanSpdPropsRsp

return GetFanSpdProps
