-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local class = require 'mc.class'
local singleton = require 'mc.singleton'
local feature = require 'mc.plugin.feature'

local Feature1 = class(feature)

function Feature1:ctor() end

function Feature1:CustomPidCountValue(...)
    return self:call('CustomPidCountValue', ...)
end

function Feature1:ImplCustomPidCountValue(preprocess_cb, process_cb,
                                          postprocess_cb)
    self:implement('CustomPidCountValue', preprocess_cb, process_cb,
                   postprocess_cb)
end

function Feature1:CustomPidUpdateSensorValue(...)
    return self:call('CustomPidUpdateSensorValue', ...)
end

function Feature1:ImplCustomPidUpdateSensorValue(preprocess_cb, process_cb,
                                                 postprocess_cb)
    self:implement('CustomPidUpdateSensorValue', preprocess_cb, process_cb,
                   postprocess_cb)
end

function Feature1:CustomReadInfo(...) return self:call('CustomReadInfo', ...) end

function Feature1:ImplCustomReadInfo(preprocess_cb, process_cb, postprocess_cb)
    self:implement('CustomReadInfo', preprocess_cb, process_cb, postprocess_cb)
end

function Feature1:CustomSetEnvTempConfig(...)
    return self:call('CustomSetEnvTempConfig', ...)
end

function Feature1:ImplCustomSetEnvTempConfig(preprocess_cb, process_cb,
                                             postprocess_cb)
    self:implement('CustomSetEnvTempConfig', preprocess_cb, process_cb,
                   postprocess_cb)
end

function Feature1:CustomSetFanAlarmSpeed(...)
    return self:call('CustomSetFanAlarmSpeed', ...)
end

function Feature1:ImplCustomSetFanAlarmSpeed(preprocess_cb, process_cb,
                                             postprocess_cb)
    self:implement('CustomSetFanAlarmSpeed', preprocess_cb, process_cb,
                   postprocess_cb)
end

function Feature1:CustomSetFanConfig(...)
    return self:call('CustomSetFanConfig', ...)
end

function Feature1:ImplCustomSetFanConfig(preprocess_cb, process_cb,
                                         postprocess_cb)
    self:implement('CustomSetFanConfig', preprocess_cb, process_cb,
                   postprocess_cb)
end

function Feature1:CustomSetRealTimeTemp(...)
    return self:call('CustomSetRealTimeTemp', ...)
end

function Feature1:ImplCustomSetRealTimeTemp(preprocess_cb, process_cb,
                                            postprocess_cb)
    self:implement('CustomSetRealTimeTemp', preprocess_cb, process_cb,
                   postprocess_cb)
end

function Feature1:CustomSetTargetTempConfig(...)
    return self:call('CustomSetTargetTempConfig', ...)
end

function Feature1:ImplCustomSetTargetTempConfig(preprocess_cb, process_cb,
                                                postprocess_cb)
    self:implement('CustomSetTargetTempConfig', preprocess_cb, process_cb,
                   postprocess_cb)
end

function Feature1:CustomTarTempCtrInit(...)
    return self:call('CustomTarTempCtrInit', ...)
end

function Feature1:ImplCustomTarTempCtrInit(preprocess_cb, process_cb,
                                           postprocess_cb)
    self:implement('CustomTarTempCtrInit', preprocess_cb, process_cb,
                   postprocess_cb)
end

return singleton(Feature1)

