-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MThermalConfiguration = {}

---@class MThermalConfiguration.Id
---@field Id integer
local TId = {}
TId.__index = TId
TId.group = {}

local function TId_from_obj(obj) return setmetatable(obj, TId) end

function TId.new(Id) return TId_from_obj({Id = Id or 1}) end
---@param obj MThermalConfiguration.Id
function TId:init_from_obj(obj) self.Id = obj.Id or 1 end

function TId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TId.group)
end

TId.from_obj = TId_from_obj

TId.proto_property = {'Id'}

TId.default = {0}

TId.struct = {{name = 'Id', is_array = false, struct = nil}}

function TId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'Id', self.Id, "uint8", false, errs,
                      need_convert)

    TId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TId.proto_property, errs, need_convert)
    return self
end

function TId:unpack(_) return self.Id end

MThermalConfiguration.Id = TId

---@class MThermalConfiguration.FanStartSlot
---@field FanStartSlot integer[]
local TFanStartSlot = {}
TFanStartSlot.__index = TFanStartSlot
TFanStartSlot.group = {}

local function TFanStartSlot_from_obj(obj)
    return setmetatable(obj, TFanStartSlot)
end

function TFanStartSlot.new(FanStartSlot)
    return TFanStartSlot_from_obj({FanStartSlot = FanStartSlot})
end
---@param obj MThermalConfiguration.FanStartSlot
function TFanStartSlot:init_from_obj(obj) self.FanStartSlot = obj.FanStartSlot end

function TFanStartSlot:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFanStartSlot.group)
end

TFanStartSlot.from_obj = TFanStartSlot_from_obj

TFanStartSlot.proto_property = {'FanStartSlot'}

TFanStartSlot.default = {{}}

TFanStartSlot.struct = {{name = 'FanStartSlot', is_array = true, struct = nil}}

function TFanStartSlot:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'FanStartSlot', self.FanStartSlot, "uint8",
                           false, errs, need_convert)

    TFanStartSlot:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFanStartSlot.proto_property, errs,
                                 need_convert)
    return self
end

function TFanStartSlot:unpack(_) return self.FanStartSlot end

MThermalConfiguration.FanStartSlot = TFanStartSlot

---@class MThermalConfiguration.StandbyFan
---@field StandbyFan integer
local TStandbyFan = {}
TStandbyFan.__index = TStandbyFan
TStandbyFan.group = {}

local function TStandbyFan_from_obj(obj) return setmetatable(obj, TStandbyFan) end

function TStandbyFan.new(StandbyFan)
    return TStandbyFan_from_obj({StandbyFan = StandbyFan or 0})
end
---@param obj MThermalConfiguration.StandbyFan
function TStandbyFan:init_from_obj(obj) self.StandbyFan = obj.StandbyFan or 0 end

function TStandbyFan:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TStandbyFan.group)
end

TStandbyFan.from_obj = TStandbyFan_from_obj

TStandbyFan.proto_property = {'StandbyFan'}

TStandbyFan.default = {0}

TStandbyFan.struct = {{name = 'StandbyFan', is_array = false, struct = nil}}

function TStandbyFan:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'StandbyFan', self.StandbyFan, "uint8", false,
                      errs, need_convert)

    TStandbyFan:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TStandbyFan.proto_property, errs,
                                 need_convert)
    return self
end

function TStandbyFan:unpack(_) return self.StandbyFan end

MThermalConfiguration.StandbyFan = TStandbyFan

return MThermalConfiguration
