-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MPumps = {}

---@class MPumps.SetPWMCmd
---@field SetPWMCmd integer
local TSetPWMCmd = {}
TSetPWMCmd.__index = TSetPWMCmd
TSetPWMCmd.group = {}

local function TSetPWMCmd_from_obj(obj) return setmetatable(obj, TSetPWMCmd) end

function TSetPWMCmd.new(SetPWMCmd)
    return TSetPWMCmd_from_obj({SetPWMCmd = SetPWMCmd})
end
---@param obj MPumps.SetPWMCmd
function TSetPWMCmd:init_from_obj(obj) self.SetPWMCmd = obj.SetPWMCmd end

function TSetPWMCmd:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetPWMCmd.group)
end

TSetPWMCmd.from_obj = TSetPWMCmd_from_obj

TSetPWMCmd.proto_property = {'SetPWMCmd'}

TSetPWMCmd.default = {0}

TSetPWMCmd.struct = {{name = 'SetPWMCmd', is_array = false, struct = nil}}

function TSetPWMCmd:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SetPWMCmd', self.SetPWMCmd, "uint32", false,
                      errs, need_convert)

    TSetPWMCmd:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetPWMCmd.proto_property, errs,
                                 need_convert)
    return self
end

function TSetPWMCmd:unpack(_) return self.SetPWMCmd end

MPumps.SetPWMCmd = TSetPWMCmd

---@class MPumps.PWMChip
---@field PWMChip integer[]
local TPWMChip = {}
TPWMChip.__index = TPWMChip
TPWMChip.group = {}

local function TPWMChip_from_obj(obj) return setmetatable(obj, TPWMChip) end

function TPWMChip.new(PWMChip) return TPWMChip_from_obj({PWMChip = PWMChip}) end
---@param obj MPumps.PWMChip
function TPWMChip:init_from_obj(obj) self.PWMChip = obj.PWMChip end

function TPWMChip:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPWMChip.group)
end

TPWMChip.from_obj = TPWMChip_from_obj

TPWMChip.proto_property = {'PWMChip'}

TPWMChip.default = {{}}

TPWMChip.struct = {{name = 'PWMChip', is_array = true, struct = nil}}

function TPWMChip:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'PWMChip', self.PWMChip, "uint8", false,
                           errs, need_convert)

    TPWMChip:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPWMChip.proto_property, errs,
                                 need_convert)
    return self
end

function TPWMChip:unpack(_) return self.PWMChip end

MPumps.PWMChip = TPWMChip

---@class MPumps.PumpsObjectName
---@field PumpsObjectName string
local TPumpsObjectName = {}
TPumpsObjectName.__index = TPumpsObjectName
TPumpsObjectName.group = {}

local function TPumpsObjectName_from_obj(obj)
    return setmetatable(obj, TPumpsObjectName)
end

function TPumpsObjectName.new(PumpsObjectName)
    return TPumpsObjectName_from_obj({PumpsObjectName = PumpsObjectName})
end
---@param obj MPumps.PumpsObjectName
function TPumpsObjectName:init_from_obj(obj)
    self.PumpsObjectName = obj.PumpsObjectName
end

function TPumpsObjectName:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPumpsObjectName.group)
end

TPumpsObjectName.from_obj = TPumpsObjectName_from_obj

TPumpsObjectName.proto_property = {'PumpsObjectName'}

TPumpsObjectName.default = {''}

TPumpsObjectName.struct = {
    {name = 'PumpsObjectName', is_array = false, struct = nil}
}

function TPumpsObjectName:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'PumpsObjectName', self.PumpsObjectName,
                      "string", false, errs, need_convert)

    TPumpsObjectName:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPumpsObjectName.proto_property, errs,
                                 need_convert)
    return self
end

function TPumpsObjectName:unpack(_) return self.PumpsObjectName end

MPumps.PumpsObjectName = TPumpsObjectName

return MPumps
