-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MFanType = {}

---@class MFanType.FanTypeObjectName
---@field FanTypeObjectName string
local TFanTypeObjectName = {}
TFanTypeObjectName.__index = TFanTypeObjectName
TFanTypeObjectName.group = {}

local function TFanTypeObjectName_from_obj(obj)
    return setmetatable(obj, TFanTypeObjectName)
end

function TFanTypeObjectName.new(FanTypeObjectName)
    return TFanTypeObjectName_from_obj({FanTypeObjectName = FanTypeObjectName})
end
---@param obj MFanType.FanTypeObjectName
function TFanTypeObjectName:init_from_obj(obj)
    self.FanTypeObjectName = obj.FanTypeObjectName
end

function TFanTypeObjectName:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFanTypeObjectName.group)
end

TFanTypeObjectName.from_obj = TFanTypeObjectName_from_obj

TFanTypeObjectName.proto_property = {'FanTypeObjectName'}

TFanTypeObjectName.default = {''}

TFanTypeObjectName.struct = {
    {name = 'FanTypeObjectName', is_array = false, struct = nil}
}

function TFanTypeObjectName:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'FanTypeObjectName', self.FanTypeObjectName,
                      "string", false, errs, need_convert)

    TFanTypeObjectName:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFanTypeObjectName.proto_property, errs,
                                 need_convert)
    return self
end

function TFanTypeObjectName:unpack(_) return self.FanTypeObjectName end

MFanType.FanTypeObjectName = TFanTypeObjectName

return MFanType
