-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MFanGroupPolicy = {}

---@class MFanGroupPolicy.SpeedPercentDifference
---@field SpeedPercentDifference integer
local TSpeedPercentDifference = {}
TSpeedPercentDifference.__index = TSpeedPercentDifference
TSpeedPercentDifference.group = {}

local function TSpeedPercentDifference_from_obj(obj)
    return setmetatable(obj, TSpeedPercentDifference)
end

function TSpeedPercentDifference.new(SpeedPercentDifference)
    return TSpeedPercentDifference_from_obj({
        SpeedPercentDifference = SpeedPercentDifference or 32767
    })
end
---@param obj MFanGroupPolicy.SpeedPercentDifference
function TSpeedPercentDifference:init_from_obj(obj)
    self.SpeedPercentDifference = obj.SpeedPercentDifference or 32767
end

function TSpeedPercentDifference:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSpeedPercentDifference.group)
end

TSpeedPercentDifference.from_obj = TSpeedPercentDifference_from_obj

TSpeedPercentDifference.proto_property = {'SpeedPercentDifference'}

TSpeedPercentDifference.default = {0}

TSpeedPercentDifference.struct = {
    {name = 'SpeedPercentDifference', is_array = false, struct = nil}
}

function TSpeedPercentDifference:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SpeedPercentDifference',
                      self.SpeedPercentDifference, "int16", false, errs,
                      need_convert)

    TSpeedPercentDifference:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSpeedPercentDifference.proto_property,
                                 errs, need_convert)
    return self
end

function TSpeedPercentDifference:unpack(_) return self.SpeedPercentDifference end

MFanGroupPolicy.SpeedPercentDifference = TSpeedPercentDifference

---@class MFanGroupPolicy.RelativeGroupIds
---@field RelativeGroupIds integer[]
local TRelativeGroupIds = {}
TRelativeGroupIds.__index = TRelativeGroupIds
TRelativeGroupIds.group = {}

local function TRelativeGroupIds_from_obj(obj)
    return setmetatable(obj, TRelativeGroupIds)
end

function TRelativeGroupIds.new(RelativeGroupIds)
    return TRelativeGroupIds_from_obj({RelativeGroupIds = RelativeGroupIds})
end
---@param obj MFanGroupPolicy.RelativeGroupIds
function TRelativeGroupIds:init_from_obj(obj)
    self.RelativeGroupIds = obj.RelativeGroupIds
end

function TRelativeGroupIds:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRelativeGroupIds.group)
end

TRelativeGroupIds.from_obj = TRelativeGroupIds_from_obj

TRelativeGroupIds.proto_property = {'RelativeGroupIds'}

TRelativeGroupIds.default = {{}}

TRelativeGroupIds.struct = {
    {name = 'RelativeGroupIds', is_array = true, struct = nil}
}

function TRelativeGroupIds:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'RelativeGroupIds', self.RelativeGroupIds,
                           "uint8", false, errs, need_convert)

    TRelativeGroupIds:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRelativeGroupIds.proto_property, errs,
                                 need_convert)
    return self
end

function TRelativeGroupIds:unpack(_) return self.RelativeGroupIds end

MFanGroupPolicy.RelativeGroupIds = TRelativeGroupIds

---@class MFanGroupPolicy.FanGroupIds
---@field FanGroupIds integer[]
local TFanGroupIds = {}
TFanGroupIds.__index = TFanGroupIds
TFanGroupIds.group = {}

local function TFanGroupIds_from_obj(obj) return setmetatable(obj, TFanGroupIds) end

function TFanGroupIds.new(FanGroupIds)
    return TFanGroupIds_from_obj({FanGroupIds = FanGroupIds})
end
---@param obj MFanGroupPolicy.FanGroupIds
function TFanGroupIds:init_from_obj(obj) self.FanGroupIds = obj.FanGroupIds end

function TFanGroupIds:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFanGroupIds.group)
end

TFanGroupIds.from_obj = TFanGroupIds_from_obj

TFanGroupIds.proto_property = {'FanGroupIds'}

TFanGroupIds.default = {{}}

TFanGroupIds.struct = {{name = 'FanGroupIds', is_array = true, struct = nil}}

function TFanGroupIds:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'FanGroupIds', self.FanGroupIds, "uint8",
                           false, errs, need_convert)

    TFanGroupIds:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFanGroupIds.proto_property, errs,
                                 need_convert)
    return self
end

function TFanGroupIds:unpack(_) return self.FanGroupIds end

MFanGroupPolicy.FanGroupIds = TFanGroupIds

---@class MFanGroupPolicy.PolicyType
---@field PolicyType integer
local TPolicyType = {}
TPolicyType.__index = TPolicyType
TPolicyType.group = {}

local function TPolicyType_from_obj(obj) return setmetatable(obj, TPolicyType) end

function TPolicyType.new(PolicyType)
    return TPolicyType_from_obj({PolicyType = PolicyType or 0})
end
---@param obj MFanGroupPolicy.PolicyType
function TPolicyType:init_from_obj(obj) self.PolicyType = obj.PolicyType or 0 end

function TPolicyType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPolicyType.group)
end

TPolicyType.from_obj = TPolicyType_from_obj

TPolicyType.proto_property = {'PolicyType'}

TPolicyType.default = {0}

TPolicyType.struct = {{name = 'PolicyType', is_array = false, struct = nil}}

function TPolicyType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PolicyType', self.PolicyType, "uint8", false,
                      errs, need_convert)

    TPolicyType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPolicyType.proto_property, errs,
                                 need_convert)
    return self
end

function TPolicyType:unpack(_) return self.PolicyType end

MFanGroupPolicy.PolicyType = TPolicyType

---@class MFanGroupPolicy.Id
---@field Id integer
local TId = {}
TId.__index = TId
TId.group = {}

local function TId_from_obj(obj) return setmetatable(obj, TId) end

function TId.new(Id) return TId_from_obj({Id = Id}) end
---@param obj MFanGroupPolicy.Id
function TId:init_from_obj(obj) self.Id = obj.Id end

function TId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TId.group)
end

TId.from_obj = TId_from_obj

TId.proto_property = {'Id'}

TId.default = {0}

TId.struct = {{name = 'Id', is_array = false, struct = nil}}

function TId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'Id', self.Id, "uint8", false, errs,
                      need_convert)

    TId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TId.proto_property, errs, need_convert)
    return self
end

function TId:unpack(_) return self.Id end

MFanGroupPolicy.Id = TId

return MFanGroupPolicy
