-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MCoolingRequirement = {}

---@class MCoolingRequirement.SmartCoolingTargetTemperature
---@field SmartCoolingTargetTemperature integer[]
local TSmartCoolingTargetTemperature = {}
TSmartCoolingTargetTemperature.__index = TSmartCoolingTargetTemperature
TSmartCoolingTargetTemperature.group = {}

local function TSmartCoolingTargetTemperature_from_obj(obj)
    return setmetatable(obj, TSmartCoolingTargetTemperature)
end

function TSmartCoolingTargetTemperature.new(SmartCoolingTargetTemperature)
    return TSmartCoolingTargetTemperature_from_obj({
        SmartCoolingTargetTemperature = SmartCoolingTargetTemperature
    })
end
---@param obj MCoolingRequirement.SmartCoolingTargetTemperature
function TSmartCoolingTargetTemperature:init_from_obj(obj)
    self.SmartCoolingTargetTemperature = obj.SmartCoolingTargetTemperature
end

function TSmartCoolingTargetTemperature:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs,
                                    TSmartCoolingTargetTemperature.group)
end

TSmartCoolingTargetTemperature.from_obj =
    TSmartCoolingTargetTemperature_from_obj

TSmartCoolingTargetTemperature.proto_property = {
    'SmartCoolingTargetTemperature'
}

TSmartCoolingTargetTemperature.default = {{}}

TSmartCoolingTargetTemperature.struct = {
    {name = 'SmartCoolingTargetTemperature', is_array = true, struct = nil}
}

function TSmartCoolingTargetTemperature:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'SmartCoolingTargetTemperature',
                           self.SmartCoolingTargetTemperature, "int16", false,
                           errs, need_convert)

    TSmartCoolingTargetTemperature:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self,
                                 TSmartCoolingTargetTemperature.proto_property,
                                 errs, need_convert)
    return self
end

function TSmartCoolingTargetTemperature:unpack(_)
    return self.SmartCoolingTargetTemperature
end

MCoolingRequirement.SmartCoolingTargetTemperature =
    TSmartCoolingTargetTemperature

---@class MCoolingRequirement.OriginSmartCoolingTargetTemperature
---@field OriginSmartCoolingTargetTemperature integer[]
local TOriginSmartCoolingTargetTemperature = {}
TOriginSmartCoolingTargetTemperature.__index =
    TOriginSmartCoolingTargetTemperature
TOriginSmartCoolingTargetTemperature.group = {}

local function TOriginSmartCoolingTargetTemperature_from_obj(obj)
    return setmetatable(obj, TOriginSmartCoolingTargetTemperature)
end

function TOriginSmartCoolingTargetTemperature.new(
    OriginSmartCoolingTargetTemperature)
    return TOriginSmartCoolingTargetTemperature_from_obj({
        OriginSmartCoolingTargetTemperature = OriginSmartCoolingTargetTemperature
    })
end
---@param obj MCoolingRequirement.OriginSmartCoolingTargetTemperature
function TOriginSmartCoolingTargetTemperature:init_from_obj(obj)
    self.OriginSmartCoolingTargetTemperature =
        obj.OriginSmartCoolingTargetTemperature
end

function TOriginSmartCoolingTargetTemperature:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs,
                                    TOriginSmartCoolingTargetTemperature.group)
end

TOriginSmartCoolingTargetTemperature.from_obj =
    TOriginSmartCoolingTargetTemperature_from_obj

TOriginSmartCoolingTargetTemperature.proto_property = {
    'OriginSmartCoolingTargetTemperature'
}

TOriginSmartCoolingTargetTemperature.default = {{}}

TOriginSmartCoolingTargetTemperature.struct = {
    {
        name = 'OriginSmartCoolingTargetTemperature',
        is_array = true,
        struct = nil
    }
}

function TOriginSmartCoolingTargetTemperature:validate(prefix, errs,
                                                       need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'OriginSmartCoolingTargetTemperature',
                           self.OriginSmartCoolingTargetTemperature, "uint8",
                           false, errs, need_convert)

    TOriginSmartCoolingTargetTemperature:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self,
                                 TOriginSmartCoolingTargetTemperature.proto_property,
                                 errs, need_convert)
    return self
end

function TOriginSmartCoolingTargetTemperature:unpack(_)
    return self.OriginSmartCoolingTargetTemperature
end

MCoolingRequirement.OriginSmartCoolingTargetTemperature =
    TOriginSmartCoolingTargetTemperature

---@class MCoolingRequirement.OriginMaxAllowedTemperatureCelsius
---@field OriginMaxAllowedTemperatureCelsius integer
local TOriginMaxAllowedTemperatureCelsius = {}
TOriginMaxAllowedTemperatureCelsius.__index =
    TOriginMaxAllowedTemperatureCelsius
TOriginMaxAllowedTemperatureCelsius.group = {}

local function TOriginMaxAllowedTemperatureCelsius_from_obj(obj)
    return setmetatable(obj, TOriginMaxAllowedTemperatureCelsius)
end

function TOriginMaxAllowedTemperatureCelsius.new(
    OriginMaxAllowedTemperatureCelsius)
    return TOriginMaxAllowedTemperatureCelsius_from_obj({
        OriginMaxAllowedTemperatureCelsius = OriginMaxAllowedTemperatureCelsius
    })
end
---@param obj MCoolingRequirement.OriginMaxAllowedTemperatureCelsius
function TOriginMaxAllowedTemperatureCelsius:init_from_obj(obj)
    self.OriginMaxAllowedTemperatureCelsius =
        obj.OriginMaxAllowedTemperatureCelsius
end

function TOriginMaxAllowedTemperatureCelsius:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs,
                                    TOriginMaxAllowedTemperatureCelsius.group)
end

TOriginMaxAllowedTemperatureCelsius.from_obj =
    TOriginMaxAllowedTemperatureCelsius_from_obj

TOriginMaxAllowedTemperatureCelsius.proto_property = {
    'OriginMaxAllowedTemperatureCelsius'
}

TOriginMaxAllowedTemperatureCelsius.default = {0}

TOriginMaxAllowedTemperatureCelsius.struct = {
    {
        name = 'OriginMaxAllowedTemperatureCelsius',
        is_array = false,
        struct = nil
    }
}

function TOriginMaxAllowedTemperatureCelsius:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'OriginMaxAllowedTemperatureCelsius',
                      self.OriginMaxAllowedTemperatureCelsius, "uint8", false,
                      errs, need_convert)

    TOriginMaxAllowedTemperatureCelsius:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self,
                                 TOriginMaxAllowedTemperatureCelsius.proto_property,
                                 errs, need_convert)
    return self
end

function TOriginMaxAllowedTemperatureCelsius:unpack(_)
    return self.OriginMaxAllowedTemperatureCelsius
end

MCoolingRequirement.OriginMaxAllowedTemperatureCelsius =
    TOriginMaxAllowedTemperatureCelsius

---@class MCoolingRequirement.OriginFailedValue
---@field OriginFailedValue integer
local TOriginFailedValue = {}
TOriginFailedValue.__index = TOriginFailedValue
TOriginFailedValue.group = {}

local function TOriginFailedValue_from_obj(obj)
    return setmetatable(obj, TOriginFailedValue)
end

function TOriginFailedValue.new(OriginFailedValue)
    return TOriginFailedValue_from_obj({OriginFailedValue = OriginFailedValue})
end
---@param obj MCoolingRequirement.OriginFailedValue
function TOriginFailedValue:init_from_obj(obj)
    self.OriginFailedValue = obj.OriginFailedValue
end

function TOriginFailedValue:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TOriginFailedValue.group)
end

TOriginFailedValue.from_obj = TOriginFailedValue_from_obj

TOriginFailedValue.proto_property = {'OriginFailedValue'}

TOriginFailedValue.default = {0}

TOriginFailedValue.struct = {
    {name = 'OriginFailedValue', is_array = false, struct = nil}
}

function TOriginFailedValue:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'OriginFailedValue', self.OriginFailedValue,
                      "uint64", false, errs, need_convert)

    TOriginFailedValue:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TOriginFailedValue.proto_property, errs,
                                 need_convert)
    return self
end

function TOriginFailedValue:unpack(_) return self.OriginFailedValue end

MCoolingRequirement.OriginFailedValue = TOriginFailedValue

---@class MCoolingRequirement.OriginTargetTemperatureCelsius
---@field OriginTargetTemperatureCelsius integer
local TOriginTargetTemperatureCelsius = {}
TOriginTargetTemperatureCelsius.__index = TOriginTargetTemperatureCelsius
TOriginTargetTemperatureCelsius.group = {}

local function TOriginTargetTemperatureCelsius_from_obj(obj)
    return setmetatable(obj, TOriginTargetTemperatureCelsius)
end

function TOriginTargetTemperatureCelsius.new(OriginTargetTemperatureCelsius)
    return TOriginTargetTemperatureCelsius_from_obj({
        OriginTargetTemperatureCelsius = OriginTargetTemperatureCelsius
    })
end
---@param obj MCoolingRequirement.OriginTargetTemperatureCelsius
function TOriginTargetTemperatureCelsius:init_from_obj(obj)
    self.OriginTargetTemperatureCelsius = obj.OriginTargetTemperatureCelsius
end

function TOriginTargetTemperatureCelsius:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs,
                                    TOriginTargetTemperatureCelsius.group)
end

TOriginTargetTemperatureCelsius.from_obj =
    TOriginTargetTemperatureCelsius_from_obj

TOriginTargetTemperatureCelsius.proto_property = {
    'OriginTargetTemperatureCelsius'
}

TOriginTargetTemperatureCelsius.default = {0}

TOriginTargetTemperatureCelsius.struct = {
    {name = 'OriginTargetTemperatureCelsius', is_array = false, struct = nil}
}

function TOriginTargetTemperatureCelsius:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'OriginTargetTemperatureCelsius',
                      self.OriginTargetTemperatureCelsius, "uint8", false, errs,
                      need_convert)

    TOriginTargetTemperatureCelsius:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self,
                                 TOriginTargetTemperatureCelsius.proto_property,
                                 errs, need_convert)
    return self
end

function TOriginTargetTemperatureCelsius:unpack(_)
    return self.OriginTargetTemperatureCelsius
end

MCoolingRequirement.OriginTargetTemperatureCelsius =
    TOriginTargetTemperatureCelsius

---@class MCoolingRequirement.SensorName
---@field SensorName string
local TSensorName = {}
TSensorName.__index = TSensorName
TSensorName.group = {}

local function TSensorName_from_obj(obj) return setmetatable(obj, TSensorName) end

function TSensorName.new(SensorName)
    return TSensorName_from_obj({SensorName = SensorName or [=[]=]})
end
---@param obj MCoolingRequirement.SensorName
function TSensorName:init_from_obj(obj)
    self.SensorName = obj.SensorName or [=[]=]
end

function TSensorName:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSensorName.group)
end

TSensorName.from_obj = TSensorName_from_obj

TSensorName.proto_property = {'SensorName'}

TSensorName.default = {''}

TSensorName.struct = {{name = 'SensorName', is_array = false, struct = nil}}

function TSensorName:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SensorName', self.SensorName, "string", false,
                      errs, need_convert)

    TSensorName:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSensorName.proto_property, errs,
                                 need_convert)
    return self
end

function TSensorName:unpack(_) return self.SensorName end

MCoolingRequirement.SensorName = TSensorName

---@class MCoolingRequirement.LiquidFailedValue
---@field LiquidFailedValue integer
local TLiquidFailedValue = {}
TLiquidFailedValue.__index = TLiquidFailedValue
TLiquidFailedValue.group = {}

local function TLiquidFailedValue_from_obj(obj)
    return setmetatable(obj, TLiquidFailedValue)
end

function TLiquidFailedValue.new(LiquidFailedValue)
    return TLiquidFailedValue_from_obj({LiquidFailedValue = LiquidFailedValue})
end
---@param obj MCoolingRequirement.LiquidFailedValue
function TLiquidFailedValue:init_from_obj(obj)
    self.LiquidFailedValue = obj.LiquidFailedValue
end

function TLiquidFailedValue:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLiquidFailedValue.group)
end

TLiquidFailedValue.from_obj = TLiquidFailedValue_from_obj

TLiquidFailedValue.proto_property = {'LiquidFailedValue'}

TLiquidFailedValue.default = {0}

TLiquidFailedValue.struct = {
    {name = 'LiquidFailedValue', is_array = false, struct = nil}
}

function TLiquidFailedValue:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'LiquidFailedValue', self.LiquidFailedValue,
                      "uint64", false, errs, need_convert)

    TLiquidFailedValue:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLiquidFailedValue.proto_property, errs,
                                 need_convert)
    return self
end

function TLiquidFailedValue:unpack(_) return self.LiquidFailedValue end

MCoolingRequirement.LiquidFailedValue = TLiquidFailedValue

---@class MCoolingRequirement.CoolingMedium
---@field CoolingMedium string
local TCoolingMedium = {}
TCoolingMedium.__index = TCoolingMedium
TCoolingMedium.group = {}

local function TCoolingMedium_from_obj(obj)
    return setmetatable(obj, TCoolingMedium)
end

function TCoolingMedium.new(CoolingMedium)
    return TCoolingMedium_from_obj({CoolingMedium = CoolingMedium or [=[Air]=]})
end
---@param obj MCoolingRequirement.CoolingMedium
function TCoolingMedium:init_from_obj(obj)
    self.CoolingMedium = obj.CoolingMedium or [=[Air]=]
end

function TCoolingMedium:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCoolingMedium.group)
end

TCoolingMedium.from_obj = TCoolingMedium_from_obj

TCoolingMedium.proto_property = {'CoolingMedium'}

TCoolingMedium.default = {''}

TCoolingMedium.struct = {
    {name = 'CoolingMedium', is_array = false, struct = nil}
}

function TCoolingMedium:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CoolingMedium', self.CoolingMedium, "string",
                      false, errs, need_convert)

    if self.CoolingMedium ~= nil then
        validate.regex(prefix .. 'CoolingMedium', self.CoolingMedium,
                       [=[^(Air|Liquid)$]=], errs, need_convert)
    end

    TCoolingMedium:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCoolingMedium.proto_property, errs,
                                 need_convert)
    return self
end

function TCoolingMedium:unpack(_) return self.CoolingMedium end

MCoolingRequirement.CoolingMedium = TCoolingMedium

---@class MCoolingRequirement.ObtainTempFaildToValid
---@field ObtainTempFaildToValid boolean
local TObtainTempFaildToValid = {}
TObtainTempFaildToValid.__index = TObtainTempFaildToValid
TObtainTempFaildToValid.group = {}

local function TObtainTempFaildToValid_from_obj(obj)
    return setmetatable(obj, TObtainTempFaildToValid)
end

function TObtainTempFaildToValid.new(ObtainTempFaildToValid)
    return TObtainTempFaildToValid_from_obj({
        ObtainTempFaildToValid = ObtainTempFaildToValid
    })
end
---@param obj MCoolingRequirement.ObtainTempFaildToValid
function TObtainTempFaildToValid:init_from_obj(obj)
    self.ObtainTempFaildToValid = obj.ObtainTempFaildToValid
end

function TObtainTempFaildToValid:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TObtainTempFaildToValid.group)
end

TObtainTempFaildToValid.from_obj = TObtainTempFaildToValid_from_obj

TObtainTempFaildToValid.proto_property = {'ObtainTempFaildToValid'}

TObtainTempFaildToValid.default = {false}

TObtainTempFaildToValid.struct = {
    {name = 'ObtainTempFaildToValid', is_array = false, struct = nil}
}

function TObtainTempFaildToValid:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ObtainTempFaildToValid',
                      self.ObtainTempFaildToValid, "bool", false, errs,
                      need_convert)

    TObtainTempFaildToValid:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TObtainTempFaildToValid.proto_property,
                                 errs, need_convert)
    return self
end

function TObtainTempFaildToValid:unpack(_) return self.ObtainTempFaildToValid end

MCoolingRequirement.ObtainTempFaildToValid = TObtainTempFaildToValid

---@class MCoolingRequirement.IsBackupRequirement
---@field IsBackupRequirement boolean
local TIsBackupRequirement = {}
TIsBackupRequirement.__index = TIsBackupRequirement
TIsBackupRequirement.group = {}

local function TIsBackupRequirement_from_obj(obj)
    return setmetatable(obj, TIsBackupRequirement)
end

function TIsBackupRequirement.new(IsBackupRequirement)
    return TIsBackupRequirement_from_obj({
        IsBackupRequirement = IsBackupRequirement or false
    })
end
---@param obj MCoolingRequirement.IsBackupRequirement
function TIsBackupRequirement:init_from_obj(obj)
    self.IsBackupRequirement = obj.IsBackupRequirement or false
end

function TIsBackupRequirement:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TIsBackupRequirement.group)
end

TIsBackupRequirement.from_obj = TIsBackupRequirement_from_obj

TIsBackupRequirement.proto_property = {'IsBackupRequirement'}

TIsBackupRequirement.default = {false}

TIsBackupRequirement.struct = {
    {name = 'IsBackupRequirement', is_array = false, struct = nil}
}

function TIsBackupRequirement:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'IsBackupRequirement', self.IsBackupRequirement,
                      "bool", false, errs, need_convert)

    TIsBackupRequirement:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TIsBackupRequirement.proto_property,
                                 errs, need_convert)
    return self
end

function TIsBackupRequirement:unpack(_) return self.IsBackupRequirement end

MCoolingRequirement.IsBackupRequirement = TIsBackupRequirement

---@class MCoolingRequirement.BackupRequirementIdx
---@field BackupRequirementIdx integer
local TBackupRequirementIdx = {}
TBackupRequirementIdx.__index = TBackupRequirementIdx
TBackupRequirementIdx.group = {}

local function TBackupRequirementIdx_from_obj(obj)
    return setmetatable(obj, TBackupRequirementIdx)
end

function TBackupRequirementIdx.new(BackupRequirementIdx)
    return TBackupRequirementIdx_from_obj({
        BackupRequirementIdx = BackupRequirementIdx
    })
end
---@param obj MCoolingRequirement.BackupRequirementIdx
function TBackupRequirementIdx:init_from_obj(obj)
    self.BackupRequirementIdx = obj.BackupRequirementIdx
end

function TBackupRequirementIdx:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBackupRequirementIdx.group)
end

TBackupRequirementIdx.from_obj = TBackupRequirementIdx_from_obj

TBackupRequirementIdx.proto_property = {'BackupRequirementIdx'}

TBackupRequirementIdx.default = {0}

TBackupRequirementIdx.struct = {
    {name = 'BackupRequirementIdx', is_array = false, struct = nil}
}

function TBackupRequirementIdx:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BackupRequirementIdx',
                      self.BackupRequirementIdx, "uint64", false, errs,
                      need_convert)

    TBackupRequirementIdx:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBackupRequirementIdx.proto_property,
                                 errs, need_convert)
    return self
end

function TBackupRequirementIdx:unpack(_) return self.BackupRequirementIdx end

MCoolingRequirement.BackupRequirementIdx = TBackupRequirementIdx

---@class MCoolingRequirement.IsValid
---@field IsValid integer
local TIsValid = {}
TIsValid.__index = TIsValid
TIsValid.group = {}

local function TIsValid_from_obj(obj) return setmetatable(obj, TIsValid) end

function TIsValid.new(IsValid) return
    TIsValid_from_obj({IsValid = IsValid or 1}) end
---@param obj MCoolingRequirement.IsValid
function TIsValid:init_from_obj(obj) self.IsValid = obj.IsValid or 1 end

function TIsValid:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TIsValid.group)
end

TIsValid.from_obj = TIsValid_from_obj

TIsValid.proto_property = {'IsValid'}

TIsValid.default = {0}

TIsValid.struct = {{name = 'IsValid', is_array = false, struct = nil}}

function TIsValid:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'IsValid', self.IsValid, "uint8", false, errs,
                      need_convert)

    TIsValid:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TIsValid.proto_property, errs,
                                 need_convert)
    return self
end

function TIsValid:unpack(_) return self.IsValid end

MCoolingRequirement.IsValid = TIsValid

---@class MCoolingRequirement.Enabled
---@field Enabled boolean
local TEnabled = {}
TEnabled.__index = TEnabled
TEnabled.group = {}

local function TEnabled_from_obj(obj) return setmetatable(obj, TEnabled) end

function TEnabled.new(Enabled)
    return TEnabled_from_obj({Enabled = Enabled == nil and true or Enabled})
end
---@param obj MCoolingRequirement.Enabled
function TEnabled:init_from_obj(obj)
    self.Enabled = obj.Enabled == nil and true or obj.Enabled
end

function TEnabled:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TEnabled.group)
end

TEnabled.from_obj = TEnabled_from_obj

TEnabled.proto_property = {'Enabled'}

TEnabled.default = {false}

TEnabled.struct = {{name = 'Enabled', is_array = false, struct = nil}}

function TEnabled:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Enabled', self.Enabled, "bool", false, errs,
                      need_convert)

    TEnabled:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TEnabled.proto_property, errs,
                                 need_convert)
    return self
end

function TEnabled:unpack(_) return self.Enabled end

MCoolingRequirement.Enabled = TEnabled

---@class MCoolingRequirement.Slot
---@field Slot integer
local TSlot = {}
TSlot.__index = TSlot
TSlot.group = {}

local function TSlot_from_obj(obj) return setmetatable(obj, TSlot) end

function TSlot.new(Slot) return TSlot_from_obj({Slot = Slot}) end
---@param obj MCoolingRequirement.Slot
function TSlot:init_from_obj(obj) self.Slot = obj.Slot end

function TSlot:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSlot.group)
end

TSlot.from_obj = TSlot_from_obj

TSlot.proto_property = {'Slot'}

TSlot.default = {0}

TSlot.struct = {{name = 'Slot', is_array = false, struct = nil}}

function TSlot:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Slot', self.Slot, "uint8", false, errs,
                      need_convert)

    TSlot:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSlot.proto_property, errs, need_convert)
    return self
end

function TSlot:unpack(_) return self.Slot end

MCoolingRequirement.Slot = TSlot

---@class MCoolingRequirement.BaseId
---@field BaseId integer
local TBaseId = {}
TBaseId.__index = TBaseId
TBaseId.group = {}

local function TBaseId_from_obj(obj) return setmetatable(obj, TBaseId) end

function TBaseId.new(BaseId) return TBaseId_from_obj({BaseId = BaseId}) end
---@param obj MCoolingRequirement.BaseId
function TBaseId:init_from_obj(obj) self.BaseId = obj.BaseId end

function TBaseId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBaseId.group)
end

TBaseId.from_obj = TBaseId_from_obj

TBaseId.proto_property = {'BaseId'}

TBaseId.default = {0}

TBaseId.struct = {{name = 'BaseId', is_array = false, struct = nil}}

function TBaseId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BaseId', self.BaseId, "uint8", false, errs,
                      need_convert)

    TBaseId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBaseId.proto_property, errs,
                                 need_convert)
    return self
end

function TBaseId:unpack(_) return self.BaseId end

MCoolingRequirement.BaseId = TBaseId

return MCoolingRequirement
