-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MCoolingConfig = {}

---@class MCoolingConfig.InitLevelInStartup
---@field InitLevelInStartup integer
local TInitLevelInStartup = {}
TInitLevelInStartup.__index = TInitLevelInStartup
TInitLevelInStartup.group = {}

local function TInitLevelInStartup_from_obj(obj)
    return setmetatable(obj, TInitLevelInStartup)
end

function TInitLevelInStartup.new(InitLevelInStartup)
    return TInitLevelInStartup_from_obj({
        InitLevelInStartup = InitLevelInStartup or 100
    })
end
---@param obj MCoolingConfig.InitLevelInStartup
function TInitLevelInStartup:init_from_obj(obj)
    self.InitLevelInStartup = obj.InitLevelInStartup or 100
end

function TInitLevelInStartup:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TInitLevelInStartup.group)
end

TInitLevelInStartup.from_obj = TInitLevelInStartup_from_obj

TInitLevelInStartup.proto_property = {'InitLevelInStartup'}

TInitLevelInStartup.default = {0}

TInitLevelInStartup.struct = {
    {name = 'InitLevelInStartup', is_array = false, struct = nil}
}

function TInitLevelInStartup:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'InitLevelInStartup', self.InitLevelInStartup,
                      "uint8", false, errs, need_convert)

    validate.ranges(prefix .. 'InitLevelInStartup', self.InitLevelInStartup, 0,
                    100, errs, need_convert)

    TInitLevelInStartup:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TInitLevelInStartup.proto_property, errs,
                                 need_convert)
    return self
end

function TInitLevelInStartup:unpack(_) return self.InitLevelInStartup end

MCoolingConfig.InitLevelInStartup = TInitLevelInStartup

---@class MCoolingConfig.OriginalSmartCoolingMode
---@field OriginalSmartCoolingMode string
local TOriginalSmartCoolingMode = {}
TOriginalSmartCoolingMode.__index = TOriginalSmartCoolingMode
TOriginalSmartCoolingMode.group = {}

local function TOriginalSmartCoolingMode_from_obj(obj)
    return setmetatable(obj, TOriginalSmartCoolingMode)
end

function TOriginalSmartCoolingMode.new(OriginalSmartCoolingMode)
    return TOriginalSmartCoolingMode_from_obj({
        OriginalSmartCoolingMode = OriginalSmartCoolingMode or [=[]=]
    })
end
---@param obj MCoolingConfig.OriginalSmartCoolingMode
function TOriginalSmartCoolingMode:init_from_obj(obj)
    self.OriginalSmartCoolingMode = obj.OriginalSmartCoolingMode or [=[]=]
end

function TOriginalSmartCoolingMode:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TOriginalSmartCoolingMode.group)
end

TOriginalSmartCoolingMode.from_obj = TOriginalSmartCoolingMode_from_obj

TOriginalSmartCoolingMode.proto_property = {'OriginalSmartCoolingMode'}

TOriginalSmartCoolingMode.default = {''}

TOriginalSmartCoolingMode.struct = {
    {name = 'OriginalSmartCoolingMode', is_array = false, struct = nil}
}

function TOriginalSmartCoolingMode:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'OriginalSmartCoolingMode',
                      self.OriginalSmartCoolingMode, "string", false, errs,
                      need_convert)

    TOriginalSmartCoolingMode:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TOriginalSmartCoolingMode.proto_property,
                                 errs, need_convert)
    return self
end

function TOriginalSmartCoolingMode:unpack(_) return
    self.OriginalSmartCoolingMode end

MCoolingConfig.OriginalSmartCoolingMode = TOriginalSmartCoolingMode

---@class MCoolingConfig.FanBoardNum
---@field FanBoardNum integer
local TFanBoardNum = {}
TFanBoardNum.__index = TFanBoardNum
TFanBoardNum.group = {}

local function TFanBoardNum_from_obj(obj) return setmetatable(obj, TFanBoardNum) end

function TFanBoardNum.new(FanBoardNum)
    return TFanBoardNum_from_obj({FanBoardNum = FanBoardNum or 1})
end
---@param obj MCoolingConfig.FanBoardNum
function TFanBoardNum:init_from_obj(obj) self.FanBoardNum = obj.FanBoardNum or 1 end

function TFanBoardNum:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFanBoardNum.group)
end

TFanBoardNum.from_obj = TFanBoardNum_from_obj

TFanBoardNum.proto_property = {'FanBoardNum'}

TFanBoardNum.default = {0}

TFanBoardNum.struct = {{name = 'FanBoardNum', is_array = false, struct = nil}}

function TFanBoardNum:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FanBoardNum', self.FanBoardNum, "uint8", false,
                      errs, need_convert)

    TFanBoardNum:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFanBoardNum.proto_property, errs,
                                 need_convert)
    return self
end

function TFanBoardNum:unpack(_) return self.FanBoardNum end

MCoolingConfig.FanBoardNum = TFanBoardNum

---@class MCoolingConfig.CoolingWay
---@field CoolingWay string
local TCoolingWay = {}
TCoolingWay.__index = TCoolingWay
TCoolingWay.group = {}

local function TCoolingWay_from_obj(obj) return setmetatable(obj, TCoolingWay) end

function TCoolingWay.new(CoolingWay)
    return TCoolingWay_from_obj({CoolingWay = CoolingWay or [=[Proactive]=]})
end
---@param obj MCoolingConfig.CoolingWay
function TCoolingWay:init_from_obj(obj)
    self.CoolingWay = obj.CoolingWay or [=[Proactive]=]
end

function TCoolingWay:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCoolingWay.group)
end

TCoolingWay.from_obj = TCoolingWay_from_obj

TCoolingWay.proto_property = {'CoolingWay'}

TCoolingWay.default = {''}

TCoolingWay.struct = {{name = 'CoolingWay', is_array = false, struct = nil}}

function TCoolingWay:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CoolingWay', self.CoolingWay, "string", false,
                      errs, need_convert)

    if self.CoolingWay ~= nil then
        validate.regex(prefix .. 'CoolingWay', self.CoolingWay,
                       [=[^(Proactive|Passive)$]=], errs, need_convert)
    end

    TCoolingWay:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCoolingWay.proto_property, errs,
                                 need_convert)
    return self
end

function TCoolingWay:unpack(_) return self.CoolingWay end

MCoolingConfig.CoolingWay = TCoolingWay

---@class MCoolingConfig.FanCtrlEnable
---@field FanCtrlEnable string
local TFanCtrlEnable = {}
TFanCtrlEnable.__index = TFanCtrlEnable
TFanCtrlEnable.group = {}

local function TFanCtrlEnable_from_obj(obj)
    return setmetatable(obj, TFanCtrlEnable)
end

function TFanCtrlEnable.new(FanCtrlEnable)
    return TFanCtrlEnable_from_obj({
        FanCtrlEnable = FanCtrlEnable or [=[Enabled]=]
    })
end
---@param obj MCoolingConfig.FanCtrlEnable
function TFanCtrlEnable:init_from_obj(obj)
    self.FanCtrlEnable = obj.FanCtrlEnable or [=[Enabled]=]
end

function TFanCtrlEnable:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFanCtrlEnable.group)
end

TFanCtrlEnable.from_obj = TFanCtrlEnable_from_obj

TFanCtrlEnable.proto_property = {'FanCtrlEnable'}

TFanCtrlEnable.default = {''}

TFanCtrlEnable.struct = {
    {name = 'FanCtrlEnable', is_array = false, struct = nil}
}

function TFanCtrlEnable:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FanCtrlEnable', self.FanCtrlEnable, "string",
                      false, errs, need_convert)

    if self.FanCtrlEnable ~= nil then
        validate.regex(prefix .. 'FanCtrlEnable', self.FanCtrlEnable,
                       [=[^(Enabled|Disabled)$]=], errs, need_convert)
    end

    TFanCtrlEnable:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFanCtrlEnable.proto_property, errs,
                                 need_convert)
    return self
end

function TFanCtrlEnable:unpack(_) return self.FanCtrlEnable end

MCoolingConfig.FanCtrlEnable = TFanCtrlEnable

---@class MCoolingConfig.FanLevel
---@field FanLevel integer
local TFanLevel = {}
TFanLevel.__index = TFanLevel
TFanLevel.group = {}

local function TFanLevel_from_obj(obj) return setmetatable(obj, TFanLevel) end

function TFanLevel.new(FanLevel)
    return TFanLevel_from_obj({FanLevel = FanLevel or 20})
end
---@param obj MCoolingConfig.FanLevel
function TFanLevel:init_from_obj(obj) self.FanLevel = obj.FanLevel or 20 end

function TFanLevel:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFanLevel.group)
end

TFanLevel.from_obj = TFanLevel_from_obj

TFanLevel.proto_property = {'FanLevel'}

TFanLevel.default = {0}

TFanLevel.struct = {{name = 'FanLevel', is_array = false, struct = nil}}

function TFanLevel:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FanLevel', self.FanLevel, "uint8", false, errs,
                      need_convert)

    TFanLevel:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFanLevel.proto_property, errs,
                                 need_convert)
    return self
end

function TFanLevel:unpack(_) return self.FanLevel end

MCoolingConfig.FanLevel = TFanLevel

---@class MCoolingConfig.MaxLimitLevel
---@field MaxLimitLevel integer
local TMaxLimitLevel = {}
TMaxLimitLevel.__index = TMaxLimitLevel
TMaxLimitLevel.group = {}

local function TMaxLimitLevel_from_obj(obj)
    return setmetatable(obj, TMaxLimitLevel)
end

function TMaxLimitLevel.new(MaxLimitLevel)
    return TMaxLimitLevel_from_obj({MaxLimitLevel = MaxLimitLevel or 100})
end
---@param obj MCoolingConfig.MaxLimitLevel
function TMaxLimitLevel:init_from_obj(obj)
    self.MaxLimitLevel = obj.MaxLimitLevel or 100
end

function TMaxLimitLevel:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMaxLimitLevel.group)
end

TMaxLimitLevel.from_obj = TMaxLimitLevel_from_obj

TMaxLimitLevel.proto_property = {'MaxLimitLevel'}

TMaxLimitLevel.default = {0}

TMaxLimitLevel.struct = {
    {name = 'MaxLimitLevel', is_array = false, struct = nil}
}

function TMaxLimitLevel:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'MaxLimitLevel', self.MaxLimitLevel, "uint8",
                      false, errs, need_convert)

    TMaxLimitLevel:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMaxLimitLevel.proto_property, errs,
                                 need_convert)
    return self
end

function TMaxLimitLevel:unpack(_) return self.MaxLimitLevel end

MCoolingConfig.MaxLimitLevel = TMaxLimitLevel

---@class MCoolingConfig.MinimalLevel
---@field MinimalLevel integer
local TMinimalLevel = {}
TMinimalLevel.__index = TMinimalLevel
TMinimalLevel.group = {}

local function TMinimalLevel_from_obj(obj)
    return setmetatable(obj, TMinimalLevel)
end

function TMinimalLevel.new(MinimalLevel)
    return TMinimalLevel_from_obj({MinimalLevel = MinimalLevel or 20})
end
---@param obj MCoolingConfig.MinimalLevel
function TMinimalLevel:init_from_obj(obj)
    self.MinimalLevel = obj.MinimalLevel or 20
end

function TMinimalLevel:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMinimalLevel.group)
end

TMinimalLevel.from_obj = TMinimalLevel_from_obj

TMinimalLevel.proto_property = {'MinimalLevel'}

TMinimalLevel.default = {0}

TMinimalLevel.struct = {{name = 'MinimalLevel', is_array = false, struct = nil}}

function TMinimalLevel:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'MinimalLevel', self.MinimalLevel, "uint8",
                      false, errs, need_convert)

    TMinimalLevel:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMinimalLevel.proto_property, errs,
                                 need_convert)
    return self
end

function TMinimalLevel:unpack(_) return self.MinimalLevel end

MCoolingConfig.MinimalLevel = TMinimalLevel

---@class MCoolingConfig.Id
---@field Id integer
local TId = {}
TId.__index = TId
TId.group = {}

local function TId_from_obj(obj) return setmetatable(obj, TId) end

function TId.new(Id) return TId_from_obj({Id = Id}) end
---@param obj MCoolingConfig.Id
function TId:init_from_obj(obj) self.Id = obj.Id end

function TId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TId.group)
end

TId.from_obj = TId_from_obj

TId.proto_property = {'Id'}

TId.default = {0}

TId.struct = {{name = 'Id', is_array = false, struct = nil}}

function TId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'Id', self.Id, "uint8", false, errs,
                      need_convert)

    TId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TId.proto_property, errs, need_convert)
    return self
end

function TId:unpack(_) return self.Id end

MCoolingConfig.Id = TId

return MCoolingConfig
