-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MBasicCoolingConfig = {}

---@class MBasicCoolingConfig.Id
---@field Id integer
local TId = {}
TId.__index = TId
TId.group = {}

local function TId_from_obj(obj) return setmetatable(obj, TId) end

function TId.new(Id) return TId_from_obj({Id = Id or 1}) end
---@param obj MBasicCoolingConfig.Id
function TId:init_from_obj(obj) self.Id = obj.Id or 1 end

function TId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TId.group)
end

TId.from_obj = TId_from_obj

TId.proto_property = {'Id'}

TId.default = {0}

TId.struct = {{name = 'Id', is_array = false, struct = nil}}

function TId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'Id', self.Id, "uint8", false, errs,
                      need_convert)

    TId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TId.proto_property, errs, need_convert)
    return self
end

function TId:unpack(_) return self.Id end

MBasicCoolingConfig.Id = TId

---@class MBasicCoolingConfig.PsuFanSpeedCalibration
---@field PsuFanSpeedCalibration integer
local TPsuFanSpeedCalibration = {}
TPsuFanSpeedCalibration.__index = TPsuFanSpeedCalibration
TPsuFanSpeedCalibration.group = {}

local function TPsuFanSpeedCalibration_from_obj(obj)
    return setmetatable(obj, TPsuFanSpeedCalibration)
end

function TPsuFanSpeedCalibration.new(PsuFanSpeedCalibration)
    return TPsuFanSpeedCalibration_from_obj({
        PsuFanSpeedCalibration = PsuFanSpeedCalibration or 32767
    })
end
---@param obj MBasicCoolingConfig.PsuFanSpeedCalibration
function TPsuFanSpeedCalibration:init_from_obj(obj)
    self.PsuFanSpeedCalibration = obj.PsuFanSpeedCalibration or 32767
end

function TPsuFanSpeedCalibration:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPsuFanSpeedCalibration.group)
end

TPsuFanSpeedCalibration.from_obj = TPsuFanSpeedCalibration_from_obj

TPsuFanSpeedCalibration.proto_property = {'PsuFanSpeedCalibration'}

TPsuFanSpeedCalibration.default = {0}

TPsuFanSpeedCalibration.struct = {
    {name = 'PsuFanSpeedCalibration', is_array = false, struct = nil}
}

function TPsuFanSpeedCalibration:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PsuFanSpeedCalibration',
                      self.PsuFanSpeedCalibration, "int16", false, errs,
                      need_convert)

    TPsuFanSpeedCalibration:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPsuFanSpeedCalibration.proto_property,
                                 errs, need_convert)
    return self
end

function TPsuFanSpeedCalibration:unpack(_) return self.PsuFanSpeedCalibration end

MBasicCoolingConfig.PsuFanSpeedCalibration = TPsuFanSpeedCalibration

---@class MBasicCoolingConfig.FanGroupSpeedDiffThresholdPercent
---@field FanGroupSpeedDiffThresholdPercent integer
local TFanGroupSpeedDiffThresholdPercent = {}
TFanGroupSpeedDiffThresholdPercent.__index = TFanGroupSpeedDiffThresholdPercent
TFanGroupSpeedDiffThresholdPercent.group = {}

local function TFanGroupSpeedDiffThresholdPercent_from_obj(obj)
    return setmetatable(obj, TFanGroupSpeedDiffThresholdPercent)
end

function TFanGroupSpeedDiffThresholdPercent.new(
    FanGroupSpeedDiffThresholdPercent)
    return TFanGroupSpeedDiffThresholdPercent_from_obj({
        FanGroupSpeedDiffThresholdPercent = FanGroupSpeedDiffThresholdPercent or
            32767
    })
end
---@param obj MBasicCoolingConfig.FanGroupSpeedDiffThresholdPercent
function TFanGroupSpeedDiffThresholdPercent:init_from_obj(obj)
    self.FanGroupSpeedDiffThresholdPercent =
        obj.FanGroupSpeedDiffThresholdPercent or 32767
end

function TFanGroupSpeedDiffThresholdPercent:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs,
                                    TFanGroupSpeedDiffThresholdPercent.group)
end

TFanGroupSpeedDiffThresholdPercent.from_obj =
    TFanGroupSpeedDiffThresholdPercent_from_obj

TFanGroupSpeedDiffThresholdPercent.proto_property = {
    'FanGroupSpeedDiffThresholdPercent'
}

TFanGroupSpeedDiffThresholdPercent.default = {0}

TFanGroupSpeedDiffThresholdPercent.struct = {
    {name = 'FanGroupSpeedDiffThresholdPercent', is_array = false, struct = nil}
}

function TFanGroupSpeedDiffThresholdPercent:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FanGroupSpeedDiffThresholdPercent',
                      self.FanGroupSpeedDiffThresholdPercent, "int16", false,
                      errs, need_convert)

    TFanGroupSpeedDiffThresholdPercent:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self,
                                 TFanGroupSpeedDiffThresholdPercent.proto_property,
                                 errs, need_convert)
    return self
end

function TFanGroupSpeedDiffThresholdPercent:unpack(_)
    return self.FanGroupSpeedDiffThresholdPercent
end

MBasicCoolingConfig.FanGroupSpeedDiffThresholdPercent =
    TFanGroupSpeedDiffThresholdPercent

return MBasicCoolingConfig
