-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MAbnormalPump = {}

---@class MAbnormalPump.AirCoolingPWMs
---@field AirCoolingPWMs integer[]
local TAirCoolingPWMs = {}
TAirCoolingPWMs.__index = TAirCoolingPWMs
TAirCoolingPWMs.group = {}

local function TAirCoolingPWMs_from_obj(obj)
    return setmetatable(obj, TAirCoolingPWMs)
end

function TAirCoolingPWMs.new(AirCoolingPWMs)
    return TAirCoolingPWMs_from_obj({AirCoolingPWMs = AirCoolingPWMs})
end
---@param obj MAbnormalPump.AirCoolingPWMs
function TAirCoolingPWMs:init_from_obj(obj)
    self.AirCoolingPWMs = obj.AirCoolingPWMs
end

function TAirCoolingPWMs:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAirCoolingPWMs.group)
end

TAirCoolingPWMs.from_obj = TAirCoolingPWMs_from_obj

TAirCoolingPWMs.proto_property = {'AirCoolingPWMs'}

TAirCoolingPWMs.default = {{}}

TAirCoolingPWMs.struct = {
    {name = 'AirCoolingPWMs', is_array = true, struct = nil}
}

function TAirCoolingPWMs:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'AirCoolingPWMs', self.AirCoolingPWMs,
                           "uint8", false, errs, need_convert)

    TAirCoolingPWMs:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAirCoolingPWMs.proto_property, errs,
                                 need_convert)
    return self
end

function TAirCoolingPWMs:unpack(_) return self.AirCoolingPWMs end

MAbnormalPump.AirCoolingPWMs = TAirCoolingPWMs

---@class MAbnormalPump.LiquidCoolingPWMs
---@field LiquidCoolingPWMs integer[]
local TLiquidCoolingPWMs = {}
TLiquidCoolingPWMs.__index = TLiquidCoolingPWMs
TLiquidCoolingPWMs.group = {}

local function TLiquidCoolingPWMs_from_obj(obj)
    return setmetatable(obj, TLiquidCoolingPWMs)
end

function TLiquidCoolingPWMs.new(LiquidCoolingPWMs)
    return TLiquidCoolingPWMs_from_obj({LiquidCoolingPWMs = LiquidCoolingPWMs})
end
---@param obj MAbnormalPump.LiquidCoolingPWMs
function TLiquidCoolingPWMs:init_from_obj(obj)
    self.LiquidCoolingPWMs = obj.LiquidCoolingPWMs
end

function TLiquidCoolingPWMs:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLiquidCoolingPWMs.group)
end

TLiquidCoolingPWMs.from_obj = TLiquidCoolingPWMs_from_obj

TLiquidCoolingPWMs.proto_property = {'LiquidCoolingPWMs'}

TLiquidCoolingPWMs.default = {{}}

TLiquidCoolingPWMs.struct = {
    {name = 'LiquidCoolingPWMs', is_array = true, struct = nil}
}

function TLiquidCoolingPWMs:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'LiquidCoolingPWMs',
                           self.LiquidCoolingPWMs, "uint8", false, errs,
                           need_convert)

    TLiquidCoolingPWMs:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLiquidCoolingPWMs.proto_property, errs,
                                 need_convert)
    return self
end

function TLiquidCoolingPWMs:unpack(_) return self.LiquidCoolingPWMs end

MAbnormalPump.LiquidCoolingPWMs = TLiquidCoolingPWMs

---@class MAbnormalPump.AirCoolingIds
---@field AirCoolingIds integer[]
local TAirCoolingIds = {}
TAirCoolingIds.__index = TAirCoolingIds
TAirCoolingIds.group = {}

local function TAirCoolingIds_from_obj(obj)
    return setmetatable(obj, TAirCoolingIds)
end

function TAirCoolingIds.new(AirCoolingIds)
    return TAirCoolingIds_from_obj({AirCoolingIds = AirCoolingIds})
end
---@param obj MAbnormalPump.AirCoolingIds
function TAirCoolingIds:init_from_obj(obj) self.AirCoolingIds =
    obj.AirCoolingIds end

function TAirCoolingIds:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAirCoolingIds.group)
end

TAirCoolingIds.from_obj = TAirCoolingIds_from_obj

TAirCoolingIds.proto_property = {'AirCoolingIds'}

TAirCoolingIds.default = {{}}

TAirCoolingIds.struct = {
    {name = 'AirCoolingIds', is_array = true, struct = nil}
}

function TAirCoolingIds:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'AirCoolingIds', self.AirCoolingIds,
                           "uint32", false, errs, need_convert)

    TAirCoolingIds:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAirCoolingIds.proto_property, errs,
                                 need_convert)
    return self
end

function TAirCoolingIds:unpack(_) return self.AirCoolingIds end

MAbnormalPump.AirCoolingIds = TAirCoolingIds

---@class MAbnormalPump.LiquidCoolingIds
---@field LiquidCoolingIds integer[]
local TLiquidCoolingIds = {}
TLiquidCoolingIds.__index = TLiquidCoolingIds
TLiquidCoolingIds.group = {}

local function TLiquidCoolingIds_from_obj(obj)
    return setmetatable(obj, TLiquidCoolingIds)
end

function TLiquidCoolingIds.new(LiquidCoolingIds)
    return TLiquidCoolingIds_from_obj({LiquidCoolingIds = LiquidCoolingIds})
end
---@param obj MAbnormalPump.LiquidCoolingIds
function TLiquidCoolingIds:init_from_obj(obj)
    self.LiquidCoolingIds = obj.LiquidCoolingIds
end

function TLiquidCoolingIds:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLiquidCoolingIds.group)
end

TLiquidCoolingIds.from_obj = TLiquidCoolingIds_from_obj

TLiquidCoolingIds.proto_property = {'LiquidCoolingIds'}

TLiquidCoolingIds.default = {{}}

TLiquidCoolingIds.struct = {
    {name = 'LiquidCoolingIds', is_array = true, struct = nil}
}

function TLiquidCoolingIds:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'LiquidCoolingIds', self.LiquidCoolingIds,
                           "uint32", false, errs, need_convert)

    TLiquidCoolingIds:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLiquidCoolingIds.proto_property, errs,
                                 need_convert)
    return self
end

function TLiquidCoolingIds:unpack(_) return self.LiquidCoolingIds end

MAbnormalPump.LiquidCoolingIds = TLiquidCoolingIds

---@class MAbnormalPump.Models
---@field Models string
local TModels = {}
TModels.__index = TModels
TModels.group = {}

local function TModels_from_obj(obj) return setmetatable(obj, TModels) end

function TModels.new(Models) return TModels_from_obj({Models = Models}) end
---@param obj MAbnormalPump.Models
function TModels:init_from_obj(obj) self.Models = obj.Models end

function TModels:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TModels.group)
end

TModels.from_obj = TModels_from_obj

TModels.proto_property = {'Models'}

TModels.default = {''}

TModels.struct = {{name = 'Models', is_array = false, struct = nil}}

function TModels:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Models', self.Models, "string", false, errs,
                      need_convert)

    if self.Models ~= nil then
        validate.regex(prefix .. 'Models', self.Models,
                       [=[^(AbnormalRotation|NotInPosition|StopWorking)$]=],
                       errs, need_convert)
    end

    TModels:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TModels.proto_property, errs,
                                 need_convert)
    return self
end

function TModels:unpack(_) return self.Models end

MAbnormalPump.Models = TModels

---@class MAbnormalPump.DeviceId
---@field DeviceId integer
local TDeviceId = {}
TDeviceId.__index = TDeviceId
TDeviceId.group = {}

local function TDeviceId_from_obj(obj) return setmetatable(obj, TDeviceId) end

function TDeviceId.new(DeviceId) return
    TDeviceId_from_obj({DeviceId = DeviceId}) end
---@param obj MAbnormalPump.DeviceId
function TDeviceId:init_from_obj(obj) self.DeviceId = obj.DeviceId end

function TDeviceId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDeviceId.group)
end

TDeviceId.from_obj = TDeviceId_from_obj

TDeviceId.proto_property = {'DeviceId'}

TDeviceId.default = {0}

TDeviceId.struct = {{name = 'DeviceId', is_array = false, struct = nil}}

function TDeviceId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DeviceId', self.DeviceId, "uint32", false,
                      errs, need_convert)

    TDeviceId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDeviceId.proto_property, errs,
                                 need_convert)
    return self
end

function TDeviceId:unpack(_) return self.DeviceId end

MAbnormalPump.DeviceId = TDeviceId

---@class MAbnormalPump.Id
---@field Id integer
local TId = {}
TId.__index = TId
TId.group = {}

local function TId_from_obj(obj) return setmetatable(obj, TId) end

function TId.new(Id) return TId_from_obj({Id = Id}) end
---@param obj MAbnormalPump.Id
function TId:init_from_obj(obj) self.Id = obj.Id end

function TId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TId.group)
end

TId.from_obj = TId_from_obj

TId.proto_property = {'Id'}

TId.default = {0}

TId.struct = {{name = 'Id', is_array = false, struct = nil}}

function TId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Id', self.Id, "uint32", false, errs,
                      need_convert)

    TId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TId.proto_property, errs, need_convert)
    return self
end

function TId:unpack(_) return self.Id end

MAbnormalPump.Id = TId

return MAbnormalPump
