-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MAbnormalFan = {}

---@class MAbnormalFan.Priority
---@field Priority integer
local TPriority = {}
TPriority.__index = TPriority
TPriority.group = {}

local function TPriority_from_obj(obj) return setmetatable(obj, TPriority) end

function TPriority.new(Priority)
    return TPriority_from_obj({Priority = Priority or 1})
end
---@param obj MAbnormalFan.Priority
function TPriority:init_from_obj(obj) self.Priority = obj.Priority or 1 end

function TPriority:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPriority.group)
end

TPriority.from_obj = TPriority_from_obj

TPriority.proto_property = {'Priority'}

TPriority.default = {0}

TPriority.struct = {{name = 'Priority', is_array = false, struct = nil}}

function TPriority:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Priority', self.Priority, "uint8", false, errs,
                      need_convert)

    TPriority:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPriority.proto_property, errs,
                                 need_convert)
    return self
end

function TPriority:unpack(_) return self.Priority end

MAbnormalFan.Priority = TPriority

---@class MAbnormalFan.SpeedPercentage
---@field SpeedPercentage integer
local TSpeedPercentage = {}
TSpeedPercentage.__index = TSpeedPercentage
TSpeedPercentage.group = {}

local function TSpeedPercentage_from_obj(obj)
    return setmetatable(obj, TSpeedPercentage)
end

function TSpeedPercentage.new(SpeedPercentage)
    return TSpeedPercentage_from_obj({SpeedPercentage = SpeedPercentage or 80})
end
---@param obj MAbnormalFan.SpeedPercentage
function TSpeedPercentage:init_from_obj(obj)
    self.SpeedPercentage = obj.SpeedPercentage or 80
end

function TSpeedPercentage:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSpeedPercentage.group)
end

TSpeedPercentage.from_obj = TSpeedPercentage_from_obj

TSpeedPercentage.proto_property = {'SpeedPercentage'}

TSpeedPercentage.default = {0}

TSpeedPercentage.struct = {
    {name = 'SpeedPercentage', is_array = false, struct = nil}
}

function TSpeedPercentage:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SpeedPercentage', self.SpeedPercentage,
                      "uint8", false, errs, need_convert)

    TSpeedPercentage:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSpeedPercentage.proto_property, errs,
                                 need_convert)
    return self
end

function TSpeedPercentage:unpack(_) return self.SpeedPercentage end

MAbnormalFan.SpeedPercentage = TSpeedPercentage

---@class MAbnormalFan.FanGroup
---@field FanGroup integer[]
local TFanGroup = {}
TFanGroup.__index = TFanGroup
TFanGroup.group = {}

local function TFanGroup_from_obj(obj) return setmetatable(obj, TFanGroup) end

function TFanGroup.new(FanGroup) return
    TFanGroup_from_obj({FanGroup = FanGroup}) end
---@param obj MAbnormalFan.FanGroup
function TFanGroup:init_from_obj(obj) self.FanGroup = obj.FanGroup end

function TFanGroup:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFanGroup.group)
end

TFanGroup.from_obj = TFanGroup_from_obj

TFanGroup.proto_property = {'FanGroup'}

TFanGroup.default = {{}}

TFanGroup.struct = {{name = 'FanGroup', is_array = true, struct = nil}}

function TFanGroup:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'FanGroup', self.FanGroup, "uint32", false,
                           errs, need_convert)

    TFanGroup:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFanGroup.proto_property, errs,
                                 need_convert)
    return self
end

function TFanGroup:unpack(_) return self.FanGroup end

MAbnormalFan.FanGroup = TFanGroup

---@class MAbnormalFan.Status
---@field Status string
local TStatus = {}
TStatus.__index = TStatus
TStatus.group = {}

local function TStatus_from_obj(obj) return setmetatable(obj, TStatus) end

function TStatus.new(Status) return TStatus_from_obj({Status = Status}) end
---@param obj MAbnormalFan.Status
function TStatus:init_from_obj(obj) self.Status = obj.Status end

function TStatus:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TStatus.group)
end

TStatus.from_obj = TStatus_from_obj

TStatus.proto_property = {'Status'}

TStatus.default = {''}

TStatus.struct = {{name = 'Status', is_array = false, struct = nil}}

function TStatus:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Status', self.Status, "string", false, errs,
                      need_convert)

    if self.Status ~= nil then
        validate.regex(prefix .. 'Status', self.Status,
                       [=[^(AbnormalRotation|NotInPosition)$]=], errs,
                       need_convert)
    end

    TStatus:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TStatus.proto_property, errs,
                                 need_convert)
    return self
end

function TStatus:unpack(_) return self.Status end

MAbnormalFan.Status = TStatus

---@class MAbnormalFan.FanIdx
---@field FanIdx integer
local TFanIdx = {}
TFanIdx.__index = TFanIdx
TFanIdx.group = {}

local function TFanIdx_from_obj(obj) return setmetatable(obj, TFanIdx) end

function TFanIdx.new(FanIdx) return TFanIdx_from_obj({FanIdx = FanIdx}) end
---@param obj MAbnormalFan.FanIdx
function TFanIdx:init_from_obj(obj) self.FanIdx = obj.FanIdx end

function TFanIdx:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFanIdx.group)
end

TFanIdx.from_obj = TFanIdx_from_obj

TFanIdx.proto_property = {'FanIdx'}

TFanIdx.default = {0}

TFanIdx.struct = {{name = 'FanIdx', is_array = false, struct = nil}}

function TFanIdx:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FanIdx', self.FanIdx, "uint32", false, errs,
                      need_convert)

    TFanIdx:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFanIdx.proto_property, errs,
                                 need_convert)
    return self
end

function TFanIdx:unpack(_) return self.FanIdx end

MAbnormalFan.FanIdx = TFanIdx

---@class MAbnormalFan.Id
---@field Id integer
local TId = {}
TId.__index = TId
TId.group = {}

local function TId_from_obj(obj) return setmetatable(obj, TId) end

function TId.new(Id) return TId_from_obj({Id = Id}) end
---@param obj MAbnormalFan.Id
function TId:init_from_obj(obj) self.Id = obj.Id end

function TId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TId.group)
end

TId.from_obj = TId_from_obj

TId.proto_property = {'Id'}

TId.default = {0}

TId.struct = {{name = 'Id', is_array = false, struct = nil}}

function TId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Id', self.Id, "uint32", false, errs,
                      need_convert)

    TId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TId.proto_property, errs, need_convert)
    return self
end

function TId:unpack(_) return self.Id end

MAbnormalFan.Id = TId

return MAbnormalFan
