-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local lu = require 'luaunit'
local c_ipmi_service = require 'ipmi_service'
local drive_collection = require 'drive.drive_collection'
local rpc_service_drive = require 'rpc_services.rpc_service_drive'
local c_drive = require 'drive.drive_object'
local common_def = require 'common_def'

TestSetFaultIndicatorState = {}

local function construct_ctx()
    local ctx = {}
    ctx.ChanType = 1
    ctx.get_initiator = function()
        return {}
    end
    return ctx
end

function TestSetFaultIndicatorState:test_rpc_service_drive()
    local drive = {RefControllerId = 255, set_locate_led_by_smc = function()
        return true
    end}
    local state = 1
    local ok, _ = pcall(function()
        return rpc_service_drive.set_location_indicator_state(drive, construct_ctx(), state)
    end)
    -- 返回成功
    lu.assertEquals(ok, true)
end

function TestSetFaultIndicatorState:test_update_dynamic_info()
    local obj = {update_dynamic_drive_info = function()
        return {}
    end}
    local ok, _ = pcall(function()
        return c_drive:update_dynamic_info(obj)
    end)
    lu.assertEquals(ok, true)
end

function TestSetFaultIndicatorState:test_set_fault_indicator_state()
    local req = {}
    local _, res = pcall(function()
        return c_ipmi_service.set_fault_indicator_state(req, construct_ctx())
    end)
    -- 测试ManufacturerId为空，返回错误
    lu.assertEquals(res.CompletionCode, 199)

    req.ManufacturerId = 0x0007DB
    req.WritingLength = 1
    req.Data = "\002"
    local _, res = pcall(function()
        return c_ipmi_service.set_fault_indicator_state(req, construct_ctx())
    end)
    -- 测试 request data invalid，返回错误
    lu.assertEquals(res.CompletionCode, 201)

    req.Data = "\001"
    drive_collection.get_drive_by_id = function()
        return nil
    end
    local _, res = pcall(function()
        return c_ipmi_service.set_fault_indicator_state(req, construct_ctx())
    end)
    -- IPMI get drive failed，返回错误
    lu.assertEquals(res.CompletionCode, 204)

    drive_collection.get_drive_by_id = function()
        return {set_fault_led_by_smc = function(num)
        end}
    end
    local _, res = pcall(function()
        return c_ipmi_service.set_fault_indicator_state(req, construct_ctx())
    end)
    -- 测试 正常返回
    lu.assertEquals(res.CompletionCode, 0)

    req.Data = "\000"
    local _, res = pcall(function()
        return c_ipmi_service.set_fault_indicator_state(req, construct_ctx())
    end)
    -- 测试 正常返回
    lu.assertEquals(res.CompletionCode, 0)
end

function TestSetFaultIndicatorState:test_set_location_indicator_state()
    local req = {}
    local _, res = pcall(function()
        return c_ipmi_service.set_location_indicator_state(req, construct_ctx())
    end)
    -- 测试ManufacturerId为空，返回错误
    lu.assertEquals(res.CompletionCode, 199)

    req.ManufacturerId = 0x0007DB
    req.Data = 1
    local _, res = pcall(function()
        return c_ipmi_service.set_location_indicator_state(req, construct_ctx())
    end)
    -- 测试 request data invalid，返回错误
    lu.assertEquals(res.CompletionCode, 201)

    req.Data = "\001"
    drive_collection.get_drive_by_id = function()
        return nil
    end
    local _, res = pcall(function()
        return c_ipmi_service.set_location_indicator_state(req, construct_ctx())
    end)
    -- IPMI get drive failed，返回错误
    lu.assertEquals(res.CompletionCode, 204)

    req.ControllerId = 255
    drive_collection.get_drive_by_id = function()
        return {set_locate_led_by_smc = function(num)
            return true
        end}
    end
    local _, res = pcall(function()
        return c_ipmi_service.set_location_indicator_state(req, construct_ctx())
    end)
    -- 测试 通过 smc 点定位灯 正常返回
    lu.assertEquals(res.CompletionCode, 0)
end

function TestSetFaultIndicatorState:test_set_location_indicator_state_raid()
    local tmp = string.unpack
    local req = {}
    req.ManufacturerId = 0x0007DB
    req.Data = "\001"
    drive_collection.get_drive_by_id = function()
        return {drive_operate = function(num)
        end}
    end
    rpc_service_drive.drive_operate = function()
    end
    local _, res = pcall(function()
        return c_ipmi_service.set_location_indicator_state(req, construct_ctx())
    end)
    -- 测试 通过 raid 点定位灯 正常返回
    lu.assertEquals(res.CompletionCode, 0)
    string.unpack = tmp
end