-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local c_object = require 'mc.orm.object'
local class = require 'mc.class'
local c_storage_service = require 'storage.service'
local lu = require 'luaunit'

TestMdbObject = class(c_storage_service)

local mdb_objects = {
    'StorageConfig',
    'Controller',
    'Nvme',
    'Drive',
    'VirtualVPDConnect',
    'DriveInfoTable',
    'DrivesTableInfo',
    'GlobalStorageConfigTable'
}

function TestMdbObject:setupClass()
    require 'storage_mdb_object'
end

function TestMdbObject:test_all_objects()
    local ret
    local mdb_object
    for _, v in pairs(mdb_objects) do
        mdb_object = c_object(v)
        ret = mdb_object.create_mdb_object({})
        lu.assertEquals(ret, {})
    end
end