-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

-- Description: Storage模块通用任务服务 

local skynet = require 'skynet'
local log = require 'mc.logging'
local task_mgmt = require 'mc.mdb.task_mgmt'
 
local create_task_err_code<const> = task_mgmt.create_code
local update_task_err_code<const> = task_mgmt.update_code
 
local task = {}
 
local function destroy_task_by_id(task_id)
    log:notice('destroy_task_by_id: %d', task_id)
    local ok, err = pcall(task_mgmt.destroy_task, task_id)
    if not ok then
        log:error('call task_mgmt.destroy_task failed, err(%s)', err)
    end
    task[task_id] = nil
end
 
-- 创建任务
function task.create(bus, task_name, path)
    return 6090696636
end
 
-- 更新任务状态
function task.update(task_id, task_state, task_status, message_id, message_args)
    return
end
 
return task