-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local class = require 'mc.class'
local log = require 'mc.logging'
local singleton = require 'mc.singleton'
local ipmi = require 'ipmi'
local comp_code = ipmi.types.Cc
local drive_collection = require 'drive.drive_collection'

local rpc_service_nvme_drive = class()

function rpc_service_nvme_drive:get_nvme_drive_count()
    local ds = drive_collection.get_instance()
    if not ds.nvme_list then
        log:error('[Storage] nvme list is nil')
        return comp_code.UnspecifiedError
    end
    local nvme_len = #ds.nvme_list
    return nvme_len
end

function rpc_service_nvme_drive:get_nvme_drive_rawdata(index)
    local ds = drive_collection.get_instance()
    if not ds.nvme_list then
        log:error('[Storage] nvme list is nil')
        return tostring(comp_code.UnspecifiedError)
    end
    local nvme_len = #ds.nvme_list

    if index > nvme_len - 1 then
        log:error('[Storage] index is out of range, index:%s, len:%s', index, nvme_len)
        return tostring(comp_code.ParmOutOfRange)
    end
    local data
    local nvme = ds.nvme_list[index + 1]
    if nvme then
        data = nvme:get_nvme_info()
    end
    if not data then
        log:error('[Storage] get data failed')
        return tostring(comp_code.UnspecifiedError)
    end
    return data
end

return singleton(rpc_service_nvme_drive)