-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local m = {}

-- 解析从芯片中读取的二进制字符串
function m.string_split(str, seq, numeration)
    if not str then
        return
    end

    local a = {}
    for word in string.gmatch(str, '[^{' .. seq .. '}*]+') do
        table.insert(a, tonumber(word, numeration))
    end

    return a
end

-- 将二进制字符串取反
function m.negation(number, length)
    local bit_arr = {}
    for i = length - 1, 0, -1 do
        table.insert(bit_arr, math.floor(number / 2^i))
        number = number % 2^i
    end

    for k, v in pairs(bit_arr) do
        bit_arr[k] = v == 0 and 1 or 0
    end

    return tonumber(table.concat(bit_arr), 2)
end

return m
