-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local log = require 'mc.logging'

local nvme_admin_command = {}

function nvme_admin_command.update_smart_log(obj)
    local smart_log = obj.nvme_mi_obj:SmartLog():value()
    if not smart_log or not next(smart_log) then
        log:info('get Disk%s smart log failed', obj.nvme.Slot)
        return
    end

    log:info('get Disk%s smart log identifiers successfully', obj.nvme.Slot)
    obj.smart_log = smart_log
end

local function update_feature_identifiers(obj)
    local feature_identifiers = obj.nvme_mi_obj:FeatureIdentifiers():value()
    if not feature_identifiers or not next(feature_identifiers) then
        log:error('get Disk%s feature identifiers failed', obj.nvme.Slot)
        return
    end

    log:info('get Disk%s feature identifiers successfully', obj.nvme.Slot)
    obj.feature_identifiers = feature_identifiers
end

local function update_fw_log(obj)
    local fw_log = obj.nvme_mi_obj:FwLog():value()
    if not fw_log then
        log:error('get Disk%s fw_log failed', obj.nvme.Slot)
        return
    end

    log:info('get Disk%s fw_log successfully,', obj.nvme.Slot)
    obj.fw_log = fw_log
end

local function update_supported_log_pages(obj)
    local supported_log_pages = obj.nvme_mi_obj:SupportedLogPages():value()
    if not supported_log_pages then
        log:error('get Disk%s supported_log_pages failed', obj.nvme.Slot)
        return
    end

    log:info('get Disk%s supported_log_pages successfully', obj.nvme.Slot)
    obj.supported_log_pages = supported_log_pages
end

local function update_error_log(obj)
    local error_log = obj.nvme_mi_obj:ErrorInformation():value()
    if not error_log then
        log:error('get Disk%s error_log failed', obj.nvme.Slot)
        return
    end

    log:info('get Disk%s error_log successfully, %s', obj.nvme.Slot)
    obj.error_log = error_log
end

function nvme_admin_command.update_admin_command_info(obj)
    nvme_admin_command.update_smart_log(obj)
    update_fw_log(obj)
    update_feature_identifiers(obj)
    update_error_log(obj)
    update_supported_log_pages(obj)
end

return nvme_admin_command