/* Copyright (c) 2024 Huawei Technologies Co., Ltd.
 * openUBMC is licensed under Mulan PSL v2.
 * You can use this software according to the terms and conditions of the Mulan PSL v2.
 * You may obtain a copy of Mulan PSL v2 at:
 *          http://license.coscl.org.cn/MulanPSL2
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PSL v2 for more details.
 */
#ifndef L_SML_PHY_ERROR_CODE
#define L_SML_PHY_ERROR_CODE

#include "l_sml.h"

namespace sml {
class l_phyerrorcode {
public:
    static void register_to(lua_State *L, luawrap::stack_table &t);

private:
    static void def_diagnose_link_phy_error_properties(lua_State *L, luawrap::lua_class<SML_PD_FAULT_ANALYSIS> &cls);
    static void register_diagnose_link_phy_error(lua_State *L, luawrap::stack_table &t);
    static void def_ctrl_exp_sas_phy_err_count_properties(lua_State *L,
        luawrap::lua_class<SML_CTRL_EXP_SAS_PHY_INFO_S> &cls);
    static void register_ctrl_exp_sas_phy_err_count(lua_State *L, luawrap::stack_table &t);
    static void def_ctrl_phy_err_count(lua_State *L, luawrap::lua_class<SML_SASPHY_INFO_S> &cls);
    static void register_ctrl_sas_phy_err_count(lua_State *L, luawrap::stack_table &t);
};

}  // namespace sml

#endif