/* Copyright (c) 2024 Huawei Technologies Co., Ltd.
 * openUBMC is licensed under Mulan PSL v2.
 * You can use this software according to the terms and conditions of the Mulan PSL v2.
 * You may obtain a copy of Mulan PSL v2 at:
 *          http://license.coscl.org.cn/MulanPSL2
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PSL v2 for more details.
 */
#include "l_battery.h"

#include "ctrl.h"
#include "l_sml_adapter.h"

namespace sml {
static int32_t update_battery_info(lua_State *L, SML_BBU_STATUS_S *info, uint8_t ctrl_index)
{
    if (auto ret = l_sml_adapter::sml_adapter_get_ctrl_bbu_status(ctrl_index, info); ret != RET_OK) {
        lua_pushinteger(L, ret);
        lua_error(L);
    }
    return 1;
}

static const char *get_type(SML_BBU_STATUS_S *info)
{
    if (!(g_utf8_validate(info->type, strlen(info->type), NULL)) || strlen(info->type) == 0) {
        return "";
    }
    return info->type;
}

static uint8_t get_pack_missing(SML_BBU_STATUS_S *info)
{
    return info->pack_missing;
}

static uint8_t get_voltage_low(SML_BBU_STATUS_S *info)
{
    return info->voltage_low;
}

static uint8_t get_temperature_high(SML_BBU_STATUS_S *info)
{
    return info->temperature_high;
}

static uint8_t get_replacepack(SML_BBU_STATUS_S *info)
{
    return info->replacepack;
}

static uint8_t get_learn_cycle_failed(SML_BBU_STATUS_S *info)
{
    return info->learn_cycle_failed;
}

static uint8_t get_learn_cycle_timeout(SML_BBU_STATUS_S *info)
{
    return info->learn_cycle_timeout;
}

static uint8_t get_predictive_failure(SML_BBU_STATUS_S *info)
{
    return info->predictive_failure;
}

static uint8_t get_remaining_capacity_low(SML_BBU_STATUS_S *info)
{
    return info->remaining_capacity_low;
}

static uint8_t get_no_space(SML_BBU_STATUS_S *info)
{
    return info->no_space;
}

static uint8_t get_failed(SML_BBU_STATUS_S *info)
{
    return info->failed;
}


void l_battery::def_properties(lua_State *L, luawrap::lua_class<SML_BBU_STATUS_S> &cls)
{
    cls.def_readonly("last_update_timestamp", &SML_BBU_STATUS_S::last_update_timestamp);
    cls.def_readonly("bbu_warnig_info_reported", &SML_BBU_STATUS_S::bbu_warnig_info_reported);
    cls.def_property("type", c_func_wrap(L, get_type));
    cls.def_readonly("present", &SML_BBU_STATUS_S::present);
    cls.def_readonly("temperature", &SML_BBU_STATUS_S::temperature);
    cls.def_property("pack_missing", c_func_wrap(L, get_pack_missing));
    cls.def_property("voltage_low", c_func_wrap(L, get_voltage_low));
    cls.def_property("temperature_high", c_func_wrap(L, get_temperature_high));
    cls.def_property("replacepack", c_func_wrap(L, get_replacepack));
    cls.def_property("learn_cycle_failed", c_func_wrap(L, get_learn_cycle_failed));
    cls.def_property("learn_cycle_timeout", c_func_wrap(L, get_learn_cycle_timeout));
    cls.def_property("predictive_failure", c_func_wrap(L, get_predictive_failure));
    cls.def_property("remaining_capacity_low", c_func_wrap(L, get_remaining_capacity_low));
    cls.def_property("no_space", c_func_wrap(L, get_no_space));
    cls.def_property("failed", c_func_wrap(L, get_failed));
    cls.def_readonly("present_updated", &SML_BBU_STATUS_S::present_updated);
}

void l_battery::register_to(lua_State *L, luawrap::stack_table &t)
{
    luawrap::restore_stack_top _s(L);

    // 导出 SML_BBU_STATUS_S 结构给 lua 使用
    auto cls = luawrap::lua_class<SML_BBU_STATUS_S>(L).ctor<>();
    cls.def("reset_zero", c_func_wrap(L, reset_zero<SML_BBU_STATUS_S>));
    cls.def("update", c_func_wrap(L, update_battery_info));
    def_properties(L, cls);

    t.set("SML_BBU_STATUS_S", cls);
}
}  // namespace sml
