-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local StorageConfig = {}

---@class StorageConfig.DiskPartitionUsagePercentageThreshold
---@field DiskPartitionUsagePercentageThreshold integer
local TDiskPartitionUsagePercentageThreshold = {}
TDiskPartitionUsagePercentageThreshold.__index = TDiskPartitionUsagePercentageThreshold
TDiskPartitionUsagePercentageThreshold.group = {}

local function TDiskPartitionUsagePercentageThreshold_from_obj(obj)
    return setmetatable(obj, TDiskPartitionUsagePercentageThreshold)
end

function TDiskPartitionUsagePercentageThreshold.new(DiskPartitionUsagePercentageThreshold)
    return TDiskPartitionUsagePercentageThreshold_from_obj({
        DiskPartitionUsagePercentageThreshold = DiskPartitionUsagePercentageThreshold or 100
    })
end
---@param obj StorageConfig.DiskPartitionUsagePercentageThreshold
function TDiskPartitionUsagePercentageThreshold:init_from_obj(obj)
    self.DiskPartitionUsagePercentageThreshold = obj.DiskPartitionUsagePercentageThreshold or 100
end

function TDiskPartitionUsagePercentageThreshold:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDiskPartitionUsagePercentageThreshold.group)
end

TDiskPartitionUsagePercentageThreshold.from_obj = TDiskPartitionUsagePercentageThreshold_from_obj

TDiskPartitionUsagePercentageThreshold.proto_property = {'DiskPartitionUsagePercentageThreshold'}

TDiskPartitionUsagePercentageThreshold.default = {0}

TDiskPartitionUsagePercentageThreshold.struct = {
    {name = 'DiskPartitionUsagePercentageThreshold', is_array = false, struct = nil}
}

function TDiskPartitionUsagePercentageThreshold:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DiskPartitionUsagePercentageThreshold', self.DiskPartitionUsagePercentageThreshold,
        'uint8', false, errs, need_convert)

    TDiskPartitionUsagePercentageThreshold:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDiskPartitionUsagePercentageThreshold.proto_property, errs, need_convert)
    return self
end

function TDiskPartitionUsagePercentageThreshold:unpack(_)
    return self.DiskPartitionUsagePercentageThreshold
end

StorageConfig.DiskPartitionUsagePercentageThreshold = TDiskPartitionUsagePercentageThreshold

---@class StorageConfig.VolumesStateAbnormal
---@field VolumesStateAbnormal integer
local TVolumesStateAbnormal = {}
TVolumesStateAbnormal.__index = TVolumesStateAbnormal
TVolumesStateAbnormal.group = {}

local function TVolumesStateAbnormal_from_obj(obj)
    return setmetatable(obj, TVolumesStateAbnormal)
end

function TVolumesStateAbnormal.new(VolumesStateAbnormal)
    return TVolumesStateAbnormal_from_obj({VolumesStateAbnormal = VolumesStateAbnormal})
end
---@param obj StorageConfig.VolumesStateAbnormal
function TVolumesStateAbnormal:init_from_obj(obj)
    self.VolumesStateAbnormal = obj.VolumesStateAbnormal
end

function TVolumesStateAbnormal:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TVolumesStateAbnormal.group)
end

TVolumesStateAbnormal.from_obj = TVolumesStateAbnormal_from_obj

TVolumesStateAbnormal.proto_property = {'VolumesStateAbnormal'}

TVolumesStateAbnormal.default = {0}

TVolumesStateAbnormal.struct = {{name = 'VolumesStateAbnormal', is_array = false, struct = nil}}

function TVolumesStateAbnormal:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'VolumesStateAbnormal', self.VolumesStateAbnormal, 'uint8', true, errs, need_convert)

    TVolumesStateAbnormal:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TVolumesStateAbnormal.proto_property, errs, need_convert)
    return self
end

function TVolumesStateAbnormal:unpack(_)
    return self.VolumesStateAbnormal
end

StorageConfig.VolumesStateAbnormal = TVolumesStateAbnormal

---@class StorageConfig.StorageConfigReady
---@field StorageConfigReady integer
local TStorageConfigReady = {}
TStorageConfigReady.__index = TStorageConfigReady
TStorageConfigReady.group = {}

local function TStorageConfigReady_from_obj(obj)
    return setmetatable(obj, TStorageConfigReady)
end

function TStorageConfigReady.new(StorageConfigReady)
    return TStorageConfigReady_from_obj({StorageConfigReady = StorageConfigReady})
end
---@param obj StorageConfig.StorageConfigReady
function TStorageConfigReady:init_from_obj(obj)
    self.StorageConfigReady = obj.StorageConfigReady
end

function TStorageConfigReady:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TStorageConfigReady.group)
end

TStorageConfigReady.from_obj = TStorageConfigReady_from_obj

TStorageConfigReady.proto_property = {'StorageConfigReady'}

TStorageConfigReady.default = {0}

TStorageConfigReady.struct = {{name = 'StorageConfigReady', is_array = false, struct = nil}}

function TStorageConfigReady:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'StorageConfigReady', self.StorageConfigReady, 'uint8', true, errs, need_convert)

    TStorageConfigReady:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TStorageConfigReady.proto_property, errs, need_convert)
    return self
end

function TStorageConfigReady:unpack(_)
    return self.StorageConfigReady
end

StorageConfig.StorageConfigReady = TStorageConfigReady

StorageConfig.interface = mdb.register_interface('bmc.kepler.Systems.Storage.StorageConfig', {
    StorageConfigReady = {'y', nil, true, nil, false},
    VolumesStateAbnormal = {'y', nil, true, nil, false},
    DiskPartitionUsagePercentageThreshold = {'y', nil, false, 100, false}
}, {}, {})

return StorageConfig
