-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local Retirement = {}

---@class Retirement.State
---@field State string
local TState = {}
TState.__index = TState
TState.group = {}

local function TState_from_obj(obj)
    return setmetatable(obj, TState)
end

function TState.new(State)
    return TState_from_obj({State = State or [=[Idle]=]})
end
---@param obj Retirement.State
function TState:init_from_obj(obj)
    self.State = obj.State or [=[Idle]=]
end

function TState:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TState.group)
end

TState.from_obj = TState_from_obj

TState.proto_property = {'State'}

TState.default = {''}

TState.struct = {{name = 'State', is_array = false, struct = nil}}

function TState:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'State', self.State, 'string', true, errs, need_convert)

    if self.State ~= nil then
        validate.Enum(prefix .. 'State', self.State, '', {'Idle', 'Running', 'Finish'}, errs, need_convert)
    end

    TState:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TState.proto_property, errs, need_convert)
    return self
end

function TState:unpack(_)
    return self.State
end

Retirement.State = TState

---@class Retirement.Progress
---@field Progress integer
local TProgress = {}
TProgress.__index = TProgress
TProgress.group = {}

local function TProgress_from_obj(obj)
    return setmetatable(obj, TProgress)
end

function TProgress.new(Progress)
    return TProgress_from_obj({Progress = Progress})
end
---@param obj Retirement.Progress
function TProgress:init_from_obj(obj)
    self.Progress = obj.Progress
end

function TProgress:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TProgress.group)
end

TProgress.from_obj = TProgress_from_obj

TProgress.proto_property = {'Progress'}

TProgress.default = {0}

TProgress.struct = {{name = 'Progress', is_array = false, struct = nil}}

function TProgress:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Progress', self.Progress, 'uint8', true, errs, need_convert)

    TProgress:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TProgress.proto_property, errs, need_convert)
    return self
end

function TProgress:unpack(_)
    return self.Progress
end

Retirement.Progress = TProgress

---@class Retirement.Result
---@field Result string
local TResult = {}
TResult.__index = TResult
TResult.group = {}

local function TResult_from_obj(obj)
    return setmetatable(obj, TResult)
end

function TResult.new(Result)
    return TResult_from_obj({Result = Result})
end
---@param obj Retirement.Result
function TResult:init_from_obj(obj)
    self.Result = obj.Result
end

function TResult:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TResult.group)
end

TResult.from_obj = TResult_from_obj

TResult.proto_property = {'Result'}

TResult.default = {''}

TResult.struct = {{name = 'Result', is_array = false, struct = nil}}

function TResult:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Result', self.Result, 'string', true, errs, need_convert)

    if self.Result ~= nil then
        validate.Enum(prefix .. 'Result', self.Result, '', {'Successful', 'Failed'}, errs, need_convert)
    end

    TResult:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TResult.proto_property, errs, need_convert)
    return self
end

function TResult:unpack(_)
    return self.Result
end

Retirement.Result = TResult

---@class Retirement.Method
---@field Method string
local TMethod = {}
TMethod.__index = TMethod
TMethod.group = {}

local function TMethod_from_obj(obj)
    return setmetatable(obj, TMethod)
end

function TMethod.new(Method)
    return TMethod_from_obj({Method = Method})
end
---@param obj Retirement.Method
function TMethod:init_from_obj(obj)
    self.Method = obj.Method
end

function TMethod:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMethod.group)
end

TMethod.from_obj = TMethod_from_obj

TMethod.proto_property = {'Method'}

TMethod.default = {''}

TMethod.struct = {{name = 'Method', is_array = false, struct = nil}}

function TMethod:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Method', self.Method, 'string', true, errs, need_convert)

    if self.Method ~= nil then
        validate.Enum(prefix .. 'Method', self.Method, '', {'OverWrite', 'BlockErase', 'CryptoErase'}, errs,
            need_convert)
    end

    TMethod:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMethod.proto_property, errs, need_convert)
    return self
end

function TMethod:unpack(_)
    return self.Method
end

Retirement.Method = TMethod

---@class Retirement.Description
---@field Description string
local TDescription = {}
TDescription.__index = TDescription
TDescription.group = {}

local function TDescription_from_obj(obj)
    return setmetatable(obj, TDescription)
end

function TDescription.new(Description)
    return TDescription_from_obj({Description = Description})
end
---@param obj Retirement.Description
function TDescription:init_from_obj(obj)
    self.Description = obj.Description
end

function TDescription:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDescription.group)
end

TDescription.from_obj = TDescription_from_obj

TDescription.proto_property = {'Description'}

TDescription.default = {''}

TDescription.struct = {{name = 'Description', is_array = false, struct = nil}}

function TDescription:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Description', self.Description, 'string', true, errs, need_convert)

    if self.Description ~= nil then
        validate.Enum(prefix .. 'Description', self.Description, '', {'Clear', 'Perge'}, errs, need_convert)
    end

    TDescription:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDescription.proto_property, errs, need_convert)
    return self
end

function TDescription:unpack(_)
    return self.Description
end

Retirement.Description = TDescription

---@class Retirement.Source
---@field Source string
local TSource = {}
TSource.__index = TSource
TSource.group = {}

local function TSource_from_obj(obj)
    return setmetatable(obj, TSource)
end

function TSource.new(Source)
    return TSource_from_obj({Source = Source})
end
---@param obj Retirement.Source
function TSource:init_from_obj(obj)
    self.Source = obj.Source
end

function TSource:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSource.group)
end

TSource.from_obj = TSource_from_obj

TSource.proto_property = {'Source'}

TSource.default = {''}

TSource.struct = {{name = 'Source', is_array = false, struct = nil}}

function TSource:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Source', self.Source, 'string', true, errs, need_convert)

    if self.Source ~= nil then
        validate.Enum(prefix .. 'Source', self.Source, '', {'Huawei', 'User'}, errs, need_convert)
    end

    TSource:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSource.proto_property, errs, need_convert)
    return self
end

function TSource:unpack(_)
    return self.Source
end

Retirement.Source = TSource

---@class Retirement.Media
---@field Media string
local TMedia = {}
TMedia.__index = TMedia
TMedia.group = {}

local function TMedia_from_obj(obj)
    return setmetatable(obj, TMedia)
end

function TMedia.new(Media)
    return TMedia_from_obj({Media = Media})
end
---@param obj Retirement.Media
function TMedia:init_from_obj(obj)
    self.Media = obj.Media
end

function TMedia:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMedia.group)
end

TMedia.from_obj = TMedia_from_obj

TMedia.proto_property = {'Media'}

TMedia.default = {''}

TMedia.struct = {{name = 'Media', is_array = false, struct = nil}}

function TMedia:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Media', self.Media, 'string', true, errs, need_convert)

    if self.Media ~= nil then
        validate.Enum(prefix .. 'Media', self.Media, '', {'Flash', 'SSD', 'Eeprom', 'HDD'}, errs, need_convert)
    end

    TMedia:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMedia.proto_property, errs, need_convert)
    return self
end

function TMedia:unpack(_)
    return self.Media
end

Retirement.Media = TMedia

---@class Retirement.GetReportReq
local TGetReportReq = {}
TGetReportReq.__index = TGetReportReq
TGetReportReq.group = {}

local function TGetReportReq_from_obj(obj)
    return setmetatable(obj, TGetReportReq)
end

function TGetReportReq.new()
    return TGetReportReq_from_obj({})
end
---@param obj Retirement.GetReportReq
function TGetReportReq:init_from_obj(obj)

end

function TGetReportReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetReportReq.group)
end

TGetReportReq.from_obj = TGetReportReq_from_obj

TGetReportReq.proto_property = {}

TGetReportReq.default = {}

TGetReportReq.struct = {}

function TGetReportReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TGetReportReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetReportReq.proto_property, errs, need_convert)
    return self
end

function TGetReportReq:unpack(_)
end

Retirement.GetReportReq = TGetReportReq

---@class Retirement.DataWipeRsp
local TDataWipeRsp = {}
TDataWipeRsp.__index = TDataWipeRsp
TDataWipeRsp.group = {}

local function TDataWipeRsp_from_obj(obj)
    return setmetatable(obj, TDataWipeRsp)
end

function TDataWipeRsp.new()
    return TDataWipeRsp_from_obj({})
end
---@param obj Retirement.DataWipeRsp
function TDataWipeRsp:init_from_obj(obj)

end

function TDataWipeRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDataWipeRsp.group)
end

TDataWipeRsp.from_obj = TDataWipeRsp_from_obj

TDataWipeRsp.proto_property = {}

TDataWipeRsp.default = {}

TDataWipeRsp.struct = {}

function TDataWipeRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TDataWipeRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDataWipeRsp.proto_property, errs, need_convert)
    return self
end

function TDataWipeRsp:unpack(_)
end

Retirement.DataWipeRsp = TDataWipeRsp

---@class Retirement.DataWipeReq
local TDataWipeReq = {}
TDataWipeReq.__index = TDataWipeReq
TDataWipeReq.group = {}

local function TDataWipeReq_from_obj(obj)
    return setmetatable(obj, TDataWipeReq)
end

function TDataWipeReq.new()
    return TDataWipeReq_from_obj({})
end
---@param obj Retirement.DataWipeReq
function TDataWipeReq:init_from_obj(obj)

end

function TDataWipeReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDataWipeReq.group)
end

TDataWipeReq.from_obj = TDataWipeReq_from_obj

TDataWipeReq.proto_property = {}

TDataWipeReq.default = {}

TDataWipeReq.struct = {}

function TDataWipeReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TDataWipeReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDataWipeReq.proto_property, errs, need_convert)
    return self
end

function TDataWipeReq:unpack(_)
end

Retirement.DataWipeReq = TDataWipeReq

---@class Retirement.DataWipeReportDict
---@field key string
---@field value string
local TDataWipeReportDict = {}
TDataWipeReportDict.__index = TDataWipeReportDict
TDataWipeReportDict.group = {}

local function TDataWipeReportDict_from_obj(obj)
    return setmetatable(obj, TDataWipeReportDict)
end

function TDataWipeReportDict.new(dict)
    return TDataWipeReportDict_from_obj(dict)
end

---@param obj Retirement.DataWipeReportDict
function TDataWipeReportDict:init_from_obj(obj)
    self = obj
end

function TDataWipeReportDict:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDataWipeReportDict.group)
end

TDataWipeReportDict.from_obj = TDataWipeReportDict_from_obj

TDataWipeReportDict.proto_property = {}

TDataWipeReportDict.default = {}

TDataWipeReportDict.struct = {}

function TDataWipeReportDict:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    for k, v in pairs(self) do

        validate.Optional(prefix .. 'key', k, 'string', false, errs, need_convert)

        validate.Optional(prefix .. 'value', v, 'string', false, errs, need_convert)

    end

    TDataWipeReportDict:remove_error_props(errs, self)
    return self
end

function TDataWipeReportDict:unpack(_)
    return self
end

Retirement.DataWipeReportDict = TDataWipeReportDict

---@class Retirement.GetReportRsp
---@field Report Retirement.DataWipeReportDict
local TGetReportRsp = {}
TGetReportRsp.__index = TGetReportRsp
TGetReportRsp.group = {}

local function TGetReportRsp_from_obj(obj)
    return setmetatable(obj, TGetReportRsp)
end

function TGetReportRsp.new(Report)
    return TGetReportRsp_from_obj({Report = Report})
end
---@param obj Retirement.GetReportRsp
function TGetReportRsp:init_from_obj(obj)
    self.Report = obj.Report
end

function TGetReportRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetReportRsp.group)
end

TGetReportRsp.from_obj = TGetReportRsp_from_obj

TGetReportRsp.proto_property = {'Report'}

TGetReportRsp.default = {Retirement.DataWipeReportDict.default}

TGetReportRsp.struct = {{name = 'Report', is_array = false, struct = Retirement.DataWipeReportDict.struct}}

function TGetReportRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    Retirement.DataWipeReportDict.new(self.Report):validate(prefix, errs, need_convert)

    TGetReportRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetReportRsp.proto_property, errs, need_convert)
    return self
end

function TGetReportRsp:unpack(_)
    return self.Report
end

Retirement.GetReportRsp = TGetReportRsp

Retirement.interface = mdb.register_interface('bmc.kepler.LifeCycle.Retirement', {
    Media = {'s', {}, true, nil, false},
    Source = {'s', {}, true, nil, false},
    Description = {'s', {}, true, nil, false},
    Method = {'s', {}, true, nil, false},
    Result = {'s', {}, true, nil, false},
    Progress = {'y', {}, true, nil, false},
    State = {'s', nil, true, 'Idle', false}
}, {DataWipe = {'a{ss}', '', TDataWipeReq, TDataWipeRsp}, GetReport = {'a{ss}', 'a{ss}', TGetReportReq, TGetReportRsp}},
    {})

return Retirement
