-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local NVMe = {}

---@class NVMe.LifeUsedPercentage
---@field LifeUsedPercentage integer
local TLifeUsedPercentage = {}
TLifeUsedPercentage.__index = TLifeUsedPercentage
TLifeUsedPercentage.group = {}

local function TLifeUsedPercentage_from_obj(obj)
    return setmetatable(obj, TLifeUsedPercentage)
end

function TLifeUsedPercentage.new(LifeUsedPercentage)
    return TLifeUsedPercentage_from_obj({LifeUsedPercentage = LifeUsedPercentage})
end
---@param obj NVMe.LifeUsedPercentage
function TLifeUsedPercentage:init_from_obj(obj)
    self.LifeUsedPercentage = obj.LifeUsedPercentage
end

function TLifeUsedPercentage:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLifeUsedPercentage.group)
end

TLifeUsedPercentage.from_obj = TLifeUsedPercentage_from_obj

TLifeUsedPercentage.proto_property = {'LifeUsedPercentage'}

TLifeUsedPercentage.default = {0}

TLifeUsedPercentage.struct = {{name = 'LifeUsedPercentage', is_array = false, struct = nil}}

function TLifeUsedPercentage:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'LifeUsedPercentage', self.LifeUsedPercentage, 'uint8', true, errs, need_convert)

    TLifeUsedPercentage:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLifeUsedPercentage.proto_property, errs, need_convert)
    return self
end

function TLifeUsedPercentage:unpack(_)
    return self.LifeUsedPercentage
end

NVMe.LifeUsedPercentage = TLifeUsedPercentage

NVMe.interface = mdb.register_interface('bmc.kepler.Systems.Storage.Drive.NVMe',
    {LifeUsedPercentage = {'y', nil, true, nil, false}}, {}, {})

return NVMe
