--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetRaidFaultStatus = {}

---@class StorageIpmiCmds.SetRaidFaultStatusReq
---@field ManufacturerId integer
---@field EventDirection integer
---@field DeviceStatus1 integer
---@field Bus integer
---@field Device integer
---@field Function integer
---@field ErrorCode integer
local TSetRaidFaultStatusReq = {}
TSetRaidFaultStatusReq.__index = TSetRaidFaultStatusReq
TSetRaidFaultStatusReq.group = {}

local function TSetRaidFaultStatusReq_from_obj(obj)
    return setmetatable(obj, TSetRaidFaultStatusReq)
end

function TSetRaidFaultStatusReq.new(ManufacturerId, EventDirection, DeviceStatus1, Bus, Device, Function, ErrorCode)
    return TSetRaidFaultStatusReq_from_obj({
        ManufacturerId = ManufacturerId,
        EventDirection = EventDirection,
        DeviceStatus1 = DeviceStatus1,
        Bus = Bus,
        Device = Device,
        Function = Function,
        ErrorCode = ErrorCode
    })
end
---@param obj StorageIpmiCmds.SetRaidFaultStatusReq
function TSetRaidFaultStatusReq:init_from_obj(obj)
    self.ManufacturerId = obj.ManufacturerId
    self.EventDirection = obj.EventDirection
    self.DeviceStatus1 = obj.DeviceStatus1
    self.Bus = obj.Bus
    self.Device = obj.Device
    self.Function = obj.Function
    self.ErrorCode = obj.ErrorCode
end

function TSetRaidFaultStatusReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetRaidFaultStatusReq.group)
end

TSetRaidFaultStatusReq.from_obj = TSetRaidFaultStatusReq_from_obj

TSetRaidFaultStatusReq.proto_property = {
    'ManufacturerId', 'EventDirection', 'DeviceStatus1', 'Bus', 'Device', 'Function', 'ErrorCode'
}

TSetRaidFaultStatusReq.default = {0, 0, 0, 0, 0, 0, 0}

TSetRaidFaultStatusReq.struct = {
    {name = 'ManufacturerId', is_array = false, struct = nil},
    {name = 'EventDirection', is_array = false, struct = nil}, {name = 'DeviceStatus1', is_array = false, struct = nil},
    {name = 'Bus', is_array = false, struct = nil}, {name = 'Device', is_array = false, struct = nil},
    {name = 'Function', is_array = false, struct = nil}, {name = 'ErrorCode', is_array = false, struct = nil}
}

function TSetRaidFaultStatusReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufacturerId', self.ManufacturerId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'EventDirection', self.EventDirection, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'DeviceStatus1', self.DeviceStatus1, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Bus', self.Bus, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Device', self.Device, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Function', self.Function, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ErrorCode', self.ErrorCode, 'uint8', false, errs, need_convert)

    TSetRaidFaultStatusReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetRaidFaultStatusReq.proto_property, errs, need_convert)
    return self
end

function TSetRaidFaultStatusReq:unpack(_)
    return self.ManufacturerId, self.EventDirection, self.DeviceStatus1, self.Bus, self.Device, self.Function,
        self.ErrorCode
end

SetRaidFaultStatus.SetRaidFaultStatusReq = TSetRaidFaultStatusReq

---@class StorageIpmiCmds.SetRaidFaultStatusRsp
---@field CompletionCode integer
---@field ManufactureId integer
local TSetRaidFaultStatusRsp = {}
TSetRaidFaultStatusRsp.__index = TSetRaidFaultStatusRsp
TSetRaidFaultStatusRsp.group = {}

local function TSetRaidFaultStatusRsp_from_obj(obj)
    return setmetatable(obj, TSetRaidFaultStatusRsp)
end

function TSetRaidFaultStatusRsp.new(CompletionCode, ManufactureId)
    return TSetRaidFaultStatusRsp_from_obj({CompletionCode = CompletionCode, ManufactureId = ManufactureId})
end
---@param obj StorageIpmiCmds.SetRaidFaultStatusRsp
function TSetRaidFaultStatusRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
end

function TSetRaidFaultStatusRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetRaidFaultStatusRsp.group)
end

TSetRaidFaultStatusRsp.from_obj = TSetRaidFaultStatusRsp_from_obj

TSetRaidFaultStatusRsp.proto_property = {'CompletionCode', 'ManufactureId'}

TSetRaidFaultStatusRsp.default = {0, 0}

TSetRaidFaultStatusRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil}
}

function TSetRaidFaultStatusRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)

    TSetRaidFaultStatusRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetRaidFaultStatusRsp.proto_property, errs, need_convert)
    return self
end

function TSetRaidFaultStatusRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId
end

SetRaidFaultStatus.SetRaidFaultStatusRsp = TSetRaidFaultStatusRsp

return SetRaidFaultStatus
