--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetLocationIndicatorState = {}

---@class StorageIpmiCmds.SetLocationIndicatorStateReq
---@field ManufacturerId integer
---@field Reserve integer
---@field ControllerId integer
---@field DriveId integer
---@field Frame integer
---@field WritingOffset integer
---@field WritingLength integer
---@field Data string
local TSetLocationIndicatorStateReq = {}
TSetLocationIndicatorStateReq.__index = TSetLocationIndicatorStateReq
TSetLocationIndicatorStateReq.group = {}

local function TSetLocationIndicatorStateReq_from_obj(obj)
    return setmetatable(obj, TSetLocationIndicatorStateReq)
end

function TSetLocationIndicatorStateReq.new(ManufacturerId, Reserve, ControllerId, DriveId, Frame, WritingOffset,
    WritingLength, Data)
    return TSetLocationIndicatorStateReq_from_obj({
        ManufacturerId = ManufacturerId,
        Reserve = Reserve,
        ControllerId = ControllerId,
        DriveId = DriveId,
        Frame = Frame,
        WritingOffset = WritingOffset,
        WritingLength = WritingLength,
        Data = Data
    })
end
---@param obj StorageIpmiCmds.SetLocationIndicatorStateReq
function TSetLocationIndicatorStateReq:init_from_obj(obj)
    self.ManufacturerId = obj.ManufacturerId
    self.Reserve = obj.Reserve
    self.ControllerId = obj.ControllerId
    self.DriveId = obj.DriveId
    self.Frame = obj.Frame
    self.WritingOffset = obj.WritingOffset
    self.WritingLength = obj.WritingLength
    self.Data = obj.Data
end

function TSetLocationIndicatorStateReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetLocationIndicatorStateReq.group)
end

TSetLocationIndicatorStateReq.from_obj = TSetLocationIndicatorStateReq_from_obj

TSetLocationIndicatorStateReq.proto_property = {
    'ManufacturerId', 'Reserve', 'ControllerId', 'DriveId', 'Frame', 'WritingOffset', 'WritingLength', 'Data'
}

TSetLocationIndicatorStateReq.default = {0, 0, 0, 0, 0, 0, 0, ''}

TSetLocationIndicatorStateReq.struct = {
    {name = 'ManufacturerId', is_array = false, struct = nil}, {name = 'Reserve', is_array = false, struct = nil},
    {name = 'ControllerId', is_array = false, struct = nil}, {name = 'DriveId', is_array = false, struct = nil},
    {name = 'Frame', is_array = false, struct = nil}, {name = 'WritingOffset', is_array = false, struct = nil},
    {name = 'WritingLength', is_array = false, struct = nil}, {name = 'Data', is_array = false, struct = nil}
}

function TSetLocationIndicatorStateReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufacturerId', self.ManufacturerId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserve', self.Reserve, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ControllerId', self.ControllerId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'DriveId', self.DriveId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Frame', self.Frame, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'WritingOffset', self.WritingOffset, 'uint16', false, errs, need_convert)
    validate.Optional(prefix .. 'WritingLength', self.WritingLength, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TSetLocationIndicatorStateReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetLocationIndicatorStateReq.proto_property, errs, need_convert)
    return self
end

function TSetLocationIndicatorStateReq:unpack(_)
    return self.ManufacturerId, self.Reserve, self.ControllerId, self.DriveId, self.Frame, self.WritingOffset,
        self.WritingLength, self.Data
end

SetLocationIndicatorState.SetLocationIndicatorStateReq = TSetLocationIndicatorStateReq

---@class StorageIpmiCmds.SetLocationIndicatorStateRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field Reserve integer
---@field Data string
local TSetLocationIndicatorStateRsp = {}
TSetLocationIndicatorStateRsp.__index = TSetLocationIndicatorStateRsp
TSetLocationIndicatorStateRsp.group = {}

local function TSetLocationIndicatorStateRsp_from_obj(obj)
    return setmetatable(obj, TSetLocationIndicatorStateRsp)
end

function TSetLocationIndicatorStateRsp.new(CompletionCode, ManufactureId, Reserve, Data)
    return TSetLocationIndicatorStateRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        Reserve = Reserve,
        Data = Data
    })
end
---@param obj StorageIpmiCmds.SetLocationIndicatorStateRsp
function TSetLocationIndicatorStateRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.Reserve = obj.Reserve
    self.Data = obj.Data
end

function TSetLocationIndicatorStateRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetLocationIndicatorStateRsp.group)
end

TSetLocationIndicatorStateRsp.from_obj = TSetLocationIndicatorStateRsp_from_obj

TSetLocationIndicatorStateRsp.proto_property = {'CompletionCode', 'ManufactureId', 'Reserve', 'Data'}

TSetLocationIndicatorStateRsp.default = {0, 0, 0, ''}

TSetLocationIndicatorStateRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'Reserve', is_array = false, struct = nil}, {name = 'Data', is_array = false, struct = nil}
}

function TSetLocationIndicatorStateRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserve', self.Reserve, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TSetLocationIndicatorStateRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetLocationIndicatorStateRsp.proto_property, errs, need_convert)
    return self
end

function TSetLocationIndicatorStateRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.Reserve, self.Data
end

SetLocationIndicatorState.SetLocationIndicatorStateRsp = TSetLocationIndicatorStateRsp

return SetLocationIndicatorState
