--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetHotspareType = {}

---@class StorageIpmiCmds.SetHotspareTypeReq
---@field ManufacturerId integer
---@field Reserve integer
---@field ControllerId integer
---@field DriveId integer
---@field Frame integer
---@field WritingOffset integer
---@field WritingLength integer
---@field Data string
local TSetHotspareTypeReq = {}
TSetHotspareTypeReq.__index = TSetHotspareTypeReq
TSetHotspareTypeReq.group = {}

local function TSetHotspareTypeReq_from_obj(obj)
    return setmetatable(obj, TSetHotspareTypeReq)
end

function TSetHotspareTypeReq.new(ManufacturerId, Reserve, ControllerId, DriveId, Frame, WritingOffset, WritingLength,
    Data)
    return TSetHotspareTypeReq_from_obj({
        ManufacturerId = ManufacturerId,
        Reserve = Reserve,
        ControllerId = ControllerId,
        DriveId = DriveId,
        Frame = Frame,
        WritingOffset = WritingOffset,
        WritingLength = WritingLength,
        Data = Data
    })
end
---@param obj StorageIpmiCmds.SetHotspareTypeReq
function TSetHotspareTypeReq:init_from_obj(obj)
    self.ManufacturerId = obj.ManufacturerId
    self.Reserve = obj.Reserve
    self.ControllerId = obj.ControllerId
    self.DriveId = obj.DriveId
    self.Frame = obj.Frame
    self.WritingOffset = obj.WritingOffset
    self.WritingLength = obj.WritingLength
    self.Data = obj.Data
end

function TSetHotspareTypeReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetHotspareTypeReq.group)
end

TSetHotspareTypeReq.from_obj = TSetHotspareTypeReq_from_obj

TSetHotspareTypeReq.proto_property = {
    'ManufacturerId', 'Reserve', 'ControllerId', 'DriveId', 'Frame', 'WritingOffset', 'WritingLength', 'Data'
}

TSetHotspareTypeReq.default = {0, 0, 0, 0, 0, 0, 0, ''}

TSetHotspareTypeReq.struct = {
    {name = 'ManufacturerId', is_array = false, struct = nil}, {name = 'Reserve', is_array = false, struct = nil},
    {name = 'ControllerId', is_array = false, struct = nil}, {name = 'DriveId', is_array = false, struct = nil},
    {name = 'Frame', is_array = false, struct = nil}, {name = 'WritingOffset', is_array = false, struct = nil},
    {name = 'WritingLength', is_array = false, struct = nil}, {name = 'Data', is_array = false, struct = nil}
}

function TSetHotspareTypeReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufacturerId', self.ManufacturerId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserve', self.Reserve, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ControllerId', self.ControllerId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'DriveId', self.DriveId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Frame', self.Frame, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'WritingOffset', self.WritingOffset, 'uint16', false, errs, need_convert)
    validate.Optional(prefix .. 'WritingLength', self.WritingLength, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TSetHotspareTypeReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetHotspareTypeReq.proto_property, errs, need_convert)
    return self
end

function TSetHotspareTypeReq:unpack(_)
    return self.ManufacturerId, self.Reserve, self.ControllerId, self.DriveId, self.Frame, self.WritingOffset,
        self.WritingLength, self.Data
end

SetHotspareType.SetHotspareTypeReq = TSetHotspareTypeReq

---@class StorageIpmiCmds.SetHotspareTypeRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field Reserve integer
---@field Data string
local TSetHotspareTypeRsp = {}
TSetHotspareTypeRsp.__index = TSetHotspareTypeRsp
TSetHotspareTypeRsp.group = {}

local function TSetHotspareTypeRsp_from_obj(obj)
    return setmetatable(obj, TSetHotspareTypeRsp)
end

function TSetHotspareTypeRsp.new(CompletionCode, ManufactureId, Reserve, Data)
    return TSetHotspareTypeRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        Reserve = Reserve,
        Data = Data
    })
end
---@param obj StorageIpmiCmds.SetHotspareTypeRsp
function TSetHotspareTypeRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.Reserve = obj.Reserve
    self.Data = obj.Data
end

function TSetHotspareTypeRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetHotspareTypeRsp.group)
end

TSetHotspareTypeRsp.from_obj = TSetHotspareTypeRsp_from_obj

TSetHotspareTypeRsp.proto_property = {'CompletionCode', 'ManufactureId', 'Reserve', 'Data'}

TSetHotspareTypeRsp.default = {0, 0, 0, ''}

TSetHotspareTypeRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'Reserve', is_array = false, struct = nil}, {name = 'Data', is_array = false, struct = nil}
}

function TSetHotspareTypeRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserve', self.Reserve, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TSetHotspareTypeRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetHotspareTypeRsp.proto_property, errs, need_convert)
    return self
end

function TSetHotspareTypeRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.Reserve, self.Data
end

SetHotspareType.SetHotspareTypeRsp = TSetHotspareTypeRsp

return SetHotspareType
