--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetLogicalDrivePds = {}

---@class StorageIpmiCmds.GetLogicalDrivePdsReq
---@field ManufacturerId integer
---@field Reserve integer
---@field ControllerId integer
---@field VolumeId integer
---@field ReadingOffset integer
---@field ReadingLength integer
local TGetLogicalDrivePdsReq = {}
TGetLogicalDrivePdsReq.__index = TGetLogicalDrivePdsReq
TGetLogicalDrivePdsReq.group = {}

local function TGetLogicalDrivePdsReq_from_obj(obj)
    return setmetatable(obj, TGetLogicalDrivePdsReq)
end

function TGetLogicalDrivePdsReq.new(ManufacturerId, Reserve, ControllerId, VolumeId, ReadingOffset, ReadingLength)
    return TGetLogicalDrivePdsReq_from_obj({
        ManufacturerId = ManufacturerId,
        Reserve = Reserve,
        ControllerId = ControllerId,
        VolumeId = VolumeId,
        ReadingOffset = ReadingOffset,
        ReadingLength = ReadingLength
    })
end
---@param obj StorageIpmiCmds.GetLogicalDrivePdsReq
function TGetLogicalDrivePdsReq:init_from_obj(obj)
    self.ManufacturerId = obj.ManufacturerId
    self.Reserve = obj.Reserve
    self.ControllerId = obj.ControllerId
    self.VolumeId = obj.VolumeId
    self.ReadingOffset = obj.ReadingOffset
    self.ReadingLength = obj.ReadingLength
end

function TGetLogicalDrivePdsReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetLogicalDrivePdsReq.group)
end

TGetLogicalDrivePdsReq.from_obj = TGetLogicalDrivePdsReq_from_obj

TGetLogicalDrivePdsReq.proto_property = {
    'ManufacturerId', 'Reserve', 'ControllerId', 'VolumeId', 'ReadingOffset', 'ReadingLength'
}

TGetLogicalDrivePdsReq.default = {0, 0, 0, 0, 0, 0}

TGetLogicalDrivePdsReq.struct = {
    {name = 'ManufacturerId', is_array = false, struct = nil}, {name = 'Reserve', is_array = false, struct = nil},
    {name = 'ControllerId', is_array = false, struct = nil}, {name = 'VolumeId', is_array = false, struct = nil},
    {name = 'ReadingOffset', is_array = false, struct = nil}, {name = 'ReadingLength', is_array = false, struct = nil}
}

function TGetLogicalDrivePdsReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufacturerId', self.ManufacturerId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserve', self.Reserve, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ControllerId', self.ControllerId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'VolumeId', self.VolumeId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ReadingOffset', self.ReadingOffset, 'uint16', false, errs, need_convert)
    validate.Optional(prefix .. 'ReadingLength', self.ReadingLength, 'uint8', false, errs, need_convert)

    TGetLogicalDrivePdsReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetLogicalDrivePdsReq.proto_property, errs, need_convert)
    return self
end

function TGetLogicalDrivePdsReq:unpack(_)
    return self.ManufacturerId, self.Reserve, self.ControllerId, self.VolumeId, self.ReadingOffset, self.ReadingLength
end

GetLogicalDrivePds.GetLogicalDrivePdsReq = TGetLogicalDrivePdsReq

---@class StorageIpmiCmds.GetLogicalDrivePdsRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field Reserve integer
---@field Data string
local TGetLogicalDrivePdsRsp = {}
TGetLogicalDrivePdsRsp.__index = TGetLogicalDrivePdsRsp
TGetLogicalDrivePdsRsp.group = {}

local function TGetLogicalDrivePdsRsp_from_obj(obj)
    return setmetatable(obj, TGetLogicalDrivePdsRsp)
end

function TGetLogicalDrivePdsRsp.new(CompletionCode, ManufactureId, Reserve, Data)
    return TGetLogicalDrivePdsRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        Reserve = Reserve,
        Data = Data
    })
end
---@param obj StorageIpmiCmds.GetLogicalDrivePdsRsp
function TGetLogicalDrivePdsRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.Reserve = obj.Reserve
    self.Data = obj.Data
end

function TGetLogicalDrivePdsRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetLogicalDrivePdsRsp.group)
end

TGetLogicalDrivePdsRsp.from_obj = TGetLogicalDrivePdsRsp_from_obj

TGetLogicalDrivePdsRsp.proto_property = {'CompletionCode', 'ManufactureId', 'Reserve', 'Data'}

TGetLogicalDrivePdsRsp.default = {0, 0, 0, ''}

TGetLogicalDrivePdsRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'Reserve', is_array = false, struct = nil}, {name = 'Data', is_array = false, struct = nil}
}

function TGetLogicalDrivePdsRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserve', self.Reserve, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TGetLogicalDrivePdsRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetLogicalDrivePdsRsp.proto_property, errs, need_convert)
    return self
end

function TGetLogicalDrivePdsRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.Reserve, self.Data
end

GetLogicalDrivePds.GetLogicalDrivePdsRsp = TGetLogicalDrivePdsRsp

return GetLogicalDrivePds
