--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetControllerPds = {}

---@class StorageIpmiCmds.GetControllerPdsReq
---@field ManufacturerId integer
---@field Reserve integer
---@field ControllerId integer
---@field ReadingOffset integer
---@field ReadingLength integer
local TGetControllerPdsReq = {}
TGetControllerPdsReq.__index = TGetControllerPdsReq
TGetControllerPdsReq.group = {}

local function TGetControllerPdsReq_from_obj(obj)
    return setmetatable(obj, TGetControllerPdsReq)
end

function TGetControllerPdsReq.new(ManufacturerId, Reserve, ControllerId, ReadingOffset, ReadingLength)
    return TGetControllerPdsReq_from_obj({
        ManufacturerId = ManufacturerId,
        Reserve = Reserve,
        ControllerId = ControllerId,
        ReadingOffset = ReadingOffset,
        ReadingLength = ReadingLength
    })
end
---@param obj StorageIpmiCmds.GetControllerPdsReq
function TGetControllerPdsReq:init_from_obj(obj)
    self.ManufacturerId = obj.ManufacturerId
    self.Reserve = obj.Reserve
    self.ControllerId = obj.ControllerId
    self.ReadingOffset = obj.ReadingOffset
    self.ReadingLength = obj.ReadingLength
end

function TGetControllerPdsReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetControllerPdsReq.group)
end

TGetControllerPdsReq.from_obj = TGetControllerPdsReq_from_obj

TGetControllerPdsReq.proto_property = {'ManufacturerId', 'Reserve', 'ControllerId', 'ReadingOffset', 'ReadingLength'}

TGetControllerPdsReq.default = {0, 0, 0, 0, 0}

TGetControllerPdsReq.struct = {
    {name = 'ManufacturerId', is_array = false, struct = nil}, {name = 'Reserve', is_array = false, struct = nil},
    {name = 'ControllerId', is_array = false, struct = nil}, {name = 'ReadingOffset', is_array = false, struct = nil},
    {name = 'ReadingLength', is_array = false, struct = nil}
}

function TGetControllerPdsReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufacturerId', self.ManufacturerId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserve', self.Reserve, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ControllerId', self.ControllerId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ReadingOffset', self.ReadingOffset, 'uint16', false, errs, need_convert)
    validate.Optional(prefix .. 'ReadingLength', self.ReadingLength, 'uint8', false, errs, need_convert)

    TGetControllerPdsReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetControllerPdsReq.proto_property, errs, need_convert)
    return self
end

function TGetControllerPdsReq:unpack(_)
    return self.ManufacturerId, self.Reserve, self.ControllerId, self.ReadingOffset, self.ReadingLength
end

GetControllerPds.GetControllerPdsReq = TGetControllerPdsReq

---@class StorageIpmiCmds.GetControllerPdsRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field Reserve integer
---@field Data string
local TGetControllerPdsRsp = {}
TGetControllerPdsRsp.__index = TGetControllerPdsRsp
TGetControllerPdsRsp.group = {}

local function TGetControllerPdsRsp_from_obj(obj)
    return setmetatable(obj, TGetControllerPdsRsp)
end

function TGetControllerPdsRsp.new(CompletionCode, ManufactureId, Reserve, Data)
    return TGetControllerPdsRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        Reserve = Reserve,
        Data = Data
    })
end
---@param obj StorageIpmiCmds.GetControllerPdsRsp
function TGetControllerPdsRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.Reserve = obj.Reserve
    self.Data = obj.Data
end

function TGetControllerPdsRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetControllerPdsRsp.group)
end

TGetControllerPdsRsp.from_obj = TGetControllerPdsRsp_from_obj

TGetControllerPdsRsp.proto_property = {'CompletionCode', 'ManufactureId', 'Reserve', 'Data'}

TGetControllerPdsRsp.default = {0, 0, 0, ''}

TGetControllerPdsRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'Reserve', is_array = false, struct = nil}, {name = 'Data', is_array = false, struct = nil}
}

function TGetControllerPdsRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserve', self.Reserve, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TGetControllerPdsRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetControllerPdsRsp.proto_property, errs, need_convert)
    return self
end

function TGetControllerPdsRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.Reserve, self.Data
end

GetControllerPds.GetControllerPdsRsp = TGetControllerPdsRsp

return GetControllerPds
