--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetControllerNvdataVersion = {}

---@class StorageIpmiCmds.GetControllerNvdataVersionReq
---@field ManufacturerId integer
---@field Reserve integer
---@field ControllerId integer
---@field ReadingOffset integer
---@field ReadingLength integer
local TGetControllerNvdataVersionReq = {}
TGetControllerNvdataVersionReq.__index = TGetControllerNvdataVersionReq
TGetControllerNvdataVersionReq.group = {}

local function TGetControllerNvdataVersionReq_from_obj(obj)
    return setmetatable(obj, TGetControllerNvdataVersionReq)
end

function TGetControllerNvdataVersionReq.new(ManufacturerId, Reserve, ControllerId, ReadingOffset, ReadingLength)
    return TGetControllerNvdataVersionReq_from_obj({
        ManufacturerId = ManufacturerId,
        Reserve = Reserve,
        ControllerId = ControllerId,
        ReadingOffset = ReadingOffset,
        ReadingLength = ReadingLength
    })
end
---@param obj StorageIpmiCmds.GetControllerNvdataVersionReq
function TGetControllerNvdataVersionReq:init_from_obj(obj)
    self.ManufacturerId = obj.ManufacturerId
    self.Reserve = obj.Reserve
    self.ControllerId = obj.ControllerId
    self.ReadingOffset = obj.ReadingOffset
    self.ReadingLength = obj.ReadingLength
end

function TGetControllerNvdataVersionReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetControllerNvdataVersionReq.group)
end

TGetControllerNvdataVersionReq.from_obj = TGetControllerNvdataVersionReq_from_obj

TGetControllerNvdataVersionReq.proto_property = {
    'ManufacturerId', 'Reserve', 'ControllerId', 'ReadingOffset', 'ReadingLength'
}

TGetControllerNvdataVersionReq.default = {0, 0, 0, 0, 0}

TGetControllerNvdataVersionReq.struct = {
    {name = 'ManufacturerId', is_array = false, struct = nil}, {name = 'Reserve', is_array = false, struct = nil},
    {name = 'ControllerId', is_array = false, struct = nil}, {name = 'ReadingOffset', is_array = false, struct = nil},
    {name = 'ReadingLength', is_array = false, struct = nil}
}

function TGetControllerNvdataVersionReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufacturerId', self.ManufacturerId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserve', self.Reserve, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ControllerId', self.ControllerId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ReadingOffset', self.ReadingOffset, 'uint16', false, errs, need_convert)
    validate.Optional(prefix .. 'ReadingLength', self.ReadingLength, 'uint8', false, errs, need_convert)

    TGetControllerNvdataVersionReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetControllerNvdataVersionReq.proto_property, errs, need_convert)
    return self
end

function TGetControllerNvdataVersionReq:unpack(_)
    return self.ManufacturerId, self.Reserve, self.ControllerId, self.ReadingOffset, self.ReadingLength
end

GetControllerNvdataVersion.GetControllerNvdataVersionReq = TGetControllerNvdataVersionReq

---@class StorageIpmiCmds.GetControllerNvdataVersionRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field Reserve integer
---@field Data string
local TGetControllerNvdataVersionRsp = {}
TGetControllerNvdataVersionRsp.__index = TGetControllerNvdataVersionRsp
TGetControllerNvdataVersionRsp.group = {}

local function TGetControllerNvdataVersionRsp_from_obj(obj)
    return setmetatable(obj, TGetControllerNvdataVersionRsp)
end

function TGetControllerNvdataVersionRsp.new(CompletionCode, ManufactureId, Reserve, Data)
    return TGetControllerNvdataVersionRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        Reserve = Reserve,
        Data = Data
    })
end
---@param obj StorageIpmiCmds.GetControllerNvdataVersionRsp
function TGetControllerNvdataVersionRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.Reserve = obj.Reserve
    self.Data = obj.Data
end

function TGetControllerNvdataVersionRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetControllerNvdataVersionRsp.group)
end

TGetControllerNvdataVersionRsp.from_obj = TGetControllerNvdataVersionRsp_from_obj

TGetControllerNvdataVersionRsp.proto_property = {'CompletionCode', 'ManufactureId', 'Reserve', 'Data'}

TGetControllerNvdataVersionRsp.default = {0, 0, 0, ''}

TGetControllerNvdataVersionRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'Reserve', is_array = false, struct = nil}, {name = 'Data', is_array = false, struct = nil}
}

function TGetControllerNvdataVersionRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserve', self.Reserve, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TGetControllerNvdataVersionRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetControllerNvdataVersionRsp.proto_property, errs, need_convert)
    return self
end

function TGetControllerNvdataVersionRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.Reserve, self.Data
end

GetControllerNvdataVersion.GetControllerNvdataVersionRsp = TGetControllerNvdataVersionRsp

return GetControllerNvdataVersion
