--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetControllerInfo = {}

---@class StorageIpmiCmds.GetControllerInfoReq
---@field ManufacturerId integer
---@field Reserve integer
---@field ControllerId integer
---@field ReadingOffset integer
---@field ReadingLength integer
local TGetControllerInfoReq = {}
TGetControllerInfoReq.__index = TGetControllerInfoReq
TGetControllerInfoReq.group = {}

local function TGetControllerInfoReq_from_obj(obj)
    return setmetatable(obj, TGetControllerInfoReq)
end

function TGetControllerInfoReq.new(ManufacturerId, Reserve, ControllerId, ReadingOffset, ReadingLength)
    return TGetControllerInfoReq_from_obj({
        ManufacturerId = ManufacturerId,
        Reserve = Reserve,
        ControllerId = ControllerId,
        ReadingOffset = ReadingOffset,
        ReadingLength = ReadingLength
    })
end
---@param obj StorageIpmiCmds.GetControllerInfoReq
function TGetControllerInfoReq:init_from_obj(obj)
    self.ManufacturerId = obj.ManufacturerId
    self.Reserve = obj.Reserve
    self.ControllerId = obj.ControllerId
    self.ReadingOffset = obj.ReadingOffset
    self.ReadingLength = obj.ReadingLength
end

function TGetControllerInfoReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetControllerInfoReq.group)
end

TGetControllerInfoReq.from_obj = TGetControllerInfoReq_from_obj

TGetControllerInfoReq.proto_property = {'ManufacturerId', 'Reserve', 'ControllerId', 'ReadingOffset', 'ReadingLength'}

TGetControllerInfoReq.default = {0, 0, 0, 0, 0}

TGetControllerInfoReq.struct = {
    {name = 'ManufacturerId', is_array = false, struct = nil}, {name = 'Reserve', is_array = false, struct = nil},
    {name = 'ControllerId', is_array = false, struct = nil}, {name = 'ReadingOffset', is_array = false, struct = nil},
    {name = 'ReadingLength', is_array = false, struct = nil}
}

function TGetControllerInfoReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufacturerId', self.ManufacturerId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserve', self.Reserve, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ControllerId', self.ControllerId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ReadingOffset', self.ReadingOffset, 'uint16', false, errs, need_convert)
    validate.Optional(prefix .. 'ReadingLength', self.ReadingLength, 'uint8', false, errs, need_convert)

    TGetControllerInfoReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetControllerInfoReq.proto_property, errs, need_convert)
    return self
end

function TGetControllerInfoReq:unpack(_)
    return self.ManufacturerId, self.Reserve, self.ControllerId, self.ReadingOffset, self.ReadingLength
end

GetControllerInfo.GetControllerInfoReq = TGetControllerInfoReq

---@class StorageIpmiCmds.GetControllerInfoRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field Reserve integer
---@field Data string
local TGetControllerInfoRsp = {}
TGetControllerInfoRsp.__index = TGetControllerInfoRsp
TGetControllerInfoRsp.group = {}

local function TGetControllerInfoRsp_from_obj(obj)
    return setmetatable(obj, TGetControllerInfoRsp)
end

function TGetControllerInfoRsp.new(CompletionCode, ManufactureId, Reserve, Data)
    return TGetControllerInfoRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        Reserve = Reserve,
        Data = Data
    })
end
---@param obj StorageIpmiCmds.GetControllerInfoRsp
function TGetControllerInfoRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.Reserve = obj.Reserve
    self.Data = obj.Data
end

function TGetControllerInfoRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetControllerInfoRsp.group)
end

TGetControllerInfoRsp.from_obj = TGetControllerInfoRsp_from_obj

TGetControllerInfoRsp.proto_property = {'CompletionCode', 'ManufactureId', 'Reserve', 'Data'}

TGetControllerInfoRsp.default = {0, 0, 0, ''}

TGetControllerInfoRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'Reserve', is_array = false, struct = nil}, {name = 'Data', is_array = false, struct = nil}
}

function TGetControllerInfoRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserve', self.Reserve, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TGetControllerInfoRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetControllerInfoRsp.proto_property, errs, need_convert)
    return self
end

function TGetControllerInfoRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.Reserve, self.Data
end

GetControllerInfo.GetControllerInfoRsp = TGetControllerInfoRsp

return GetControllerInfo
