--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local CreateLogicalDriveOnExistedArray = {}

---@class StorageIpmiCmds.CreateLogicalDriveOnExistedArrayReq
---@field ManufacturerId integer
---@field Reserve integer
---@field ControllerId integer
---@field ArrayIDLow integer
---@field ArrayIDHigh integer
---@field Frame integer
---@field WritingOffset integer
---@field WritingLength integer
---@field Data string
local TCreateLogicalDriveOnExistedArrayReq = {}
TCreateLogicalDriveOnExistedArrayReq.__index = TCreateLogicalDriveOnExistedArrayReq
TCreateLogicalDriveOnExistedArrayReq.group = {}

local function TCreateLogicalDriveOnExistedArrayReq_from_obj(obj)
    return setmetatable(obj, TCreateLogicalDriveOnExistedArrayReq)
end

function TCreateLogicalDriveOnExistedArrayReq.new(ManufacturerId, Reserve, ControllerId, ArrayIDLow, ArrayIDHigh, Frame,
    WritingOffset, WritingLength, Data)
    return TCreateLogicalDriveOnExistedArrayReq_from_obj({
        ManufacturerId = ManufacturerId,
        Reserve = Reserve,
        ControllerId = ControllerId,
        ArrayIDLow = ArrayIDLow,
        ArrayIDHigh = ArrayIDHigh,
        Frame = Frame,
        WritingOffset = WritingOffset,
        WritingLength = WritingLength,
        Data = Data
    })
end
---@param obj StorageIpmiCmds.CreateLogicalDriveOnExistedArrayReq
function TCreateLogicalDriveOnExistedArrayReq:init_from_obj(obj)
    self.ManufacturerId = obj.ManufacturerId
    self.Reserve = obj.Reserve
    self.ControllerId = obj.ControllerId
    self.ArrayIDLow = obj.ArrayIDLow
    self.ArrayIDHigh = obj.ArrayIDHigh
    self.Frame = obj.Frame
    self.WritingOffset = obj.WritingOffset
    self.WritingLength = obj.WritingLength
    self.Data = obj.Data
end

function TCreateLogicalDriveOnExistedArrayReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCreateLogicalDriveOnExistedArrayReq.group)
end

TCreateLogicalDriveOnExistedArrayReq.from_obj = TCreateLogicalDriveOnExistedArrayReq_from_obj

TCreateLogicalDriveOnExistedArrayReq.proto_property = {
    'ManufacturerId', 'Reserve', 'ControllerId', 'ArrayIDLow', 'ArrayIDHigh', 'Frame', 'WritingOffset', 'WritingLength',
    'Data'
}

TCreateLogicalDriveOnExistedArrayReq.default = {0, 0, 0, 0, 0, 0, 0, 0, ''}

TCreateLogicalDriveOnExistedArrayReq.struct = {
    {name = 'ManufacturerId', is_array = false, struct = nil}, {name = 'Reserve', is_array = false, struct = nil},
    {name = 'ControllerId', is_array = false, struct = nil}, {name = 'ArrayIDLow', is_array = false, struct = nil},
    {name = 'ArrayIDHigh', is_array = false, struct = nil}, {name = 'Frame', is_array = false, struct = nil},
    {name = 'WritingOffset', is_array = false, struct = nil}, {name = 'WritingLength', is_array = false, struct = nil},
    {name = 'Data', is_array = false, struct = nil}
}

function TCreateLogicalDriveOnExistedArrayReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufacturerId', self.ManufacturerId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserve', self.Reserve, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ControllerId', self.ControllerId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ArrayIDLow', self.ArrayIDLow, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ArrayIDHigh', self.ArrayIDHigh, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Frame', self.Frame, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'WritingOffset', self.WritingOffset, 'uint16', false, errs, need_convert)
    validate.Optional(prefix .. 'WritingLength', self.WritingLength, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TCreateLogicalDriveOnExistedArrayReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCreateLogicalDriveOnExistedArrayReq.proto_property, errs, need_convert)
    return self
end

function TCreateLogicalDriveOnExistedArrayReq:unpack(_)
    return self.ManufacturerId, self.Reserve, self.ControllerId, self.ArrayIDLow, self.ArrayIDHigh, self.Frame,
        self.WritingOffset, self.WritingLength, self.Data
end

CreateLogicalDriveOnExistedArray.CreateLogicalDriveOnExistedArrayReq = TCreateLogicalDriveOnExistedArrayReq

---@class StorageIpmiCmds.CreateLogicalDriveOnExistedArrayRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field Reserve integer
---@field Data string
local TCreateLogicalDriveOnExistedArrayRsp = {}
TCreateLogicalDriveOnExistedArrayRsp.__index = TCreateLogicalDriveOnExistedArrayRsp
TCreateLogicalDriveOnExistedArrayRsp.group = {}

local function TCreateLogicalDriveOnExistedArrayRsp_from_obj(obj)
    return setmetatable(obj, TCreateLogicalDriveOnExistedArrayRsp)
end

function TCreateLogicalDriveOnExistedArrayRsp.new(CompletionCode, ManufactureId, Reserve, Data)
    return TCreateLogicalDriveOnExistedArrayRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        Reserve = Reserve,
        Data = Data
    })
end
---@param obj StorageIpmiCmds.CreateLogicalDriveOnExistedArrayRsp
function TCreateLogicalDriveOnExistedArrayRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.Reserve = obj.Reserve
    self.Data = obj.Data
end

function TCreateLogicalDriveOnExistedArrayRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCreateLogicalDriveOnExistedArrayRsp.group)
end

TCreateLogicalDriveOnExistedArrayRsp.from_obj = TCreateLogicalDriveOnExistedArrayRsp_from_obj

TCreateLogicalDriveOnExistedArrayRsp.proto_property = {'CompletionCode', 'ManufactureId', 'Reserve', 'Data'}

TCreateLogicalDriveOnExistedArrayRsp.default = {0, 0, 0, ''}

TCreateLogicalDriveOnExistedArrayRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'Reserve', is_array = false, struct = nil}, {name = 'Data', is_array = false, struct = nil}
}

function TCreateLogicalDriveOnExistedArrayRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserve', self.Reserve, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TCreateLogicalDriveOnExistedArrayRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCreateLogicalDriveOnExistedArrayRsp.proto_property, errs, need_convert)
    return self
end

function TCreateLogicalDriveOnExistedArrayRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.Reserve, self.Data
end

CreateLogicalDriveOnExistedArray.CreateLogicalDriveOnExistedArrayRsp = TCreateLogicalDriveOnExistedArrayRsp

return CreateLogicalDriveOnExistedArray
