-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MController = {}

---@class MController.SlotId
---@field SlotId integer
local TSlotId = {}
TSlotId.__index = TSlotId
TSlotId.group = {}

local function TSlotId_from_obj(obj)
    return setmetatable(obj, TSlotId)
end

function TSlotId.new(SlotId)
    return TSlotId_from_obj({SlotId = SlotId})
end
---@param obj MController.SlotId
function TSlotId:init_from_obj(obj)
    self.SlotId = obj.SlotId
end

function TSlotId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSlotId.group)
end

TSlotId.from_obj = TSlotId_from_obj

TSlotId.proto_property = {'SlotId'}

TSlotId.default = {0}

TSlotId.struct = {{name = 'SlotId', is_array = false, struct = nil}}

function TSlotId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SlotId', self.SlotId, 'uint8', true, errs, need_convert)

    TSlotId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSlotId.proto_property, errs, need_convert)
    return self
end

function TSlotId:unpack(_)
    return self.SlotId
end

MController.SlotId = TSlotId

---@class MController.CtrlOption3
---@field CtrlOption3 integer
local TCtrlOption3 = {}
TCtrlOption3.__index = TCtrlOption3
TCtrlOption3.group = {}

local function TCtrlOption3_from_obj(obj)
    return setmetatable(obj, TCtrlOption3)
end

function TCtrlOption3.new(CtrlOption3)
    return TCtrlOption3_from_obj({CtrlOption3 = CtrlOption3})
end
---@param obj MController.CtrlOption3
function TCtrlOption3:init_from_obj(obj)
    self.CtrlOption3 = obj.CtrlOption3
end

function TCtrlOption3:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCtrlOption3.group)
end

TCtrlOption3.from_obj = TCtrlOption3_from_obj

TCtrlOption3.proto_property = {'CtrlOption3'}

TCtrlOption3.default = {0}

TCtrlOption3.struct = {{name = 'CtrlOption3', is_array = false, struct = nil}}

function TCtrlOption3:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CtrlOption3', self.CtrlOption3, 'uint32', true, errs, need_convert)

    TCtrlOption3:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCtrlOption3.proto_property, errs, need_convert)
    return self
end

function TCtrlOption3:unpack(_)
    return self.CtrlOption3
end

MController.CtrlOption3 = TCtrlOption3

---@class MController.CtrlOption2
---@field CtrlOption2 integer
local TCtrlOption2 = {}
TCtrlOption2.__index = TCtrlOption2
TCtrlOption2.group = {}

local function TCtrlOption2_from_obj(obj)
    return setmetatable(obj, TCtrlOption2)
end

function TCtrlOption2.new(CtrlOption2)
    return TCtrlOption2_from_obj({CtrlOption2 = CtrlOption2})
end
---@param obj MController.CtrlOption2
function TCtrlOption2:init_from_obj(obj)
    self.CtrlOption2 = obj.CtrlOption2
end

function TCtrlOption2:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCtrlOption2.group)
end

TCtrlOption2.from_obj = TCtrlOption2_from_obj

TCtrlOption2.proto_property = {'CtrlOption2'}

TCtrlOption2.default = {0}

TCtrlOption2.struct = {{name = 'CtrlOption2', is_array = false, struct = nil}}

function TCtrlOption2:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CtrlOption2', self.CtrlOption2, 'uint32', true, errs, need_convert)

    TCtrlOption2:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCtrlOption2.proto_property, errs, need_convert)
    return self
end

function TCtrlOption2:unpack(_)
    return self.CtrlOption2
end

MController.CtrlOption2 = TCtrlOption2

---@class MController.CtrlOption1
---@field CtrlOption1 integer
local TCtrlOption1 = {}
TCtrlOption1.__index = TCtrlOption1
TCtrlOption1.group = {}

local function TCtrlOption1_from_obj(obj)
    return setmetatable(obj, TCtrlOption1)
end

function TCtrlOption1.new(CtrlOption1)
    return TCtrlOption1_from_obj({CtrlOption1 = CtrlOption1})
end
---@param obj MController.CtrlOption1
function TCtrlOption1:init_from_obj(obj)
    self.CtrlOption1 = obj.CtrlOption1
end

function TCtrlOption1:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCtrlOption1.group)
end

TCtrlOption1.from_obj = TCtrlOption1_from_obj

TCtrlOption1.proto_property = {'CtrlOption1'}

TCtrlOption1.default = {0}

TCtrlOption1.struct = {{name = 'CtrlOption1', is_array = false, struct = nil}}

function TCtrlOption1:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CtrlOption1', self.CtrlOption1, 'uint32', true, errs, need_convert)

    TCtrlOption1:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCtrlOption1.proto_property, errs, need_convert)
    return self
end

function TCtrlOption1:unpack(_)
    return self.CtrlOption1
end

MController.CtrlOption1 = TCtrlOption1

---@class MController.Phyaddr
---@field Phyaddr integer
local TPhyaddr = {}
TPhyaddr.__index = TPhyaddr
TPhyaddr.group = {}

local function TPhyaddr_from_obj(obj)
    return setmetatable(obj, TPhyaddr)
end

function TPhyaddr.new(Phyaddr)
    return TPhyaddr_from_obj({Phyaddr = Phyaddr})
end
---@param obj MController.Phyaddr
function TPhyaddr:init_from_obj(obj)
    self.Phyaddr = obj.Phyaddr
end

function TPhyaddr:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPhyaddr.group)
end

TPhyaddr.from_obj = TPhyaddr_from_obj

TPhyaddr.proto_property = {'Phyaddr'}

TPhyaddr.default = {0}

TPhyaddr.struct = {{name = 'Phyaddr', is_array = false, struct = nil}}

function TPhyaddr:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Phyaddr', self.Phyaddr, 'uint16', true, errs, need_convert)

    TPhyaddr:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPhyaddr.proto_property, errs, need_convert)
    return self
end

function TPhyaddr:unpack(_)
    return self.Phyaddr
end

MController.Phyaddr = TPhyaddr

---@class MController.Eid
---@field Eid integer
local TEid = {}
TEid.__index = TEid
TEid.group = {}

local function TEid_from_obj(obj)
    return setmetatable(obj, TEid)
end

function TEid.new(Eid)
    return TEid_from_obj({Eid = Eid})
end
---@param obj MController.Eid
function TEid:init_from_obj(obj)
    self.Eid = obj.Eid
end

function TEid:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TEid.group)
end

TEid.from_obj = TEid_from_obj

TEid.proto_property = {'Eid'}

TEid.default = {0}

TEid.struct = {{name = 'Eid', is_array = false, struct = nil}}

function TEid:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Eid', self.Eid, 'uint8', true, errs, need_convert)

    TEid:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TEid.proto_property, errs, need_convert)
    return self
end

function TEid:unpack(_)
    return self.Eid
end

MController.Eid = TEid

---@class MController.DevFunction
---@field DevFunction integer
local TDevFunction = {}
TDevFunction.__index = TDevFunction
TDevFunction.group = {}

local function TDevFunction_from_obj(obj)
    return setmetatable(obj, TDevFunction)
end

function TDevFunction.new(DevFunction)
    return TDevFunction_from_obj({DevFunction = DevFunction})
end
---@param obj MController.DevFunction
function TDevFunction:init_from_obj(obj)
    self.DevFunction = obj.DevFunction
end

function TDevFunction:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDevFunction.group)
end

TDevFunction.from_obj = TDevFunction_from_obj

TDevFunction.proto_property = {'DevFunction'}

TDevFunction.default = {0}

TDevFunction.struct = {{name = 'DevFunction', is_array = false, struct = nil}}

function TDevFunction:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DevFunction', self.DevFunction, 'uint8', true, errs, need_convert)

    TDevFunction:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDevFunction.proto_property, errs, need_convert)
    return self
end

function TDevFunction:unpack(_)
    return self.DevFunction
end

MController.DevFunction = TDevFunction

---@class MController.DevDevice
---@field DevDevice integer
local TDevDevice = {}
TDevDevice.__index = TDevDevice
TDevDevice.group = {}

local function TDevDevice_from_obj(obj)
    return setmetatable(obj, TDevDevice)
end

function TDevDevice.new(DevDevice)
    return TDevDevice_from_obj({DevDevice = DevDevice})
end
---@param obj MController.DevDevice
function TDevDevice:init_from_obj(obj)
    self.DevDevice = obj.DevDevice
end

function TDevDevice:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDevDevice.group)
end

TDevDevice.from_obj = TDevDevice_from_obj

TDevDevice.proto_property = {'DevDevice'}

TDevDevice.default = {0}

TDevDevice.struct = {{name = 'DevDevice', is_array = false, struct = nil}}

function TDevDevice:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DevDevice', self.DevDevice, 'uint8', true, errs, need_convert)

    TDevDevice:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDevDevice.proto_property, errs, need_convert)
    return self
end

function TDevDevice:unpack(_)
    return self.DevDevice
end

MController.DevDevice = TDevDevice

---@class MController.DevBus
---@field DevBus integer
local TDevBus = {}
TDevBus.__index = TDevBus
TDevBus.group = {}

local function TDevBus_from_obj(obj)
    return setmetatable(obj, TDevBus)
end

function TDevBus.new(DevBus)
    return TDevBus_from_obj({DevBus = DevBus})
end
---@param obj MController.DevBus
function TDevBus:init_from_obj(obj)
    self.DevBus = obj.DevBus
end

function TDevBus:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDevBus.group)
end

TDevBus.from_obj = TDevBus_from_obj

TDevBus.proto_property = {'DevBus'}

TDevBus.default = {0}

TDevBus.struct = {{name = 'DevBus', is_array = false, struct = nil}}

function TDevBus:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DevBus', self.DevBus, 'uint8', true, errs, need_convert)

    TDevBus:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDevBus.proto_property, errs, need_convert)
    return self
end

function TDevBus:unpack(_)
    return self.DevBus
end

MController.DevBus = TDevBus

---@class MController.Segment
---@field Segment integer
local TSegment = {}
TSegment.__index = TSegment
TSegment.group = {}

local function TSegment_from_obj(obj)
    return setmetatable(obj, TSegment)
end

function TSegment.new(Segment)
    return TSegment_from_obj({Segment = Segment})
end
---@param obj MController.Segment
function TSegment:init_from_obj(obj)
    self.Segment = obj.Segment
end

function TSegment:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSegment.group)
end

TSegment.from_obj = TSegment_from_obj

TSegment.proto_property = {'Segment'}

TSegment.default = {0}

TSegment.struct = {{name = 'Segment', is_array = false, struct = nil}}

function TSegment:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Segment', self.Segment, 'uint8', true, errs, need_convert)

    TSegment:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSegment.proto_property, errs, need_convert)
    return self
end

function TSegment:unpack(_)
    return self.Segment
end

MController.Segment = TSegment

---@class MController.SocketId
---@field SocketId integer
local TSocketId = {}
TSocketId.__index = TSocketId
TSocketId.group = {}

local function TSocketId_from_obj(obj)
    return setmetatable(obj, TSocketId)
end

function TSocketId.new(SocketId)
    return TSocketId_from_obj({SocketId = SocketId})
end
---@param obj MController.SocketId
function TSocketId:init_from_obj(obj)
    self.SocketId = obj.SocketId
end

function TSocketId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSocketId.group)
end

TSocketId.from_obj = TSocketId_from_obj

TSocketId.proto_property = {'SocketId'}

TSocketId.default = {0}

TSocketId.struct = {{name = 'SocketId', is_array = false, struct = nil}}

function TSocketId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SocketId', self.SocketId, 'uint8', true, errs, need_convert)

    TSocketId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSocketId.proto_property, errs, need_convert)
    return self
end

function TSocketId:unpack(_)
    return self.SocketId
end

MController.SocketId = TSocketId

---@class MController.SystemId
---@field SystemId integer
local TSystemId = {}
TSystemId.__index = TSystemId
TSystemId.group = {}

local function TSystemId_from_obj(obj)
    return setmetatable(obj, TSystemId)
end

function TSystemId.new(SystemId)
    return TSystemId_from_obj({SystemId = SystemId})
end
---@param obj MController.SystemId
function TSystemId:init_from_obj(obj)
    self.SystemId = obj.SystemId
end

function TSystemId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSystemId.group)
end

TSystemId.from_obj = TSystemId_from_obj

TSystemId.proto_property = {'SystemId'}

TSystemId.default = {0}

TSystemId.struct = {{name = 'SystemId', is_array = false, struct = nil}}

function TSystemId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SystemId', self.SystemId, 'uint8', true, errs, need_convert)

    TSystemId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSystemId.proto_property, errs, need_convert)
    return self
end

function TSystemId:unpack(_)
    return self.SystemId
end

MController.SystemId = TSystemId

---@class MController.RefChip
---@field RefChip integer[]
local TRefChip = {}
TRefChip.__index = TRefChip
TRefChip.group = {}

local function TRefChip_from_obj(obj)
    return setmetatable(obj, TRefChip)
end

function TRefChip.new(RefChip)
    return TRefChip_from_obj({RefChip = RefChip})
end
---@param obj MController.RefChip
function TRefChip:init_from_obj(obj)
    self.RefChip = obj.RefChip
end

function TRefChip:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRefChip.group)
end

TRefChip.from_obj = TRefChip_from_obj

TRefChip.proto_property = {'RefChip'}

TRefChip.default = {{}}

TRefChip.struct = {{name = 'RefChip', is_array = true, struct = nil}}

function TRefChip:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'RefChip', self.RefChip, 'uint8', false, errs, need_convert)

    TRefChip:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRefChip.proto_property, errs, need_convert)
    return self
end

function TRefChip:unpack(_)
    return self.RefChip
end

MController.RefChip = TRefChip

return MController
