-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local mdb = require 'mc.mdb'
local class = require 'mc.class_mgnt'
local privilege = require 'mc.privilege'

local controller_class_types = require 'class.types.Controller'
local disk_array_class_types = require 'class.types.DiskArray'
local drive_class_types = require 'class.types.Drive'
local volume_class_types = require 'class.types.Volume'
local battery_class_types = require 'class.types.Battery'
local nvme_class_types = require 'class.types.Nvme'
local virtual_vpd_connect_class_types = require 'class.types.VirtualVPDConnect'
local drive_info_table_class_types = require 'class.types.DriveInfoTable'
local drives_table_info_class_types = require 'class.types.DrivesTableInfo'
local storage_reset_class_types = require 'class.types.StorageReset'
local global_storage_config_table_class_types = require 'class.types.GlobalStorageConfigTable'
local storage_config_intf_types = require 'storage.json_types.StorageConfig'
local diagnose_intf_types = require 'storage.json_types.Diagnose'
local phy_bit_error_intf_types = require 'storage.json_types.PhyBitError'
local record_drive_spare_block_intf_types = require 'storage.json_types.RecordDriveSpareBlock'
local properties_intf_types = require 'storage.json_types.Properties'
local controller_intf_types = require 'storage.json_types.Controller'
local driver_intf_types = require 'storage.json_types.Driver'
local chip_intf_types = require 'storage.json_types.Chip'
local consistency_check_intf_types = require 'storage.json_types.ConsistencyCheck'
local volume_manage_intf_types = require 'storage.json_types.VolumeManage'
local controller_status_intf_types = require 'storage.json_types.ControllerStatus'
local battery_status_intf_types = require 'storage.json_types.BatteryStatus'
local retirement_intf_types = require 'storage.json_types.Retirement'
local hardware_intf_types = require 'storage.json_types.Hardware'
local phy_error_intf_types = require 'storage.json_types.PhyError'
local disk_array_intf_types = require 'storage.json_types.DiskArray'
local drive_intf_types = require 'storage.json_types.Drive'
local addr_info_intf_types = require 'storage.json_types.AddrInfo'
local drive_status_intf_types = require 'storage.json_types.DriveStatus'
local sassmart_intf_types = require 'storage.json_types.SASSMART'
local metric_intf_types = require 'storage.json_types.Metric'
local drive_sub_health_intf_types = require 'storage.json_types.DriveSubHealth'
local nv_me_intf_types = require 'storage.json_types.NVMe'
local nv_me_smart_intf_types = require 'storage.json_types.NVMeSMART'
local drives_intf_types = require 'storage.json_types.Drives'
local volume_intf_types = require 'storage.json_types.Volume'
local battery_intf_types = require 'storage.json_types.Battery'
local sas_metrics_intf_types = require 'storage.json_types.SASMetrics'
local disk_partition_intf_types = require 'storage.json_types.DiskPartition'

local StorageConfig = {
    ['table_name'] = 't_storage_config_table_info',
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Systems.Storage.StorageConfig'] = {
            ['StorageConfigReady'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = '用于控制器配置导入导出场景,标志了所有控制器的状态',
                ['validator'] = storage_config_intf_types.StorageConfigReady
            },
            ['VolumesStateAbnormal'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = '是否存在状态异常的逻辑盘。0：否，1：是',
                ['usage'] = {'CSR'},
                ['validator'] = storage_config_intf_types.VolumesStateAbnormal
            },
            ['DiskPartitionUsagePercentageThreshold'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = false,
                ['description'] = '磁盘分区占用率告警阈值(百分比)',
                ['privilege'] = {['read'] = {'ReadOnly'}, ['write'] = {'BasicSetting'}},
                ['default'] = 100,
                ['validator'] = storage_config_intf_types.DiskPartitionUsagePercentageThreshold
            }
        },
        ['bmc.kepler.Systems.Storage.Diagnose'] = {
            ['PhyErrorEnabled'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = false,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = 'PHY误码诊断使能',
                ['usage'] = {'PoweroffPer'},
                ['primaryKey'] = true,
                ['default'] = true,
                ['validator'] = diagnose_intf_types.PhyErrorEnabled
            },
            ['PhyErrorInterval'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = false,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = 'PHY误码数据采集的时间间隔，单位秒',
                ['usage'] = {'PoweroffPer'},
                ['default'] = 1800,
                ['validator'] = diagnose_intf_types.PhyErrorInterval
            },
            ['PhyErrorMaxRecord'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = false,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = 'PHY误码在一个OS启动周期内记录的最大条数（有增长的记录）',
                ['usage'] = {'PoweroffPer'},
                ['default'] = 20,
                ['validator'] = diagnose_intf_types.PhyErrorMaxRecord
            },
            ['PhyErrorThreshold'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = false,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = 'PHY误码单位时间增长过快的判断门限值',
                ['usage'] = {'PoweroffPer'},
                ['default'] = 100,
                ['validator'] = diagnose_intf_types.PhyErrorThreshold
            },
            ['MaxPhyErrorLogFileRotationCount'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = false,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = 'PHY误码循环记录的最大文件数',
                ['usage'] = {'PoweroffPer'},
                ['default'] = 10,
                ['validator'] = diagnose_intf_types.MaxPhyErrorLogFileRotationCount
            },
            ['PhyErrorSelUnlimitFlag'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = false,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = 'PHY误码是否允许产生多个SEL告警事件',
                ['usage'] = {'PoweroffPer'},
                ['validator'] = diagnose_intf_types.PhyErrorSelUnlimitFlag
            }
        },
        ['bmc.kepler.Debug.Storage.PhyBitError'] = {
            ['FileMockEnabled'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = false,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = 'PHY误码模拟文件使能',
                ['usage'] = {'PoweroffPer'},
                ['validator'] = phy_bit_error_intf_types.FileMockEnabled
            }
        },
        ['bmc.kepler.Debug.Storage.RecordDriveSpareBlock'] = {},
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '对象类名',
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '对象名',
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['description'] = '对象标志符',
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.Debug.Storage.PhyBitError'] = {
            ['MockData'] = {
                ['description'] = '模拟Phy误码数据',
                ['req'] = {
                    {['baseType'] = 'U8', ['description'] = '控制器Id', ['param'] = 'ControllerId'},
                    {['baseType'] = 'U8', ['description'] = 'Expander的Id', ['param'] = 'ExpanderId'},
                    {
                        ['baseType'] = 'String',
                        ['description'] = '误码数据文件存放路径',
                        ['param'] = 'FilePath'
                    }
                },
                ['rsp'] = {{['baseType'] = 'U8', ['description'] = '模拟结果', ['param'] = 'MockResult'}}
            }
        },
        ['bmc.kepler.Debug.Storage.RecordDriveSpareBlock'] = {
            ['MockRecordSpareBlock'] = {
                ['description'] = '模拟硬盘冗余块数据',
                ['privilege'] = {'BasicSetting'},
                ['req'] = {
                    {['baseType'] = 'U8', ['description'] = '硬盘Id', ['param'] = 'Id'},
                    {['baseType'] = 'U8', ['description'] = '非用户区冗余块数据', ['param'] = 'SlcSpareBlock'},
                    {['baseType'] = 'U8', ['description'] = '用户区冗余块数据', ['param'] = 'TlcSpareBlock'}
                },
                ['rsp'] = {}
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['GetOptions'] = {
                ['req'] = {
                    {['baseType'] = 'String', ['description'] = '接口名', ['param'] = 'Interface'},
                    {['baseType'] = 'String', ['description'] = '属性名', ['param'] = 'Property'}
                },
                ['rsp'] = {
                    {
                        ['baseType'] = 'Struct',
                        ['$ref'] = '#/defs/Options',
                        ['description'] = '属性能力选项，例如是否弃用、是否是易变属性等',
                        ['param'] = 'Options'
                    }
                },
                ['description'] = '按接口名和属性名查询属性的能力选项'
            },
            ['GetPropertiesByOptions'] = {
                ['req'] = {
                    {['baseType'] = 'String', ['description'] = '接口名', ['param'] = 'Interface'}, {
                        ['baseType'] = 'Struct',
                        ['$ref'] = '#/defs/Options',
                        ['description'] = '属性能力选项，例如是否弃用、是否是易变属性等',
                        ['param'] = 'Options'
                    }
                },
                ['rsp'] = {{['baseType'] = 'String[]', ['description'] = '属性名列表', ['param'] = 'Properties'}},
                ['description'] = '按接口名和能力选项查询符合条件的所有属性'
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Systems/:SystemId/Storage'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Systems.Storage.StorageConfig'] = {
            ['property_defaults'] = {
                ['StorageConfigReady'] = storage_config_intf_types.StorageConfigReady.default[1],
                ['VolumesStateAbnormal'] = storage_config_intf_types.VolumesStateAbnormal.default[1],
                ['DiskPartitionUsagePercentageThreshold'] = 100
            },
            ['privileges'] = {
                ['path'] = privilege.ReadOnly,
                ['props'] = {
                    ['DiskPartitionUsagePercentageThreshold'] = {
                        ['read'] = privilege.ReadOnly,
                        ['write'] = privilege.BasicSetting
                    }
                }
            },
            ['interface_types'] = storage_config_intf_types
        },
        ['bmc.kepler.Systems.Storage.Diagnose'] = {
            ['property_defaults'] = {
                ['PhyErrorEnabled'] = true,
                ['PhyErrorInterval'] = 1800,
                ['PhyErrorMaxRecord'] = 20,
                ['PhyErrorThreshold'] = 100,
                ['MaxPhyErrorLogFileRotationCount'] = 10,
                ['PhyErrorSelUnlimitFlag'] = diagnose_intf_types.PhyErrorSelUnlimitFlag.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = diagnose_intf_types
        },
        ['bmc.kepler.Debug.Storage.PhyBitError'] = {
            ['property_defaults'] = {['FileMockEnabled'] = phy_bit_error_intf_types.FileMockEnabled.default[1]},
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = phy_bit_error_intf_types
        },
        ['bmc.kepler.Debug.Storage.RecordDriveSpareBlock'] = {
            ['property_defaults'] = {},
            ['privileges'] = {
                ['path'] = privilege.ReadOnly,
                ['methods'] = {['MockRecordSpareBlock'] = privilege.BasicSetting}
            },
            ['interface_types'] = record_drive_spare_block_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local Controller = {
    ['table_name'] = 't_controller_info',
    ['alias_map'] = {
        ['ControllerName'] = {['original_name'] = 'Name', ['interface'] = 'bmc.kepler.Systems.Storage.Controller'},
        ['DriverName'] = {['original_name'] = 'Name', ['interface'] = 'bmc.kepler.Systems.Storage.Controller.Driver'},
        ['DriverVersion'] = {
            ['original_name'] = 'Version',
            ['interface'] = 'bmc.kepler.Systems.Storage.Controller.Driver'
        },
        ['ConsistencyCheckState'] = {
            ['original_name'] = 'State',
            ['interface'] = 'bmc.kepler.Systems.Storage.Controller.ConsistencyCheck'
        },
        ['RetirementState'] = {['original_name'] = 'State', ['interface'] = 'bmc.kepler.LifeCycle.Retirement'},
        ['InventorySerialNumber'] = {
            ['original_name'] = 'SerialNumber',
            ['interface'] = 'bmc.kepler.Inventory.Hardware'
        },
        ['InventoryFirmwareVersion'] = {
            ['original_name'] = 'FirmwareVersion',
            ['interface'] = 'bmc.kepler.Inventory.Hardware'
        }
    },
    ['prop_configs'] = {
        ['RefChip'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8[]',
            ['refInterface'] = 'bmc.kepler.Chip.BlockIO',
            ['validator'] = controller_class_types.RefChip
        },
        ['SystemId'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['readOnly'] = true,
            ['validator'] = controller_class_types.SystemId
        },
        ['SocketId'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['readOnly'] = true,
            ['validator'] = controller_class_types.SocketId
        },
        ['Segment'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['readOnly'] = true,
            ['validator'] = controller_class_types.Segment
        },
        ['DevBus'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['readOnly'] = true,
            ['validator'] = controller_class_types.DevBus
        },
        ['DevDevice'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['readOnly'] = true,
            ['validator'] = controller_class_types.DevDevice
        },
        ['DevFunction'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['readOnly'] = true,
            ['validator'] = controller_class_types.DevFunction
        },
        ['Eid'] = {['baseType'] = 'U8', ['readOnly'] = true, ['validator'] = controller_class_types.Eid},
        ['Phyaddr'] = {['baseType'] = 'U16', ['readOnly'] = true, ['validator'] = controller_class_types.Phyaddr},
        ['CtrlOption1'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U32',
            ['readOnly'] = true,
            ['validator'] = controller_class_types.CtrlOption1
        },
        ['CtrlOption2'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U32',
            ['readOnly'] = true,
            ['validator'] = controller_class_types.CtrlOption2
        },
        ['CtrlOption3'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U32',
            ['readOnly'] = true,
            ['validator'] = controller_class_types.CtrlOption3
        },
        ['SlotId'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['readOnly'] = true,
            ['validator'] = controller_class_types.SlotId
        }
    },
    ['default_props'] = {
        ['RefChip'] = controller_class_types.RefChip.default[1],
        ['SystemId'] = controller_class_types.SystemId.default[1],
        ['SocketId'] = controller_class_types.SocketId.default[1],
        ['Segment'] = controller_class_types.Segment.default[1],
        ['DevBus'] = controller_class_types.DevBus.default[1],
        ['DevDevice'] = controller_class_types.DevDevice.default[1],
        ['DevFunction'] = controller_class_types.DevFunction.default[1],
        ['Eid'] = controller_class_types.Eid.default[1],
        ['Phyaddr'] = controller_class_types.Phyaddr.default[1],
        ['CtrlOption1'] = controller_class_types.CtrlOption1.default[1],
        ['CtrlOption2'] = controller_class_types.CtrlOption2.default[1],
        ['CtrlOption3'] = controller_class_types.CtrlOption3.default[1],
        ['SlotId'] = controller_class_types.SlotId.default[1]
    },
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Systems.Storage.Controller'] = {
            ['Id'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = '控制器Id, 由软件生成，默认值0xFF',
                ['usage'] = {'ResetPer'},
                ['default'] = 255,
                ['validator'] = controller_intf_types.Id
            },
            ['Type'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '控制器类型',
                ['validator'] = controller_intf_types.Type
            },
            ['TypeId'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = '控制器的类型Id',
                ['usage'] = {'CSR'},
                ['validator'] = controller_intf_types.TypeId
            },
            ['DeviceName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '对应的PCIeDevice的设备名',
                ['usage'] = {'CSR'},
                ['primaryKey'] = true,
                ['validator'] = controller_intf_types.DeviceName
            },
            ['Position'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '对应的PCIeDevice的位置',
                ['usage'] = {'CSR'},
                ['validator'] = controller_intf_types.Position
            },
            ['TemperatureCelsius'] = {
                ['baseType'] = 'S16',
                ['readOnly'] = true,
                ['options'] = {['volatile'] = true, ['emitsChangedSignal'] = 'true'},
                ['description'] = '控制器芯片温度',
                ['usage'] = {'CSR'},
                ['validator'] = controller_intf_types.TemperatureCelsius
            },
            ['TemperatureAbnormal'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = '温度异常描述，温度获取失败时置1',
                ['usage'] = {'CSR'},
                ['validator'] = controller_intf_types.TemperatureAbnormal
            },
            ['Name'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '控制器名称',
                ['usage'] = {'CSR'},
                ['alias'] = 'ControllerName',
                ['validator'] = controller_intf_types.Name
            },
            ['OOBSupport'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = '支持带外管理模式，0：不支持带外；1：支持带外',
                ['usage'] = {'CSR', 'PoweroffPer'},
                ['validator'] = controller_intf_types.OOBSupport
            },
            ['FirmwareVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '控制器固件版本',
                ['validator'] = controller_intf_types.FirmwareVersion
            },
            ['SupportedMode'] = {
                ['baseType'] = 'String[]',
                ['readOnly'] = true,
                ['description'] = '控制器工作模式',
                ['validator'] = controller_intf_types.SupportedMode
            },
            ['MemorySizeMiB'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['description'] = '控制器内存大小，单位MB',
                ['validator'] = controller_intf_types.MemorySizeMiB
            },
            ['DeviceInterface'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '控制器设备接口',
                ['validator'] = controller_intf_types.DeviceInterface
            },
            ['SASAddr'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '控制器SAS地址',
                ['validator'] = controller_intf_types.SASAddr
            },
            ['SerialNumber'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '控制器序列号',
                ['usage'] = {'CSR'},
                ['validator'] = controller_intf_types.SerialNumber
            },
            ['MaxStripSizeBytes'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['description'] = '控制器支持的最大条带',
                ['validator'] = controller_intf_types.MaxStripSizeBytes
            },
            ['MinStripSizeBytes'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['description'] = '控制器支持的最小条带',
                ['validator'] = controller_intf_types.MinStripSizeBytes
            },
            ['NVDataVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '控制器配置版本',
                ['validator'] = controller_intf_types.NVDataVersion
            },
            ['MaintainPDFailHistrory'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = '是否启用控制器的物理盘故障记忆功能',
                ['validator'] = controller_intf_types.MaintainPDFailHistrory
            },
            ['PCIeLinkWidth'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '控制器的PCIE带宽',
                ['validator'] = controller_intf_types.PCIeLinkWidth
            },
            ['UnconfiguredDriveWriteCachePolicy'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '非RAID组成员盘的写缓存策略:Enabled,Disabled,Default',
                ['validator'] = controller_intf_types.UnconfiguredDriveWriteCachePolicy
            },
            ['HBADriveWriteCachePolicy'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = 'HBA模式下硬盘的写缓存策略:Enabled,Disabled,Default',
                ['validator'] = controller_intf_types.HBADriveWriteCachePolicy
            },
            ['ConfiguredDriveWriteCachePolicy'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = 'RAID组成员盘的写缓存策略:Enabled,Disabled,Default',
                ['validator'] = controller_intf_types.ConfiguredDriveWriteCachePolicy
            },
            ['SupportedRAIDTypes'] = {
                ['baseType'] = 'String[]',
                ['readOnly'] = true,
                ['description'] = 'RAID级别',
                ['validator'] = controller_intf_types.SupportedRAIDTypes
            },
            ['SmarterCopyBackState'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = 'RAID控制器在检测到物理盘SMART错误之后是否自动进行Copyback',
                ['validator'] = controller_intf_types.SmarterCopyBackState
            },
            ['CopyBackState'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = '指定控制器的回拷功能使能状态',
                ['validator'] = controller_intf_types.CopyBackState
            },
            ['BootDevices'] = {
                ['baseType'] = 'String[]',
                ['readOnly'] = true,
                ['description'] = '控制器的启动设备列表',
                ['validator'] = controller_intf_types.BootDevices
            },
            ['HardwareRevision'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '控制器的硬件版本',
                ['validator'] = controller_intf_types.HardwareRevision
            },
            ['HotSpareActivationMode'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '控制器的热备激活模式:Failure,Predictive,Unknown',
                ['validator'] = controller_intf_types.HotSpareActivationMode
            },
            ['NoBatteryWriteCacheEnabled'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = '控制器的无电池写缓存模式',
                ['validator'] = controller_intf_types.NoBatteryWriteCacheEnabled
            },
            ['ReadCachePercent'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = '控制器的读缓存百分比，取值范围：0~100',
                ['validator'] = controller_intf_types.ReadCachePercent
            },
            ['JBODState'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = '控制器的JBOD功能状态：false，true',
                ['validator'] = controller_intf_types.JBODState
            },
            ['CachePinnedState'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = '控制器的Cache Pinned开关',
                ['validator'] = controller_intf_types.CachePinnedState
            },
            ['DDREccCount'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['description'] = 'DDR ECC计数',
                ['validator'] = controller_intf_types.DDREccCount
            },
            ['WorkMode'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '控制器的工作模式, 包括RAID、HBA、JBOD和MIXED四种',
                ['validator'] = controller_intf_types.WorkMode
            },
            ['RefDrives'] = {
                ['baseType'] = 'String[]',
                ['readOnly'] = true,
                ['description'] = '控制器下挂载的所有硬盘名',
                ['validator'] = controller_intf_types.RefDrives
            },
            ['BOMNumber'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = 'BOM编码',
                ['usage'] = {'CSR'},
                ['validator'] = controller_intf_types.BOMNumber
            },
            ['CryptoEraseSupported'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = true,
                ['description'] = '驱动器是否支持加密盘数据擦除',
                ['validator'] = controller_intf_types.CryptoEraseSupported
            }
        },
        ['bmc.kepler.Systems.Storage.Controller.Driver'] = {
            ['Name'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '控制器驱动器名称',
                ['alias'] = 'DriverName',
                ['validator'] = driver_intf_types.Name
            },
            ['Version'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '控制器驱动器版本',
                ['alias'] = 'DriverVersion',
                ['validator'] = driver_intf_types.Version
            }
        },
        ['bmc.kepler.Systems.Storage.Controller.Chip'] = {
            ['Model'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = 'raid卡芯片型号',
                ['usage'] = {'CSR'},
                ['validator'] = chip_intf_types.Model
            },
            ['ChipManufacturer'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = 'raid卡芯片厂商',
                ['usage'] = {'CSR'},
                ['validator'] = chip_intf_types.ChipManufacturer
            }
        },
        ['bmc.kepler.Systems.Storage.Controller.ConsistencyCheck'] = {
            ['State'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = 'RAID控制器一致性校验功能状态',
                ['alias'] = 'ConsistencyCheckState',
                ['validator'] = consistency_check_intf_types.State
            },
            ['PeriodOfHours'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['description'] = 'RAID控制器一致性校验周期，单位(小时), 取值范围[1:1440]',
                ['validator'] = consistency_check_intf_types.PeriodOfHours
            },
            ['Rate'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = 'RAID控制器一致性校验速率',
                ['validator'] = consistency_check_intf_types.Rate
            },
            ['AutoRepairEnabled'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = 'RAID控制器一致性校验自修复开关',
                ['validator'] = consistency_check_intf_types.AutoRepairEnabled
            },
            ['RunningStatus'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = 'RAID控制器一致性校验状态',
                ['validator'] = consistency_check_intf_types.RunningStatus
            },
            ['TotalVolumeCounts'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['description'] = 'RAID控制器一致性校验需要校验的总数量',
                ['validator'] = consistency_check_intf_types.TotalVolumeCounts
            },
            ['CompletedVolumeCounts'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['description'] = 'RAID控制器一致性校验运行已经完成的数量',
                ['validator'] = consistency_check_intf_types.CompletedVolumeCounts
            },
            ['DelayToStart'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['description'] = 'RAID控制器一致性校验任务的等待开始时间，取值范围[0:24]，时间单位：h',
                ['validator'] = consistency_check_intf_types.DelayToStart
            }
        },
        ['bmc.kepler.Systems.Storage.Controller.VolumeManage'] = {
            ['CreateVolumeSupported'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = true,
                ['description'] = '控制器是否支持创建逻辑盘',
                ['validator'] = volume_manage_intf_types.CreateVolumeSupported
            },
            ['SupportedReadPolicyList'] = {
                ['baseType'] = 'String[]',
                ['readOnly'] = true,
                ['description'] = '支持的逻辑盘读策略列表',
                ['validator'] = volume_manage_intf_types.SupportedReadPolicyList
            },
            ['DefaultReadPolicy'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '默认的逻辑盘读策略',
                ['validator'] = volume_manage_intf_types.DefaultReadPolicy
            },
            ['ReadPolicyWritable'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = true,
                ['description'] = '支持修改逻辑盘读策略',
                ['validator'] = volume_manage_intf_types.ReadPolicyWritable
            },
            ['SupportedWritePolicyList'] = {
                ['baseType'] = 'String[]',
                ['readOnly'] = true,
                ['description'] = '支持的逻辑盘写策略列表',
                ['validator'] = volume_manage_intf_types.SupportedWritePolicyList
            },
            ['DefaultWritePolicy'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '默认的逻辑盘写策略',
                ['validator'] = volume_manage_intf_types.DefaultWritePolicy
            },
            ['WritePolicyWritable'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = true,
                ['description'] = '支持修改逻辑盘写策略',
                ['validator'] = volume_manage_intf_types.WritePolicyWritable
            },
            ['SupportedIOPolicyList'] = {
                ['baseType'] = 'String[]',
                ['readOnly'] = true,
                ['description'] = '支持的逻辑盘IO策略列表',
                ['validator'] = volume_manage_intf_types.SupportedIOPolicyList
            },
            ['DefaultIOPolicy'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '默认的逻辑盘IO策略',
                ['validator'] = volume_manage_intf_types.DefaultIOPolicy
            },
            ['IOPolicyWritable'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = true,
                ['description'] = '支持修改逻辑盘IO策略',
                ['validator'] = volume_manage_intf_types.IOPolicyWritable
            },
            ['SupportedAccessPolicyList'] = {
                ['baseType'] = 'String[]',
                ['readOnly'] = true,
                ['description'] = '支持的逻辑盘访问策略列表',
                ['validator'] = volume_manage_intf_types.SupportedAccessPolicyList
            },
            ['DefaultAccessPolicy'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '默认的逻辑盘访问策略',
                ['validator'] = volume_manage_intf_types.DefaultAccessPolicy
            },
            ['AccessPolicyWritable'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = true,
                ['description'] = '支持修改逻辑盘访问策略',
                ['validator'] = volume_manage_intf_types.AccessPolicyWritable
            },
            ['SupportedDriveCachePolicyList'] = {
                ['baseType'] = 'String[]',
                ['readOnly'] = true,
                ['description'] = '支持的逻辑盘硬盘缓存策略列表',
                ['validator'] = volume_manage_intf_types.SupportedDriveCachePolicyList
            },
            ['DefaultDriveCachePolicy'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '默认的逻辑盘硬盘缓存策略',
                ['validator'] = volume_manage_intf_types.DefaultDriveCachePolicy
            },
            ['DriveCachePolicyWritable'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = true,
                ['description'] = '支持修改逻辑盘硬盘缓存策略',
                ['validator'] = volume_manage_intf_types.DriveCachePolicyWritable
            }
        },
        ['bmc.kepler.Systems.Storage.Controller.ControllerStatus'] = {
            ['FaultCode'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['description'] = '控制器的故障码',
                ['usage'] = {'CSR'},
                ['validator'] = controller_status_intf_types.FaultCode
            },
            ['CommunicationLoss'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = '控制器通信丢失标志',
                ['usage'] = {'CSR'},
                ['validator'] = controller_status_intf_types.CommunicationLoss
            },
            ['Health'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = '控制器健康状态',
                ['usage'] = {'CSR'},
                ['validator'] = controller_status_intf_types.Health
            },
            ['FaultCodeByBios'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = 'BIOS上报的硬件故障错误码。0：正常；非0：故障',
                ['usage'] = {'CSR', 'ResetPer'},
                ['validator'] = controller_status_intf_types.FaultCodeByBios
            }
        },
        ['bmc.kepler.Systems.Storage.Controller.BatteryStatus'] = {
            ['BatteryPresence'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = '控制器下挂载的电池在位信息',
                ['usage'] = {'CSR'},
                ['default'] = 255,
                ['validator'] = battery_status_intf_types.BatteryPresence
            },
            ['BatteryFault'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = '控制器下挂载的电池故障信息',
                ['usage'] = {'CSR'},
                ['validator'] = battery_status_intf_types.BatteryFault
            },
            ['BatteryHealth'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = '控制器下挂载的电池健康信息',
                ['usage'] = {'CSR'},
                ['validator'] = battery_status_intf_types.BatteryHealth
            }
        },
        ['bmc.kepler.LifeCycle.Retirement'] = {
            ['Media'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['enum'] = {'Flash', 'SSD', 'Eeprom', 'HDD'},
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '数据存储介质',
                ['validator'] = retirement_intf_types.Media
            },
            ['Source'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['enum'] = {'Huawei', 'User'},
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '存储介质来源',
                ['validator'] = retirement_intf_types.Source
            },
            ['Description'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['enum'] = {'Clear', 'Perge'},
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '数据清理描述',
                ['validator'] = retirement_intf_types.Description
            },
            ['Method'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['enum'] = {'OverWrite', 'BlockErase', 'CryptoErase'},
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '数据清除方法',
                ['validator'] = retirement_intf_types.Method
            },
            ['Result'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['enum'] = {'Successful', 'Failed'},
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '部件数据销毁结果',
                ['validator'] = retirement_intf_types.Result
            },
            ['Progress'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '部件数据销毁进度',
                ['validator'] = retirement_intf_types.Progress
            },
            ['State'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['enum'] = {'Idle', 'Running', 'Finish'},
                ['default'] = 'Idle',
                ['description'] = '部件数据销毁状态',
                ['alias'] = 'RetirementState',
                ['validator'] = retirement_intf_types.State
            }
        },
        ['bmc.kepler.Inventory.Hardware'] = {
            ['AssetType'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '硬件资产类型',
                ['validator'] = hardware_intf_types.AssetType
            },
            ['AssetName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '硬件资产名称',
                ['validator'] = hardware_intf_types.AssetName
            },
            ['SerialNumber'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '硬件资产序列号',
                ['alias'] = 'InventorySerialNumber',
                ['validator'] = hardware_intf_types.SerialNumber
            },
            ['FirmwareVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '硬件资产固件版本',
                ['alias'] = 'InventoryFirmwareVersion',
                ['validator'] = hardware_intf_types.FirmwareVersion
            },
            ['PCBVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '硬件资产PCB版本',
                ['validator'] = hardware_intf_types.PCBVersion
            },
            ['Manufacturer'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '硬件资产制造商',
                ['validator'] = hardware_intf_types.Manufacturer
            },
            ['AssetTag'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '硬件资产标签',
                ['validator'] = hardware_intf_types.AssetTag
            },
            ['PartNumber'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '硬件资产部件编号',
                ['validator'] = hardware_intf_types.PartNumber
            },
            ['ManufactureDate'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '硬件资产生产日期',
                ['validator'] = hardware_intf_types.ManufactureDate
            },
            ['Slot'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '硬件槽位号',
                ['validator'] = hardware_intf_types.Slot
            },
            ['UUID'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '硬件UUID号',
                ['validator'] = hardware_intf_types.UUID
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '对象类名',
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '对象名',
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['description'] = '对象标志符',
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.Systems.Storage.Controller'] = {
            ['SetBootDevices'] = {
                ['description'] = '设置控制器的启动盘设备',
                ['privilege'] = {'BasicSetting'},
                ['req'] = {
                    {['baseType'] = 'String', ['description'] = '设备1名称', ['param'] = 'PriorityDriveName'},
                    {['baseType'] = 'String', ['description'] = '设备2名称', ['param'] = 'SecondaryDriveName'}
                },
                ['rsp'] = {}
            },
            ['SetJBODState'] = {
                ['description'] = '设置控制器的JBOD功能状态',
                ['privilege'] = {'BasicSetting'},
                ['req'] = {{['baseType'] = 'U8', ['description'] = '状态 0:Disable  1:Enable', ['param'] = 'State'}},
                ['rsp'] = {}
            },
            ['SetSmarterCopyBackState'] = {
                ['description'] = '设置RAID控制器在检测到物理盘SMART错误之后是否自动进行Copyback',
                ['privilege'] = {'BasicSetting'},
                ['req'] = {{['baseType'] = 'U8', ['description'] = '状态 0:Disable  1:Enable', ['param'] = 'State'}},
                ['rsp'] = {}
            },
            ['RestoreDefaultSettings'] = {
                ['description'] = '恢复控制器的默认配置',
                ['privilege'] = {'BasicSetting'},
                ['req'] = {},
                ['rsp'] = {}
            },
            ['SetCopybackState'] = {
                ['description'] = '设置控制器的回拷功能',
                ['privilege'] = {'BasicSetting'},
                ['req'] = {{['baseType'] = 'U8', ['description'] = '状态 0:Disable  1:Enable', ['param'] = 'State'}},
                ['rsp'] = {}
            },
            ['SetWorkMode'] = {
                ['privilege'] = {'BasicSetting'},
                ['req'] = {
                    {
                        ['baseType'] = 'U8',
                        ['description'] = '工作模式: Mode的取值为0:RAID, 1:HBA, 2:RAID, 3:MIXED',
                        ['param'] = 'Mode'
                    }, {['baseType'] = 'U8', ['description'] = '配置文件的IP, 取值为0', ['param'] = 'ProfileId'}
                },
                ['rsp'] = {},
                ['description'] = '设置控制器的工作模式'
            },
            ['ImportForeignConfig'] = {
                ['privilege'] = {'BasicSetting'},
                ['req'] = {},
                ['rsp'] = {},
                ['description'] = '一键导入外部配置'
            },
            ['DumpLog'] = {
                ['privilege'] = {'BasicSetting'},
                ['req'] = {},
                ['rsp'] = {{['baseType'] = 'U32', ['description'] = '任务ID', ['param'] = 'TaskId'}},
                ['description'] = '收集RAID控制器信息'
            },
            ['ClearForeignConfig'] = {
                ['privilege'] = {'BasicSetting'},
                ['req'] = {},
                ['rsp'] = {},
                ['description'] = '一键清除外部配置'
            },
            ['SetNoBatteryWriteCache'] = {
                ['privilege'] = {'BasicSetting'},
                ['req'] = {
                    {
                        ['baseType'] = 'U8',
                        ['description'] = '0-Disable, 1-Enable',
                        ['param'] = 'NoBatteryWriteCacheEnabled'
                    }
                },
                ['rsp'] = {},
                ['description'] = '设置控制器无电池写缓存状态'
            },
            ['SetReadCachePercent'] = {
                ['privilege'] = {'BasicSetting'},
                ['req'] = {
                    {['baseType'] = 'U8', ['description'] = '取值范围：0~100', ['param'] = 'ReadCachePercent'}
                },
                ['rsp'] = {},
                ['description'] = '设置控制器读缓存百分比'
            },
            ['SetWriteCachePolicy'] = {
                ['privilege'] = {'BasicSetting'},
                ['req'] = {
                    {
                        ['baseType'] = 'String',
                        ['enum'] = {
                            'ConfiguredDriveWriteCachePolicy', 'UnconfiguredDriveWriteCachePolicy',
                            'HBADriveWriteCachePolicy'
                        },
                        ['description'] = 'RAID卡下的硬盘管理类型',
                        ['param'] = 'Type'
                    }, {['baseType'] = 'String', ['description'] = '写缓存策略', ['param'] = 'WriteCachePolicy'}
                },
                ['rsp'] = {},
                ['description'] = '设置控制器写缓存策略'
            }
        },
        ['bmc.kepler.Systems.Storage.Controller.ConsistencyCheck'] = {
            ['Enable'] = {
                ['description'] = '打开控制器的一致性校验功能',
                ['privilege'] = {'BasicSetting'},
                ['req'] = {
                    {
                        ['baseType'] = 'U16',
                        ['description'] = 'RAID控制器一致性校验周期，单位(小时), 取值范围[1:1440]',
                        ['param'] = 'Period'
                    },
                    {['baseType'] = 'U8', ['description'] = 'RAID控制器一致性校验速率', ['param'] = 'Rate'},
                    {
                        ['baseType'] = 'U8',
                        ['description'] = '自动修复启用使能',
                        ['param'] = 'AutoRepairedEnabled'
                    }, {
                        ['baseType'] = 'U32',
                        ['description'] = 'RAID控制器一致性校验任务的等待开始时间，取值范围[0:24]，时间单位：h',
                        ['param'] = 'DelayToStart'
                    }
                },
                ['rsp'] = {}
            },
            ['Disable'] = {
                ['description'] = '关闭控制器的一致性校验功能',
                ['privilege'] = {'BasicSetting'},
                ['req'] = {},
                ['rsp'] = {}
            },
            ['SetParameters'] = {
                ['description'] = '设置控制器的一致性校验信息',
                ['privilege'] = {'BasicSetting'},
                ['req'] = {
                    {
                        ['baseType'] = 'U16',
                        ['description'] = 'RAID控制器一致性校验周期，单位(小时), 取值范围[1:1440]',
                        ['param'] = 'Period'
                    },
                    {['baseType'] = 'U8', ['description'] = 'RAID控制器一致性校验速率', ['param'] = 'Rate'},
                    {
                        ['baseType'] = 'U8',
                        ['description'] = '自动修复启用使能',
                        ['param'] = 'AutoRepairedEnabled'
                    }
                },
                ['rsp'] = {}
            }
        },
        ['bmc.kepler.Systems.Storage.Controller.VolumeManage'] = {
            ['CreateVolumeInNewArray'] = {
                ['description'] = '用全新阵列创建逻辑盘',
                ['privilege'] = {'BasicSetting'},
                ['req'] = {
                    {['baseType'] = 'U8[]', ['description'] = '设备列表', ['param'] = 'DriveLists'},
                    {['baseType'] = 'U8', ['description'] = 'raid卡类型', ['param'] = 'RaidType'},
                    {['baseType'] = 'U8', ['description'] = '阵列的数量', ['param'] = 'SpanDepth'},
                    {['baseType'] = 'String', ['description'] = '创建逻辑盘的名称', ['param'] = 'Name'},
                    {['baseType'] = 'U32', ['description'] = '容量', ['param'] = 'Capacity'},
                    {['baseType'] = 'U8', ['description'] = '容量单位', ['param'] = 'CapacityUnit'},
                    {['baseType'] = 'U8', ['description'] = '条带大小', ['param'] = 'StripSize'},
                    {['baseType'] = 'U8', ['description'] = '逻辑盘读策略', ['param'] = 'ReadPolicy'},
                    {['baseType'] = 'U8', ['description'] = '逻辑盘写策略', ['param'] = 'WritePolicy'},
                    {['baseType'] = 'U8', ['description'] = '逻辑盘IO策略', ['param'] = 'IOPolicy'},
                    {['baseType'] = 'U8', ['description'] = '逻辑盘访问策略', ['param'] = 'AccessPolicy'},
                    {['baseType'] = 'U8', ['description'] = '硬盘Cache策略', ['param'] = 'DiskCachePolicy'},
                    {['baseType'] = 'U8', ['description'] = '初始化类型', ['param'] = 'InitType'},
                    {['baseType'] = 'U8', ['description'] = '加速方法', ['param'] = 'Accelerator'}
                },
                ['rsp'] = {{['baseType'] = 'U32', ['description'] = '任务ID', ['param'] = 'TaskId'}}
            },
            ['DeleteVolume'] = {
                ['description'] = '删除指定逻辑盘',
                ['privilege'] = {'BasicSetting'},
                ['req'] = {{['baseType'] = 'U16', ['description'] = '存储卷ID', ['param'] = 'VolumeId'}},
                ['rsp'] = {{['baseType'] = 'U32', ['description'] = '任务ID', ['param'] = 'TaskId'}}
            },
            ['CreateVolumeInExisingtArray'] = {
                ['description'] = '在已有阵列上创建逻辑盘',
                ['privilege'] = {'BasicSetting'},
                ['req'] = {
                    {['baseType'] = 'U16', ['description'] = '阵列ID', ['param'] = 'ArrayId'},
                    {['baseType'] = 'U8', ['description'] = '块索引', ['param'] = 'BlockIndex'},
                    {['baseType'] = 'U8', ['description'] = 'raid卡类型', ['param'] = 'RaidType'},
                    {['baseType'] = 'U8', ['description'] = '阵列的数量', ['param'] = 'SpanDepth'},
                    {['baseType'] = 'String', ['description'] = '创建逻辑盘的名称', ['param'] = 'Name'},
                    {['baseType'] = 'U32', ['description'] = '容量', ['param'] = 'Capacity'},
                    {['baseType'] = 'U8', ['description'] = '容量单位', ['param'] = 'CapacityUnit'},
                    {['baseType'] = 'U8', ['description'] = '条带大小', ['param'] = 'StripSize'},
                    {['baseType'] = 'U8', ['description'] = '逻辑盘读策略', ['param'] = 'ReadPolicy'},
                    {['baseType'] = 'U8', ['description'] = '逻辑盘写策略', ['param'] = 'WritePolicy'},
                    {['baseType'] = 'U8', ['description'] = '逻辑盘IO策略', ['param'] = 'IOPolicy'},
                    {['baseType'] = 'U8', ['description'] = '逻辑盘访问策略', ['param'] = 'AccessPolicy'},
                    {['baseType'] = 'U8', ['description'] = '硬盘Cache策略', ['param'] = 'DiskCachePolicy'},
                    {['baseType'] = 'U8', ['description'] = '初始化类型', ['param'] = 'InitType'},
                    {['baseType'] = 'U8', ['description'] = '加速方法', ['param'] = 'Accelerator'}
                },
                ['rsp'] = {{['baseType'] = 'U32', ['description'] = '任务ID', ['param'] = 'TaskId'}}
            },
            ['CreateCachecadeVolume'] = {
                ['description'] = '创建cachecade逻辑盘',
                ['req'] = {
                    {['baseType'] = 'U8[]', ['description'] = '设备列表', ['param'] = 'DriveLists'},
                    {['baseType'] = 'U8', ['description'] = 'raid卡类型', ['param'] = 'RaidType'},
                    {['baseType'] = 'String', ['description'] = '创建逻辑盘的名称', ['param'] = 'Name'},
                    {['baseType'] = 'U8', ['description'] = '逻辑盘写策略', ['param'] = 'WritePolicy'},
                    {['baseType'] = 'U16', ['description'] = '阵列ID', ['param'] = 'ArrayId'},
                    {['baseType'] = 'U32', ['description'] = '容量', ['param'] = 'Capacity'},
                    {['baseType'] = 'U8', ['description'] = '容量单位', ['param'] = 'CapacityUnit'},
                    {['baseType'] = 'U16', ['description'] = '关联逻辑盘', ['param'] = 'AssociateLd'},
                    {['baseType'] = 'U8', ['description'] = '缓存行大小', ['param'] = 'CacheLineSize'}
                },
                ['rsp'] = {{['baseType'] = 'U32', ['description'] = '任务ID', ['param'] = 'TaskId'}}
            }
        },
        ['bmc.kepler.LifeCycle.Retirement'] = {
            ['DataWipe'] = {
                ['privilege'] = {'UserMgmt'},
                ['req'] = {},
                ['rsp'] = {},
                ['description'] = '执行部件数据销毁'
            },
            ['GetReport'] = {
                ['privilege'] = {'ReadOnly'},
                ['req'] = {},
                ['rsp'] = {{['baseType'] = 'Dictionary', ['$ref'] = '#/defs/DataWipeReportDict', ['param'] = 'Report'}},
                ['description'] = '获取部件数据销毁报告'
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['GetOptions'] = {
                ['req'] = {
                    {['baseType'] = 'String', ['description'] = '接口名', ['param'] = 'Interface'},
                    {['baseType'] = 'String', ['description'] = '属性名', ['param'] = 'Property'}
                },
                ['rsp'] = {
                    {
                        ['baseType'] = 'Struct',
                        ['$ref'] = '#/defs/Options',
                        ['description'] = '属性能力选项，例如是否弃用、是否是易变属性等',
                        ['param'] = 'Options'
                    }
                },
                ['description'] = '按接口名和属性名查询属性的能力选项'
            },
            ['GetPropertiesByOptions'] = {
                ['req'] = {
                    {['baseType'] = 'String', ['description'] = '接口名', ['param'] = 'Interface'}, {
                        ['baseType'] = 'Struct',
                        ['$ref'] = '#/defs/Options',
                        ['description'] = '属性能力选项，例如是否弃用、是否是易变属性等',
                        ['param'] = 'Options'
                    }
                },
                ['rsp'] = {{['baseType'] = 'String[]', ['description'] = '属性名列表', ['param'] = 'Properties'}},
                ['description'] = '按接口名和能力选项查询符合条件的所有属性'
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Systems/:SystemId/Storage/Controllers/:Id'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Systems.Storage.Controller'] = {
            ['property_defaults'] = {
                ['Id'] = 255,
                ['Type'] = controller_intf_types.Type.default[1],
                ['TypeId'] = controller_intf_types.TypeId.default[1],
                ['DeviceName'] = controller_intf_types.DeviceName.default[1],
                ['Position'] = controller_intf_types.Position.default[1],
                ['TemperatureCelsius'] = controller_intf_types.TemperatureCelsius.default[1],
                ['TemperatureAbnormal'] = controller_intf_types.TemperatureAbnormal.default[1],
                ['Name'] = controller_intf_types.Name.default[1],
                ['OOBSupport'] = controller_intf_types.OOBSupport.default[1],
                ['FirmwareVersion'] = controller_intf_types.FirmwareVersion.default[1],
                ['SupportedMode'] = controller_intf_types.SupportedMode.default[1],
                ['MemorySizeMiB'] = controller_intf_types.MemorySizeMiB.default[1],
                ['DeviceInterface'] = controller_intf_types.DeviceInterface.default[1],
                ['SASAddr'] = controller_intf_types.SASAddr.default[1],
                ['SerialNumber'] = controller_intf_types.SerialNumber.default[1],
                ['MaxStripSizeBytes'] = controller_intf_types.MaxStripSizeBytes.default[1],
                ['MinStripSizeBytes'] = controller_intf_types.MinStripSizeBytes.default[1],
                ['NVDataVersion'] = controller_intf_types.NVDataVersion.default[1],
                ['MaintainPDFailHistrory'] = controller_intf_types.MaintainPDFailHistrory.default[1],
                ['PCIeLinkWidth'] = controller_intf_types.PCIeLinkWidth.default[1],
                ['UnconfiguredDriveWriteCachePolicy'] = 
                    controller_intf_types.UnconfiguredDriveWriteCachePolicy.default[1],
                ['HBADriveWriteCachePolicy'] = controller_intf_types.HBADriveWriteCachePolicy.default[1],
                ['ConfiguredDriveWriteCachePolicy'] = controller_intf_types.ConfiguredDriveWriteCachePolicy.default[1],
                ['SupportedRAIDTypes'] = controller_intf_types.SupportedRAIDTypes.default[1],
                ['SmarterCopyBackState'] = controller_intf_types.SmarterCopyBackState.default[1],
                ['CopyBackState'] = controller_intf_types.CopyBackState.default[1],
                ['BootDevices'] = controller_intf_types.BootDevices.default[1],
                ['HardwareRevision'] = controller_intf_types.HardwareRevision.default[1],
                ['HotSpareActivationMode'] = controller_intf_types.HotSpareActivationMode.default[1],
                ['NoBatteryWriteCacheEnabled'] = controller_intf_types.NoBatteryWriteCacheEnabled.default[1],
                ['ReadCachePercent'] = controller_intf_types.ReadCachePercent.default[1],
                ['JBODState'] = controller_intf_types.JBODState.default[1],
                ['CachePinnedState'] = controller_intf_types.CachePinnedState.default[1],
                ['DDREccCount'] = controller_intf_types.DDREccCount.default[1],
                ['WorkMode'] = controller_intf_types.WorkMode.default[1],
                ['RefDrives'] = controller_intf_types.RefDrives.default[1],
                ['BOMNumber'] = controller_intf_types.BOMNumber.default[1],
                ['CryptoEraseSupported'] = controller_intf_types.CryptoEraseSupported.default[1]
            },
            ['privileges'] = {
                ['path'] = privilege.ReadOnly,
                ['methods'] = {
                    ['SetBootDevices'] = privilege.BasicSetting,
                    ['SetJBODState'] = privilege.BasicSetting,
                    ['SetSmarterCopyBackState'] = privilege.BasicSetting,
                    ['RestoreDefaultSettings'] = privilege.BasicSetting,
                    ['SetCopybackState'] = privilege.BasicSetting,
                    ['SetWorkMode'] = privilege.BasicSetting,
                    ['ImportForeignConfig'] = privilege.BasicSetting,
                    ['DumpLog'] = privilege.BasicSetting,
                    ['ClearForeignConfig'] = privilege.BasicSetting,
                    ['SetNoBatteryWriteCache'] = privilege.BasicSetting,
                    ['SetReadCachePercent'] = privilege.BasicSetting,
                    ['SetWriteCachePolicy'] = privilege.BasicSetting
                }
            },
            ['interface_types'] = controller_intf_types
        },
        ['bmc.kepler.Systems.Storage.Controller.Driver'] = {
            ['property_defaults'] = {
                ['Name'] = driver_intf_types.Name.default[1],
                ['Version'] = driver_intf_types.Version.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = driver_intf_types
        },
        ['bmc.kepler.Systems.Storage.Controller.Chip'] = {
            ['property_defaults'] = {
                ['Model'] = chip_intf_types.Model.default[1],
                ['ChipManufacturer'] = chip_intf_types.ChipManufacturer.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = chip_intf_types
        },
        ['bmc.kepler.Systems.Storage.Controller.ConsistencyCheck'] = {
            ['property_defaults'] = {
                ['State'] = consistency_check_intf_types.State.default[1],
                ['PeriodOfHours'] = consistency_check_intf_types.PeriodOfHours.default[1],
                ['Rate'] = consistency_check_intf_types.Rate.default[1],
                ['AutoRepairEnabled'] = consistency_check_intf_types.AutoRepairEnabled.default[1],
                ['RunningStatus'] = consistency_check_intf_types.RunningStatus.default[1],
                ['TotalVolumeCounts'] = consistency_check_intf_types.TotalVolumeCounts.default[1],
                ['CompletedVolumeCounts'] = consistency_check_intf_types.CompletedVolumeCounts.default[1],
                ['DelayToStart'] = consistency_check_intf_types.DelayToStart.default[1]
            },
            ['privileges'] = {
                ['path'] = privilege.ReadOnly,
                ['methods'] = {
                    ['Enable'] = privilege.BasicSetting,
                    ['Disable'] = privilege.BasicSetting,
                    ['SetParameters'] = privilege.BasicSetting
                }
            },
            ['interface_types'] = consistency_check_intf_types
        },
        ['bmc.kepler.Systems.Storage.Controller.VolumeManage'] = {
            ['property_defaults'] = {
                ['CreateVolumeSupported'] = volume_manage_intf_types.CreateVolumeSupported.default[1],
                ['SupportedReadPolicyList'] = volume_manage_intf_types.SupportedReadPolicyList.default[1],
                ['DefaultReadPolicy'] = volume_manage_intf_types.DefaultReadPolicy.default[1],
                ['ReadPolicyWritable'] = volume_manage_intf_types.ReadPolicyWritable.default[1],
                ['SupportedWritePolicyList'] = volume_manage_intf_types.SupportedWritePolicyList.default[1],
                ['DefaultWritePolicy'] = volume_manage_intf_types.DefaultWritePolicy.default[1],
                ['WritePolicyWritable'] = volume_manage_intf_types.WritePolicyWritable.default[1],
                ['SupportedIOPolicyList'] = volume_manage_intf_types.SupportedIOPolicyList.default[1],
                ['DefaultIOPolicy'] = volume_manage_intf_types.DefaultIOPolicy.default[1],
                ['IOPolicyWritable'] = volume_manage_intf_types.IOPolicyWritable.default[1],
                ['SupportedAccessPolicyList'] = volume_manage_intf_types.SupportedAccessPolicyList.default[1],
                ['DefaultAccessPolicy'] = volume_manage_intf_types.DefaultAccessPolicy.default[1],
                ['AccessPolicyWritable'] = volume_manage_intf_types.AccessPolicyWritable.default[1],
                ['SupportedDriveCachePolicyList'] = volume_manage_intf_types.SupportedDriveCachePolicyList.default[1],
                ['DefaultDriveCachePolicy'] = volume_manage_intf_types.DefaultDriveCachePolicy.default[1],
                ['DriveCachePolicyWritable'] = volume_manage_intf_types.DriveCachePolicyWritable.default[1]
            },
            ['privileges'] = {
                ['path'] = privilege.ReadOnly,
                ['methods'] = {
                    ['CreateVolumeInNewArray'] = privilege.BasicSetting,
                    ['DeleteVolume'] = privilege.BasicSetting,
                    ['CreateVolumeInExisingtArray'] = privilege.BasicSetting
                }
            },
            ['interface_types'] = volume_manage_intf_types
        },
        ['bmc.kepler.Systems.Storage.Controller.ControllerStatus'] = {
            ['property_defaults'] = {
                ['FaultCode'] = controller_status_intf_types.FaultCode.default[1],
                ['CommunicationLoss'] = controller_status_intf_types.CommunicationLoss.default[1],
                ['Health'] = controller_status_intf_types.Health.default[1],
                ['FaultCodeByBios'] = controller_status_intf_types.FaultCodeByBios.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = controller_status_intf_types
        },
        ['bmc.kepler.Systems.Storage.Controller.BatteryStatus'] = {
            ['property_defaults'] = {
                ['BatteryPresence'] = 255,
                ['BatteryFault'] = battery_status_intf_types.BatteryFault.default[1],
                ['BatteryHealth'] = battery_status_intf_types.BatteryHealth.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = battery_status_intf_types
        },
        ['bmc.kepler.LifeCycle.Retirement'] = {
            ['property_defaults'] = {
                ['Media'] = retirement_intf_types.Media.default[1],
                ['Source'] = retirement_intf_types.Source.default[1],
                ['Description'] = retirement_intf_types.Description.default[1],
                ['Method'] = retirement_intf_types.Method.default[1],
                ['Result'] = retirement_intf_types.Result.default[1],
                ['Progress'] = retirement_intf_types.Progress.default[1],
                ['State'] = 'Idle'
            },
            ['privileges'] = {
                ['path'] = privilege.ReadOnly,
                ['methods'] = {['DataWipe'] = privilege.UserMgmt, ['GetReport'] = privilege.ReadOnly}
            },
            ['interface_types'] = retirement_intf_types
        },
        ['bmc.kepler.Inventory.Hardware'] = {
            ['property_defaults'] = {
                ['AssetType'] = hardware_intf_types.AssetType.default[1],
                ['AssetName'] = hardware_intf_types.AssetName.default[1],
                ['SerialNumber'] = hardware_intf_types.SerialNumber.default[1],
                ['FirmwareVersion'] = hardware_intf_types.FirmwareVersion.default[1],
                ['PCBVersion'] = hardware_intf_types.PCBVersion.default[1],
                ['Manufacturer'] = hardware_intf_types.Manufacturer.default[1],
                ['AssetTag'] = hardware_intf_types.AssetTag.default[1],
                ['PartNumber'] = hardware_intf_types.PartNumber.default[1],
                ['ManufactureDate'] = hardware_intf_types.ManufactureDate.default[1],
                ['Slot'] = hardware_intf_types.Slot.default[1],
                ['UUID'] = hardware_intf_types.UUID.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = hardware_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local SASPhy = {
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Systems.Storage.PhyError'] = {
            ['PhyId'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = 'PHY误码Id',
                ['usage'] = {'CSR'},
                ['validator'] = phy_error_intf_types.PhyId
            },
            ['InvalidDwordCount'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '无效DWORD数',
                ['usage'] = {'CSR'},
                ['validator'] = phy_error_intf_types.InvalidDwordCount
            },
            ['LossDwordSyncCount'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '丢失DWORD同步数',
                ['usage'] = {'CSR'},
                ['validator'] = phy_error_intf_types.LossDwordSyncCount
            },
            ['PhyResetProblemCount'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = 'PHY重启问题数',
                ['usage'] = {'CSR'},
                ['validator'] = phy_error_intf_types.PhyResetProblemCount
            },
            ['RunningDisparityErrorCount'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '连续不均衡性错误数',
                ['usage'] = {'CSR'},
                ['validator'] = phy_error_intf_types.RunningDisparityErrorCount
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '对象类名',
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '对象名',
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['description'] = '对象标志符',
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.Object.Properties'] = {
            ['GetOptions'] = {
                ['req'] = {
                    {['baseType'] = 'String', ['description'] = '接口名', ['param'] = 'Interface'},
                    {['baseType'] = 'String', ['description'] = '属性名', ['param'] = 'Property'}
                },
                ['rsp'] = {
                    {
                        ['baseType'] = 'Struct',
                        ['$ref'] = '#/defs/Options',
                        ['description'] = '属性能力选项，例如是否弃用、是否是易变属性等',
                        ['param'] = 'Options'
                    }
                },
                ['description'] = '按接口名和属性名查询属性的能力选项'
            },
            ['GetPropertiesByOptions'] = {
                ['req'] = {
                    {['baseType'] = 'String', ['description'] = '接口名', ['param'] = 'Interface'}, {
                        ['baseType'] = 'Struct',
                        ['$ref'] = '#/defs/Options',
                        ['description'] = '属性能力选项，例如是否弃用、是否是易变属性等',
                        ['param'] = 'Options'
                    }
                },
                ['rsp'] = {{['baseType'] = 'String[]', ['description'] = '属性名列表', ['param'] = 'Properties'}},
                ['description'] = '按接口名和能力选项查询符合条件的所有属性'
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Systems/:SystemId/Storage/Controllers/:Id1/SASPhy/:Id2'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Systems.Storage.PhyError'] = {
            ['property_defaults'] = {
                ['PhyId'] = phy_error_intf_types.PhyId.default[1],
                ['InvalidDwordCount'] = phy_error_intf_types.InvalidDwordCount.default[1],
                ['LossDwordSyncCount'] = phy_error_intf_types.LossDwordSyncCount.default[1],
                ['PhyResetProblemCount'] = phy_error_intf_types.PhyResetProblemCount.default[1],
                ['RunningDisparityErrorCount'] = phy_error_intf_types.RunningDisparityErrorCount.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = phy_error_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local DiskArray = {
    ['prop_configs'] = {
        ['RefPDSlots'] = {
            ['baseType'] = 'U8[]',
            ['readOnly'] = true, 
            ['validator'] = disk_array_class_types.RefPDSlots
        },
        ['RefPDEnclosures'] = {
            ['baseType'] = 'U16[]',
            ['readOnly'] = true,
            ['validator'] = disk_array_class_types.RefPDEnclosures
        }
    },
    ['default_props'] = {
        ['RefPDSlots'] = disk_array_class_types.RefPDSlots.default[1],
        ['RefPDEnclosures'] = disk_array_class_types.RefPDEnclosures.default[1]
    },
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Systems.Storage.DiskArray'] = {
            ['Id'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['description'] = 'RAID组的序号，由RAID卡读到',
                ['validator'] = disk_array_intf_types.Id
            },
            ['UsedSpaceMiB'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['description'] = 'RAID组的已使用的空间',
                ['validator'] = disk_array_intf_types.UsedSpaceMiB
            },
            ['TotalFreeSpaceMiB'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['description'] = 'RAID组的空闲空间',
                ['validator'] = disk_array_intf_types.TotalFreeSpaceMiB
            },
            ['FreeBlocksSpaceMiB'] = {
                ['baseType'] = 'U32[]',
                ['readOnly'] = true,
                ['description'] = 'RAID组的空闲块容量列表',
                ['validator'] = disk_array_intf_types.FreeBlocksSpaceMiB
            },
            ['RefVolumes'] = {
                ['baseType'] = 'U16[]',
                ['readOnly'] = true,
                ['description'] = 'RAID组的关联逻辑盘列表，例：[145, 144]',
                ['validator'] = disk_array_intf_types.RefVolumes
            },
            ['RefDrives'] = {
                ['baseType'] = 'String[]',
                ['readOnly'] = true,
                ['description'] = 'RAID组的关联物理盘列表，例：[Disk0, Disk1]',
                ['validator'] = disk_array_intf_types.RefDrives
            },
            ['DriveNumPerSpan'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = '驱动器阵列中每个Span的成员的个数',
                ['validator'] = disk_array_intf_types.DriveNumPerSpan
            },
            ['RAIDType'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '驱动器阵列组成的虚拟磁盘的级别',
                ['validator'] = disk_array_intf_types.RAIDType
            },
            ['AverageDriveFreeSpaceMiB'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['description'] = '指定驱动器阵列中每个驱动器的剩余容量',
                ['validator'] = disk_array_intf_types.AverageDriveFreeSpaceMiB
            },
            ['RefControllerId'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = 'RAID组关联的控制器ID',
                ['validator'] = disk_array_intf_types.RefControllerId
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '对象类名',
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '对象名',
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['description'] = '对象标志符',
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.Object.Properties'] = {
            ['GetOptions'] = {
                ['req'] = {
                    {['baseType'] = 'String', ['description'] = '接口名', ['param'] = 'Interface'},
                    {['baseType'] = 'String', ['description'] = '属性名', ['param'] = 'Property'}
                },
                ['rsp'] = {
                    {
                        ['baseType'] = 'Struct',
                        ['$ref'] = '#/defs/Options',
                        ['description'] = '属性能力选项，例如是否弃用、是否是易变属性等',
                        ['param'] = 'Options'
                    }
                },
                ['description'] = '按接口名和属性名查询属性的能力选项'
            },
            ['GetPropertiesByOptions'] = {
                ['req'] = {
                    {['baseType'] = 'String', ['description'] = '接口名', ['param'] = 'Interface'}, {
                        ['baseType'] = 'Struct',
                        ['$ref'] = '#/defs/Options',
                        ['description'] = '属性能力选项，例如是否弃用、是否是易变属性等',
                        ['param'] = 'Options'
                    }
                },
                ['rsp'] = {{['baseType'] = 'String[]', ['description'] = '属性名列表', ['param'] = 'Properties'}},
                ['description'] = '按接口名和能力选项查询符合条件的所有属性'
            }
        }
    },
    ['mdb_classes'] = 
        mdb.get_class_obj('/bmc/kepler/Systems/:SystemId/Storage/Controllers/:ControllerId/DiskArrays/:Id'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Systems.Storage.DiskArray'] = {
            ['property_defaults'] = {
                ['Id'] = disk_array_intf_types.Id.default[1],
                ['UsedSpaceMiB'] = disk_array_intf_types.UsedSpaceMiB.default[1],
                ['TotalFreeSpaceMiB'] = disk_array_intf_types.TotalFreeSpaceMiB.default[1],
                ['FreeBlocksSpaceMiB'] = disk_array_intf_types.FreeBlocksSpaceMiB.default[1],
                ['RefVolumes'] = disk_array_intf_types.RefVolumes.default[1],
                ['RefDrives'] = disk_array_intf_types.RefDrives.default[1],
                ['DriveNumPerSpan'] = disk_array_intf_types.DriveNumPerSpan.default[1],
                ['RAIDType'] = disk_array_intf_types.RAIDType.default[1],
                ['AverageDriveFreeSpaceMiB'] = disk_array_intf_types.AverageDriveFreeSpaceMiB.default[1],
                ['RefControllerId'] = disk_array_intf_types.RefControllerId.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = disk_array_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local Drive = {
    ['table_name'] = 't_storage_drive',
    ['alias_map'] = {
        ['InventorySerialNumber'] = {
            ['original_name'] = 'SerialNumber',
            ['interface'] = 'bmc.kepler.Inventory.Hardware'
        },
        ['InventoryFirmwareVersion'] = {
            ['original_name'] = 'FirmwareVersion',
            ['interface'] = 'bmc.kepler.Inventory.Hardware'
        },
        ['InventoryManufacturer'] = {
            ['original_name'] = 'Manufacturer',
            ['interface'] = 'bmc.kepler.Inventory.Hardware'
        }
    },
    ['prop_configs'] = {
        ['LocateReg'] = {['usage'] = {'CSR'}, ['baseType'] = 'U8', ['validator'] = drive_class_types.LocateReg},
        ['FaultReg'] = {['usage'] = {'CSR'}, ['baseType'] = 'U8', ['validator'] = drive_class_types.FaultReg},
        ['ActivationLed'] = {['usage'] = {'CSR'}, ['baseType'] = 'U8', ['validator'] = drive_class_types.ActivationLed},
        ['PhysicalLocation'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'String',
            ['validator'] = drive_class_types.PhysicalLocation
        },
        ['PassThrough'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['default'] = 255,
            ['validator'] = drive_class_types.PassThrough
        },
        ['HddBackplaneStartSlot'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['default'] = 255,
            ['validator'] = drive_class_types.HddBackplaneStartSlot
        },
        ['RelativeSlot'] = {['usage'] = {'CSR'}, ['baseType'] = 'U8', ['validator'] = drive_class_types.RelativeSlot},
        ['LinkFault'] = {
            ['usage'] = {'ResetPer'},
            ['baseType'] = 'Boolean',
            ['default'] = false,
            ['validator'] = drive_class_types.LinkFault
        },
        ['SetLocateLed'] = {['usage'] = {'CSR'}, ['baseType'] = 'U8', ['validator'] = drive_class_types.SetLocateLed},
        ['SetFaultLed'] = {['usage'] = {'CSR'}, ['baseType'] = 'U8', ['validator'] = drive_class_types.SetFaultLed}
    },
    ['default_props'] = {
        ['LocateReg'] = drive_class_types.LocateReg.default[1],
        ['FaultReg'] = drive_class_types.FaultReg.default[1],
        ['ActivationLed'] = drive_class_types.ActivationLed.default[1],
        ['PhysicalLocation'] = drive_class_types.PhysicalLocation.default[1],
        ['PassThrough'] = 255,
        ['HddBackplaneStartSlot'] = 255,
        ['RelativeSlot'] = drive_class_types.RelativeSlot.default[1],
        ['LinkFault'] = false,
        ['SetLocateLed'] = drive_class_types.SetLocateLed.default[1],
        ['SetFaultLed'] = drive_class_types.SetFaultLed.default[1]
    },
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Systems.Storage.Drive'] = {
            ['NodeId'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '资源的唯一Id',
                ['usage'] = {'CSR'},
                ['validator'] = drive_intf_types.NodeId
            },
            ['Id'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = '硬盘Id, 由软件生成，默认值0',
                ['usage'] = {'CSR'},
                ['primaryKey'] = true,
                ['validator'] = drive_intf_types.Id
            },
            ['SlotNumber'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = '硬盘槽位号',
                ['usage'] = {'ResetPer'},
                ['default'] = 255,
                ['validator'] = drive_intf_types.SlotNumber
            },
            ['Name'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '硬盘名称，Disk1，NMVeDisk1等',
                ['usage'] = {'CSR'},
                ['validator'] = drive_intf_types.Name
            },
            ['Presence'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = '硬盘在位状态,0不在位,1在位',
                ['usage'] = {'CSR'},
                ['default'] = 255,
                ['validator'] = drive_intf_types.Presence
            },
            ['LocateLed'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = '硬盘locate寄存器的值',
                ['usage'] = {'CSR'},
                ['validator'] = drive_intf_types.LocateLed
            },
            ['FaultLed'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = '硬盘fault寄存器的值',
                ['usage'] = {'CSR'},
                ['validator'] = drive_intf_types.FaultLed
            },
            ['EnclosureId'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['description'] = '硬盘所在背板的id，由控制器分配',
                ['usage'] = {'ResetPer'},
                ['default'] = 65535,
                ['validator'] = drive_intf_types.EnclosureId
            },
            ['LocationIndicatorState'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = '硬盘定位状态，根据locate寄存器和fault寄存器判断',
                ['validator'] = drive_intf_types.LocationIndicatorState
            },
            ['CapacityMiB'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['description'] = '硬盘容量，以MiB为单位',
                ['usage'] = {'ResetPer'},
                ['default'] = 4294967295,
                ['validator'] = drive_intf_types.CapacityMiB
            },
            ['TemperatureCelsius'] = {
                ['baseType'] = 'S16',
                ['readOnly'] = true,
                ['options'] = {['volatile'] = true, ['emitsChangedSignal'] = 'false'},
                ['description'] = '硬盘温度，硬盘存在零下负温场景',
                ['usage'] = {'CSR'},
                ['default'] = 255,
                ['validator'] = drive_intf_types.TemperatureCelsius
            },
            ['Model'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '硬盘型号，比如MBF2300RC',
                ['usage'] = {'ResetPer'},
                ['default'] = 'N/A',
                ['validator'] = drive_intf_types.Model
            },
            ['Protocol'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = '硬盘接口类型：0:Unknown,1:parallel.SCSI,2:SAS,3:SATA,4:FC',
                ['usage'] = {'ResetPer'},
                ['default'] = 255,
                ['validator'] = drive_intf_types.Protocol
            },
            ['CapableSpeedGbs'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = '硬盘接口速率（最大速率）',
                ['usage'] = {'ResetPer'},
                ['default'] = 255,
                ['validator'] = drive_intf_types.CapableSpeedGbs
            },
            ['NegotiatedSpeedGbs'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = '硬盘连接速率（协商速率）',
                ['usage'] = {'ResetPer'},
                ['default'] = 255,
                ['validator'] = drive_intf_types.NegotiatedSpeedGbs
            },
            ['MediaType'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = '硬盘介质类型：0:HDD,1:SSD,2:SSM,255:Unknown',
                ['usage'] = {'ResetPer'},
                ['default'] = 255,
                ['validator'] = drive_intf_types.MediaType
            },
            ['FirmwareStatus'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = '硬盘固件状态',
                ['usage'] = {'CSR'},
                ['default'] = 255,
                ['validator'] = drive_intf_types.FirmwareStatus
            },
            ['SerialNumber'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '硬盘序列号',
                ['usage'] = {'CSR', 'ResetPer'},
                ['default'] = 'N/A',
                ['validator'] = drive_intf_types.SerialNumber
            },
            ['Manufacturer'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '硬盘厂商',
                ['usage'] = {'ResetPer'},
                ['default'] = 'N/A',
                ['validator'] = drive_intf_types.Manufacturer
            },
            ['PowerOnHours'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['options'] = {['volatile'] = true, ['emitsChangedSignal'] = 'false'},
                ['description'] = '硬盘通电时间',
                ['validator'] = drive_intf_types.PowerOnHours
            },
            ['Revision'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '硬盘固件版本',
                ['usage'] = {'ResetPer'},
                ['default'] = 'N/A',
                ['validator'] = drive_intf_types.Revision
            },
            ['RotationSpeedRPM'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['description'] = '硬盘转速',
                ['validator'] = drive_intf_types.RotationSpeedRPM
            },
            ['BlockSizeBytes'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['description'] = '硬盘块大小',
                ['validator'] = drive_intf_types.BlockSizeBytes
            },
            ['SASAddress1'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '硬盘SAS地址的第一部分',
                ['validator'] = drive_intf_types.SASAddress1
            },
            ['SASAddress2'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '硬盘SAS地址的第二部分',
                ['validator'] = drive_intf_types.SASAddress2
            },
            ['Location'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '表示当前盘的物理位置',
                ['validator'] = drive_intf_types.Location
            },
            ['DeviceName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '表示当前盘的设备名称',
                ['usage'] = {'CSR'},
                ['default'] = 'N/A',
                ['validator'] = drive_intf_types.DeviceName
            },
            ['PredictedMediaLifeLeftPercent'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = '硬盘剩余磨损率，即剩余擦写次数的百分比（0-100，或者255表示无效）',
                ['usage'] = {'CSR'},
                ['default'] = 255,
                ['validator'] = drive_intf_types.PredictedMediaLifeLeftPercent
            },
            ['PredictedFailCount'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['description'] = '硬盘预故障错误统计',
                ['validator'] = drive_intf_types.PredictedFailCount
            },
            ['MediaErrorCount'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['description'] = '硬盘媒介错误统计',
                ['validator'] = drive_intf_types.MediaErrorCount
            },
            ['OtherErrorCount'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['description'] = '硬盘其他错误统计',
                ['validator'] = drive_intf_types.OtherErrorCount
            },
            ['PatrolState'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = '硬盘巡检状态：0:没有巡检或巡检结束，1:巡检中，255:未知',
                ['validator'] = drive_intf_types.PatrolState
            },
            ['PowerState'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = '硬件电源状态',
                ['validator'] = drive_intf_types.PowerState
            },
            ['RebuildState'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = '硬盘重构状态：0:没有重建或重建结束，1:重建中，255:未知',
                ['usage'] = {'CSR'},
                ['validator'] = drive_intf_types.RebuildState
            },
            ['RebuildProgress'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['volatile'] = true, ['emitsChangedSignal'] = 'true'},
                ['description'] = '硬盘重构进度',
                ['validator'] = drive_intf_types.RebuildProgress
            },
            ['BootPriority'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = '硬盘启动盘优先级',
                ['validator'] = drive_intf_types.BootPriority
            },
            ['HotspareType'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = '硬盘热备状态',
                ['validator'] = drive_intf_types.HotspareType
            },
            ['RefControllerId'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = '关联的控制器Id',
                ['usage'] = {'ResetPer'},
                ['default'] = 255,
                ['validator'] = drive_intf_types.RefControllerId
            },
            ['RefVolumeList'] = {
                ['baseType'] = 'U16[]',
                ['readOnly'] = true,
                ['description'] = '关联的逻辑盘Id列表',
                ['validator'] = drive_intf_types.RefVolumeList
            },
            ['RefDiskArrayId'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['description'] = '关联的硬盘阵列Id',
                ['validator'] = drive_intf_types.RefDiskArrayId
            },
            ['ManufacturerId'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['description'] = '厂商Id',
                ['validator'] = drive_intf_types.ManufacturerId
            },
            ['PCIeLinkSpeed'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['description'] = 'PCIe单个通道的速率',
                ['validator'] = drive_intf_types.PCIeLinkSpeed
            },
            ['ResourceId'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = '表示当前盘的资源归属',
                ['validator'] = drive_intf_types.ResourceId
            }
        },
        ['bmc.kepler.Systems.Storage.Drive.AddrInfo'] = {
            ['Type'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '硬盘的丝印类型',
                ['usage'] = {'CSR'},
                ['default'] = 'N/A',
                ['validator'] = addr_info_intf_types.Type
            },
            ['SocketId'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '硬盘的CPU归属',
                ['usage'] = {'CSR'},
                ['validator'] = addr_info_intf_types.SocketId
            },
            ['SlotId'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '硬盘的槽位号',
                ['usage'] = {'CSR'},
                ['validator'] = addr_info_intf_types.SlotId
            },
            ['PortId'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '硬盘的端口号',
                ['usage'] = {'CSR'},
                ['validator'] = addr_info_intf_types.PortId
            },
            ['RootBDF'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '硬盘的BDF',
                ['usage'] = {'CSR'},
                ['default'] = 'N/A',
                ['validator'] = addr_info_intf_types.RootBDF
            }
        },
        ['bmc.kepler.Systems.Storage.Drive.DriveStatus'] = {
            ['Missing'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['description'] = '硬盘丢失标志',
                ['usage'] = {'CSR'},
                ['validator'] = drive_status_intf_types.Missing
            },
            ['PredictiveFailure'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = '预故障标志',
                ['usage'] = {'CSR'},
                ['validator'] = drive_status_intf_types.PredictiveFailure
            },
            ['InAFailedArray'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = '是否处于一个故障的硬盘阵列。0：否，1：是',
                ['usage'] = {'CSR'},
                ['validator'] = drive_status_intf_types.InAFailedArray
            },
            ['CapacityError'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = true,
                ['description'] = '硬盘容量是否异常',
                ['usage'] = {'CSR'},
                ['validator'] = drive_status_intf_types.CapacityError
            },
            ['FirmwareStatusError'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = true,
                ['description'] = '硬盘固件状态是否异常',
                ['usage'] = {'CSR'},
                ['validator'] = drive_status_intf_types.FirmwareStatusError
            },
            ['Failure'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = true,
                ['description'] = '硬盘是否故障',
                ['usage'] = {'CSR'},
                ['validator'] = drive_status_intf_types.Failure
            },
            ['Health'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = '硬盘健康状态',
                ['usage'] = {'CSR'},
                ['validator'] = drive_status_intf_types.Health
            }
        },
        ['bmc.kepler.Systems.Storage.Drive.SAS.SMART'] = {
            ['StripTemperatureCelsius'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['description'] = '驱动器条带温度(摄氏度)',
                ['validator'] = sassmart_intf_types.StripTemperatureCelsius
            },
            ['ElementsInGrownDefectList'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['description'] = '增长缺陷列表(G表)中的元素',
                ['validator'] = sassmart_intf_types.ElementsInGrownDefectList
            },
            ['ElementsInPrimaryDefectList'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['description'] = '主缺陷列表(P表)中的元素',
                ['validator'] = sassmart_intf_types.ElementsInPrimaryDefectList
            },
            ['ManufacturedInWeekOfYear'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '生产日期：年中周',
                ['validator'] = sassmart_intf_types.ManufacturedInWeekOfYear
            },
            ['BlocksSentToInitiator'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['description'] = '发送到启动器的块',
                ['validator'] = sassmart_intf_types.BlocksSentToInitiator
            },
            ['BlocksReceivedFromInitiator'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['description'] = '从启动器收到的块',
                ['validator'] = sassmart_intf_types.BlocksReceivedFromInitiator
            },
            ['UntilNextInterSMARTTestMinutes'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '距下一次内部SMART测试的时长(分钟)',
                ['validator'] = sassmart_intf_types.UntilNextInterSMARTTestMinutes
            },
            ['LastPrefailEventSeqNum'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '最后一次预测故障事件的序列号',
                ['validator'] = sassmart_intf_types.LastPrefailEventSeqNum
            }
        },
        ['bmc.kepler.Metric'] = {},
        ['bmc.kepler.Inventory.Hardware'] = {
            ['AssetType'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '硬件资产类型',
                ['validator'] = hardware_intf_types.AssetType
            },
            ['AssetName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '硬件资产名称',
                ['validator'] = hardware_intf_types.AssetName
            },
            ['SerialNumber'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '硬件资产序列号',
                ['alias'] = 'InventorySerialNumber',
                ['validator'] = hardware_intf_types.SerialNumber
            },
            ['FirmwareVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '硬件资产固件版本',
                ['alias'] = 'InventoryFirmwareVersion',
                ['validator'] = hardware_intf_types.FirmwareVersion
            },
            ['PCBVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '硬件资产PCB版本',
                ['validator'] = hardware_intf_types.PCBVersion
            },
            ['Manufacturer'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '硬件资产制造商',
                ['alias'] = 'InventoryManufacturer',
                ['validator'] = hardware_intf_types.Manufacturer
            },
            ['AssetTag'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '硬件资产标签',
                ['validator'] = hardware_intf_types.AssetTag
            },
            ['PartNumber'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '硬件资产部件编号',
                ['validator'] = hardware_intf_types.PartNumber
            },
            ['ManufactureDate'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '硬件资产生产日期',
                ['validator'] = hardware_intf_types.ManufactureDate
            },
            ['Slot'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '硬件槽位号',
                ['validator'] = hardware_intf_types.Slot
            },
            ['UUID'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '硬件UUID号',
                ['validator'] = hardware_intf_types.UUID
            }
        },
        ['bmc.kepler.Systems.Storage.Drive.DriveSubHealth'] = {
            ['EstimatedRemainingLifespanInsufficient'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = '硬盘预估剩余寿命不足',
                ['usage'] = {'CSR', 'ResetPer'},
                ['validator'] = drive_sub_health_intf_types.EstimatedRemainingLifespanInsufficient
            },
            ['SLCSpareBlockPercentage'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = '非用户区剩余冗余块百分比',
                ['usage'] = {'CSR'},
                ['default'] = 255,
                ['validator'] = drive_sub_health_intf_types.SLCSpareBlockPercentage
            },
            ['TLCSpareBlockPercentage'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = '用户区剩余冗余块百分比',
                ['usage'] = {'CSR'},
                ['default'] = 255,
                ['validator'] = drive_sub_health_intf_types.TLCSpareBlockPercentage
            },
            ['EstimatedRemainingLifespan'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['description'] = '硬盘预估剩余寿命',
                ['usage'] = {'CSR', 'PoweroffPer'},
                ['default'] = 4294967295,
                ['validator'] = drive_sub_health_intf_types.EstimatedRemainingLifespan
            },
            ['IODeteriorationHealthCode'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['description'] = '硬盘IO性能健康码',
                ['usage'] = {'CSR', 'PoweroffPer'},
                ['validator'] = drive_sub_health_intf_types.IODeteriorationHealthCode
            }
        },
        ['bmc.kepler.Systems.Storage.Drive.NVMe'] = {
            ['LifeUsedPercentage'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = '驱动器寿命百分比',
                ['validator'] = nv_me_intf_types.LifeUsedPercentage
            }
        },
        ['bmc.kepler.Systems.Storage.Drive.NVMe.SMART'] = {
            ['AvailableSpare'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '驱动器可用冗余空间的百分比（0到100）',
                ['validator'] = nv_me_smart_intf_types.AvailableSpare
            },
            ['CriticalWarning'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = [[控制器状态的重要的告警,
                                    bit0:表示冗余空间小于设定的阈值,
                                    bit1:表示温度超过或低于一个重要的阈值,
                                    bit2:表示由于重要的media错误,器件的可靠性已经降低,
                                    bit3:该介质已经被置为只读模式,
                                    bit4:表示控制器的易失性器件fail,该域仅在控制器内部存在易失性器件时有效,
                                    bit5-7:保留]],
                ['validator'] = nv_me_smart_intf_types.CriticalWarning
            },
            ['UsedPercentage'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '用户实际使用和厂家设定的器件寿命的百分比（0到100）',
                ['validator'] = nv_me_smart_intf_types.UsedPercentage
            },
            ['Status'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = 'SMART告警状态',
                ['validator'] = nv_me_smart_intf_types.Status
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '对象类名',
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '对象名',
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['description'] = '对象标志符',
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.Systems.Storage.Drive'] = {
            ['SetLocationIndicatorState'] = {
                ['description'] = '设置物理盘的定位灯状态',
                ['privilege'] = {'BasicSetting'},
                ['req'] = {
                    {
                        ['baseType'] = 'U8',
                        ['description'] = '定位指示灯状态 0 = Off 1 = Blinking',
                        ['param'] = 'LocationIndicatorState'
                    }
                },
                ['rsp'] = {}
            },
            ['SetFaultIndicatorState'] = {
                ['description'] = '设置物理盘的故障灯状态',
                ['privilege'] = {'BasicSetting'},
                ['req'] = {
                    {
                        ['baseType'] = 'U8',
                        ['description'] = '故障指示灯状态 0 = Off 1 = Blinking',
                        ['param'] = 'FaultIndicatorState'
                    }
                },
                ['rsp'] = {}
            },
            ['SetFirmwareStatus'] = {
                ['description'] = '设置物理盘的固件状态',
                ['privilege'] = {'BasicSetting'},
                ['req'] = {{['baseType'] = 'U8', ['description'] = '固件状态', ['param'] = 'FirmwareStatus'}},
                ['rsp'] = {}
            },
            ['SetHotspareType'] = {
                ['description'] = '设置物理盘是否为热备盘',
                ['privilege'] = {'BasicSetting'},
                ['req'] = {
                    {
                        ['baseType'] = 'U8',
                        ['description'] = '驱动器的热备状态 0 = None  1 = Global  2 = Dedicated',
                        ['param'] = 'HotspareType'
                    }, {['baseType'] = 'U16', ['description'] = '存储卷ID', ['param'] = 'VolumeId'}
                },
                ['rsp'] = {}
            },
            ['SetBootPriority'] = {
                ['description'] = '设置物理盘的启动优先级',
                ['privilege'] = {'BasicSetting'},
                ['req'] = {
                    {
                        ['baseType'] = 'U8',
                        ['description'] = '启动优先级 0 = None  1 = Primary',
                        ['param'] = 'BootPriority'
                    }
                },
                ['rsp'] = {}
            },
            ['SetPatrolState'] = {
                ['description'] = '设置物理盘的巡检状态',
                ['privilege'] = {'BasicSetting'},
                ['req'] = {
                    {['baseType'] = 'U8', ['description'] = '巡检状态 0 = stop  1 = run', ['param'] = 'PatrolState'}
                },
                ['rsp'] = {}
            },
            ['CryptoErase'] = {
                ['description'] = '支持设置物理盘被加密擦除',
                ['privilege'] = {'BasicSetting'},
                ['req'] = {},
                ['rsp'] = {}
            }
        },
        ['bmc.kepler.Metric'] = {
            ['GetData'] = {
                ['description'] = '根据MetricName获取采集项数据',
                ['req'] = {{['baseType'] = 'String[]', ['description'] = '采集项名称', ['param'] = 'MetricName'}},
                ['rsp'] = {
                    {
                        ['baseType'] = 'Array',
                        ['items'] = {['$ref'] = '#/defs/DataCollectionItem'},
                        ['description'] = '采集项数据',
                        ['param'] = 'Val'
                    }
                }
            },
            ['GetItems'] = {
                ['description'] = '获取采集项描述信息',
                ['req'] = {},
                ['rsp'] = {
                    {['baseType'] = 'String', ['description'] = '采集主体名称', ['param'] = 'Component'}, {
                        ['baseType'] = 'Array',
                        ['items'] = {['$ref'] = '#/defs/TagProp'},
                        ['description'] = '分类信息',
                        ['param'] = 'Classification'
                    }, {
                        ['baseType'] = 'Array',
                        ['items'] = {['$ref'] = '#/defs/TagProp'},
                        ['description'] = '标识信息',
                        ['param'] = 'Identification'
                    }, {['baseType'] = 'String[]', ['description'] = '采集项名称', ['param'] = 'MetricName'}
                }
            },
            ['SynDataAcquisitionEnable'] = {
                ['description'] = '将数据采集开关同步到业务组件',
                ['req'] = {{['baseType'] = 'U8', ['description'] = '数据采集开关', ['param'] = 'Enabled'}},
                ['rsp'] = {}
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['GetOptions'] = {
                ['req'] = {
                    {['baseType'] = 'String', ['description'] = '接口名', ['param'] = 'Interface'},
                    {['baseType'] = 'String', ['description'] = '属性名', ['param'] = 'Property'}
                },
                ['rsp'] = {
                    {
                        ['baseType'] = 'Struct',
                        ['$ref'] = '#/defs/Options',
                        ['description'] = '属性能力选项，例如是否弃用、是否是易变属性等',
                        ['param'] = 'Options'
                    }
                },
                ['description'] = '按接口名和属性名查询属性的能力选项'
            },
            ['GetPropertiesByOptions'] = {
                ['req'] = {
                    {['baseType'] = 'String', ['description'] = '接口名', ['param'] = 'Interface'}, {
                        ['baseType'] = 'Struct',
                        ['$ref'] = '#/defs/Options',
                        ['description'] = '属性能力选项，例如是否弃用、是否是易变属性等',
                        ['param'] = 'Options'
                    }
                },
                ['rsp'] = {{['baseType'] = 'String[]', ['description'] = '属性名列表', ['param'] = 'Properties'}},
                ['description'] = '按接口名和能力选项查询符合条件的所有属性'
            }
        }
    },
    ['mdb_signal_configs'] = {
        ['bmc.kepler.Metric'] = {
            ['CollectSignal'] = {
                {['baseType'] = 'String', ['param'] = 'MetricName'}, {['baseType'] = 'String', ['param'] = 'TagPath'}
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Systems/:SystemId/Storage/Drives/:Id'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Systems.Storage.Drive'] = {
            ['property_defaults'] = {
                ['NodeId'] = drive_intf_types.NodeId.default[1],
                ['Id'] = drive_intf_types.Id.default[1],
                ['SlotNumber'] = 255,
                ['Name'] = drive_intf_types.Name.default[1],
                ['Presence'] = 255,
                ['LocateLed'] = drive_intf_types.LocateLed.default[1],
                ['FaultLed'] = drive_intf_types.FaultLed.default[1],
                ['EnclosureId'] = 65535,
                ['LocationIndicatorState'] = drive_intf_types.LocationIndicatorState.default[1],
                ['CapacityMiB'] = 4294967295,
                ['TemperatureCelsius'] = 255,
                ['Model'] = 'N/A',
                ['Protocol'] = 255,
                ['CapableSpeedGbs'] = 255,
                ['NegotiatedSpeedGbs'] = 255,
                ['MediaType'] = 255,
                ['FirmwareStatus'] = 255,
                ['SerialNumber'] = 'N/A',
                ['Manufacturer'] = 'N/A',
                ['PowerOnHours'] = drive_intf_types.PowerOnHours.default[1],
                ['Revision'] = 'N/A',
                ['RotationSpeedRPM'] = drive_intf_types.RotationSpeedRPM.default[1],
                ['BlockSizeBytes'] = drive_intf_types.BlockSizeBytes.default[1],
                ['SASAddress1'] = drive_intf_types.SASAddress1.default[1],
                ['SASAddress2'] = drive_intf_types.SASAddress2.default[1],
                ['Location'] = drive_intf_types.Location.default[1],
                ['DeviceName'] = 'N/A',
                ['PredictedMediaLifeLeftPercent'] = 255,
                ['PredictedFailCount'] = drive_intf_types.PredictedFailCount.default[1],
                ['MediaErrorCount'] = drive_intf_types.MediaErrorCount.default[1],
                ['OtherErrorCount'] = drive_intf_types.OtherErrorCount.default[1],
                ['PatrolState'] = drive_intf_types.PatrolState.default[1],
                ['PowerState'] = drive_intf_types.PowerState.default[1],
                ['RebuildState'] = drive_intf_types.RebuildState.default[1],
                ['RebuildProgress'] = drive_intf_types.RebuildProgress.default[1],
                ['BootPriority'] = drive_intf_types.BootPriority.default[1],
                ['HotspareType'] = drive_intf_types.HotspareType.default[1],
                ['RefControllerId'] = 255,
                ['RefVolumeList'] = drive_intf_types.RefVolumeList.default[1],
                ['RefDiskArrayId'] = drive_intf_types.RefDiskArrayId.default[1],
                ['ManufacturerId'] = drive_intf_types.ManufacturerId.default[1],
                ['PCIeLinkSpeed'] = drive_intf_types.PCIeLinkSpeed.default[1],
                ['ResourceId'] = drive_intf_types.ResourceId.default[1]
            },
            ['privileges'] = {
                ['path'] = privilege.ReadOnly,
                ['methods'] = {
                    ['SetLocationIndicatorState'] = privilege.BasicSetting,
                    ['SetFaultIndicatorState'] = privilege.BasicSetting,
                    ['SetFirmwareStatus'] = privilege.BasicSetting,
                    ['SetHotspareType'] = privilege.BasicSetting,
                    ['SetBootPriority'] = privilege.BasicSetting,
                    ['SetPatrolState'] = privilege.BasicSetting,
                    ['CryptoErase'] = privilege.BasicSetting
                }
            },
            ['interface_types'] = drive_intf_types
        },
        ['bmc.kepler.Systems.Storage.Drive.AddrInfo'] = {
            ['property_defaults'] = {
                ['Type'] = 'N/A',
                ['SocketId'] = addr_info_intf_types.SocketId.default[1],
                ['SlotId'] = addr_info_intf_types.SlotId.default[1],
                ['PortId'] = addr_info_intf_types.PortId.default[1],
                ['RootBDF'] = 'N/A'
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = addr_info_intf_types
        },
        ['bmc.kepler.Systems.Storage.Drive.DriveStatus'] = {
            ['property_defaults'] = {
                ['Missing'] = drive_status_intf_types.Missing.default[1],
                ['PredictiveFailure'] = drive_status_intf_types.PredictiveFailure.default[1],
                ['InAFailedArray'] = drive_status_intf_types.InAFailedArray.default[1],
                ['CapacityError'] = drive_status_intf_types.CapacityError.default[1],
                ['FirmwareStatusError'] = drive_status_intf_types.FirmwareStatusError.default[1],
                ['Failure'] = drive_status_intf_types.Failure.default[1],
                ['Health'] = drive_status_intf_types.Health.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = drive_status_intf_types
        },
        ['bmc.kepler.Systems.Storage.Drive.SAS.SMART'] = {
            ['property_defaults'] = {
                ['StripTemperatureCelsius'] = sassmart_intf_types.StripTemperatureCelsius.default[1],
                ['ElementsInGrownDefectList'] = sassmart_intf_types.ElementsInGrownDefectList.default[1],
                ['ElementsInPrimaryDefectList'] = sassmart_intf_types.ElementsInPrimaryDefectList.default[1],
                ['ManufacturedInWeekOfYear'] = sassmart_intf_types.ManufacturedInWeekOfYear.default[1],
                ['BlocksSentToInitiator'] = sassmart_intf_types.BlocksSentToInitiator.default[1],
                ['BlocksReceivedFromInitiator'] = sassmart_intf_types.BlocksReceivedFromInitiator.default[1],
                ['UntilNextInterSMARTTestMinutes'] = sassmart_intf_types.UntilNextInterSMARTTestMinutes.default[1],
                ['LastPrefailEventSeqNum'] = sassmart_intf_types.LastPrefailEventSeqNum.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = sassmart_intf_types
        },
        ['bmc.kepler.Metric'] = {
            ['property_defaults'] = {},
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = metric_intf_types
        },
        ['bmc.kepler.Inventory.Hardware'] = {
            ['property_defaults'] = {
                ['AssetType'] = hardware_intf_types.AssetType.default[1],
                ['AssetName'] = hardware_intf_types.AssetName.default[1],
                ['SerialNumber'] = hardware_intf_types.SerialNumber.default[1],
                ['FirmwareVersion'] = hardware_intf_types.FirmwareVersion.default[1],
                ['PCBVersion'] = hardware_intf_types.PCBVersion.default[1],
                ['Manufacturer'] = hardware_intf_types.Manufacturer.default[1],
                ['AssetTag'] = hardware_intf_types.AssetTag.default[1],
                ['PartNumber'] = hardware_intf_types.PartNumber.default[1],
                ['ManufactureDate'] = hardware_intf_types.ManufactureDate.default[1],
                ['Slot'] = hardware_intf_types.Slot.default[1],
                ['UUID'] = hardware_intf_types.UUID.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = hardware_intf_types
        },
        ['bmc.kepler.Systems.Storage.Drive.DriveSubHealth'] = {
            ['property_defaults'] = {
                ['EstimatedRemainingLifespanInsufficient'] = drive_sub_health_intf_types.EstimatedRemainingLifespanInsufficient
                    .default[1],
                ['SLCSpareBlockPercentage'] = 255,
                ['TLCSpareBlockPercentage'] = 255,
                ['EstimatedRemainingLifespan'] = 4294967295,
                ['IODeteriorationHealthCode'] = drive_sub_health_intf_types.IODeteriorationHealthCode.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = drive_sub_health_intf_types
        },
        ['bmc.kepler.Systems.Storage.Drive.NVMe'] = {
            ['property_defaults'] = {['LifeUsedPercentage'] = nv_me_intf_types.LifeUsedPercentage.default[1]},
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = nv_me_intf_types
        },
        ['bmc.kepler.Systems.Storage.Drive.NVMe.SMART'] = {
            ['property_defaults'] = {
                ['AvailableSpare'] = nv_me_smart_intf_types.AvailableSpare.default[1],
                ['CriticalWarning'] = nv_me_smart_intf_types.CriticalWarning.default[1],
                ['UsedPercentage'] = nv_me_smart_intf_types.UsedPercentage.default[1],
                ['Status'] = nv_me_smart_intf_types.Status.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = nv_me_smart_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local Drives = {
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Systems.Storage.Drives'] = {
            ['MaxTemperatureCelsius'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = '驱动器最高温度，用于风扇调速',
                ['validator'] = drives_intf_types.MaxTemperatureCelsius
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '对象类名',
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '对象名',
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['description'] = '对象标志符',
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.Systems.Storage.Drives'] = {
            ['CollectIODeteriorationDiagInfo'] = {
                ['description'] = '设置启动收集硬盘IO性能诊断信息',
                ['req'] = {},
                ['rsp'] = {{['baseType'] = 'U32', ['description'] = '任务Id', ['param'] = 'TaskId'}},
                ['privilege'] = {'BasicSetting'}
            },
            ['GetDrivesSubHealthDiagInfo'] = {
                ['description'] = '获取硬盘IO性能诊断信息列表',
                ['req'] = {
                    {
                        ['baseType'] = 'String',
                        ['description'] = '硬盘亚健康数据类型',
                        ['param'] = 'SubHealthType'
                    }
                },
                ['rsp'] = {
                    {
                        ['baseType'] = 'Array',
                        ['description'] = '硬盘亚健康诊断信息列表',
                        ['items'] = {['$ref'] = '#/defs/DriveList'},
                        ['param'] = 'SubHealthDiagInfoList'
                    }
                },
                ['privilege'] = {'BasicSetting'}
            },
            ['GetNvmeDriveRawData'] = {
                ['description'] = '获取NVMe盘的信息',
                ['req'] = {{['baseType'] = 'U16', ['description'] = 'Nvme盘序号', ['param'] = 'index'}},
                ['rsp'] = {
                    {['baseType'] = 'String', ['description'] = 'Nvme盘信息数据', ['param'] = 'NvmeDriveData'}
                },
                ['privilege'] = {'BasicSetting'}
            },
            ['GetNvmeDriveCount'] = {
                ['description'] = '获取NVMe盘的数量',
                ['req'] = {},
                ['rsp'] = {{['baseType'] = 'U16', ['description'] = 'Nvme盘数量', ['param'] = 'NvmeDriveCount'}}
            },
            ['SetDriveSubHealthDiagResult'] = {
                ['description'] = '设置硬盘IO性能健康码',
                ['req'] = {
                    {
                        ['baseType'] = 'Array',
                        ['items'] = {['$ref'] = '#/defs/KeyValueTable'},
                        ['description'] = '硬盘亚健康信息诊断结果列表，必选参数：（DriveName：硬盘名称）可选参数：（EstimatedRemainingLifespan：硬盘预估寿命告警码，EstimatedRemainingLifespan：硬盘预估剩余寿命，IODeteriorationHealthCode：硬盘I/O性能健康码）',
                        ['param'] = 'SubHealthDiagResult'
                    }
                },
                ['rsp'] = {},
                ['privilege'] = {'BasicSetting'}
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['GetOptions'] = {
                ['req'] = {
                    {['baseType'] = 'String', ['description'] = '接口名', ['param'] = 'Interface'},
                    {['baseType'] = 'String', ['description'] = '属性名', ['param'] = 'Property'}
                },
                ['rsp'] = {
                    {
                        ['baseType'] = 'Struct',
                        ['$ref'] = '#/defs/Options',
                        ['description'] = '属性能力选项，例如是否弃用、是否是易变属性等',
                        ['param'] = 'Options'
                    }
                },
                ['description'] = '按接口名和属性名查询属性的能力选项'
            },
            ['GetPropertiesByOptions'] = {
                ['req'] = {
                    {['baseType'] = 'String', ['description'] = '接口名', ['param'] = 'Interface'}, {
                        ['baseType'] = 'Struct',
                        ['$ref'] = '#/defs/Options',
                        ['description'] = '属性能力选项，例如是否弃用、是否是易变属性等',
                        ['param'] = 'Options'
                    }
                },
                ['rsp'] = {{['baseType'] = 'String[]', ['description'] = '属性名列表', ['param'] = 'Properties'}},
                ['description'] = '按接口名和能力选项查询符合条件的所有属性'
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Systems/:SystemId/Storage/Drives'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Systems.Storage.Drives'] = {
            ['property_defaults'] = {['MaxTemperatureCelsius'] = drives_intf_types.MaxTemperatureCelsius.default[1]},
            ['privileges'] = {
                ['path'] = privilege.ReadOnly,
                ['methods'] = {
                    ['CollectIODeteriorationDiagInfo'] = privilege.BasicSetting,
                    ['GetDrivesSubHealthDiagInfo'] = privilege.BasicSetting,
                    ['GetNvmeDriveRawData'] = privilege.BasicSetting,
                    ['SetDriveSubHealthDiagResult'] = privilege.BasicSetting
                }
            },
            ['interface_types'] = drives_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local Volume = {
    ['prop_configs'] = {
        ['NumDrivePerSpan'] = {['baseType'] = 'U8', 
        ['validator'] = volume_class_types.NumDrivePerSpan
    }},
    ['default_props'] = {['NumDrivePerSpan'] = volume_class_types.NumDrivePerSpan.default[1]},
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Systems.Storage.Volume'] = {
            ['Id'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['description'] = '逻辑盘的Id',
                ['validator'] = volume_intf_types.Id
            },
            ['VolumeName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '逻辑盘的名称',
                ['validator'] = volume_intf_types.VolumeName
            },
            ['OptimumIOSizeBytes'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['description'] = '逻辑盘的条带大小',
                ['validator'] = volume_intf_types.OptimumIOSizeBytes
            },
            ['DefaultReadPolicy'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '逻辑盘的默认读策略',
                ['validator'] = volume_intf_types.DefaultReadPolicy
            },
            ['DefaultWritePolicy'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '逻辑盘的默认写策略',
                ['validator'] = volume_intf_types.DefaultWritePolicy
            },
            ['State'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = '逻辑盘的状态',
                ['default'] = 255,
                ['validator'] = volume_intf_types.State
            },
            ['RAIDType'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = '逻辑盘的Raid级别',
                ['validator'] = volume_intf_types.RAIDType
            },
            ['CapacityBytes'] = {
                ['baseType'] = 'U64',
                ['readOnly'] = true,
                ['description'] = '逻辑盘的容量',
                ['validator'] = volume_intf_types.CapacityBytes
            },
            ['DriveCachePolicy'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = '逻辑盘的硬盘缓存策略',
                ['validator'] = volume_intf_types.DriveCachePolicy
            },
            ['CurrentForegroundInitState'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = '逻辑盘当前是否在FGI中',
                ['validator'] = volume_intf_types.CurrentForegroundInitState
            },
            ['ForegroundInitProgress'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['volatile'] = true, ['emitsChangedSignal'] = 'true'},
                ['description'] = '逻辑盘当前的FGI进度，百分比',
                ['validator'] = volume_intf_types.ForegroundInitProgress
            },
            ['CurrentReadPolicy'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '逻辑盘当前读策略',
                ['validator'] = volume_intf_types.CurrentReadPolicy
            },
            ['CurrentWritePolicy'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '逻辑盘当前写策略',
                ['validator'] = volume_intf_types.CurrentWritePolicy
            },
            ['BootPriority'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = '启动优先级',
                ['validator'] = volume_intf_types.BootPriority
            },
            ['BootEnable'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = '是否为启动盘',
                ['validator'] = volume_intf_types.BootEnable
            },
            ['OSDriveName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '逻辑盘对应的OS盘符',
                ['validator'] = volume_intf_types.OSDriveName
            },
            ['BGIEnable'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = '后台初始化使能状态',
                ['validator'] = volume_intf_types.BGIEnable
            },
            ['SSDCachecadeVolume'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = '是否为CacheCade逻辑盘',
                ['validator'] = volume_intf_types.SSDCachecadeVolume
            },
            ['ConsistencyCheck'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = '一致性检查功能的启用状态',
                ['validator'] = volume_intf_types.ConsistencyCheck
            },
            ['SSDCachingEnable'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = '是否可使用CacheCade逻辑盘',
                ['validator'] = volume_intf_types.SSDCachingEnable
            },
            ['AssociatedVolumes'] = {
                ['baseType'] = 'U16[]',
                ['readOnly'] = true,
                ['description'] = '所关联的普通逻辑盘的访问路径',
                ['validator'] = volume_intf_types.AssociatedVolumes
            },
            ['AssociatedCacheCadeVolume'] = {
                ['baseType'] = 'U16[]',
                ['readOnly'] = true,
                ['description'] = '所关联的CacheCade逻辑盘的访问路径',
                ['validator'] = volume_intf_types.AssociatedCacheCadeVolume
            },
            ['DefaultCachePolicy'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '逻辑盘默认的Cache策略',
                ['validator'] = volume_intf_types.DefaultCachePolicy
            },
            ['AccessPolicy'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '逻辑盘的访问策略',
                ['validator'] = volume_intf_types.AccessPolicy
            },
            ['CurrentCachePolicy'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '逻辑盘当前Cache策略',
                ['validator'] = volume_intf_types.CurrentCachePolicy
            },
            ['CacheLineSizeKiB'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = '缓存行大小',
                ['validator'] = volume_intf_types.CacheLineSizeKiB
            },
            ['AccelerationMethod'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '加速方法',
                ['validator'] = volume_intf_types.AccelerationMethod
            },
            ['RebuildProgress'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = '指定逻辑盘数据重建进度',
                ['validator'] = volume_intf_types.RebuildProgress
            },
            ['InitializationMode'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = '初始化模式',
                ['validator'] = volume_intf_types.InitializationMode
            },
            ['RebuildState'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = '指定逻辑盘数据重建状态',
                ['validator'] = volume_intf_types.RebuildState
            },
            ['RefControllerId'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = '指定逻辑盘所属控制器id',
                ['validator'] = volume_intf_types.RefControllerId
            },
            ['RefDriveList'] = {
                ['baseType'] = 'String[]',
                ['readOnly'] = true,
                ['description'] = '指定逻辑盘关联的物理盘列表',
                ['validator'] = volume_intf_types.RefDriveList
            },
            ['RefDiskArrayList'] = {
                ['baseType'] = 'U16[]',
                ['readOnly'] = true,
                ['description'] = '指定逻辑盘关联的阵列列表',
                ['validator'] = volume_intf_types.RefDiskArrayList
            },
            ['HotSpareDriveList'] = {
                ['baseType'] = 'String[]',
                ['readOnly'] = true,
                ['description'] = '逻辑盘关联热备盘列表',
                ['validator'] = volume_intf_types.HotSpareDriveList
            },
            ['SpanCount'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = '逻辑盘包含的子组数',
                ['validator'] = volume_intf_types.SpanCount
            },
            ['MaxResizableSizeBytes'] = {
                ['baseType'] = 'U64',
                ['readOnly'] = true,
                ['description'] = '逻辑盘的最大可设置的容量',
                ['validator'] = volume_intf_types.MaxResizableSizeBytes
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '对象类名',
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '对象名',
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['description'] = '对象标志符',
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.Systems.Storage.Volume'] = {
            ['SetName'] = {
                ['description'] = '设置逻辑盘的名称',
                ['privilege'] = {'BasicSetting'},
                ['req'] = {{['baseType'] = 'String', ['description'] = '名称', ['param'] = 'Name'}},
                ['rsp'] = {}
            },
            ['SetReadPolicy'] = {
                ['description'] = '设置逻辑盘的读策略',
                ['privilege'] = {'BasicSetting'},
                ['req'] = {{['baseType'] = 'U8', ['description'] = '读策略', ['param'] = 'ReadPolicy'}},
                ['rsp'] = {}
            },
            ['SetWritePolicy'] = {
                ['description'] = '设置逻辑盘的写策略',
                ['privilege'] = {'BasicSetting'},
                ['req'] = {{['baseType'] = 'U8', ['description'] = '写策略', ['param'] = 'WritePolicy'}},
                ['rsp'] = {}
            },
            ['SetBootable'] = {
                ['description'] = '设置逻辑盘是否启动盘',
                ['privilege'] = {'BasicSetting'},
                ['req'] = {{['baseType'] = 'U8', ['description'] = '启动优先级', ['param'] = 'BootPriority'}},
                ['rsp'] = {}
            },
            ['SetIOPolicy'] = {
                ['description'] = '设置逻辑盘的IO策略',
                ['privilege'] = {'BasicSetting'},
                ['req'] = {{['baseType'] = 'U8', ['description'] = 'IO策略', ['param'] = 'IOPolicy'}},
                ['rsp'] = {}
            },
            ['SetBGIEnable'] = {
                ['description'] = '设置逻辑盘的后台初始化',
                ['privilege'] = {'BasicSetting'},
                ['req'] = {{['baseType'] = 'U8', ['description'] = '是否后台初始化', ['param'] = 'BGIEnabled'}},
                ['rsp'] = {}
            },
            ['SetAccessPolicy'] = {
                ['description'] = '设置逻辑盘的获取策略',
                ['privilege'] = {'BasicSetting'},
                ['req'] = {{['baseType'] = 'U8', ['description'] = '获取策略', ['param'] = 'AccessPolicy'}},
                ['rsp'] = {}
            },
            ['SetDiskCachePolicy'] = {
                ['description'] = '设置逻辑盘的硬盘Cache策略',
                ['privilege'] = {'BasicSetting'},
                ['req'] = {{['baseType'] = 'U8', ['description'] = '硬盘Cache策略', ['param'] = 'DiskCachePolicy'}},
                ['rsp'] = {}
            },
            ['StartForegroundInit'] = {
                ['description'] = '开始前台初始化',
                ['privilege'] = {'BasicSetting'},
                ['req'] = {{['baseType'] = 'U8', ['description'] = '初始化类型', ['param'] = 'InitType'}},
                ['rsp'] = {{['baseType'] = 'U32', ['description'] = '任务ID', ['param'] = 'TaskId'}}
            },
            ['CancelForegroundInit'] = {
                ['description'] = '取消前台初始化',
                ['privilege'] = {'BasicSetting'},
                ['req'] = {},
                ['rsp'] = {{['baseType'] = 'U32', ['description'] = '任务ID', ['param'] = 'TaskId'}}
            },
            ['SetCachecadeEnable'] = {
                ['description'] = '设置Cache使能状态',
                ['privilege'] = {'BasicSetting'},
                ['req'] = {{['baseType'] = 'U8', ['description'] = '关联Cache号', ['param'] = 'AssociateCachecade'}},
                ['rsp'] = {}
            },
            ['SetAccelerator'] = {
                ['description'] = '设置逻辑盘的加速方法',
                ['privilege'] = {'BasicSetting'},
                ['req'] = {{['baseType'] = 'U8', ['description'] = '加速方法', ['param'] = 'Accelerator'}},
                ['rsp'] = {}
            },
            ['SetCapacitySize'] = {
                ['privilege'] = {'BasicSetting'},
                ['req'] = {
                    {['baseType'] = 'U32', ['description'] = '容量大小', ['param'] = 'CapacitySize'},
                    {['baseType'] = 'U8', ['description'] = '容量单位，0:MB,1:GB,2:TB', ['param'] = 'CapacityUnit'}
                },
                ['rsp'] = {},
                ['description'] = '设置逻辑盘的容量'
            },
            ['SetStripSize'] = {
                ['privilege'] = {'BasicSetting'},
                ['req'] = {{['baseType'] = 'U8', ['description'] = '条带大小', ['param'] = 'StripSize'}},
                ['rsp'] = {},
                ['description'] = '设置逻辑盘的条带大小'
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['GetOptions'] = {
                ['req'] = {
                    {['baseType'] = 'String', ['description'] = '接口名', ['param'] = 'Interface'},
                    {['baseType'] = 'String', ['description'] = '属性名', ['param'] = 'Property'}
                },
                ['rsp'] = {
                    {
                        ['baseType'] = 'Struct',
                        ['$ref'] = '#/defs/Options',
                        ['description'] = '属性能力选项，例如是否弃用、是否是易变属性等',
                        ['param'] = 'Options'
                    }
                },
                ['description'] = '按接口名和属性名查询属性的能力选项'
            },
            ['GetPropertiesByOptions'] = {
                ['req'] = {
                    {['baseType'] = 'String', ['description'] = '接口名', ['param'] = 'Interface'}, {
                        ['baseType'] = 'Struct',
                        ['$ref'] = '#/defs/Options',
                        ['description'] = '属性能力选项，例如是否弃用、是否是易变属性等',
                        ['param'] = 'Options'
                    }
                },
                ['rsp'] = {{['baseType'] = 'String[]', ['description'] = '属性名列表', ['param'] = 'Properties'}},
                ['description'] = '按接口名和能力选项查询符合条件的所有属性'
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Systems/:SystemId/Storage/Controllers/:ControllerId/Volumes/:Id'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Systems.Storage.Volume'] = {
            ['property_defaults'] = {
                ['Id'] = volume_intf_types.Id.default[1],
                ['VolumeName'] = volume_intf_types.VolumeName.default[1],
                ['OptimumIOSizeBytes'] = volume_intf_types.OptimumIOSizeBytes.default[1],
                ['DefaultReadPolicy'] = volume_intf_types.DefaultReadPolicy.default[1],
                ['DefaultWritePolicy'] = volume_intf_types.DefaultWritePolicy.default[1],
                ['State'] = 255,
                ['RAIDType'] = volume_intf_types.RAIDType.default[1],
                ['CapacityBytes'] = volume_intf_types.CapacityBytes.default[1],
                ['DriveCachePolicy'] = volume_intf_types.DriveCachePolicy.default[1],
                ['CurrentForegroundInitState'] = volume_intf_types.CurrentForegroundInitState.default[1],
                ['ForegroundInitProgress'] = volume_intf_types.ForegroundInitProgress.default[1],
                ['CurrentReadPolicy'] = volume_intf_types.CurrentReadPolicy.default[1],
                ['CurrentWritePolicy'] = volume_intf_types.CurrentWritePolicy.default[1],
                ['BootPriority'] = volume_intf_types.BootPriority.default[1],
                ['BootEnable'] = volume_intf_types.BootEnable.default[1],
                ['OSDriveName'] = volume_intf_types.OSDriveName.default[1],
                ['BGIEnable'] = volume_intf_types.BGIEnable.default[1],
                ['SSDCachecadeVolume'] = volume_intf_types.SSDCachecadeVolume.default[1],
                ['ConsistencyCheck'] = volume_intf_types.ConsistencyCheck.default[1],
                ['SSDCachingEnable'] = volume_intf_types.SSDCachingEnable.default[1],
                ['AssociatedVolumes'] = volume_intf_types.AssociatedVolumes.default[1],
                ['AssociatedCacheCadeVolume'] = volume_intf_types.AssociatedCacheCadeVolume.default[1],
                ['DefaultCachePolicy'] = volume_intf_types.DefaultCachePolicy.default[1],
                ['AccessPolicy'] = volume_intf_types.AccessPolicy.default[1],
                ['CurrentCachePolicy'] = volume_intf_types.CurrentCachePolicy.default[1],
                ['CacheLineSizeKiB'] = volume_intf_types.CacheLineSizeKiB.default[1],
                ['AccelerationMethod'] = volume_intf_types.AccelerationMethod.default[1],
                ['RebuildProgress'] = volume_intf_types.RebuildProgress.default[1],
                ['InitializationMode'] = volume_intf_types.InitializationMode.default[1],
                ['RebuildState'] = volume_intf_types.RebuildState.default[1],
                ['RefControllerId'] = volume_intf_types.RefControllerId.default[1],
                ['RefDriveList'] = volume_intf_types.RefDriveList.default[1],
                ['RefDiskArrayList'] = volume_intf_types.RefDiskArrayList.default[1],
                ['HotSpareDriveList'] = volume_intf_types.HotSpareDriveList.default[1],
                ['SpanCount'] = volume_intf_types.SpanCount.default[1],
                ['MaxResizableSizeBytes'] = volume_intf_types.MaxResizableSizeBytes.default[1]
            },
            ['privileges'] = {
                ['path'] = privilege.ReadOnly,
                ['methods'] = {
                    ['SetName'] = privilege.BasicSetting,
                    ['SetReadPolicy'] = privilege.BasicSetting,
                    ['SetWritePolicy'] = privilege.BasicSetting,
                    ['SetBootable'] = privilege.BasicSetting,
                    ['SetIOPolicy'] = privilege.BasicSetting,
                    ['SetBGIEnable'] = privilege.BasicSetting,
                    ['SetAccessPolicy'] = privilege.BasicSetting,
                    ['SetDiskCachePolicy'] = privilege.BasicSetting,
                    ['StartForegroundInit'] = privilege.BasicSetting,
                    ['CancelForegroundInit'] = privilege.BasicSetting,
                    ['SetCachecadeEnable'] = privilege.BasicSetting,
                    ['SetAccelerator'] = privilege.BasicSetting,
                    ['SetCapacitySize'] = privilege.BasicSetting,
                    ['SetStripSize'] = privilege.BasicSetting
                }
            },
            ['interface_types'] = volume_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local Battery = {
    ['prop_configs'] = {
        ['RefController'] = {['baseType'] = 'U8', ['validator'] = battery_class_types.RefController},
        ['RefControllerDeviceName'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'String',
            ['validator'] = battery_class_types.RefControllerDeviceName
        },
        ['RefControllerSlotId'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = battery_class_types.RefControllerSlotId
        },
        ['RefControllerTypeId'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = battery_class_types.RefControllerTypeId
        }
    },
    ['default_props'] = {
        ['RefController'] = battery_class_types.RefController.default[1],
        ['RefControllerDeviceName'] = battery_class_types.RefControllerDeviceName.default[1],
        ['RefControllerSlotId'] = battery_class_types.RefControllerSlotId.default[1],
        ['RefControllerTypeId'] = battery_class_types.RefControllerTypeId.default[1]
    },
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Systems.Storage.Battery'] = {
            ['Name'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = 'BBU名称',
                ['validator'] = battery_intf_types.Name
            },
            ['State'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = 'BBU在位信息',
                ['validator'] = battery_intf_types.State
            },
            ['Fault'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = 'BBU故障标志',
                ['validator'] = battery_intf_types.Fault
            },
            ['HealthStatus'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = 'bit0:电压过低,bit1:需要更换BBU,bit2:电量校准失败,bit3:电量校准超时,bit4:预故障,bit5:剩余容量低,bit6:没有用于缓存卸载的空间,others:resrved',
                ['validator'] = battery_intf_types.HealthStatus
            },
            ['Health'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = 'BBU健康状态',
                ['validator'] = battery_intf_types.Health
            },
            ['TemperatureCelsius'] = {
                ['baseType'] = 'S16',
                ['readOnly'] = true,
                ['options'] = {['volatile'] = true, ['emitsChangedSignal'] = 'true'},
                ['description'] = 'BBU温度',
                ['usage'] = {'CSR'},
                ['validator'] = battery_intf_types.TemperatureCelsius
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '对象类名',
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '对象名',
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['description'] = '对象标志符',
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.Object.Properties'] = {
            ['GetOptions'] = {
                ['req'] = {
                    {['baseType'] = 'String', ['description'] = '接口名', ['param'] = 'Interface'},
                    {['baseType'] = 'String', ['description'] = '属性名', ['param'] = 'Property'}
                },
                ['rsp'] = {
                    {
                        ['baseType'] = 'Struct',
                        ['$ref'] = '#/defs/Options',
                        ['description'] = '属性能力选项，例如是否弃用、是否是易变属性等',
                        ['param'] = 'Options'
                    }
                },
                ['description'] = '按接口名和属性名查询属性的能力选项'
            },
            ['GetPropertiesByOptions'] = {
                ['req'] = {
                    {['baseType'] = 'String', ['description'] = '接口名', ['param'] = 'Interface'}, {
                        ['baseType'] = 'Struct',
                        ['$ref'] = '#/defs/Options',
                        ['description'] = '属性能力选项，例如是否弃用、是否是易变属性等',
                        ['param'] = 'Options'
                    }
                },
                ['rsp'] = {{['baseType'] = 'String[]', ['description'] = '属性名列表', ['param'] = 'Properties'}},
                ['description'] = '按接口名和能力选项查询符合条件的所有属性'
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Systems/:SystemId/Storage/Controllers/:Id/Battery'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Systems.Storage.Battery'] = {
            ['property_defaults'] = {
                ['Name'] = battery_intf_types.Name.default[1],
                ['State'] = battery_intf_types.State.default[1],
                ['Fault'] = battery_intf_types.Fault.default[1],
                ['HealthStatus'] = battery_intf_types.HealthStatus.default[1],
                ['Health'] = battery_intf_types.Health.default[1],
                ['TemperatureCelsius'] = battery_intf_types.TemperatureCelsius.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = battery_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local Nvme = {
    ['table_name'] = 't_nvme_info',
    ['prop_configs'] = {
        ['Slot'] = {
            ['primaryKey'] = true,
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = nvme_class_types.Slot
        },
        ['MediaType'] = {['usage'] = {'CSR'}, ['baseType'] = 'U8', ['validator'] = nvme_class_types.MediaType},
        ['Protocol'] = {['usage'] = {'CSR'}, ['baseType'] = 'U8', ['validator'] = nvme_class_types.Protocol},
        ['Revision'] = {['usage'] = {'CSR'}, ['baseType'] = 'String', ['validator'] = nvme_class_types.Revision},
        ['PredictedMediaLifeLeftPercent'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = nvme_class_types.PredictedMediaLifeLeftPercent
        },
        ['VPDChip'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8[]',
            ['refInterface'] = 'bmc.kepler.Chip.BlockIO',
            ['validator'] = nvme_class_types.VPDChip
        },
        ['SSDChip'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8[]',
            ['refInterface'] = 'bmc.kepler.Chip.BlockIO',
            ['validator'] = nvme_class_types.SSDChip
        },
        ['RefComponent'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8[]',
            ['refInterface'] = 'bmc.kepler.Systems.PcieAddrInfo',
            ['validator'] = nvme_class_types.RefComponent
        },
        ['TemperatureCelsius'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = nvme_class_types.TemperatureCelsius
        },
        ['Failure'] = {['usage'] = {'CSR'}, ['baseType'] = 'U16', ['validator'] = nvme_class_types.Failure},
        ['PredictiveFailure'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U16',
            ['validator'] = nvme_class_types.PredictiveFailure
        },
        ['SerialNumber'] = {['usage'] = {}, ['baseType'] = 'String', ['validator'] = nvme_class_types.SerialNumber}
    },
    ['default_props'] = {
        ['Slot'] = nvme_class_types.Slot.default[1],
        ['MediaType'] = nvme_class_types.MediaType.default[1],
        ['Protocol'] = nvme_class_types.Protocol.default[1],
        ['Revision'] = nvme_class_types.Revision.default[1],
        ['PredictedMediaLifeLeftPercent'] = nvme_class_types.PredictedMediaLifeLeftPercent.default[1],
        ['VPDChip'] = nvme_class_types.VPDChip.default[1],
        ['SSDChip'] = nvme_class_types.SSDChip.default[1],
        ['RefComponent'] = nvme_class_types.RefComponent.default[1],
        ['TemperatureCelsius'] = nvme_class_types.TemperatureCelsius.default[1],
        ['Failure'] = nvme_class_types.Failure.default[1],
        ['PredictiveFailure'] = nvme_class_types.PredictiveFailure.default[1],
        ['SerialNumber'] = nvme_class_types.SerialNumber.default[1]
    }
}

local VirtualVPDConnect = {
    ['table_name'] = 't_vpd_connect',
    ['prop_configs'] = {
        ['Slot'] = {
            ['primaryKey'] = true,
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = virtual_vpd_connect_class_types.Slot
        },
        ['RefVPDChip'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8[]',
            ['refInterface'] = 'bmc.kepler.Chip.BlockIO',
            ['validator'] = virtual_vpd_connect_class_types.RefVPDChip
        },
        ['RefConnector'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8[]',
            ['refInterface'] = 'bmc.kepler.Connector',
            ['validator'] = virtual_vpd_connect_class_types.RefConnector
        }
    },
    ['default_props'] = {
        ['Slot'] = virtual_vpd_connect_class_types.Slot.default[1],
        ['RefVPDChip'] = virtual_vpd_connect_class_types.RefVPDChip.default[1],
        ['RefConnector'] = virtual_vpd_connect_class_types.RefConnector.default[1]
    }
}

local Port = {
    ['prop_configs'] = {},
    ['default_props'] = {},
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Systems.Storage.SASMetrics'] = {
            ['ControllerId'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = '关联的控制器序号',
                ['validator'] = sas_metrics_intf_types.ControllerId
            },
            ['InvalidDwordCount'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['description'] = '无效DWORD数',
                ['validator'] = sas_metrics_intf_types.InvalidDwordCount
            },
            ['LossDwordSyncCount'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['description'] = '丢失DWORD同步数',
                ['validator'] = sas_metrics_intf_types.LossDwordSyncCount
            },
            ['PhyResetProblemCount'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['description'] = 'PHY重启问题数',
                ['validator'] = sas_metrics_intf_types.PhyResetProblemCount
            },
            ['RunningDisparityErrorCount'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['description'] = '连续不均衡性错误数',
                ['validator'] = sas_metrics_intf_types.RunningDisparityErrorCount
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '对象类名',
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '对象名',
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['description'] = '对象标志符',
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.Object.Properties'] = {
            ['GetOptions'] = {
                ['req'] = {
                    {['baseType'] = 'String', ['description'] = '接口名', ['param'] = 'Interface'},
                    {['baseType'] = 'String', ['description'] = '属性名', ['param'] = 'Property'}
                },
                ['rsp'] = {
                    {
                        ['baseType'] = 'Struct',
                        ['$ref'] = '#/defs/Options',
                        ['description'] = '属性能力选项，例如是否弃用、是否是易变属性等',
                        ['param'] = 'Options'
                    }
                },
                ['description'] = '按接口名和属性名查询属性的能力选项'
            },
            ['GetPropertiesByOptions'] = {
                ['req'] = {
                    {['baseType'] = 'String', ['description'] = '接口名', ['param'] = 'Interface'}, {
                        ['baseType'] = 'Struct',
                        ['$ref'] = '#/defs/Options',
                        ['description'] = '属性能力选项，例如是否弃用、是否是易变属性等',
                        ['param'] = 'Options'
                    }
                },
                ['rsp'] = {{['baseType'] = 'String[]', ['description'] = '属性名列表', ['param'] = 'Properties'}},
                ['description'] = '按接口名和能力选项查询符合条件的所有属性'
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Systems/:SystemId/Storage/Controllers/:ControllerId/Ports/:Id'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Systems.Storage.SASMetrics'] = {
            ['property_defaults'] = {
                ['ControllerId'] = sas_metrics_intf_types.ControllerId.default[1],
                ['InvalidDwordCount'] = sas_metrics_intf_types.InvalidDwordCount.default[1],
                ['LossDwordSyncCount'] = sas_metrics_intf_types.LossDwordSyncCount.default[1],
                ['PhyResetProblemCount'] = sas_metrics_intf_types.PhyResetProblemCount.default[1],
                ['RunningDisparityErrorCount'] = sas_metrics_intf_types.RunningDisparityErrorCount.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = sas_metrics_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local DriveInfoTable = {
    ['table_name'] = 't_drive_info',
    ['prop_configs'] = {
        ['Id'] = {
            ['primaryKey'] = true,
            ['baseType'] = 'String',
            ['usage'] = {'PoweroffPer'},
            ['validator'] = drive_info_table_class_types.Id
        }
    },
    ['default_props'] = {['Id'] = drive_info_table_class_types.Id.default[1]}
}

local DrivesTableInfo = {
    ['table_name'] = 't_drives_table_info',
    ['prop_configs'] = {
        ['Id'] = {
            ['primaryKey'] = true,
            ['baseType'] = 'String',
            ['usage'] = {'PoweroffPer'},
            ['validator'] = drives_table_info_class_types.Id
        },
        ['TemperatureCelsius'] = {
            ['baseType'] = 'U8',
            ['usage'] = {'PoweroffPer'},
            ['validator'] = drives_table_info_class_types.TemperatureCelsius
        },
        ['IsAlerted'] = {
            ['baseType'] = 'Boolean',
            ['usage'] = {'PoweroffPer'},
            ['validator'] = drives_table_info_class_types.IsAlerted
        }
    },
    ['default_props'] = {
        ['Id'] = drives_table_info_class_types.Id.default[1],
        ['TemperatureCelsius'] = drives_table_info_class_types.TemperatureCelsius.default[1],
        ['IsAlerted'] = drives_table_info_class_types.IsAlerted.default[1]
    }
}

local DiskPartition = {
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Systems.Storage.DiskPartition'] = {
            ['Name'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = 'os盘符',
                ['validator'] = disk_partition_intf_types.Name
            },
            ['Usage'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = '磁盘分区利用率',
                ['validator'] = disk_partition_intf_types.Usage
            },
            ['UsedCapacityGiB'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['description'] = '硬盘分区当前使用容量',
                ['validator'] = disk_partition_intf_types.UsedCapacityGiB
            },
            ['TotalCapacityGiB'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['description'] = '硬盘分区总容量',
                ['validator'] = disk_partition_intf_types.TotalCapacityGiB
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '对象类名',
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '对象名',
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['description'] = '对象标志符',
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.Object.Properties'] = {
            ['GetOptions'] = {
                ['req'] = {
                    {['baseType'] = 'String', ['description'] = '接口名', ['param'] = 'Interface'},
                    {['baseType'] = 'String', ['description'] = '属性名', ['param'] = 'Property'}
                },
                ['rsp'] = {
                    {
                        ['baseType'] = 'Struct',
                        ['$ref'] = '#/defs/Options',
                        ['description'] = '属性能力选项，例如是否弃用、是否是易变属性等',
                        ['param'] = 'Options'
                    }
                },
                ['description'] = '按接口名和属性名查询属性的能力选项'
            },
            ['GetPropertiesByOptions'] = {
                ['req'] = {
                    {['baseType'] = 'String', ['description'] = '接口名', ['param'] = 'Interface'}, {
                        ['baseType'] = 'Struct',
                        ['$ref'] = '#/defs/Options',
                        ['description'] = '属性能力选项，例如是否弃用、是否是易变属性等',
                        ['param'] = 'Options'
                    }
                },
                ['rsp'] = {{['baseType'] = 'String[]', ['description'] = '属性名列表', ['param'] = 'Properties'}},
                ['description'] = '按接口名和能力选项查询符合条件的所有属性'
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Systems/:SystemId/Storage/DiskPartitions/:Id'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Systems.Storage.DiskPartition'] = {
            ['property_defaults'] = {
                ['Name'] = disk_partition_intf_types.Name.default[1],
                ['Usage'] = disk_partition_intf_types.Usage.default[1],
                ['UsedCapacityGiB'] = disk_partition_intf_types.UsedCapacityGiB.default[1],
                ['TotalCapacityGiB'] = disk_partition_intf_types.TotalCapacityGiB.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = disk_partition_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local StorageReset = {
    ['table_name'] = 't_storage_reset',
    ['prop_configs'] = {
        ['PerId'] = {['primaryKey'] = true, ['baseType'] = 'String', ['validator'] = storage_reset_class_types.PerId},
        ['Key'] = {['primaryKey'] = true, ['baseType'] = 'String', ['validator'] = storage_reset_class_types.Key},
        ['Value'] = {['baseType'] = 'String', ['validator'] = storage_reset_class_types.Value}
    },
    ['default_props'] = {
        ['PerId'] = storage_reset_class_types.PerId.default[1],
        ['Key'] = storage_reset_class_types.Key.default[1],
        ['Value'] = storage_reset_class_types.Value.default[1]
    }
}

local GlobalStorageConfigTable = {
    ['table_name'] = 't_storage_global_config_table',
    ['prop_configs'] = {
        ['Id'] = {
            ['baseType'] = 'String',
            ['primaryKey'] = true,
            ['usage'] = {'PoweroffPer'},
            ['default'] = 'GlobalStorageConfig',
            ['validator'] = global_storage_config_table_class_types.Id
        },
        ['DiskPartitionUsagePercentageThreshold'] = {
            ['baseType'] = 'U8',
            ['default'] = 100,
            ['usage'] = {'PoweroffPer'},
            ['validator'] = global_storage_config_table_class_types.DiskPartitionUsagePercentageThreshold
        }
    },
    ['default_props'] = {['Id'] = 'GlobalStorageConfig', ['DiskPartitionUsagePercentageThreshold'] = 100}
}

local M = {}

function M.init(bus)
    class('StorageConfig', StorageConfig):set_bus(bus)
    class('Controller', Controller):set_bus(bus)
    class('SASPhy', SASPhy):set_bus(bus)
    class('DiskArray', DiskArray):set_bus(bus)
    class('Drive', Drive):set_bus(bus)
    class('Drives', Drives):set_bus(bus)
    class('Volume', Volume):set_bus(bus)
    class('Battery', Battery):set_bus(bus)
    class('Nvme', Nvme):set_bus(bus)
    class('VirtualVPDConnect', VirtualVPDConnect):set_bus(bus)
    class('Port', Port):set_bus(bus)
    class('DriveInfoTable', DriveInfoTable):set_bus(bus)
    class('DrivesTableInfo', DrivesTableInfo):set_bus(bus)
    class('DiskPartition', DiskPartition):set_bus(bus)
    class('StorageReset', StorageReset):set_bus(bus)
    class('GlobalStorageConfigTable', GlobalStorageConfigTable):set_bus(bus)
end

-- The callback needs to be registered during app initialization
function M.ImplStorageConfigPhyBitErrorMockData(cb)
    class('StorageConfig')['bmc.kepler.Debug.Storage.PhyBitError'].MockData = function(obj, ctx, ...)
        local req = phy_bit_error_intf_types.MockDataReq.new(...):validate(nil, nil, true)
        local rsp = phy_bit_error_intf_types.MockDataRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplStorageConfigRecordDriveSpareBlockMockRecordSpareBlock(cb)
    class('StorageConfig')['bmc.kepler.Debug.Storage.RecordDriveSpareBlock'].MockRecordSpareBlock =
        function(obj, ctx, ...)
            local req = record_drive_spare_block_intf_types.MockRecordSpareBlockReq.new(...):validate(nil, nil, true)
            local rsp =
                record_drive_spare_block_intf_types.MockRecordSpareBlockRsp.new(cb(obj, ctx, req:unpack())):validate()
            return rsp:unpack(true)
        end
end

-- The callback needs to be registered during app initialization
function M.ImplStorageConfigPropertiesGetOptions(cb)
    class('StorageConfig')['bmc.kepler.Object.Properties'].GetOptions = function(obj, ctx, ...)
        local req = properties_intf_types.GetOptionsReq.new(...):validate(nil, nil, true)
        local rsp = properties_intf_types.GetOptionsRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplStorageConfigPropertiesGetPropertiesByOptions(cb)
    class('StorageConfig')['bmc.kepler.Object.Properties'].GetPropertiesByOptions = function(obj, ctx, ...)
        local req = properties_intf_types.GetPropertiesByOptionsReq.new(...):validate(nil, nil, true)
        local rsp = properties_intf_types.GetPropertiesByOptionsRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplControllerControllerSetBootDevices(cb)
    class('Controller')['bmc.kepler.Systems.Storage.Controller'].SetBootDevices = function(obj, ctx, ...)
        local req = controller_intf_types.SetBootDevicesReq.new(...):validate(nil, nil, true)
        local rsp = controller_intf_types.SetBootDevicesRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplControllerControllerSetJBODState(cb)
    class('Controller')['bmc.kepler.Systems.Storage.Controller'].SetJBODState = function(obj, ctx, ...)
        local req = controller_intf_types.SetJBODStateReq.new(...):validate(nil, nil, true)
        local rsp = controller_intf_types.SetJBODStateRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplControllerControllerSetSmarterCopyBackState(cb)
    class('Controller')['bmc.kepler.Systems.Storage.Controller'].SetSmarterCopyBackState = function(obj, ctx, ...)
        local req = controller_intf_types.SetSmarterCopyBackStateReq.new(...):validate(nil, nil, true)
        local rsp = controller_intf_types.SetSmarterCopyBackStateRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplControllerControllerRestoreDefaultSettings(cb)
    class('Controller')['bmc.kepler.Systems.Storage.Controller'].RestoreDefaultSettings = function(obj, ctx, ...)
        local req = controller_intf_types.RestoreDefaultSettingsReq.new(...):validate(nil, nil, true)
        local rsp = controller_intf_types.RestoreDefaultSettingsRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplControllerControllerSetCopybackState(cb)
    class('Controller')['bmc.kepler.Systems.Storage.Controller'].SetCopybackState = function(obj, ctx, ...)
        local req = controller_intf_types.SetCopybackStateReq.new(...):validate(nil, nil, true)
        local rsp = controller_intf_types.SetCopybackStateRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplControllerControllerSetWorkMode(cb)
    class('Controller')['bmc.kepler.Systems.Storage.Controller'].SetWorkMode = function(obj, ctx, ...)
        local req = controller_intf_types.SetWorkModeReq.new(...):validate(nil, nil, true)
        local rsp = controller_intf_types.SetWorkModeRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplControllerControllerImportForeignConfig(cb)
    class('Controller')['bmc.kepler.Systems.Storage.Controller'].ImportForeignConfig = function(obj, ctx, ...)
        local req = controller_intf_types.ImportForeignConfigReq.new(...):validate(nil, nil, true)
        local rsp = controller_intf_types.ImportForeignConfigRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplControllerControllerDumpLog(cb)
    class('Controller')['bmc.kepler.Systems.Storage.Controller'].DumpLog = function(obj, ctx, ...)
        local req = controller_intf_types.DumpLogReq.new(...):validate(nil, nil, true)
        local rsp = controller_intf_types.DumpLogRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplControllerControllerClearForeignConfig(cb)
    class('Controller')['bmc.kepler.Systems.Storage.Controller'].ClearForeignConfig = function(obj, ctx, ...)
        local req = controller_intf_types.ClearForeignConfigReq.new(...):validate(nil, nil, true)
        local rsp = controller_intf_types.ClearForeignConfigRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplControllerControllerSetNoBatteryWriteCache(cb)
    class('Controller')['bmc.kepler.Systems.Storage.Controller'].SetNoBatteryWriteCache = function(obj, ctx, ...)
        local req = controller_intf_types.SetNoBatteryWriteCacheReq.new(...):validate(nil, nil, true)
        local rsp = controller_intf_types.SetNoBatteryWriteCacheRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplControllerControllerSetReadCachePercent(cb)
    class('Controller')['bmc.kepler.Systems.Storage.Controller'].SetReadCachePercent = function(obj, ctx, ...)
        local req = controller_intf_types.SetReadCachePercentReq.new(...):validate(nil, nil, true)
        local rsp = controller_intf_types.SetReadCachePercentRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplControllerControllerSetWriteCachePolicy(cb)
    class('Controller')['bmc.kepler.Systems.Storage.Controller'].SetWriteCachePolicy = function(obj, ctx, ...)
        local req = controller_intf_types.SetWriteCachePolicyReq.new(...):validate(nil, nil, true)
        local rsp = controller_intf_types.SetWriteCachePolicyRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplControllerConsistencyCheckEnable(cb)
    class('Controller')['bmc.kepler.Systems.Storage.Controller.ConsistencyCheck'].Enable = function(obj, ctx, ...)
        local req = consistency_check_intf_types.EnableReq.new(...):validate(nil, nil, true)
        local rsp = consistency_check_intf_types.EnableRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplControllerConsistencyCheckDisable(cb)
    class('Controller')['bmc.kepler.Systems.Storage.Controller.ConsistencyCheck'].Disable = function(obj, ctx, ...)
        local req = consistency_check_intf_types.DisableReq.new(...):validate(nil, nil, true)
        local rsp = consistency_check_intf_types.DisableRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplControllerConsistencyCheckSetParameters(cb)
    class('Controller')['bmc.kepler.Systems.Storage.Controller.ConsistencyCheck'].SetParameters =
        function(obj, ctx, ...)
            local req = consistency_check_intf_types.SetParametersReq.new(...):validate(nil, nil, true)
            local rsp = consistency_check_intf_types.SetParametersRsp.new(cb(obj, ctx, req:unpack())):validate()
            return rsp:unpack(true)
        end
end

-- The callback needs to be registered during app initialization
function M.ImplControllerVolumeManageCreateVolumeInNewArray(cb)
    class('Controller')['bmc.kepler.Systems.Storage.Controller.VolumeManage'].CreateVolumeInNewArray =
        function(obj, ctx, ...)
            local req = volume_manage_intf_types.CreateVolumeInNewArrayReq.new(...):validate(nil, nil, true)
            local rsp = volume_manage_intf_types.CreateVolumeInNewArrayRsp.new(cb(obj, ctx, req:unpack())):validate()
            return rsp:unpack(true)
        end
end

-- The callback needs to be registered during app initialization
function M.ImplControllerVolumeManageDeleteVolume(cb)
    class('Controller')['bmc.kepler.Systems.Storage.Controller.VolumeManage'].DeleteVolume = function(obj, ctx, ...)
        local req = volume_manage_intf_types.DeleteVolumeReq.new(...):validate(nil, nil, true)
        local rsp = volume_manage_intf_types.DeleteVolumeRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplControllerVolumeManageCreateVolumeInExisingtArray(cb)
    class('Controller')['bmc.kepler.Systems.Storage.Controller.VolumeManage'].CreateVolumeInExisingtArray = function(
        obj, ctx, ...)
        local req = volume_manage_intf_types.CreateVolumeInExisingtArrayReq.new(...):validate(nil, nil, true)
        local rsp = volume_manage_intf_types.CreateVolumeInExisingtArrayRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplControllerVolumeManageCreateCachecadeVolume(cb)
    class('Controller')['bmc.kepler.Systems.Storage.Controller.VolumeManage'].CreateCachecadeVolume =
        function(obj, ctx, ...)
            local req = volume_manage_intf_types.CreateCachecadeVolumeReq.new(...):validate(nil, nil, true)
            local rsp = volume_manage_intf_types.CreateCachecadeVolumeRsp.new(cb(obj, ctx, req:unpack())):validate()
            return rsp:unpack(true)
        end
end

-- The callback needs to be registered during app initialization
function M.ImplControllerRetirementDataWipe(cb)
    class('Controller')['bmc.kepler.LifeCycle.Retirement'].DataWipe = function(obj, ctx, ...)
        local req = retirement_intf_types.DataWipeReq.new(...):validate(nil, nil, true)
        local rsp = retirement_intf_types.DataWipeRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplControllerRetirementGetReport(cb)
    class('Controller')['bmc.kepler.LifeCycle.Retirement'].GetReport = function(obj, ctx, ...)
        local req = retirement_intf_types.GetReportReq.new(...):validate(nil, nil, true)
        local rsp = retirement_intf_types.GetReportRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplControllerPropertiesGetOptions(cb)
    class('Controller')['bmc.kepler.Object.Properties'].GetOptions = function(obj, ctx, ...)
        local req = properties_intf_types.GetOptionsReq.new(...):validate(nil, nil, true)
        local rsp = properties_intf_types.GetOptionsRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplControllerPropertiesGetPropertiesByOptions(cb)
    class('Controller')['bmc.kepler.Object.Properties'].GetPropertiesByOptions = function(obj, ctx, ...)
        local req = properties_intf_types.GetPropertiesByOptionsReq.new(...):validate(nil, nil, true)
        local rsp = properties_intf_types.GetPropertiesByOptionsRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplSASPhyPropertiesGetOptions(cb)
    class('SASPhy')['bmc.kepler.Object.Properties'].GetOptions = function(obj, ctx, ...)
        local req = properties_intf_types.GetOptionsReq.new(...):validate(nil, nil, true)
        local rsp = properties_intf_types.GetOptionsRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplSASPhyPropertiesGetPropertiesByOptions(cb)
    class('SASPhy')['bmc.kepler.Object.Properties'].GetPropertiesByOptions = function(obj, ctx, ...)
        local req = properties_intf_types.GetPropertiesByOptionsReq.new(...):validate(nil, nil, true)
        local rsp = properties_intf_types.GetPropertiesByOptionsRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDiskArrayPropertiesGetOptions(cb)
    class('DiskArray')['bmc.kepler.Object.Properties'].GetOptions = function(obj, ctx, ...)
        local req = properties_intf_types.GetOptionsReq.new(...):validate(nil, nil, true)
        local rsp = properties_intf_types.GetOptionsRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDiskArrayPropertiesGetPropertiesByOptions(cb)
    class('DiskArray')['bmc.kepler.Object.Properties'].GetPropertiesByOptions = function(obj, ctx, ...)
        local req = properties_intf_types.GetPropertiesByOptionsReq.new(...):validate(nil, nil, true)
        local rsp = properties_intf_types.GetPropertiesByOptionsRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDriveDriveSetLocationIndicatorState(cb)
    class('Drive')['bmc.kepler.Systems.Storage.Drive'].SetLocationIndicatorState = function(obj, ctx, ...)
        local req = drive_intf_types.SetLocationIndicatorStateReq.new(...):validate(nil, nil, true)
        local rsp = drive_intf_types.SetLocationIndicatorStateRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDriveDriveSetFaultIndicatorState(cb)
    class('Drive')['bmc.kepler.Systems.Storage.Drive'].SetFaultIndicatorState = function(obj, ctx, ...)
        local req = drive_intf_types.SetFaultIndicatorStateReq.new(...):validate(nil, nil, true)
        local rsp = drive_intf_types.SetFaultIndicatorStateRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDriveDriveSetFirmwareStatus(cb)
    class('Drive')['bmc.kepler.Systems.Storage.Drive'].SetFirmwareStatus = function(obj, ctx, ...)
        local req = drive_intf_types.SetFirmwareStatusReq.new(...):validate(nil, nil, true)
        local rsp = drive_intf_types.SetFirmwareStatusRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDriveDriveSetHotspareType(cb)
    class('Drive')['bmc.kepler.Systems.Storage.Drive'].SetHotspareType = function(obj, ctx, ...)
        local req = drive_intf_types.SetHotspareTypeReq.new(...):validate(nil, nil, true)
        local rsp = drive_intf_types.SetHotspareTypeRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDriveDriveSetBootPriority(cb)
    class('Drive')['bmc.kepler.Systems.Storage.Drive'].SetBootPriority = function(obj, ctx, ...)
        local req = drive_intf_types.SetBootPriorityReq.new(...):validate(nil, nil, true)
        local rsp = drive_intf_types.SetBootPriorityRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDriveDriveSetPatrolState(cb)
    class('Drive')['bmc.kepler.Systems.Storage.Drive'].SetPatrolState = function(obj, ctx, ...)
        local req = drive_intf_types.SetPatrolStateReq.new(...):validate(nil, nil, true)
        local rsp = drive_intf_types.SetPatrolStateRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDriveDriveCryptoErase(cb)
    class('Drive')['bmc.kepler.Systems.Storage.Drive'].CryptoErase = function(obj, ctx, ...)
        local req = drive_intf_types.CryptoEraseReq.new(...):validate(nil, nil, true)
        local rsp = drive_intf_types.CryptoEraseRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDriveMetricGetData(cb)
    class('Drive')['bmc.kepler.Metric'].GetData = function(obj, ctx, ...)
        local req = metric_intf_types.GetDataReq.new(...):validate(nil, nil, true)
        local rsp = metric_intf_types.GetDataRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDriveMetricGetItems(cb)
    class('Drive')['bmc.kepler.Metric'].GetItems = function(obj, ctx, ...)
        local req = metric_intf_types.GetItemsReq.new(...):validate(nil, nil, true)
        local rsp = metric_intf_types.GetItemsRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDriveMetricSynDataAcquisitionEnable(cb)
    class('Drive')['bmc.kepler.Metric'].SynDataAcquisitionEnable = function(obj, ctx, ...)
        local req = metric_intf_types.SynDataAcquisitionEnableReq.new(...):validate(nil, nil, true)
        local rsp = metric_intf_types.SynDataAcquisitionEnableRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDrivePropertiesGetOptions(cb)
    class('Drive')['bmc.kepler.Object.Properties'].GetOptions = function(obj, ctx, ...)
        local req = properties_intf_types.GetOptionsReq.new(...):validate(nil, nil, true)
        local rsp = properties_intf_types.GetOptionsRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDrivePropertiesGetPropertiesByOptions(cb)
    class('Drive')['bmc.kepler.Object.Properties'].GetPropertiesByOptions = function(obj, ctx, ...)
        local req = properties_intf_types.GetPropertiesByOptionsReq.new(...):validate(nil, nil, true)
        local rsp = properties_intf_types.GetPropertiesByOptionsRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDrivesDrivesCollectIODeteriorationDiagInfo(cb)
    class('Drives')['bmc.kepler.Systems.Storage.Drives'].CollectIODeteriorationDiagInfo = function(obj, ctx, ...)
        local req = drives_intf_types.CollectIODeteriorationDiagInfoReq.new(...):validate(nil, nil, true)
        local rsp = drives_intf_types.CollectIODeteriorationDiagInfoRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDrivesDrivesGetDrivesSubHealthDiagInfo(cb)
    class('Drives')['bmc.kepler.Systems.Storage.Drives'].GetDrivesSubHealthDiagInfo = function(obj, ctx, ...)
        local req = drives_intf_types.GetDrivesSubHealthDiagInfoReq.new(...):validate(nil, nil, true)
        local rsp = drives_intf_types.GetDrivesSubHealthDiagInfoRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDrivesDrivesGetNvmeDriveRawData(cb)
    class('Drives')['bmc.kepler.Systems.Storage.Drives'].GetNvmeDriveRawData = function(obj, ctx, ...)
        local req = drives_intf_types.GetNvmeDriveRawDataReq.new(...):validate(nil, nil, true)
        local rsp = drives_intf_types.GetNvmeDriveRawDataRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDrivesDrivesGetNvmeDriveCount(cb)
    class('Drives')['bmc.kepler.Systems.Storage.Drives'].GetNvmeDriveCount = function(obj, ctx, ...)
        local req = drives_intf_types.GetNvmeDriveCountReq.new(...):validate(nil, nil, true)
        local rsp = drives_intf_types.GetNvmeDriveCountRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDrivesDrivesSetDriveSubHealthDiagResult(cb)
    class('Drives')['bmc.kepler.Systems.Storage.Drives'].SetDriveSubHealthDiagResult = function(obj, ctx, ...)
        local req = drives_intf_types.SetDriveSubHealthDiagResultReq.new(...):validate(nil, nil, true)
        local rsp = drives_intf_types.SetDriveSubHealthDiagResultRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDrivesPropertiesGetOptions(cb)
    class('Drives')['bmc.kepler.Object.Properties'].GetOptions = function(obj, ctx, ...)
        local req = properties_intf_types.GetOptionsReq.new(...):validate(nil, nil, true)
        local rsp = properties_intf_types.GetOptionsRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDrivesPropertiesGetPropertiesByOptions(cb)
    class('Drives')['bmc.kepler.Object.Properties'].GetPropertiesByOptions = function(obj, ctx, ...)
        local req = properties_intf_types.GetPropertiesByOptionsReq.new(...):validate(nil, nil, true)
        local rsp = properties_intf_types.GetPropertiesByOptionsRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplVolumeVolumeSetName(cb)
    class('Volume')['bmc.kepler.Systems.Storage.Volume'].SetName = function(obj, ctx, ...)
        local req = volume_intf_types.SetNameReq.new(...):validate(nil, nil, true)
        local rsp = volume_intf_types.SetNameRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplVolumeVolumeSetReadPolicy(cb)
    class('Volume')['bmc.kepler.Systems.Storage.Volume'].SetReadPolicy = function(obj, ctx, ...)
        local req = volume_intf_types.SetReadPolicyReq.new(...):validate(nil, nil, true)
        local rsp = volume_intf_types.SetReadPolicyRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplVolumeVolumeSetWritePolicy(cb)
    class('Volume')['bmc.kepler.Systems.Storage.Volume'].SetWritePolicy = function(obj, ctx, ...)
        local req = volume_intf_types.SetWritePolicyReq.new(...):validate(nil, nil, true)
        local rsp = volume_intf_types.SetWritePolicyRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplVolumeVolumeSetBootable(cb)
    class('Volume')['bmc.kepler.Systems.Storage.Volume'].SetBootable = function(obj, ctx, ...)
        local req = volume_intf_types.SetBootableReq.new(...):validate(nil, nil, true)
        local rsp = volume_intf_types.SetBootableRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplVolumeVolumeSetIOPolicy(cb)
    class('Volume')['bmc.kepler.Systems.Storage.Volume'].SetIOPolicy = function(obj, ctx, ...)
        local req = volume_intf_types.SetIOPolicyReq.new(...):validate(nil, nil, true)
        local rsp = volume_intf_types.SetIOPolicyRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplVolumeVolumeSetBGIEnable(cb)
    class('Volume')['bmc.kepler.Systems.Storage.Volume'].SetBGIEnable = function(obj, ctx, ...)
        local req = volume_intf_types.SetBGIEnableReq.new(...):validate(nil, nil, true)
        local rsp = volume_intf_types.SetBGIEnableRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplVolumeVolumeSetAccessPolicy(cb)
    class('Volume')['bmc.kepler.Systems.Storage.Volume'].SetAccessPolicy = function(obj, ctx, ...)
        local req = volume_intf_types.SetAccessPolicyReq.new(...):validate(nil, nil, true)
        local rsp = volume_intf_types.SetAccessPolicyRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplVolumeVolumeSetDiskCachePolicy(cb)
    class('Volume')['bmc.kepler.Systems.Storage.Volume'].SetDiskCachePolicy = function(obj, ctx, ...)
        local req = volume_intf_types.SetDiskCachePolicyReq.new(...):validate(nil, nil, true)
        local rsp = volume_intf_types.SetDiskCachePolicyRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplVolumeVolumeStartForegroundInit(cb)
    class('Volume')['bmc.kepler.Systems.Storage.Volume'].StartForegroundInit = function(obj, ctx, ...)
        local req = volume_intf_types.StartForegroundInitReq.new(...):validate(nil, nil, true)
        local rsp = volume_intf_types.StartForegroundInitRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplVolumeVolumeCancelForegroundInit(cb)
    class('Volume')['bmc.kepler.Systems.Storage.Volume'].CancelForegroundInit = function(obj, ctx, ...)
        local req = volume_intf_types.CancelForegroundInitReq.new(...):validate(nil, nil, true)
        local rsp = volume_intf_types.CancelForegroundInitRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplVolumeVolumeSetCachecadeEnable(cb)
    class('Volume')['bmc.kepler.Systems.Storage.Volume'].SetCachecadeEnable = function(obj, ctx, ...)
        local req = volume_intf_types.SetCachecadeEnableReq.new(...):validate(nil, nil, true)
        local rsp = volume_intf_types.SetCachecadeEnableRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplVolumeVolumeSetAccelerator(cb)
    class('Volume')['bmc.kepler.Systems.Storage.Volume'].SetAccelerator = function(obj, ctx, ...)
        local req = volume_intf_types.SetAcceleratorReq.new(...):validate(nil, nil, true)
        local rsp = volume_intf_types.SetAcceleratorRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplVolumeVolumeSetCapacitySize(cb)
    class('Volume')['bmc.kepler.Systems.Storage.Volume'].SetCapacitySize = function(obj, ctx, ...)
        local req = volume_intf_types.SetCapacitySizeReq.new(...):validate(nil, nil, true)
        local rsp = volume_intf_types.SetCapacitySizeRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplVolumeVolumeSetStripSize(cb)
    class('Volume')['bmc.kepler.Systems.Storage.Volume'].SetStripSize = function(obj, ctx, ...)
        local req = volume_intf_types.SetStripSizeReq.new(...):validate(nil, nil, true)
        local rsp = volume_intf_types.SetStripSizeRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplVolumePropertiesGetOptions(cb)
    class('Volume')['bmc.kepler.Object.Properties'].GetOptions = function(obj, ctx, ...)
        local req = properties_intf_types.GetOptionsReq.new(...):validate(nil, nil, true)
        local rsp = properties_intf_types.GetOptionsRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplVolumePropertiesGetPropertiesByOptions(cb)
    class('Volume')['bmc.kepler.Object.Properties'].GetPropertiesByOptions = function(obj, ctx, ...)
        local req = properties_intf_types.GetPropertiesByOptionsReq.new(...):validate(nil, nil, true)
        local rsp = properties_intf_types.GetPropertiesByOptionsRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplBatteryPropertiesGetOptions(cb)
    class('Battery')['bmc.kepler.Object.Properties'].GetOptions = function(obj, ctx, ...)
        local req = properties_intf_types.GetOptionsReq.new(...):validate(nil, nil, true)
        local rsp = properties_intf_types.GetOptionsRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplBatteryPropertiesGetPropertiesByOptions(cb)
    class('Battery')['bmc.kepler.Object.Properties'].GetPropertiesByOptions = function(obj, ctx, ...)
        local req = properties_intf_types.GetPropertiesByOptionsReq.new(...):validate(nil, nil, true)
        local rsp = properties_intf_types.GetPropertiesByOptionsRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplPortPropertiesGetOptions(cb)
    class('Port')['bmc.kepler.Object.Properties'].GetOptions = function(obj, ctx, ...)
        local req = properties_intf_types.GetOptionsReq.new(...):validate(nil, nil, true)
        local rsp = properties_intf_types.GetOptionsRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplPortPropertiesGetPropertiesByOptions(cb)
    class('Port')['bmc.kepler.Object.Properties'].GetPropertiesByOptions = function(obj, ctx, ...)
        local req = properties_intf_types.GetPropertiesByOptionsReq.new(...):validate(nil, nil, true)
        local rsp = properties_intf_types.GetPropertiesByOptionsRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDiskPartitionPropertiesGetOptions(cb)
    class('DiskPartition')['bmc.kepler.Object.Properties'].GetOptions = function(obj, ctx, ...)
        local req = properties_intf_types.GetOptionsReq.new(...):validate(nil, nil, true)
        local rsp = properties_intf_types.GetOptionsRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDiskPartitionPropertiesGetPropertiesByOptions(cb)
    class('DiskPartition')['bmc.kepler.Object.Properties'].GetPropertiesByOptions = function(obj, ctx, ...)
        local req = properties_intf_types.GetPropertiesByOptionsReq.new(...):validate(nil, nil, true)
        local rsp = properties_intf_types.GetPropertiesByOptionsRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

return M
