-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

-- Description: Constants for sel.
local sel_const = {}
sel_const.__index = sel_const

-- SEL 格式版本号
sel_const.IPMI_SEL_VER = 0x51

-- SEL 预约ID，同SDR的预约ID
sel_const.RESERVE_ID_INIT = 0x1234

-- SEL 最大数目
sel_const.SEL_TOTOAL_NUM = 2000

-- SEL 每条记录大小
sel_const.SEL_ITEM_SIZE = 16

-- SEL 日志使能
sel_const.SEL_LOG_ENABLE = 1
sel_const.SEL_LOG_DISABLE = 0

-- SEL 日志访问权限
sel_const.SEL_LOG_NO_ACCESSABLE = 1
sel_const.SEL_LOG_ACCESSABLE = 1

-- SEL 清除操作命令字
sel_const.SEL_ERASE_INITIATE = 0xaa
sel_const.SEL_ERASE_GET_STATE = 0x00

-- SEL 清除状态
sel_const.SEL_CLEAR_INPROGRESS = 0
sel_const.SEL_CLEAR_COMPLETED = 1

-- SEL 无传感器对应填充
sel_const.SEL_NO_SENSOR = "NoSensor"
sel_const.SEL_NO_ENTITY = "NoEntity"
sel_const.SEL_NO_ENTITY_TYPE = "NoEntityType"

-- 传感器事件接收标记
sel_const.EVENT_RECEIVER_DISABLE = 0xFF
sel_const.EVENT_RECEIVER_SMM = 0x20

-- SEL 日志类型
sel_const.SEL_RECORD_TYPE_SYS = 0x02

-- Boot Error 故障代码
sel_const.NO_BOOT_DEV = 0
sel_const.NO_BOOT_DISK = 1
sel_const.PXE_SVR_ERR = 2
sel_const.INVALID_BOOT_DEV = 3
sel_const.TIMEOUT_FOR_SELECTION = 4
sel_const.CPU_EEPROM_READ_FAIL = 5

sel_const.CLEAR_AFTER_FULL = 0
sel_const.ROTATE_AFTER_FULL = 1

-- OS Boot 故障代码
sel_const.BOOT_COMPLETED = 6

-- 匹配sys/bmc复位事件
sel_const.SYS_RESET_SENSOR_TYPE = 0x1D
sel_const.BMC_RESET_SENSOR_TYPE = 0x16
sel_const.BMC_RESET_EVENT_TYPE = 0x09
-- 匹配版本变更事件
sel_const.VERCHANGE_SENSOR_TYPE = 0x2B
-- 匹配热拔插事件
sel_const.HOTSWAP_SENSOR_TYPE = 0xF0

-- 上报管理板IPMI请求的netfn及cmd
sel_const.PLATFORM_EVENT_NETFN = 0x04
sel_const.PLATFORM_EVENT_CMD = 0x02

return sel_const