-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

-- Description: Specified constraits in ipmi commands implementation.
local const  = {}
const.__index = const

-- SDR仓库支持的最大SDR条数
const.SDR_MAX_NUMBER = 65535

-- SDR仓库预约ID初始值
const.SDR_RESERVE_ID_INIT = 0x1234

-- SDR的最大长度
const.SDR_MAX_LEN = 64

-- SDR类型定义
const.SDR_TYPE_FULL = 0x01
const.SDR_TYPE_COMPACT = 0x02
const.SDR_TYPE_EVENTONLY = 0x03
const.SDR_TYPE_EA = 0x08
const.SDR_TYPE_DEA = 0x09
const.SDR_TYPE_GDL = 0x10
const.SDR_TYPE_FDL = 0x11
const.SDR_TYPE_MCDL = 0x12
const.SDR_TYPE_MCC = 0x13
const.SDR_TYPE_BMCI = 0x14
const.SDR_TYPE_OEMC0 = 0xC0

-- 不同SDR数据的基本长度定义
const.SDR_TYPE_FULL_LEN = (48 - 5)
const.SDR_TYPE_COMPACT_LEN = (32 - 5)
const.SDR_TYPE_EVENTONLY_LEN = (17 - 5)
const.SDR_TYPE_EA_LEN = (16 - 5)
const.SDR_TYPE_DEA_LEN = (32 - 5)
const.SDR_TYPE_GDL_LEN = (16 - 5)
const.SDR_TYPE_FDL_LEN = (16 - 5)
const.SDR_TYPE_MCDL_LEN = (16 - 5)
const.SDR_TYPE_MCC_LEN = (32 - 5)
const.SDR_TYPE_BMCI_LEN = (16 - 5)
const.SDR_TYPE_OEMC0_LEN = (8 - 5)


-- SDR版本定义
const.SDR_VERSION = 0x51

-- SDR存储类型，本地或者远端
const.LOCAL_SDR = 0x00
const.AMC_MODULE_SDR = 0x01

-- SDR设备的更新状态
const.SDRDEV_NORMAL_MODE = 0
const.SDRDEV_UPDATE_MODE = 1

-- SDR设备的更新Owner
const.SDR_UPDATING_BY_MYSELF = 0
const.SDR_UPDATING_BY_OTHER = 1
const.SDR_NO_UPDATING = 2

-- PARTIAL ADD的操作状态
const.SDR_PARTIAL_ADD_IN_PROGRESS = 0
const.SDR_PARTIAL_ADD_FINISHED = 1

-- SDR清除操作命令字
const.SDR_ERASE_INITIATE = 0xaa
const.SDR_ERASE_GET_STATE = 0x00


-- SDR支持的操作类型
const.SDR_OP_GET_SDR_REPOSITORY_ALLOCATION = 0x01
const.SDR_OP_RESERVE_SDR_REPOSITORY = 0x02
const.SDR_OP_PARTIAL_ADD_SDR = 0x04
const.SDR_OP_DELETE_SDR = 0x08
-- BIT4保留不使用
-- BIT5/6判断modal/non-modal类型
const.SDR_OP_SDR_NON_MODAL = 0x20
const.SDR_OP_SDR_MODAL = 0x40
const.SDR_OP_SDR_MODAL_BOTH = 0x60
const.SDR_OP_OVERFLOW_FLAG = 0x80

-- SDR哪个LUN有传感器
const.LUN0_HAS_SENSOR = 0x01
const.LUN1_HAS_SENSOR = 0x02
const.LUN2_HAS_SENSOR = 0x04
const.LUN3_HAS_SENSOR = 0x08

-- LUN的最大个数
const.SENSOR_LUN_NUM = 0x04

-- SDR发布类型
const.SDR_POPULATION_STATIC = 0
const.SDR_POPULATION_DYNAMIC = 1

-- SDR 设备更新Owner
const.SDR_UPDATING_BY_MYSELF = 0
const.SDR_UPDATING_BY_OTHER = 1
const.SDR_NO_UPDATING = 2

-- SDR 设备更新状态
const.SDRDEV_NORMAL_MODE = 0
const.SDRDEV_UPDATE_MODE = 1

-- 公共管理标识为0
const.PUBLIC_SYSTEM_ID = 0

return const