-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local ThresholdSensor = {}

---@class ThresholdSensor.OriginalReading
---@field OriginalReading number
local TOriginalReading = {}
TOriginalReading.__index = TOriginalReading
TOriginalReading.group = {}

local function TOriginalReading_from_obj(obj)
    return setmetatable(obj, TOriginalReading)
end

function TOriginalReading.new(OriginalReading)
    return TOriginalReading_from_obj({OriginalReading = OriginalReading or 0})
end
---@param obj ThresholdSensor.OriginalReading
function TOriginalReading:init_from_obj(obj)
    self.OriginalReading = obj.OriginalReading or 0
end

function TOriginalReading:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TOriginalReading.group)
end

TOriginalReading.from_obj = TOriginalReading_from_obj

TOriginalReading.proto_property = {'OriginalReading'}

TOriginalReading.default = {0}

TOriginalReading.struct = {{name = 'OriginalReading', is_array = false, struct = nil}}

function TOriginalReading:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'OriginalReading', self.OriginalReading, 'double', true, errs, need_convert)

    TOriginalReading:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TOriginalReading.proto_property, errs, need_convert)
    return self
end

function TOriginalReading:unpack(_)
    return self.OriginalReading
end

ThresholdSensor.OriginalReading = TOriginalReading

---@class ThresholdSensor.ReadingStatus
---@field ReadingStatus integer
local TReadingStatus = {}
TReadingStatus.__index = TReadingStatus
TReadingStatus.group = {}

local function TReadingStatus_from_obj(obj)
    return setmetatable(obj, TReadingStatus)
end

function TReadingStatus.new(ReadingStatus)
    return TReadingStatus_from_obj({ReadingStatus = ReadingStatus or 0})
end
---@param obj ThresholdSensor.ReadingStatus
function TReadingStatus:init_from_obj(obj)
    self.ReadingStatus = obj.ReadingStatus or 0
end

function TReadingStatus:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TReadingStatus.group)
end

TReadingStatus.from_obj = TReadingStatus_from_obj

TReadingStatus.proto_property = {'ReadingStatus'}

TReadingStatus.default = {0}

TReadingStatus.struct = {{name = 'ReadingStatus', is_array = false, struct = nil}}

function TReadingStatus:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ReadingStatus', self.ReadingStatus, 'uint8', true, errs, need_convert)

    TReadingStatus:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TReadingStatus.proto_property, errs, need_convert)
    return self
end

function TReadingStatus:unpack(_)
    return self.ReadingStatus
end

ThresholdSensor.ReadingStatus = TReadingStatus

---@class ThresholdSensor.Reading
---@field Reading integer
local TReading = {}
TReading.__index = TReading
TReading.group = {}

local function TReading_from_obj(obj)
    return setmetatable(obj, TReading)
end

function TReading.new(Reading)
    return TReading_from_obj({Reading = Reading or 0})
end
---@param obj ThresholdSensor.Reading
function TReading:init_from_obj(obj)
    self.Reading = obj.Reading or 0
end

function TReading:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TReading.group)
end

TReading.from_obj = TReading_from_obj

TReading.proto_property = {'Reading'}

TReading.default = {0}

TReading.struct = {{name = 'Reading', is_array = false, struct = nil}}

function TReading:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Reading', self.Reading, 'uint8', true, errs, need_convert)

    TReading:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TReading.proto_property, errs, need_convert)
    return self
end

function TReading:unpack(_)
    return self.Reading
end

ThresholdSensor.Reading = TReading

---@class ThresholdSensor.OwnerLun
---@field OwnerLun integer
local TOwnerLun = {}
TOwnerLun.__index = TOwnerLun
TOwnerLun.group = {}

local function TOwnerLun_from_obj(obj)
    return setmetatable(obj, TOwnerLun)
end

function TOwnerLun.new(OwnerLun)
    return TOwnerLun_from_obj({OwnerLun = OwnerLun or 0})
end
---@param obj ThresholdSensor.OwnerLun
function TOwnerLun:init_from_obj(obj)
    self.OwnerLun = obj.OwnerLun or 0
end

function TOwnerLun:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TOwnerLun.group)
end

TOwnerLun.from_obj = TOwnerLun_from_obj

TOwnerLun.proto_property = {'OwnerLun'}

TOwnerLun.default = {0}

TOwnerLun.struct = {{name = 'OwnerLun', is_array = false, struct = nil}}

function TOwnerLun:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'OwnerLun', self.OwnerLun, 'uint8', true, errs, need_convert)

    TOwnerLun:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TOwnerLun.proto_property, errs, need_convert)
    return self
end

function TOwnerLun:unpack(_)
    return self.OwnerLun
end

ThresholdSensor.OwnerLun = TOwnerLun

---@class ThresholdSensor.SensorNumber
---@field SensorNumber integer
local TSensorNumber = {}
TSensorNumber.__index = TSensorNumber
TSensorNumber.group = {}

local function TSensorNumber_from_obj(obj)
    return setmetatable(obj, TSensorNumber)
end

function TSensorNumber.new(SensorNumber)
    return TSensorNumber_from_obj({SensorNumber = SensorNumber or 255})
end
---@param obj ThresholdSensor.SensorNumber
function TSensorNumber:init_from_obj(obj)
    self.SensorNumber = obj.SensorNumber or 255
end

function TSensorNumber:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSensorNumber.group)
end

TSensorNumber.from_obj = TSensorNumber_from_obj

TSensorNumber.proto_property = {'SensorNumber'}

TSensorNumber.default = {0}

TSensorNumber.struct = {{name = 'SensorNumber', is_array = false, struct = nil}}

function TSensorNumber:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SensorNumber', self.SensorNumber, 'uint8', true, errs, need_convert)

    TSensorNumber:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSensorNumber.proto_property, errs, need_convert)
    return self
end

function TSensorNumber:unpack(_)
    return self.SensorNumber
end

ThresholdSensor.SensorNumber = TSensorNumber

---@class ThresholdSensor.NegativeHysteresis
---@field NegativeHysteresis integer
local TNegativeHysteresis = {}
TNegativeHysteresis.__index = TNegativeHysteresis
TNegativeHysteresis.group = {}

local function TNegativeHysteresis_from_obj(obj)
    return setmetatable(obj, TNegativeHysteresis)
end

function TNegativeHysteresis.new(NegativeHysteresis)
    return TNegativeHysteresis_from_obj({NegativeHysteresis = NegativeHysteresis or 0})
end
---@param obj ThresholdSensor.NegativeHysteresis
function TNegativeHysteresis:init_from_obj(obj)
    self.NegativeHysteresis = obj.NegativeHysteresis or 0
end

function TNegativeHysteresis:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TNegativeHysteresis.group)
end

TNegativeHysteresis.from_obj = TNegativeHysteresis_from_obj

TNegativeHysteresis.proto_property = {'NegativeHysteresis'}

TNegativeHysteresis.default = {0}

TNegativeHysteresis.struct = {{name = 'NegativeHysteresis', is_array = false, struct = nil}}

function TNegativeHysteresis:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'NegativeHysteresis', self.NegativeHysteresis, 'uint8', true, errs, need_convert)

    TNegativeHysteresis:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TNegativeHysteresis.proto_property, errs, need_convert)
    return self
end

function TNegativeHysteresis:unpack(_)
    return self.NegativeHysteresis
end

ThresholdSensor.NegativeHysteresis = TNegativeHysteresis

---@class ThresholdSensor.PositiveHysteresis
---@field PositiveHysteresis integer
local TPositiveHysteresis = {}
TPositiveHysteresis.__index = TPositiveHysteresis
TPositiveHysteresis.group = {}

local function TPositiveHysteresis_from_obj(obj)
    return setmetatable(obj, TPositiveHysteresis)
end

function TPositiveHysteresis.new(PositiveHysteresis)
    return TPositiveHysteresis_from_obj({PositiveHysteresis = PositiveHysteresis or 0})
end
---@param obj ThresholdSensor.PositiveHysteresis
function TPositiveHysteresis:init_from_obj(obj)
    self.PositiveHysteresis = obj.PositiveHysteresis or 0
end

function TPositiveHysteresis:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPositiveHysteresis.group)
end

TPositiveHysteresis.from_obj = TPositiveHysteresis_from_obj

TPositiveHysteresis.proto_property = {'PositiveHysteresis'}

TPositiveHysteresis.default = {0}

TPositiveHysteresis.struct = {{name = 'PositiveHysteresis', is_array = false, struct = nil}}

function TPositiveHysteresis:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PositiveHysteresis', self.PositiveHysteresis, 'uint8', true, errs, need_convert)

    TPositiveHysteresis:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPositiveHysteresis.proto_property, errs, need_convert)
    return self
end

function TPositiveHysteresis:unpack(_)
    return self.PositiveHysteresis
end

ThresholdSensor.PositiveHysteresis = TPositiveHysteresis

---@class ThresholdSensor.LowerCritical
---@field LowerCritical integer
local TLowerCritical = {}
TLowerCritical.__index = TLowerCritical
TLowerCritical.group = {}

local function TLowerCritical_from_obj(obj)
    return setmetatable(obj, TLowerCritical)
end

function TLowerCritical.new(LowerCritical)
    return TLowerCritical_from_obj({LowerCritical = LowerCritical or 0})
end
---@param obj ThresholdSensor.LowerCritical
function TLowerCritical:init_from_obj(obj)
    self.LowerCritical = obj.LowerCritical or 0
end

function TLowerCritical:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLowerCritical.group)
end

TLowerCritical.from_obj = TLowerCritical_from_obj

TLowerCritical.proto_property = {'LowerCritical'}

TLowerCritical.default = {0}

TLowerCritical.struct = {{name = 'LowerCritical', is_array = false, struct = nil}}

function TLowerCritical:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'LowerCritical', self.LowerCritical, 'uint8', true, errs, need_convert)

    TLowerCritical:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLowerCritical.proto_property, errs, need_convert)
    return self
end

function TLowerCritical:unpack(_)
    return self.LowerCritical
end

ThresholdSensor.LowerCritical = TLowerCritical

---@class ThresholdSensor.LowerNoncritical
---@field LowerNoncritical integer
local TLowerNoncritical = {}
TLowerNoncritical.__index = TLowerNoncritical
TLowerNoncritical.group = {}

local function TLowerNoncritical_from_obj(obj)
    return setmetatable(obj, TLowerNoncritical)
end

function TLowerNoncritical.new(LowerNoncritical)
    return TLowerNoncritical_from_obj({LowerNoncritical = LowerNoncritical or 0})
end
---@param obj ThresholdSensor.LowerNoncritical
function TLowerNoncritical:init_from_obj(obj)
    self.LowerNoncritical = obj.LowerNoncritical or 0
end

function TLowerNoncritical:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLowerNoncritical.group)
end

TLowerNoncritical.from_obj = TLowerNoncritical_from_obj

TLowerNoncritical.proto_property = {'LowerNoncritical'}

TLowerNoncritical.default = {0}

TLowerNoncritical.struct = {{name = 'LowerNoncritical', is_array = false, struct = nil}}

function TLowerNoncritical:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'LowerNoncritical', self.LowerNoncritical, 'uint8', true, errs, need_convert)

    TLowerNoncritical:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLowerNoncritical.proto_property, errs, need_convert)
    return self
end

function TLowerNoncritical:unpack(_)
    return self.LowerNoncritical
end

ThresholdSensor.LowerNoncritical = TLowerNoncritical

---@class ThresholdSensor.LowerNonrecoverable
---@field LowerNonrecoverable integer
local TLowerNonrecoverable = {}
TLowerNonrecoverable.__index = TLowerNonrecoverable
TLowerNonrecoverable.group = {}

local function TLowerNonrecoverable_from_obj(obj)
    return setmetatable(obj, TLowerNonrecoverable)
end

function TLowerNonrecoverable.new(LowerNonrecoverable)
    return TLowerNonrecoverable_from_obj({LowerNonrecoverable = LowerNonrecoverable or 0})
end
---@param obj ThresholdSensor.LowerNonrecoverable
function TLowerNonrecoverable:init_from_obj(obj)
    self.LowerNonrecoverable = obj.LowerNonrecoverable or 0
end

function TLowerNonrecoverable:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLowerNonrecoverable.group)
end

TLowerNonrecoverable.from_obj = TLowerNonrecoverable_from_obj

TLowerNonrecoverable.proto_property = {'LowerNonrecoverable'}

TLowerNonrecoverable.default = {0}

TLowerNonrecoverable.struct = {{name = 'LowerNonrecoverable', is_array = false, struct = nil}}

function TLowerNonrecoverable:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'LowerNonrecoverable', self.LowerNonrecoverable, 'uint8', true, errs, need_convert)

    TLowerNonrecoverable:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLowerNonrecoverable.proto_property, errs, need_convert)
    return self
end

function TLowerNonrecoverable:unpack(_)
    return self.LowerNonrecoverable
end

ThresholdSensor.LowerNonrecoverable = TLowerNonrecoverable

---@class ThresholdSensor.UpperNoncritical
---@field UpperNoncritical integer
local TUpperNoncritical = {}
TUpperNoncritical.__index = TUpperNoncritical
TUpperNoncritical.group = {}

local function TUpperNoncritical_from_obj(obj)
    return setmetatable(obj, TUpperNoncritical)
end

function TUpperNoncritical.new(UpperNoncritical)
    return TUpperNoncritical_from_obj({UpperNoncritical = UpperNoncritical or 0})
end
---@param obj ThresholdSensor.UpperNoncritical
function TUpperNoncritical:init_from_obj(obj)
    self.UpperNoncritical = obj.UpperNoncritical or 0
end

function TUpperNoncritical:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUpperNoncritical.group)
end

TUpperNoncritical.from_obj = TUpperNoncritical_from_obj

TUpperNoncritical.proto_property = {'UpperNoncritical'}

TUpperNoncritical.default = {0}

TUpperNoncritical.struct = {{name = 'UpperNoncritical', is_array = false, struct = nil}}

function TUpperNoncritical:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'UpperNoncritical', self.UpperNoncritical, 'uint8', true, errs, need_convert)

    TUpperNoncritical:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUpperNoncritical.proto_property, errs, need_convert)
    return self
end

function TUpperNoncritical:unpack(_)
    return self.UpperNoncritical
end

ThresholdSensor.UpperNoncritical = TUpperNoncritical

---@class ThresholdSensor.UpperCritical
---@field UpperCritical integer
local TUpperCritical = {}
TUpperCritical.__index = TUpperCritical
TUpperCritical.group = {}

local function TUpperCritical_from_obj(obj)
    return setmetatable(obj, TUpperCritical)
end

function TUpperCritical.new(UpperCritical)
    return TUpperCritical_from_obj({UpperCritical = UpperCritical or 0})
end
---@param obj ThresholdSensor.UpperCritical
function TUpperCritical:init_from_obj(obj)
    self.UpperCritical = obj.UpperCritical or 0
end

function TUpperCritical:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUpperCritical.group)
end

TUpperCritical.from_obj = TUpperCritical_from_obj

TUpperCritical.proto_property = {'UpperCritical'}

TUpperCritical.default = {0}

TUpperCritical.struct = {{name = 'UpperCritical', is_array = false, struct = nil}}

function TUpperCritical:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'UpperCritical', self.UpperCritical, 'uint8', true, errs, need_convert)

    TUpperCritical:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUpperCritical.proto_property, errs, need_convert)
    return self
end

function TUpperCritical:unpack(_)
    return self.UpperCritical
end

ThresholdSensor.UpperCritical = TUpperCritical

---@class ThresholdSensor.UpperNonrecoverable
---@field UpperNonrecoverable integer
local TUpperNonrecoverable = {}
TUpperNonrecoverable.__index = TUpperNonrecoverable
TUpperNonrecoverable.group = {}

local function TUpperNonrecoverable_from_obj(obj)
    return setmetatable(obj, TUpperNonrecoverable)
end

function TUpperNonrecoverable.new(UpperNonrecoverable)
    return TUpperNonrecoverable_from_obj({UpperNonrecoverable = UpperNonrecoverable or 0})
end
---@param obj ThresholdSensor.UpperNonrecoverable
function TUpperNonrecoverable:init_from_obj(obj)
    self.UpperNonrecoverable = obj.UpperNonrecoverable or 0
end

function TUpperNonrecoverable:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUpperNonrecoverable.group)
end

TUpperNonrecoverable.from_obj = TUpperNonrecoverable_from_obj

TUpperNonrecoverable.proto_property = {'UpperNonrecoverable'}

TUpperNonrecoverable.default = {0}

TUpperNonrecoverable.struct = {{name = 'UpperNonrecoverable', is_array = false, struct = nil}}

function TUpperNonrecoverable:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'UpperNonrecoverable', self.UpperNonrecoverable, 'uint8', true, errs, need_convert)

    TUpperNonrecoverable:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUpperNonrecoverable.proto_property, errs, need_convert)
    return self
end

function TUpperNonrecoverable:unpack(_)
    return self.UpperNonrecoverable
end

ThresholdSensor.UpperNonrecoverable = TUpperNonrecoverable

---@class ThresholdSensor.ReadingMask
---@field ReadingMask integer
local TReadingMask = {}
TReadingMask.__index = TReadingMask
TReadingMask.group = {}

local function TReadingMask_from_obj(obj)
    return setmetatable(obj, TReadingMask)
end

function TReadingMask.new(ReadingMask)
    return TReadingMask_from_obj({ReadingMask = ReadingMask or 0})
end
---@param obj ThresholdSensor.ReadingMask
function TReadingMask:init_from_obj(obj)
    self.ReadingMask = obj.ReadingMask or 0
end

function TReadingMask:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TReadingMask.group)
end

TReadingMask.from_obj = TReadingMask_from_obj

TReadingMask.proto_property = {'ReadingMask'}

TReadingMask.default = {0}

TReadingMask.struct = {{name = 'ReadingMask', is_array = false, struct = nil}}

function TReadingMask:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ReadingMask', self.ReadingMask, 'uint16', true, errs, need_convert)

    TReadingMask:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TReadingMask.proto_property, errs, need_convert)
    return self
end

function TReadingMask:unpack(_)
    return self.ReadingMask
end

ThresholdSensor.ReadingMask = TReadingMask

---@class ThresholdSensor.SensorType
---@field SensorType integer
local TSensorType = {}
TSensorType.__index = TSensorType
TSensorType.group = {}

local function TSensorType_from_obj(obj)
    return setmetatable(obj, TSensorType)
end

function TSensorType.new(SensorType)
    return TSensorType_from_obj({SensorType = SensorType or 0})
end
---@param obj ThresholdSensor.SensorType
function TSensorType:init_from_obj(obj)
    self.SensorType = obj.SensorType or 0
end

function TSensorType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSensorType.group)
end

TSensorType.from_obj = TSensorType_from_obj

TSensorType.proto_property = {'SensorType'}

TSensorType.default = {0}

TSensorType.struct = {{name = 'SensorType', is_array = false, struct = nil}}

function TSensorType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SensorType', self.SensorType, 'uint8', true, errs, need_convert)

    TSensorType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSensorType.proto_property, errs, need_convert)
    return self
end

function TSensorType:unpack(_)
    return self.SensorType
end

ThresholdSensor.SensorType = TSensorType

---@class ThresholdSensor.Capabilities
---@field Capabilities integer
local TCapabilities = {}
TCapabilities.__index = TCapabilities
TCapabilities.group = {}

local function TCapabilities_from_obj(obj)
    return setmetatable(obj, TCapabilities)
end

function TCapabilities.new(Capabilities)
    return TCapabilities_from_obj({Capabilities = Capabilities or 0})
end
---@param obj ThresholdSensor.Capabilities
function TCapabilities:init_from_obj(obj)
    self.Capabilities = obj.Capabilities or 0
end

function TCapabilities:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCapabilities.group)
end

TCapabilities.from_obj = TCapabilities_from_obj

TCapabilities.proto_property = {'Capabilities'}

TCapabilities.default = {0}

TCapabilities.struct = {{name = 'Capabilities', is_array = false, struct = nil}}

function TCapabilities:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Capabilities', self.Capabilities, 'uint8', true, errs, need_convert)

    TCapabilities:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCapabilities.proto_property, errs, need_convert)
    return self
end

function TCapabilities:unpack(_)
    return self.Capabilities
end

ThresholdSensor.Capabilities = TCapabilities

---@class ThresholdSensor.SensorName
---@field SensorName string
local TSensorName = {}
TSensorName.__index = TSensorName
TSensorName.group = {}

local function TSensorName_from_obj(obj)
    return setmetatable(obj, TSensorName)
end

function TSensorName.new(SensorName)
    return TSensorName_from_obj({SensorName = SensorName or [=[]=]})
end
---@param obj ThresholdSensor.SensorName
function TSensorName:init_from_obj(obj)
    self.SensorName = obj.SensorName or [=[]=]
end

function TSensorName:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSensorName.group)
end

TSensorName.from_obj = TSensorName_from_obj

TSensorName.proto_property = {'SensorName'}

TSensorName.default = {''}

TSensorName.struct = {{name = 'SensorName', is_array = false, struct = nil}}

function TSensorName:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SensorName', self.SensorName, 'string', true, errs, need_convert)

    TSensorName:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSensorName.proto_property, errs, need_convert)
    return self
end

function TSensorName:unpack(_)
    return self.SensorName
end

ThresholdSensor.SensorName = TSensorName

---@class ThresholdSensor.SensorIdentifier
---@field SensorIdentifier string
local TSensorIdentifier = {}
TSensorIdentifier.__index = TSensorIdentifier
TSensorIdentifier.group = {}

local function TSensorIdentifier_from_obj(obj)
    return setmetatable(obj, TSensorIdentifier)
end

function TSensorIdentifier.new(SensorIdentifier)
    return TSensorIdentifier_from_obj({SensorIdentifier = SensorIdentifier or [=[]=]})
end
---@param obj ThresholdSensor.SensorIdentifier
function TSensorIdentifier:init_from_obj(obj)
    self.SensorIdentifier = obj.SensorIdentifier or [=[]=]
end

function TSensorIdentifier:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSensorIdentifier.group)
end

TSensorIdentifier.from_obj = TSensorIdentifier_from_obj

TSensorIdentifier.proto_property = {'SensorIdentifier'}

TSensorIdentifier.default = {''}

TSensorIdentifier.struct = {{name = 'SensorIdentifier', is_array = false, struct = nil}}

function TSensorIdentifier:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SensorIdentifier', self.SensorIdentifier, 'string', true, errs, need_convert)

    TSensorIdentifier:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSensorIdentifier.proto_property, errs, need_convert)
    return self
end

function TSensorIdentifier:unpack(_)
    return self.SensorIdentifier
end

ThresholdSensor.SensorIdentifier = TSensorIdentifier

---@class ThresholdSensor.EntityInstance
---@field EntityInstance integer
local TEntityInstance = {}
TEntityInstance.__index = TEntityInstance
TEntityInstance.group = {}

local function TEntityInstance_from_obj(obj)
    return setmetatable(obj, TEntityInstance)
end

function TEntityInstance.new(EntityInstance)
    return TEntityInstance_from_obj({EntityInstance = EntityInstance or 0})
end
---@param obj ThresholdSensor.EntityInstance
function TEntityInstance:init_from_obj(obj)
    self.EntityInstance = obj.EntityInstance or 0
end

function TEntityInstance:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TEntityInstance.group)
end

TEntityInstance.from_obj = TEntityInstance_from_obj

TEntityInstance.proto_property = {'EntityInstance'}

TEntityInstance.default = {0}

TEntityInstance.struct = {{name = 'EntityInstance', is_array = false, struct = nil}}

function TEntityInstance:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'EntityInstance', self.EntityInstance, 'uint8', true, errs, need_convert)

    TEntityInstance:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TEntityInstance.proto_property, errs, need_convert)
    return self
end

function TEntityInstance:unpack(_)
    return self.EntityInstance
end

ThresholdSensor.EntityInstance = TEntityInstance

---@class ThresholdSensor.EntityId
---@field EntityId integer
local TEntityId = {}
TEntityId.__index = TEntityId
TEntityId.group = {}

local function TEntityId_from_obj(obj)
    return setmetatable(obj, TEntityId)
end

function TEntityId.new(EntityId)
    return TEntityId_from_obj({EntityId = EntityId or 0})
end
---@param obj ThresholdSensor.EntityId
function TEntityId:init_from_obj(obj)
    self.EntityId = obj.EntityId or 0
end

function TEntityId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TEntityId.group)
end

TEntityId.from_obj = TEntityId_from_obj

TEntityId.proto_property = {'EntityId'}

TEntityId.default = {0}

TEntityId.struct = {{name = 'EntityId', is_array = false, struct = nil}}

function TEntityId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'EntityId', self.EntityId, 'uint8', true, errs, need_convert)

    TEntityId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TEntityId.proto_property, errs, need_convert)
    return self
end

function TEntityId:unpack(_)
    return self.EntityId
end

ThresholdSensor.EntityId = TEntityId

ThresholdSensor.interface = mdb.register_interface('bmc.kepler.Systems.ThresholdSensor', {
    EntityId = {'y', {}, true, 0, false},
    EntityInstance = {'y', {}, true, 0, false},
    SensorIdentifier = {'s', {'CONST'}, true, '', false},
    SensorName = {'s', nil, true, '', false},
    Capabilities = {'y', {'CONST'}, true, 0, false},
    SensorType = {'y', {'CONST'}, true, 0, false},
    ReadingMask = {'q', {'CONST'}, true, 0, false},
    UpperNonrecoverable = {'y', nil, true, 0, false},
    UpperCritical = {'y', nil, true, 0, false},
    UpperNoncritical = {'y', nil, true, 0, false},
    LowerNonrecoverable = {'y', nil, true, 0, false},
    LowerNoncritical = {'y', nil, true, 0, false},
    LowerCritical = {'y', nil, true, 0, false},
    PositiveHysteresis = {'y', nil, true, 0, false},
    NegativeHysteresis = {'y', nil, true, 0, false},
    SensorNumber = {'y', {}, true, 255, false},
    OwnerLun = {'y', nil, true, 0, false},
    Reading = {'y', {'VOLATILE', 'EMIT_CHANGE'}, true, 0, false},
    ReadingStatus = {'y', {}, true, 0, false},
    OriginalReading = {'d', {'VOLATILE'}, true, 0, false}
}, {}, {})

return ThresholdSensor
