-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local DiscreteSensorDisplay = {}

---@class DiscreteSensorDisplay.AssertStatus
---@field AssertStatus integer
local TAssertStatus = {}
TAssertStatus.__index = TAssertStatus
TAssertStatus.group = {}

local function TAssertStatus_from_obj(obj)
    return setmetatable(obj, TAssertStatus)
end

function TAssertStatus.new(AssertStatus)
    return TAssertStatus_from_obj({AssertStatus = AssertStatus})
end
---@param obj DiscreteSensorDisplay.AssertStatus
function TAssertStatus:init_from_obj(obj)
    self.AssertStatus = obj.AssertStatus
end

function TAssertStatus:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAssertStatus.group)
end

TAssertStatus.from_obj = TAssertStatus_from_obj

TAssertStatus.proto_property = {'AssertStatus'}

TAssertStatus.default = {0}

TAssertStatus.struct = {{name = 'AssertStatus', is_array = false, struct = nil}}

function TAssertStatus:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'AssertStatus', self.AssertStatus, 'uint16', true, errs, need_convert)

    TAssertStatus:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAssertStatus.proto_property, errs, need_convert)
    return self
end

function TAssertStatus:unpack(_)
    return self.AssertStatus
end

DiscreteSensorDisplay.AssertStatus = TAssertStatus

---@class DiscreteSensorDisplay.Health
---@field Health string
local THealth = {}
THealth.__index = THealth
THealth.group = {}

local function THealth_from_obj(obj)
    return setmetatable(obj, THealth)
end

function THealth.new(Health)
    return THealth_from_obj({Health = Health})
end
---@param obj DiscreteSensorDisplay.Health
function THealth:init_from_obj(obj)
    self.Health = obj.Health
end

function THealth:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, THealth.group)
end

THealth.from_obj = THealth_from_obj

THealth.proto_property = {'Health'}

THealth.default = {''}

THealth.struct = {{name = 'Health', is_array = false, struct = nil}}

function THealth:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Health', self.Health, 'string', true, errs, need_convert)

    THealth:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, THealth.proto_property, errs, need_convert)
    return self
end

function THealth:unpack(_)
    return self.Health
end

DiscreteSensorDisplay.Health = THealth

---@class DiscreteSensorDisplay.Status
---@field Status string
local TStatus = {}
TStatus.__index = TStatus
TStatus.group = {}

local function TStatus_from_obj(obj)
    return setmetatable(obj, TStatus)
end

function TStatus.new(Status)
    return TStatus_from_obj({Status = Status})
end
---@param obj DiscreteSensorDisplay.Status
function TStatus:init_from_obj(obj)
    self.Status = obj.Status
end

function TStatus:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TStatus.group)
end

TStatus.from_obj = TStatus_from_obj

TStatus.proto_property = {'Status'}

TStatus.default = {''}

TStatus.struct = {{name = 'Status', is_array = false, struct = nil}}

function TStatus:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Status', self.Status, 'string', true, errs, need_convert)

    TStatus:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TStatus.proto_property, errs, need_convert)
    return self
end

function TStatus:unpack(_)
    return self.Status
end

DiscreteSensorDisplay.Status = TStatus

DiscreteSensorDisplay.interface = mdb.register_interface('bmc.kepler.Systems.DiscreteSensorDisplay', {
    Status = {'s', {}, true, nil, false},
    Health = {'s', {}, true, nil, false},
    AssertStatus = {'q', {}, true, nil, false}
}, {}, {})

return DiscreteSensorDisplay
