--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetSensorEventReceiver = {}

---@class SensorIpmiCmds.SetSensorEventReceiverReq
---@field Addr integer
---@field Lun integer
local TSetSensorEventReceiverReq = {}
TSetSensorEventReceiverReq.__index = TSetSensorEventReceiverReq
TSetSensorEventReceiverReq.group = {}

local function TSetSensorEventReceiverReq_from_obj(obj)
    return setmetatable(obj, TSetSensorEventReceiverReq)
end

function TSetSensorEventReceiverReq.new(Addr, Lun)
    return TSetSensorEventReceiverReq_from_obj({Addr = Addr, Lun = Lun})
end
---@param obj SensorIpmiCmds.SetSensorEventReceiverReq
function TSetSensorEventReceiverReq:init_from_obj(obj)
    self.Addr = obj.Addr
    self.Lun = obj.Lun
end

function TSetSensorEventReceiverReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetSensorEventReceiverReq.group)
end

TSetSensorEventReceiverReq.from_obj = TSetSensorEventReceiverReq_from_obj

TSetSensorEventReceiverReq.proto_property = {'Addr', 'Lun'}

TSetSensorEventReceiverReq.default = {0, 0}

TSetSensorEventReceiverReq.struct = {
    {name = 'Addr', is_array = false, struct = nil}, {name = 'Lun', is_array = false, struct = nil}
}

function TSetSensorEventReceiverReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Addr', self.Addr, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Lun', self.Lun, 'uint8', false, errs, need_convert)

    TSetSensorEventReceiverReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetSensorEventReceiverReq.proto_property, errs, need_convert)
    return self
end

function TSetSensorEventReceiverReq:unpack(_)
    return self.Addr, self.Lun
end

SetSensorEventReceiver.SetSensorEventReceiverReq = TSetSensorEventReceiverReq

---@class SensorIpmiCmds.SetSensorEventReceiverRsp
---@field CompletionCode integer
local TSetSensorEventReceiverRsp = {}
TSetSensorEventReceiverRsp.__index = TSetSensorEventReceiverRsp
TSetSensorEventReceiverRsp.group = {}

local function TSetSensorEventReceiverRsp_from_obj(obj)
    return setmetatable(obj, TSetSensorEventReceiverRsp)
end

function TSetSensorEventReceiverRsp.new(CompletionCode)
    return TSetSensorEventReceiverRsp_from_obj({CompletionCode = CompletionCode})
end
---@param obj SensorIpmiCmds.SetSensorEventReceiverRsp
function TSetSensorEventReceiverRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
end

function TSetSensorEventReceiverRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetSensorEventReceiverRsp.group)
end

TSetSensorEventReceiverRsp.from_obj = TSetSensorEventReceiverRsp_from_obj

TSetSensorEventReceiverRsp.proto_property = {'CompletionCode'}

TSetSensorEventReceiverRsp.default = {0}

TSetSensorEventReceiverRsp.struct = {{name = 'CompletionCode', is_array = false, struct = nil}}

function TSetSensorEventReceiverRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)

    TSetSensorEventReceiverRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetSensorEventReceiverRsp.proto_property, errs, need_convert)
    return self
end

function TSetSensorEventReceiverRsp:unpack(_)
    return self.CompletionCode
end

SetSensorEventReceiver.SetSensorEventReceiverRsp = TSetSensorEventReceiverRsp

return SetSensorEventReceiver
