--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetPEFLastEventId = {}

---@class SensorIpmiCmds.SetPEFLastEventIdReq
---@field Reserved integer
---@field BMC integer
---@field RecordId integer
local TSetPEFLastEventIdReq = {}
TSetPEFLastEventIdReq.__index = TSetPEFLastEventIdReq
TSetPEFLastEventIdReq.group = {}

local function TSetPEFLastEventIdReq_from_obj(obj)
    return setmetatable(obj, TSetPEFLastEventIdReq)
end

function TSetPEFLastEventIdReq.new(Reserved, BMC, RecordId)
    return TSetPEFLastEventIdReq_from_obj({Reserved = Reserved, BMC = BMC, RecordId = RecordId})
end
---@param obj SensorIpmiCmds.SetPEFLastEventIdReq
function TSetPEFLastEventIdReq:init_from_obj(obj)
    self.Reserved = obj.Reserved
    self.BMC = obj.BMC
    self.RecordId = obj.RecordId
end

function TSetPEFLastEventIdReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetPEFLastEventIdReq.group)
end

TSetPEFLastEventIdReq.from_obj = TSetPEFLastEventIdReq_from_obj

TSetPEFLastEventIdReq.proto_property = {'Reserved', 'BMC', 'RecordId'}

TSetPEFLastEventIdReq.default = {0, 0, 0}

TSetPEFLastEventIdReq.struct = {
    {name = 'Reserved', is_array = false, struct = nil}, {name = 'BMC', is_array = false, struct = nil},
    {name = 'RecordId', is_array = false, struct = nil}
}

function TSetPEFLastEventIdReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Reserved', self.Reserved, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'BMC', self.BMC, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'RecordId', self.RecordId, 'uint16', false, errs, need_convert)

    TSetPEFLastEventIdReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetPEFLastEventIdReq.proto_property, errs, need_convert)
    return self
end

function TSetPEFLastEventIdReq:unpack(_)
    return self.Reserved, self.BMC, self.RecordId
end

SetPEFLastEventId.SetPEFLastEventIdReq = TSetPEFLastEventIdReq

---@class SensorIpmiCmds.SetPEFLastEventIdRsp
---@field CompletionCode integer
local TSetPEFLastEventIdRsp = {}
TSetPEFLastEventIdRsp.__index = TSetPEFLastEventIdRsp
TSetPEFLastEventIdRsp.group = {}

local function TSetPEFLastEventIdRsp_from_obj(obj)
    return setmetatable(obj, TSetPEFLastEventIdRsp)
end

function TSetPEFLastEventIdRsp.new(CompletionCode)
    return TSetPEFLastEventIdRsp_from_obj({CompletionCode = CompletionCode})
end
---@param obj SensorIpmiCmds.SetPEFLastEventIdRsp
function TSetPEFLastEventIdRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
end

function TSetPEFLastEventIdRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetPEFLastEventIdRsp.group)
end

TSetPEFLastEventIdRsp.from_obj = TSetPEFLastEventIdRsp_from_obj

TSetPEFLastEventIdRsp.proto_property = {'CompletionCode'}

TSetPEFLastEventIdRsp.default = {0}

TSetPEFLastEventIdRsp.struct = {{name = 'CompletionCode', is_array = false, struct = nil}}

function TSetPEFLastEventIdRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)

    TSetPEFLastEventIdRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetPEFLastEventIdRsp.proto_property, errs, need_convert)
    return self
end

function TSetPEFLastEventIdRsp:unpack(_)
    return self.CompletionCode
end

SetPEFLastEventId.SetPEFLastEventIdRsp = TSetPEFLastEventIdRsp

return SetPEFLastEventId
