--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local RunSDRInitAgent = {}

---@class SensorIpmiCmds.RunSDRInitAgentReq
---@field RunFlag integer
local TRunSDRInitAgentReq = {}
TRunSDRInitAgentReq.__index = TRunSDRInitAgentReq
TRunSDRInitAgentReq.group = {}

local function TRunSDRInitAgentReq_from_obj(obj)
    return setmetatable(obj, TRunSDRInitAgentReq)
end

function TRunSDRInitAgentReq.new(RunFlag)
    return TRunSDRInitAgentReq_from_obj({RunFlag = RunFlag})
end
---@param obj SensorIpmiCmds.RunSDRInitAgentReq
function TRunSDRInitAgentReq:init_from_obj(obj)
    self.RunFlag = obj.RunFlag
end

function TRunSDRInitAgentReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRunSDRInitAgentReq.group)
end

TRunSDRInitAgentReq.from_obj = TRunSDRInitAgentReq_from_obj

TRunSDRInitAgentReq.proto_property = {'RunFlag'}

TRunSDRInitAgentReq.default = {0}

TRunSDRInitAgentReq.struct = {{name = 'RunFlag', is_array = false, struct = nil}}

function TRunSDRInitAgentReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'RunFlag', self.RunFlag, 'uint8', false, errs, need_convert)

    TRunSDRInitAgentReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRunSDRInitAgentReq.proto_property, errs, need_convert)
    return self
end

function TRunSDRInitAgentReq:unpack(_)
    return self.RunFlag
end

RunSDRInitAgent.RunSDRInitAgentReq = TRunSDRInitAgentReq

---@class SensorIpmiCmds.RunSDRInitAgentRsp
---@field CompletionCode integer
---@field Progress integer
local TRunSDRInitAgentRsp = {}
TRunSDRInitAgentRsp.__index = TRunSDRInitAgentRsp
TRunSDRInitAgentRsp.group = {}

local function TRunSDRInitAgentRsp_from_obj(obj)
    return setmetatable(obj, TRunSDRInitAgentRsp)
end

function TRunSDRInitAgentRsp.new(CompletionCode, Progress)
    return TRunSDRInitAgentRsp_from_obj({CompletionCode = CompletionCode, Progress = Progress})
end
---@param obj SensorIpmiCmds.RunSDRInitAgentRsp
function TRunSDRInitAgentRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.Progress = obj.Progress
end

function TRunSDRInitAgentRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRunSDRInitAgentRsp.group)
end

TRunSDRInitAgentRsp.from_obj = TRunSDRInitAgentRsp_from_obj

TRunSDRInitAgentRsp.proto_property = {'CompletionCode', 'Progress'}

TRunSDRInitAgentRsp.default = {0, 0}

TRunSDRInitAgentRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'Progress', is_array = false, struct = nil}
}

function TRunSDRInitAgentRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Progress', self.Progress, 'uint8', false, errs, need_convert)

    TRunSDRInitAgentRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRunSDRInitAgentRsp.proto_property, errs, need_convert)
    return self
end

function TRunSDRInitAgentRsp:unpack(_)
    return self.CompletionCode, self.Progress
end

RunSDRInitAgent.RunSDRInitAgentRsp = TRunSDRInitAgentRsp

return RunSDRInitAgent
