--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local ReserveDeviceSDR = {}

---@class SensorIpmiCmds.ReserveDeviceSDRReq
local TReserveDeviceSDRReq = {}
TReserveDeviceSDRReq.__index = TReserveDeviceSDRReq
TReserveDeviceSDRReq.group = {}

local function TReserveDeviceSDRReq_from_obj(obj)
    return setmetatable(obj, TReserveDeviceSDRReq)
end

function TReserveDeviceSDRReq.new()
    return TReserveDeviceSDRReq_from_obj({})
end
---@param obj SensorIpmiCmds.ReserveDeviceSDRReq
function TReserveDeviceSDRReq:init_from_obj(obj)

end

function TReserveDeviceSDRReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TReserveDeviceSDRReq.group)
end

TReserveDeviceSDRReq.from_obj = TReserveDeviceSDRReq_from_obj

TReserveDeviceSDRReq.proto_property = {}

TReserveDeviceSDRReq.default = {}

TReserveDeviceSDRReq.struct = {}

function TReserveDeviceSDRReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TReserveDeviceSDRReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TReserveDeviceSDRReq.proto_property, errs, need_convert)
    return self
end

function TReserveDeviceSDRReq:unpack(_)
end

ReserveDeviceSDR.ReserveDeviceSDRReq = TReserveDeviceSDRReq

---@class SensorIpmiCmds.ReserveDeviceSDRRsp
---@field CompletionCode integer
---@field ReserveIdL integer
---@field ReserveIdH integer
local TReserveDeviceSDRRsp = {}
TReserveDeviceSDRRsp.__index = TReserveDeviceSDRRsp
TReserveDeviceSDRRsp.group = {}

local function TReserveDeviceSDRRsp_from_obj(obj)
    return setmetatable(obj, TReserveDeviceSDRRsp)
end

function TReserveDeviceSDRRsp.new(CompletionCode, ReserveIdL, ReserveIdH)
    return TReserveDeviceSDRRsp_from_obj({
        CompletionCode = CompletionCode,
        ReserveIdL = ReserveIdL,
        ReserveIdH = ReserveIdH
    })
end
---@param obj SensorIpmiCmds.ReserveDeviceSDRRsp
function TReserveDeviceSDRRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ReserveIdL = obj.ReserveIdL
    self.ReserveIdH = obj.ReserveIdH
end

function TReserveDeviceSDRRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TReserveDeviceSDRRsp.group)
end

TReserveDeviceSDRRsp.from_obj = TReserveDeviceSDRRsp_from_obj

TReserveDeviceSDRRsp.proto_property = {'CompletionCode', 'ReserveIdL', 'ReserveIdH'}

TReserveDeviceSDRRsp.default = {0, 0, 0}

TReserveDeviceSDRRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ReserveIdL', is_array = false, struct = nil},
    {name = 'ReserveIdH', is_array = false, struct = nil}
}

function TReserveDeviceSDRRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ReserveIdL', self.ReserveIdL, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ReserveIdH', self.ReserveIdH, 'uint8', false, errs, need_convert)

    TReserveDeviceSDRRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TReserveDeviceSDRRsp.proto_property, errs, need_convert)
    return self
end

function TReserveDeviceSDRRsp:unpack(_)
    return self.CompletionCode, self.ReserveIdL, self.ReserveIdH
end

ReserveDeviceSDR.ReserveDeviceSDRRsp = TReserveDeviceSDRRsp

return ReserveDeviceSDR
