--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local OEMGetSystemSel2 = {}

---@class SensorIpmiCmds.OEMGetSystemSel2Req
---@field ManuId integer
---@field RecordId integer
local TOEMGetSystemSel2Req = {}
TOEMGetSystemSel2Req.__index = TOEMGetSystemSel2Req
TOEMGetSystemSel2Req.group = {}

local function TOEMGetSystemSel2Req_from_obj(obj)
    return setmetatable(obj, TOEMGetSystemSel2Req)
end

function TOEMGetSystemSel2Req.new(ManuId, RecordId)
    return TOEMGetSystemSel2Req_from_obj({ManuId = ManuId, RecordId = RecordId})
end
---@param obj SensorIpmiCmds.OEMGetSystemSel2Req
function TOEMGetSystemSel2Req:init_from_obj(obj)
    self.ManuId = obj.ManuId
    self.RecordId = obj.RecordId
end

function TOEMGetSystemSel2Req:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TOEMGetSystemSel2Req.group)
end

TOEMGetSystemSel2Req.from_obj = TOEMGetSystemSel2Req_from_obj

TOEMGetSystemSel2Req.proto_property = {'ManuId', 'RecordId'}

TOEMGetSystemSel2Req.default = {0, 0}

TOEMGetSystemSel2Req.struct = {
    {name = 'ManuId', is_array = false, struct = nil},
    {name = 'RecordId', is_array = false, struct = nil}
}

function TOEMGetSystemSel2Req:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManuId', self.ManuId, "uint32", false, errs,
                      need_convert)
    validate.Optional(prefix .. 'RecordId', self.RecordId, "uint16", false,
                      errs, need_convert)

    TOEMGetSystemSel2Req:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TOEMGetSystemSel2Req.proto_property,
                                 errs, need_convert)
    return self
end

function TOEMGetSystemSel2Req:unpack(_) return self.ManuId, self.RecordId end

OEMGetSystemSel2.OEMGetSystemSel2Req = TOEMGetSystemSel2Req

---@class SensorIpmiCmds.OEMGetSystemSel2Rsp
---@field CompletionCode integer
---@field ManuId integer
---@field RecordId integer
---@field Datas string
local TOEMGetSystemSel2Rsp = {}
TOEMGetSystemSel2Rsp.__index = TOEMGetSystemSel2Rsp
TOEMGetSystemSel2Rsp.group = {}

local function TOEMGetSystemSel2Rsp_from_obj(obj)
    return setmetatable(obj, TOEMGetSystemSel2Rsp)
end

function TOEMGetSystemSel2Rsp.new(CompletionCode, ManuId, RecordId, Datas)
    return TOEMGetSystemSel2Rsp_from_obj({
        CompletionCode = CompletionCode,
        ManuId = ManuId,
        RecordId = RecordId,
        Datas = Datas
    })
end
---@param obj SensorIpmiCmds.OEMGetSystemSel2Rsp
function TOEMGetSystemSel2Rsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManuId = obj.ManuId
    self.RecordId = obj.RecordId
    self.Datas = obj.Datas
end

function TOEMGetSystemSel2Rsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TOEMGetSystemSel2Rsp.group)
end

TOEMGetSystemSel2Rsp.from_obj = TOEMGetSystemSel2Rsp_from_obj

TOEMGetSystemSel2Rsp.proto_property = {
    'CompletionCode', 'ManuId', 'RecordId', 'Datas'
}

TOEMGetSystemSel2Rsp.default = {0, 0, 0, ''}

TOEMGetSystemSel2Rsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil},
    {name = 'ManuId', is_array = false, struct = nil},
    {name = 'RecordId', is_array = false, struct = nil},
    {name = 'Datas', is_array = false, struct = nil}
}

function TOEMGetSystemSel2Rsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, "uint8",
                      false, errs, need_convert)
    validate.Optional(prefix .. 'ManuId', self.ManuId, "uint32", false, errs,
                      need_convert)
    validate.Optional(prefix .. 'RecordId', self.RecordId, "uint16", false,
                      errs, need_convert)
    validate.Optional(prefix .. 'Datas', self.Datas, "string", false, errs,
                      need_convert)

    TOEMGetSystemSel2Rsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TOEMGetSystemSel2Rsp.proto_property,
                                 errs, need_convert)
    return self
end

function TOEMGetSystemSel2Rsp:unpack(_)
    return self.CompletionCode, self.ManuId, self.RecordId, self.Datas
end

OEMGetSystemSel2.OEMGetSystemSel2Rsp = TOEMGetSystemSel2Rsp

return OEMGetSystemSel2
