--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetSDRRepoAllocInfo = {}

---@class SensorIpmiCmds.GetSDRRepoAllocInfoReq
local TGetSDRRepoAllocInfoReq = {}
TGetSDRRepoAllocInfoReq.__index = TGetSDRRepoAllocInfoReq
TGetSDRRepoAllocInfoReq.group = {}

local function TGetSDRRepoAllocInfoReq_from_obj(obj)
    return setmetatable(obj, TGetSDRRepoAllocInfoReq)
end

function TGetSDRRepoAllocInfoReq.new()
    return TGetSDRRepoAllocInfoReq_from_obj({})
end
---@param obj SensorIpmiCmds.GetSDRRepoAllocInfoReq
function TGetSDRRepoAllocInfoReq:init_from_obj(obj)

end

function TGetSDRRepoAllocInfoReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetSDRRepoAllocInfoReq.group)
end

TGetSDRRepoAllocInfoReq.from_obj = TGetSDRRepoAllocInfoReq_from_obj

TGetSDRRepoAllocInfoReq.proto_property = {}

TGetSDRRepoAllocInfoReq.default = {}

TGetSDRRepoAllocInfoReq.struct = {}

function TGetSDRRepoAllocInfoReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TGetSDRRepoAllocInfoReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetSDRRepoAllocInfoReq.proto_property, errs, need_convert)
    return self
end

function TGetSDRRepoAllocInfoReq:unpack(_)
end

GetSDRRepoAllocInfo.GetSDRRepoAllocInfoReq = TGetSDRRepoAllocInfoReq

---@class SensorIpmiCmds.GetSDRRepoAllocInfoRsp
---@field CompletionCode integer
---@field UnitCntL integer
---@field UnitCntH integer
---@field UnitSizeL integer
---@field UnitSizeH integer
---@field FreeUnitL integer
---@field FreeUnitH integer
---@field FreeBlockL integer
---@field FreeBlockH integer
---@field MaxUnitSize integer
local TGetSDRRepoAllocInfoRsp = {}
TGetSDRRepoAllocInfoRsp.__index = TGetSDRRepoAllocInfoRsp
TGetSDRRepoAllocInfoRsp.group = {}

local function TGetSDRRepoAllocInfoRsp_from_obj(obj)
    return setmetatable(obj, TGetSDRRepoAllocInfoRsp)
end

function TGetSDRRepoAllocInfoRsp.new(CompletionCode, UnitCntL, UnitCntH, UnitSizeL, UnitSizeH, FreeUnitL, FreeUnitH,
    FreeBlockL, FreeBlockH, MaxUnitSize)
    return TGetSDRRepoAllocInfoRsp_from_obj({
        CompletionCode = CompletionCode,
        UnitCntL = UnitCntL,
        UnitCntH = UnitCntH,
        UnitSizeL = UnitSizeL,
        UnitSizeH = UnitSizeH,
        FreeUnitL = FreeUnitL,
        FreeUnitH = FreeUnitH,
        FreeBlockL = FreeBlockL,
        FreeBlockH = FreeBlockH,
        MaxUnitSize = MaxUnitSize
    })
end
---@param obj SensorIpmiCmds.GetSDRRepoAllocInfoRsp
function TGetSDRRepoAllocInfoRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.UnitCntL = obj.UnitCntL
    self.UnitCntH = obj.UnitCntH
    self.UnitSizeL = obj.UnitSizeL
    self.UnitSizeH = obj.UnitSizeH
    self.FreeUnitL = obj.FreeUnitL
    self.FreeUnitH = obj.FreeUnitH
    self.FreeBlockL = obj.FreeBlockL
    self.FreeBlockH = obj.FreeBlockH
    self.MaxUnitSize = obj.MaxUnitSize
end

function TGetSDRRepoAllocInfoRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetSDRRepoAllocInfoRsp.group)
end

TGetSDRRepoAllocInfoRsp.from_obj = TGetSDRRepoAllocInfoRsp_from_obj

TGetSDRRepoAllocInfoRsp.proto_property = {
    'CompletionCode', 'UnitCntL', 'UnitCntH', 'UnitSizeL', 'UnitSizeH', 'FreeUnitL', 'FreeUnitH', 'FreeBlockL',
    'FreeBlockH', 'MaxUnitSize'
}

TGetSDRRepoAllocInfoRsp.default = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0}

TGetSDRRepoAllocInfoRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'UnitCntL', is_array = false, struct = nil},
    {name = 'UnitCntH', is_array = false, struct = nil}, {name = 'UnitSizeL', is_array = false, struct = nil},
    {name = 'UnitSizeH', is_array = false, struct = nil}, {name = 'FreeUnitL', is_array = false, struct = nil},
    {name = 'FreeUnitH', is_array = false, struct = nil}, {name = 'FreeBlockL', is_array = false, struct = nil},
    {name = 'FreeBlockH', is_array = false, struct = nil}, {name = 'MaxUnitSize', is_array = false, struct = nil}
}

function TGetSDRRepoAllocInfoRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'UnitCntL', self.UnitCntL, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'UnitCntH', self.UnitCntH, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'UnitSizeL', self.UnitSizeL, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'UnitSizeH', self.UnitSizeH, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'FreeUnitL', self.FreeUnitL, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'FreeUnitH', self.FreeUnitH, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'FreeBlockL', self.FreeBlockL, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'FreeBlockH', self.FreeBlockH, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'MaxUnitSize', self.MaxUnitSize, 'uint8', false, errs, need_convert)

    TGetSDRRepoAllocInfoRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetSDRRepoAllocInfoRsp.proto_property, errs, need_convert)
    return self
end

function TGetSDRRepoAllocInfoRsp:unpack(_)
    return self.CompletionCode, self.UnitCntL, self.UnitCntH, self.UnitSizeL, self.UnitSizeH, self.FreeUnitL,
        self.FreeUnitH, self.FreeBlockL, self.FreeBlockH, self.MaxUnitSize
end

GetSDRRepoAllocInfo.GetSDRRepoAllocInfoRsp = TGetSDRRepoAllocInfoRsp

return GetSDRRepoAllocInfo
