--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local EnterSDRRepoUpdate = {}

---@class SensorIpmiCmds.EnterSDRRepoUpdateReq
local TEnterSDRRepoUpdateReq = {}
TEnterSDRRepoUpdateReq.__index = TEnterSDRRepoUpdateReq
TEnterSDRRepoUpdateReq.group = {}

local function TEnterSDRRepoUpdateReq_from_obj(obj)
    return setmetatable(obj, TEnterSDRRepoUpdateReq)
end

function TEnterSDRRepoUpdateReq.new()
    return TEnterSDRRepoUpdateReq_from_obj({})
end
---@param obj SensorIpmiCmds.EnterSDRRepoUpdateReq
function TEnterSDRRepoUpdateReq:init_from_obj(obj)

end

function TEnterSDRRepoUpdateReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TEnterSDRRepoUpdateReq.group)
end

TEnterSDRRepoUpdateReq.from_obj = TEnterSDRRepoUpdateReq_from_obj

TEnterSDRRepoUpdateReq.proto_property = {}

TEnterSDRRepoUpdateReq.default = {}

TEnterSDRRepoUpdateReq.struct = {}

function TEnterSDRRepoUpdateReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TEnterSDRRepoUpdateReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TEnterSDRRepoUpdateReq.proto_property, errs, need_convert)
    return self
end

function TEnterSDRRepoUpdateReq:unpack(_)
end

EnterSDRRepoUpdate.EnterSDRRepoUpdateReq = TEnterSDRRepoUpdateReq

---@class SensorIpmiCmds.EnterSDRRepoUpdateRsp
---@field CompletionCode integer
local TEnterSDRRepoUpdateRsp = {}
TEnterSDRRepoUpdateRsp.__index = TEnterSDRRepoUpdateRsp
TEnterSDRRepoUpdateRsp.group = {}

local function TEnterSDRRepoUpdateRsp_from_obj(obj)
    return setmetatable(obj, TEnterSDRRepoUpdateRsp)
end

function TEnterSDRRepoUpdateRsp.new(CompletionCode)
    return TEnterSDRRepoUpdateRsp_from_obj({CompletionCode = CompletionCode})
end
---@param obj SensorIpmiCmds.EnterSDRRepoUpdateRsp
function TEnterSDRRepoUpdateRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
end

function TEnterSDRRepoUpdateRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TEnterSDRRepoUpdateRsp.group)
end

TEnterSDRRepoUpdateRsp.from_obj = TEnterSDRRepoUpdateRsp_from_obj

TEnterSDRRepoUpdateRsp.proto_property = {'CompletionCode'}

TEnterSDRRepoUpdateRsp.default = {0}

TEnterSDRRepoUpdateRsp.struct = {{name = 'CompletionCode', is_array = false, struct = nil}}

function TEnterSDRRepoUpdateRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)

    TEnterSDRRepoUpdateRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TEnterSDRRepoUpdateRsp.proto_property, errs, need_convert)
    return self
end

function TEnterSDRRepoUpdateRsp:unpack(_)
    return self.CompletionCode
end

EnterSDRRepoUpdate.EnterSDRRepoUpdateRsp = TEnterSDRRepoUpdateRsp

return EnterSDRRepoUpdate
