--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local ClearSDR = {}

---@class SensorIpmiCmds.ClearSDRReq
---@field RecordIdL integer
---@field RecordIdH integer
---@field FlagC integer
---@field FlagL integer
---@field FlagR integer
---@field Operation integer
local TClearSDRReq = {}
TClearSDRReq.__index = TClearSDRReq
TClearSDRReq.group = {}

local function TClearSDRReq_from_obj(obj)
    return setmetatable(obj, TClearSDRReq)
end

function TClearSDRReq.new(RecordIdL, RecordIdH, FlagC, FlagL, FlagR, Operation)
    return TClearSDRReq_from_obj({
        RecordIdL = RecordIdL,
        RecordIdH = RecordIdH,
        FlagC = FlagC,
        FlagL = FlagL,
        FlagR = FlagR,
        Operation = Operation
    })
end
---@param obj SensorIpmiCmds.ClearSDRReq
function TClearSDRReq:init_from_obj(obj)
    self.RecordIdL = obj.RecordIdL
    self.RecordIdH = obj.RecordIdH
    self.FlagC = obj.FlagC
    self.FlagL = obj.FlagL
    self.FlagR = obj.FlagR
    self.Operation = obj.Operation
end

function TClearSDRReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TClearSDRReq.group)
end

TClearSDRReq.from_obj = TClearSDRReq_from_obj

TClearSDRReq.proto_property = {'RecordIdL', 'RecordIdH', 'FlagC', 'FlagL', 'FlagR', 'Operation'}

TClearSDRReq.default = {0, 0, 0, 0, 0, 0}

TClearSDRReq.struct = {
    {name = 'RecordIdL', is_array = false, struct = nil}, {name = 'RecordIdH', is_array = false, struct = nil},
    {name = 'FlagC', is_array = false, struct = nil}, {name = 'FlagL', is_array = false, struct = nil},
    {name = 'FlagR', is_array = false, struct = nil}, {name = 'Operation', is_array = false, struct = nil}
}

function TClearSDRReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'RecordIdL', self.RecordIdL, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'RecordIdH', self.RecordIdH, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'FlagC', self.FlagC, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'FlagL', self.FlagL, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'FlagR', self.FlagR, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Operation', self.Operation, 'uint8', false, errs, need_convert)

    TClearSDRReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TClearSDRReq.proto_property, errs, need_convert)
    return self
end

function TClearSDRReq:unpack(_)
    return self.RecordIdL, self.RecordIdH, self.FlagC, self.FlagL, self.FlagR, self.Operation
end

ClearSDR.ClearSDRReq = TClearSDRReq

---@class SensorIpmiCmds.ClearSDRRsp
---@field CompletionCode integer
---@field Status integer
---@field Reserved integer
local TClearSDRRsp = {}
TClearSDRRsp.__index = TClearSDRRsp
TClearSDRRsp.group = {}

local function TClearSDRRsp_from_obj(obj)
    return setmetatable(obj, TClearSDRRsp)
end

function TClearSDRRsp.new(CompletionCode, Status, Reserved)
    return TClearSDRRsp_from_obj({CompletionCode = CompletionCode, Status = Status, Reserved = Reserved})
end
---@param obj SensorIpmiCmds.ClearSDRRsp
function TClearSDRRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.Status = obj.Status
    self.Reserved = obj.Reserved
end

function TClearSDRRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TClearSDRRsp.group)
end

TClearSDRRsp.from_obj = TClearSDRRsp_from_obj

TClearSDRRsp.proto_property = {'CompletionCode', 'Status', 'Reserved'}

TClearSDRRsp.default = {0, 0, 0}

TClearSDRRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'Status', is_array = false, struct = nil},
    {name = 'Reserved', is_array = false, struct = nil}
}

function TClearSDRRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Status', self.Status, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserved', self.Reserved, 'uint8', false, errs, need_convert)

    TClearSDRRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TClearSDRRsp.proto_property, errs, need_convert)
    return self
end

function TClearSDRRsp:unpack(_)
    return self.CompletionCode, self.Status, self.Reserved
end

ClearSDR.ClearSDRRsp = TClearSDRRsp

return ClearSDR
