-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MIpmiPefConfig = {}

---@class MIpmiPefConfig.Id
---@field Id integer
local TId = {}
TId.__index = TId
TId.group = {}

local function TId_from_obj(obj)
    return setmetatable(obj, TId)
end

function TId.new(Id)
    return TId_from_obj({Id = Id or 1})
end
---@param obj MIpmiPefConfig.Id
function TId:init_from_obj(obj)
    self.Id = obj.Id or 1
end

function TId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TId.group)
end

TId.from_obj = TId_from_obj

TId.proto_property = {'Id'}

TId.default = {0}

TId.struct = {{name = 'Id', is_array = false, struct = nil}}

function TId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'Id', self.Id, 'uint8', false, errs, need_convert)

    TId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TId.proto_property, errs, need_convert)
    return self
end

function TId:unpack(_)
    return self.Id
end

MIpmiPefConfig.Id = TId

---@class MIpmiPefConfig.SystemGUID
---@field SystemGUID string
local TSystemGUID = {}
TSystemGUID.__index = TSystemGUID
TSystemGUID.group = {}

local function TSystemGUID_from_obj(obj)
    return setmetatable(obj, TSystemGUID)
end

function TSystemGUID.new(SystemGUID)
    return TSystemGUID_from_obj({SystemGUID = SystemGUID or [=[000000000000000000]=]})
end
---@param obj MIpmiPefConfig.SystemGUID
function TSystemGUID:init_from_obj(obj)
    self.SystemGUID = obj.SystemGUID or [=[000000000000000000]=]
end

function TSystemGUID:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSystemGUID.group)
end

TSystemGUID.from_obj = TSystemGUID_from_obj

TSystemGUID.proto_property = {'SystemGUID'}

TSystemGUID.default = {''}

TSystemGUID.struct = {{name = 'SystemGUID', is_array = false, struct = nil}}

function TSystemGUID:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SystemGUID', self.SystemGUID, 'string', false, errs, need_convert)

    TSystemGUID:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSystemGUID.proto_property, errs, need_convert)
    return self
end

function TSystemGUID:unpack(_)
    return self.SystemGUID
end

MIpmiPefConfig.SystemGUID = TSystemGUID

---@class MIpmiPefConfig.AlertStartupDelay
---@field AlertStartupDelay integer
local TAlertStartupDelay = {}
TAlertStartupDelay.__index = TAlertStartupDelay
TAlertStartupDelay.group = {}

local function TAlertStartupDelay_from_obj(obj)
    return setmetatable(obj, TAlertStartupDelay)
end

function TAlertStartupDelay.new(AlertStartupDelay)
    return TAlertStartupDelay_from_obj({AlertStartupDelay = AlertStartupDelay or 0})
end
---@param obj MIpmiPefConfig.AlertStartupDelay
function TAlertStartupDelay:init_from_obj(obj)
    self.AlertStartupDelay = obj.AlertStartupDelay or 0
end

function TAlertStartupDelay:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAlertStartupDelay.group)
end

TAlertStartupDelay.from_obj = TAlertStartupDelay_from_obj

TAlertStartupDelay.proto_property = {'AlertStartupDelay'}

TAlertStartupDelay.default = {0}

TAlertStartupDelay.struct = {{name = 'AlertStartupDelay', is_array = false, struct = nil}}

function TAlertStartupDelay:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'AlertStartupDelay', self.AlertStartupDelay, 'uint8', false, errs, need_convert)

    TAlertStartupDelay:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAlertStartupDelay.proto_property, errs, need_convert)
    return self
end

function TAlertStartupDelay:unpack(_)
    return self.AlertStartupDelay
end

MIpmiPefConfig.AlertStartupDelay = TAlertStartupDelay

---@class MIpmiPefConfig.StartupDelay
---@field StartupDelay integer
local TStartupDelay = {}
TStartupDelay.__index = TStartupDelay
TStartupDelay.group = {}

local function TStartupDelay_from_obj(obj)
    return setmetatable(obj, TStartupDelay)
end

function TStartupDelay.new(StartupDelay)
    return TStartupDelay_from_obj({StartupDelay = StartupDelay or 0})
end
---@param obj MIpmiPefConfig.StartupDelay
function TStartupDelay:init_from_obj(obj)
    self.StartupDelay = obj.StartupDelay or 0
end

function TStartupDelay:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TStartupDelay.group)
end

TStartupDelay.from_obj = TStartupDelay_from_obj

TStartupDelay.proto_property = {'StartupDelay'}

TStartupDelay.default = {0}

TStartupDelay.struct = {{name = 'StartupDelay', is_array = false, struct = nil}}

function TStartupDelay:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'StartupDelay', self.StartupDelay, 'uint8', false, errs, need_convert)

    TStartupDelay:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TStartupDelay.proto_property, errs, need_convert)
    return self
end

function TStartupDelay:unpack(_)
    return self.StartupDelay
end

MIpmiPefConfig.StartupDelay = TStartupDelay

---@class MIpmiPefConfig.SystemGUIDEnabled
---@field SystemGUIDEnabled integer
local TSystemGUIDEnabled = {}
TSystemGUIDEnabled.__index = TSystemGUIDEnabled
TSystemGUIDEnabled.group = {}

local function TSystemGUIDEnabled_from_obj(obj)
    return setmetatable(obj, TSystemGUIDEnabled)
end

function TSystemGUIDEnabled.new(SystemGUIDEnabled)
    return TSystemGUIDEnabled_from_obj({SystemGUIDEnabled = SystemGUIDEnabled or 0})
end
---@param obj MIpmiPefConfig.SystemGUIDEnabled
function TSystemGUIDEnabled:init_from_obj(obj)
    self.SystemGUIDEnabled = obj.SystemGUIDEnabled or 0
end

function TSystemGUIDEnabled:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSystemGUIDEnabled.group)
end

TSystemGUIDEnabled.from_obj = TSystemGUIDEnabled_from_obj

TSystemGUIDEnabled.proto_property = {'SystemGUIDEnabled'}

TSystemGUIDEnabled.default = {0}

TSystemGUIDEnabled.struct = {{name = 'SystemGUIDEnabled', is_array = false, struct = nil}}

function TSystemGUIDEnabled:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SystemGUIDEnabled', self.SystemGUIDEnabled, 'uint8', false, errs, need_convert)

    TSystemGUIDEnabled:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSystemGUIDEnabled.proto_property, errs, need_convert)
    return self
end

function TSystemGUIDEnabled:unpack(_)
    return self.SystemGUIDEnabled
end

MIpmiPefConfig.SystemGUIDEnabled = TSystemGUIDEnabled

---@class MIpmiPefConfig.DiagInterruptEnabled
---@field DiagInterruptEnabled integer
local TDiagInterruptEnabled = {}
TDiagInterruptEnabled.__index = TDiagInterruptEnabled
TDiagInterruptEnabled.group = {}

local function TDiagInterruptEnabled_from_obj(obj)
    return setmetatable(obj, TDiagInterruptEnabled)
end

function TDiagInterruptEnabled.new(DiagInterruptEnabled)
    return TDiagInterruptEnabled_from_obj({DiagInterruptEnabled = DiagInterruptEnabled or 0})
end
---@param obj MIpmiPefConfig.DiagInterruptEnabled
function TDiagInterruptEnabled:init_from_obj(obj)
    self.DiagInterruptEnabled = obj.DiagInterruptEnabled or 0
end

function TDiagInterruptEnabled:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDiagInterruptEnabled.group)
end

TDiagInterruptEnabled.from_obj = TDiagInterruptEnabled_from_obj

TDiagInterruptEnabled.proto_property = {'DiagInterruptEnabled'}

TDiagInterruptEnabled.default = {0}

TDiagInterruptEnabled.struct = {{name = 'DiagInterruptEnabled', is_array = false, struct = nil}}

function TDiagInterruptEnabled:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DiagInterruptEnabled', self.DiagInterruptEnabled, 'uint8', false, errs, need_convert)

    TDiagInterruptEnabled:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDiagInterruptEnabled.proto_property, errs, need_convert)
    return self
end

function TDiagInterruptEnabled:unpack(_)
    return self.DiagInterruptEnabled
end

MIpmiPefConfig.DiagInterruptEnabled = TDiagInterruptEnabled

---@class MIpmiPefConfig.OEMEnabled
---@field OEMEnabled integer
local TOEMEnabled = {}
TOEMEnabled.__index = TOEMEnabled
TOEMEnabled.group = {}

local function TOEMEnabled_from_obj(obj)
    return setmetatable(obj, TOEMEnabled)
end

function TOEMEnabled.new(OEMEnabled)
    return TOEMEnabled_from_obj({OEMEnabled = OEMEnabled or 0})
end
---@param obj MIpmiPefConfig.OEMEnabled
function TOEMEnabled:init_from_obj(obj)
    self.OEMEnabled = obj.OEMEnabled or 0
end

function TOEMEnabled:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TOEMEnabled.group)
end

TOEMEnabled.from_obj = TOEMEnabled_from_obj

TOEMEnabled.proto_property = {'OEMEnabled'}

TOEMEnabled.default = {0}

TOEMEnabled.struct = {{name = 'OEMEnabled', is_array = false, struct = nil}}

function TOEMEnabled:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'OEMEnabled', self.OEMEnabled, 'uint8', false, errs, need_convert)

    TOEMEnabled:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TOEMEnabled.proto_property, errs, need_convert)
    return self
end

function TOEMEnabled:unpack(_)
    return self.OEMEnabled
end

MIpmiPefConfig.OEMEnabled = TOEMEnabled

---@class MIpmiPefConfig.PowerCycleEnabled
---@field PowerCycleEnabled integer
local TPowerCycleEnabled = {}
TPowerCycleEnabled.__index = TPowerCycleEnabled
TPowerCycleEnabled.group = {}

local function TPowerCycleEnabled_from_obj(obj)
    return setmetatable(obj, TPowerCycleEnabled)
end

function TPowerCycleEnabled.new(PowerCycleEnabled)
    return TPowerCycleEnabled_from_obj({PowerCycleEnabled = PowerCycleEnabled or 1})
end
---@param obj MIpmiPefConfig.PowerCycleEnabled
function TPowerCycleEnabled:init_from_obj(obj)
    self.PowerCycleEnabled = obj.PowerCycleEnabled or 1
end

function TPowerCycleEnabled:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPowerCycleEnabled.group)
end

TPowerCycleEnabled.from_obj = TPowerCycleEnabled_from_obj

TPowerCycleEnabled.proto_property = {'PowerCycleEnabled'}

TPowerCycleEnabled.default = {0}

TPowerCycleEnabled.struct = {{name = 'PowerCycleEnabled', is_array = false, struct = nil}}

function TPowerCycleEnabled:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PowerCycleEnabled', self.PowerCycleEnabled, 'uint8', false, errs, need_convert)

    TPowerCycleEnabled:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPowerCycleEnabled.proto_property, errs, need_convert)
    return self
end

function TPowerCycleEnabled:unpack(_)
    return self.PowerCycleEnabled
end

MIpmiPefConfig.PowerCycleEnabled = TPowerCycleEnabled

---@class MIpmiPefConfig.ResetEnabled
---@field ResetEnabled integer
local TResetEnabled = {}
TResetEnabled.__index = TResetEnabled
TResetEnabled.group = {}

local function TResetEnabled_from_obj(obj)
    return setmetatable(obj, TResetEnabled)
end

function TResetEnabled.new(ResetEnabled)
    return TResetEnabled_from_obj({ResetEnabled = ResetEnabled or 1})
end
---@param obj MIpmiPefConfig.ResetEnabled
function TResetEnabled:init_from_obj(obj)
    self.ResetEnabled = obj.ResetEnabled or 1
end

function TResetEnabled:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TResetEnabled.group)
end

TResetEnabled.from_obj = TResetEnabled_from_obj

TResetEnabled.proto_property = {'ResetEnabled'}

TResetEnabled.default = {0}

TResetEnabled.struct = {{name = 'ResetEnabled', is_array = false, struct = nil}}

function TResetEnabled:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ResetEnabled', self.ResetEnabled, 'uint8', false, errs, need_convert)

    TResetEnabled:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TResetEnabled.proto_property, errs, need_convert)
    return self
end

function TResetEnabled:unpack(_)
    return self.ResetEnabled
end

MIpmiPefConfig.ResetEnabled = TResetEnabled

---@class MIpmiPefConfig.PowerOffEnabled
---@field PowerOffEnabled integer
local TPowerOffEnabled = {}
TPowerOffEnabled.__index = TPowerOffEnabled
TPowerOffEnabled.group = {}

local function TPowerOffEnabled_from_obj(obj)
    return setmetatable(obj, TPowerOffEnabled)
end

function TPowerOffEnabled.new(PowerOffEnabled)
    return TPowerOffEnabled_from_obj({PowerOffEnabled = PowerOffEnabled or 1})
end
---@param obj MIpmiPefConfig.PowerOffEnabled
function TPowerOffEnabled:init_from_obj(obj)
    self.PowerOffEnabled = obj.PowerOffEnabled or 1
end

function TPowerOffEnabled:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPowerOffEnabled.group)
end

TPowerOffEnabled.from_obj = TPowerOffEnabled_from_obj

TPowerOffEnabled.proto_property = {'PowerOffEnabled'}

TPowerOffEnabled.default = {0}

TPowerOffEnabled.struct = {{name = 'PowerOffEnabled', is_array = false, struct = nil}}

function TPowerOffEnabled:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PowerOffEnabled', self.PowerOffEnabled, 'uint8', false, errs, need_convert)

    TPowerOffEnabled:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPowerOffEnabled.proto_property, errs, need_convert)
    return self
end

function TPowerOffEnabled:unpack(_)
    return self.PowerOffEnabled
end

MIpmiPefConfig.PowerOffEnabled = TPowerOffEnabled

---@class MIpmiPefConfig.AlertEnabled
---@field AlertEnabled integer
local TAlertEnabled = {}
TAlertEnabled.__index = TAlertEnabled
TAlertEnabled.group = {}

local function TAlertEnabled_from_obj(obj)
    return setmetatable(obj, TAlertEnabled)
end

function TAlertEnabled.new(AlertEnabled)
    return TAlertEnabled_from_obj({AlertEnabled = AlertEnabled or 1})
end
---@param obj MIpmiPefConfig.AlertEnabled
function TAlertEnabled:init_from_obj(obj)
    self.AlertEnabled = obj.AlertEnabled or 1
end

function TAlertEnabled:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAlertEnabled.group)
end

TAlertEnabled.from_obj = TAlertEnabled_from_obj

TAlertEnabled.proto_property = {'AlertEnabled'}

TAlertEnabled.default = {0}

TAlertEnabled.struct = {{name = 'AlertEnabled', is_array = false, struct = nil}}

function TAlertEnabled:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'AlertEnabled', self.AlertEnabled, 'uint8', false, errs, need_convert)

    TAlertEnabled:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAlertEnabled.proto_property, errs, need_convert)
    return self
end

function TAlertEnabled:unpack(_)
    return self.AlertEnabled
end

MIpmiPefConfig.AlertEnabled = TAlertEnabled

---@class MIpmiPefConfig.AlertStartupDelayDisabled
---@field AlertStartupDelayDisabled integer
local TAlertStartupDelayDisabled = {}
TAlertStartupDelayDisabled.__index = TAlertStartupDelayDisabled
TAlertStartupDelayDisabled.group = {}

local function TAlertStartupDelayDisabled_from_obj(obj)
    return setmetatable(obj, TAlertStartupDelayDisabled)
end

function TAlertStartupDelayDisabled.new(AlertStartupDelayDisabled)
    return TAlertStartupDelayDisabled_from_obj({AlertStartupDelayDisabled = AlertStartupDelayDisabled or 0})
end
---@param obj MIpmiPefConfig.AlertStartupDelayDisabled
function TAlertStartupDelayDisabled:init_from_obj(obj)
    self.AlertStartupDelayDisabled = obj.AlertStartupDelayDisabled or 0
end

function TAlertStartupDelayDisabled:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAlertStartupDelayDisabled.group)
end

TAlertStartupDelayDisabled.from_obj = TAlertStartupDelayDisabled_from_obj

TAlertStartupDelayDisabled.proto_property = {'AlertStartupDelayDisabled'}

TAlertStartupDelayDisabled.default = {0}

TAlertStartupDelayDisabled.struct = {{name = 'AlertStartupDelayDisabled', is_array = false, struct = nil}}

function TAlertStartupDelayDisabled:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'AlertStartupDelayDisabled', self.AlertStartupDelayDisabled, 'uint8', false, errs,
        need_convert)

    TAlertStartupDelayDisabled:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAlertStartupDelayDisabled.proto_property, errs, need_convert)
    return self
end

function TAlertStartupDelayDisabled:unpack(_)
    return self.AlertStartupDelayDisabled
end

MIpmiPefConfig.AlertStartupDelayDisabled = TAlertStartupDelayDisabled

---@class MIpmiPefConfig.StartupDelayDisabled
---@field StartupDelayDisabled integer
local TStartupDelayDisabled = {}
TStartupDelayDisabled.__index = TStartupDelayDisabled
TStartupDelayDisabled.group = {}

local function TStartupDelayDisabled_from_obj(obj)
    return setmetatable(obj, TStartupDelayDisabled)
end

function TStartupDelayDisabled.new(StartupDelayDisabled)
    return TStartupDelayDisabled_from_obj({StartupDelayDisabled = StartupDelayDisabled or 0})
end
---@param obj MIpmiPefConfig.StartupDelayDisabled
function TStartupDelayDisabled:init_from_obj(obj)
    self.StartupDelayDisabled = obj.StartupDelayDisabled or 0
end

function TStartupDelayDisabled:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TStartupDelayDisabled.group)
end

TStartupDelayDisabled.from_obj = TStartupDelayDisabled_from_obj

TStartupDelayDisabled.proto_property = {'StartupDelayDisabled'}

TStartupDelayDisabled.default = {0}

TStartupDelayDisabled.struct = {{name = 'StartupDelayDisabled', is_array = false, struct = nil}}

function TStartupDelayDisabled:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'StartupDelayDisabled', self.StartupDelayDisabled, 'uint8', false, errs, need_convert)

    TStartupDelayDisabled:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TStartupDelayDisabled.proto_property, errs, need_convert)
    return self
end

function TStartupDelayDisabled:unpack(_)
    return self.StartupDelayDisabled
end

MIpmiPefConfig.StartupDelayDisabled = TStartupDelayDisabled

---@class MIpmiPefConfig.ActionEnabled
---@field ActionEnabled integer
local TActionEnabled = {}
TActionEnabled.__index = TActionEnabled
TActionEnabled.group = {}

local function TActionEnabled_from_obj(obj)
    return setmetatable(obj, TActionEnabled)
end

function TActionEnabled.new(ActionEnabled)
    return TActionEnabled_from_obj({ActionEnabled = ActionEnabled or 0})
end
---@param obj MIpmiPefConfig.ActionEnabled
function TActionEnabled:init_from_obj(obj)
    self.ActionEnabled = obj.ActionEnabled or 0
end

function TActionEnabled:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TActionEnabled.group)
end

TActionEnabled.from_obj = TActionEnabled_from_obj

TActionEnabled.proto_property = {'ActionEnabled'}

TActionEnabled.default = {0}

TActionEnabled.struct = {{name = 'ActionEnabled', is_array = false, struct = nil}}

function TActionEnabled:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ActionEnabled', self.ActionEnabled, 'uint8', false, errs, need_convert)

    TActionEnabled:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TActionEnabled.proto_property, errs, need_convert)
    return self
end

function TActionEnabled:unpack(_)
    return self.ActionEnabled
end

MIpmiPefConfig.ActionEnabled = TActionEnabled

---@class MIpmiPefConfig.Enabled
---@field Enabled integer
local TEnabled = {}
TEnabled.__index = TEnabled
TEnabled.group = {}

local function TEnabled_from_obj(obj)
    return setmetatable(obj, TEnabled)
end

function TEnabled.new(Enabled)
    return TEnabled_from_obj({Enabled = Enabled or 1})
end
---@param obj MIpmiPefConfig.Enabled
function TEnabled:init_from_obj(obj)
    self.Enabled = obj.Enabled or 1
end

function TEnabled:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TEnabled.group)
end

TEnabled.from_obj = TEnabled_from_obj

TEnabled.proto_property = {'Enabled'}

TEnabled.default = {0}

TEnabled.struct = {{name = 'Enabled', is_array = false, struct = nil}}

function TEnabled:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Enabled', self.Enabled, 'uint8', false, errs, need_convert)

    TEnabled:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TEnabled.proto_property, errs, need_convert)
    return self
end

function TEnabled:unpack(_)
    return self.Enabled
end

MIpmiPefConfig.Enabled = TEnabled

return MIpmiPefConfig
