-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MDiscreteEvent = {}

---@class MDiscreteEvent.InvalidReading
---@field InvalidReading integer
local TInvalidReading = {}
TInvalidReading.__index = TInvalidReading
TInvalidReading.group = {}

local function TInvalidReading_from_obj(obj)
    return setmetatable(obj, TInvalidReading)
end

function TInvalidReading.new(InvalidReading)
    return TInvalidReading_from_obj({InvalidReading = InvalidReading})
end
---@param obj MDiscreteEvent.InvalidReading
function TInvalidReading:init_from_obj(obj)
    self.InvalidReading = obj.InvalidReading
end

function TInvalidReading:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TInvalidReading.group)
end

TInvalidReading.from_obj = TInvalidReading_from_obj

TInvalidReading.proto_property = {'InvalidReading'}

TInvalidReading.default = {0}

TInvalidReading.struct = {{name = 'InvalidReading', is_array = false, struct = nil}}

function TInvalidReading:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'InvalidReading', self.InvalidReading, 'uint8', true, errs, need_convert)

    TInvalidReading:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TInvalidReading.proto_property, errs, need_convert)
    return self
end

function TInvalidReading:unpack(_)
    return self.InvalidReading
end

MDiscreteEvent.InvalidReading = TInvalidReading

---@class MDiscreteEvent.InvalidReadingIgnore
---@field InvalidReadingIgnore integer
local TInvalidReadingIgnore = {}
TInvalidReadingIgnore.__index = TInvalidReadingIgnore
TInvalidReadingIgnore.group = {}

local function TInvalidReadingIgnore_from_obj(obj)
    return setmetatable(obj, TInvalidReadingIgnore)
end

function TInvalidReadingIgnore.new(InvalidReadingIgnore)
    return TInvalidReadingIgnore_from_obj({InvalidReadingIgnore = InvalidReadingIgnore})
end
---@param obj MDiscreteEvent.InvalidReadingIgnore
function TInvalidReadingIgnore:init_from_obj(obj)
    self.InvalidReadingIgnore = obj.InvalidReadingIgnore
end

function TInvalidReadingIgnore:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TInvalidReadingIgnore.group)
end

TInvalidReadingIgnore.from_obj = TInvalidReadingIgnore_from_obj

TInvalidReadingIgnore.proto_property = {'InvalidReadingIgnore'}

TInvalidReadingIgnore.default = {0}

TInvalidReadingIgnore.struct = {{name = 'InvalidReadingIgnore', is_array = false, struct = nil}}

function TInvalidReadingIgnore:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'InvalidReadingIgnore', self.InvalidReadingIgnore, 'uint8', true, errs, need_convert)

    TInvalidReadingIgnore:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TInvalidReadingIgnore.proto_property, errs, need_convert)
    return self
end

function TInvalidReadingIgnore:unpack(_)
    return self.InvalidReadingIgnore
end

MDiscreteEvent.InvalidReadingIgnore = TInvalidReadingIgnore

---@class MDiscreteEvent.Conversion
---@field Conversion integer
local TConversion = {}
TConversion.__index = TConversion
TConversion.group = {}

local function TConversion_from_obj(obj)
    return setmetatable(obj, TConversion)
end

function TConversion.new(Conversion)
    return TConversion_from_obj({Conversion = Conversion})
end
---@param obj MDiscreteEvent.Conversion
function TConversion:init_from_obj(obj)
    self.Conversion = obj.Conversion
end

function TConversion:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TConversion.group)
end

TConversion.from_obj = TConversion_from_obj

TConversion.proto_property = {'Conversion'}

TConversion.default = {0}

TConversion.struct = {{name = 'Conversion', is_array = false, struct = nil}}

function TConversion:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Conversion', self.Conversion, 'uint8', true, errs, need_convert)

    TConversion:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TConversion.proto_property, errs, need_convert)
    return self
end

function TConversion:unpack(_)
    return self.Conversion
end

MDiscreteEvent.Conversion = TConversion

---@class MDiscreteEvent.EventData3
---@field EventData3 integer
local TEventData3 = {}
TEventData3.__index = TEventData3
TEventData3.group = {}

local function TEventData3_from_obj(obj)
    return setmetatable(obj, TEventData3)
end

function TEventData3.new(EventData3)
    return TEventData3_from_obj({EventData3 = EventData3})
end
---@param obj MDiscreteEvent.EventData3
function TEventData3:init_from_obj(obj)
    self.EventData3 = obj.EventData3
end

function TEventData3:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TEventData3.group)
end

TEventData3.from_obj = TEventData3_from_obj

TEventData3.proto_property = {'EventData3'}

TEventData3.default = {0}

TEventData3.struct = {{name = 'EventData3', is_array = false, struct = nil}}

function TEventData3:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'EventData3', self.EventData3, 'uint8', true, errs, need_convert)

    TEventData3:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TEventData3.proto_property, errs, need_convert)
    return self
end

function TEventData3:unpack(_)
    return self.EventData3
end

MDiscreteEvent.EventData3 = TEventData3

---@class MDiscreteEvent.EventData2
---@field EventData2 integer
local TEventData2 = {}
TEventData2.__index = TEventData2
TEventData2.group = {}

local function TEventData2_from_obj(obj)
    return setmetatable(obj, TEventData2)
end

function TEventData2.new(EventData2)
    return TEventData2_from_obj({EventData2 = EventData2})
end
---@param obj MDiscreteEvent.EventData2
function TEventData2:init_from_obj(obj)
    self.EventData2 = obj.EventData2
end

function TEventData2:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TEventData2.group)
end

TEventData2.from_obj = TEventData2_from_obj

TEventData2.proto_property = {'EventData2'}

TEventData2.default = {0}

TEventData2.struct = {{name = 'EventData2', is_array = false, struct = nil}}

function TEventData2:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'EventData2', self.EventData2, 'uint8', true, errs, need_convert)

    TEventData2:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TEventData2.proto_property, errs, need_convert)
    return self
end

function TEventData2:unpack(_)
    return self.EventData2
end

MDiscreteEvent.EventData2 = TEventData2

---@class MDiscreteEvent.EventData1
---@field EventData1 integer
local TEventData1 = {}
TEventData1.__index = TEventData1
TEventData1.group = {}

local function TEventData1_from_obj(obj)
    return setmetatable(obj, TEventData1)
end

function TEventData1.new(EventData1)
    return TEventData1_from_obj({EventData1 = EventData1})
end
---@param obj MDiscreteEvent.EventData1
function TEventData1:init_from_obj(obj)
    self.EventData1 = obj.EventData1
end

function TEventData1:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TEventData1.group)
end

TEventData1.from_obj = TEventData1_from_obj

TEventData1.proto_property = {'EventData1'}

TEventData1.default = {0}

TEventData1.struct = {{name = 'EventData1', is_array = false, struct = nil}}

function TEventData1:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'EventData1', self.EventData1, 'uint8', true, errs, need_convert)

    TEventData1:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TEventData1.proto_property, errs, need_convert)
    return self
end

function TEventData1:unpack(_)
    return self.EventData1
end

MDiscreteEvent.EventData1 = TEventData1

---@class MDiscreteEvent.ListenType
---@field ListenType integer
local TListenType = {}
TListenType.__index = TListenType
TListenType.group = {}

local function TListenType_from_obj(obj)
    return setmetatable(obj, TListenType)
end

function TListenType.new(ListenType)
    return TListenType_from_obj({ListenType = ListenType})
end
---@param obj MDiscreteEvent.ListenType
function TListenType:init_from_obj(obj)
    self.ListenType = obj.ListenType
end

function TListenType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TListenType.group)
end

TListenType.from_obj = TListenType_from_obj

TListenType.proto_property = {'ListenType'}

TListenType.default = {0}

TListenType.struct = {{name = 'ListenType', is_array = false, struct = nil}}

function TListenType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ListenType', self.ListenType, 'uint8', true, errs, need_convert)

    if self.ListenType ~= nil then
        validate.ranges(prefix .. 'ListenType', self.ListenType, 0, 1, errs, need_convert)
    end

    TListenType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TListenType.proto_property, errs, need_convert)
    return self
end

function TListenType:unpack(_)
    return self.ListenType
end

MDiscreteEvent.ListenType = TListenType

return MDiscreteEvent
