#! /bin/bash
# Copyright (c) 2024 Huawei Technologies Co., Ltd.
# openUBMC is licensed under Mulan PSL v2.
# You can use this software according to the terms and conditions of the Mulan PSL v2.
# You may obtain a copy of Mulan PSL v2 at:
        #  http://license.coscl.org.cn/MulanPSL2
# THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
# EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
# MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
# See the Mulan PSL v2 for more details.

if [ -f /data/newflag ];then
    echo "new datafs."
    rm -Rf /opt/bmc/pram/*
    rm -f /data/newflag
fi
if [ ! -d /var/run/syslog-ng ];then
    mkdir /var/run/syslog-ng
fi
if [ ! -d /data/var/log/bmc ];then
    mkdir -p /data/var/log/bmc
fi
if [ ! -d /var/log/framework ];then
    mkdir -p /var/log/framework
fi

if [ ! -d /var/log/hisec ];then
    mkdir -p /var/log/hisec
fi

if [ ! -d /data/backup/persistence ];then
    mkdir -p /data/backup/persistence
fi

# ksf文件数据目录
# Eeprom数据备份目录
dirs_list='/opt/bmc/pram/persistence /run/persistence /data/opt/bmc/trust/ksf
/data/opt/bmc/sr /data/opt/bmc/sr/backup'
# 创建目录并修改目录权限
for dir in ${dirs_list}; do
    if [ ! -d "${dir}" ]; then
        mkdir -p "${dir}" && chmod 750 "${dir}"
    fi
done

# 本地持久化数据库目录
persistence_local_dirs='/data/opt/bmc/persistence.local /opt/bmc/pram/persistence.local
/dev/shm/persistence.local'
# 创建目录并修改目录权限支持非root用户访问
for dir in ${persistence_local_dirs}; do
    if [ ! -d "${dir}" ]; then
        mkdir -p "${dir}" && chmod 770 "${dir}"
    else
        chmod 770 "${dir}"
    fi
    chown 0:103 "${dir}"
done

mkdir /data/opt/bmc -p
if [ ! -f /data/opt/bmc/passwd ]; then
    touch /data/opt/bmc/passwd
fi
if [ ! -f /data/opt/bmc/shadow ]; then
    touch /data/opt/bmc/shadow
fi
if [ ! -f /data/opt/bmc/group ]; then
    touch /data/opt/bmc/group
fi

# 用于外部文件检验，权限与/dev/shm目录保持一致
mkdir /dev/shm/tmp
chmod 1777 /dev/shm/tmp

mkdir -p /dev/shm/log/web
mkdir -p /dev/shm/web/client_body_temp
mkdir -p /dev/shm/web/proxy_temp
touch /dev/shm/log/web/error_log

chown -R 98:98 /dev/shm/log
chown -R 98:98 /dev/shm/web

if [ ! -d /var/empty ];then
    mkdir /var/empty
fi

# 低可信可读写目录
if [ ! -d /data/opt/bmc/conf ];then
    mkdir /data/opt/bmc/conf
    chmod 775 /data/opt/bmc/conf
fi

# 保证沙箱日志文件及其转储文件属组正确，防止沙箱启动失败
if [ -e /var/log/secbox/secbox.log ];then
    chown 104:104 /var/log/secbox/*
fi

# 保证安全切面日志文件及其转储文件属组正确，防止沙箱进程无法记录
if [ ! -f /dev/shm/log/cbb.log ]; then
    touch /dev/shm/log/cbb.log
fi

chown 0:104 /dev/shm/log/cbb.log
chmod 660 /dev/shm/log/cbb.log

# 修改权限
chmod 750 /run/log/
chmod 750 /data/var/log/
chmod 750 /var/volatile/log/

chmod 640 /var/log/running.log > /dev/null 2>&1
chmod 640 /var/log/security.log > /dev/null 2>&1
chmod 640 /var/log/maintenance.log > /dev/null 2>&1
chmod 640 /var/log/operation.log > /dev/null 2>&1
chmod 640 /var/log/app.log > /dev/null 2>&1
chmod 640 /var/log/framework.log > /dev/null 2>&1
chmod 640 /dev/shm/rsyslog_check.log > /dev/null 2>&1

# 针对日志名变更后的优化措施：
# BMC起来的时候，如果新的日志名和转储文件不存在，则将老的日志和转储文件重命名为新的
ls /var/log/operation.log.*.gz > /dev/null 2>&1
if [[ ! -e /var/log/operation.log && $? -ne 0 ]]; then
    mv /var/log/operate_log /var/log/operation.log
    ls /var/log/operate_log.*.gz > /dev/null 2>&1
    if [ $? -eq 0 ]; then
        for logname in `ls /var/log/operate_log.*.gz` ; do
            mv $logname ${logname/operate_log/operation.log}
        done
    fi
fi
# 安全日志没有compress
ls /var/log/security.log.* > /dev/null 2>&1
if [[ ! -e /var/log/security.log && $? -ne 0 ]]; then
    mv /var/log/security_log /var/log/security.log
    ls /var/log/security_log.* > /dev/null 2>&1
    if [ $? -eq 0 ]; then
        for logname in `ls /var/log/security_log.*` ; do
            mv $logname ${logname/_/.}
        done
    fi
fi
ls /var/log/running.log.*.gz > /dev/null 2>&1
if [[ ! -e /var/log/running.log && $? -ne 0 ]]; then
    mv /var/log/running_log /var/log/running.log
    ls /var/log/running_log.*.gz > /dev/null 2>&1
    if [ $? -eq 0 ]; then
        for logname in `ls /var/log/running_log.*.gz` ; do
            mv $logname ${logname/_/.}
        done
    fi
fi
ls /var/log/maintenance.log.*.gz > /dev/null 2>&1
if [[ ! -e /var/log/maintenance.log && $? -ne 0 ]]; then
    mv /var/log/maintenance_log /var/log/maintenance.log
    ls /var/log/maintenance_log.*.gz > /dev/null 2>&1
    if [ $? -eq 0 ]; then
        for logname in `ls /var/log/maintenance_log.*.gz` ; do
            mv $logname ${logname/_/.}
        done
    fi
fi
ls /var/log/app.log.*.gz > /dev/null 2>&1
if [[ ! -e /var/log/app.log && $? -ne 0 ]]; then
    mv /var/log/app_debug_log_all /var/log/app.log
    ls /var/log/app_debug_log_all.*.gz > /dev/null 2>&1
    if [ $? -eq 0 ]; then
        for logname in `ls /var/log/app_debug_log_all.*.gz` ; do
            mv $logname ${logname/app_debug_log_all/app.log}
        done
    fi
fi
