-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local dt_mdb = require 'tree'

local function get_sub_paths(_, path, depth, interfaces)
    local obj = dt_mdb.get_instance()
    return {['SubPaths'] = obj:get_sub_paths(path, depth, interfaces)}
end

local function get_path(_, interface, filter, ignore_case, _)
    local obj = dt_mdb.get_instance()
    return {['Path'] = obj:get_path(interface, filter, ignore_case)}, false
end

local function is_valid_path(_, path)
    local obj = dt_mdb.get_instance()
    return {['Result'] = obj:is_valid_path(path)}
end

return {
    get_sub_paths = get_sub_paths,
    get_path = get_path,
    is_valid_path = is_valid_path
}
